/*
 * Decompiled with CFR 0.152.
 */
package com.uwetrottmann.trakt5;

import com.uwetrottmann.trakt5.TraktV2;
import com.uwetrottmann.trakt5.entities.AccessToken;
import java.io.IOException;
import javax.annotation.Nullable;
import okhttp3.Authenticator;
import okhttp3.Request;
import okhttp3.Route;
import retrofit2.Response;

public class TraktV2Authenticator
implements Authenticator {
    public final TraktV2 trakt;

    public TraktV2Authenticator(TraktV2 trakt) {
        this.trakt = trakt;
    }

    @Nullable
    public Request authenticate(@Nullable Route route, okhttp3.Response response) throws IOException {
        return TraktV2Authenticator.handleAuthenticate(response, this.trakt);
    }

    @Nullable
    public static Request handleAuthenticate(okhttp3.Response response, TraktV2 trakt) throws IOException {
        if (!"api.trakt.tv".equals(response.request().url().host())) {
            return null;
        }
        if (TraktV2Authenticator.responseCount(response) >= 2) {
            return null;
        }
        String refreshToken = trakt.refreshToken();
        if (refreshToken == null || refreshToken.length() == 0) {
            return null;
        }
        Response<AccessToken> refreshResponse = trakt.refreshAccessToken(refreshToken);
        AccessToken body = (AccessToken)refreshResponse.body();
        if (!refreshResponse.isSuccessful() || body == null) {
            return null;
        }
        String accessToken = body.access_token;
        trakt.accessToken(accessToken);
        trakt.refreshToken(body.refresh_token);
        return response.request().newBuilder().header("Authorization", "Bearer " + accessToken).build();
    }

    private static int responseCount(okhttp3.Response response) {
        int result = 1;
        while ((response = response.priorResponse()) != null) {
            ++result;
        }
        return result;
    }
}

