/*
 * Decompiled with CFR 0.152.
 */
package com.github.stephenc.javaisotools.loopfs.udf.descriptor;

import com.github.stephenc.javaisotools.loopfs.udf.descriptor.element.DescriptorTag;
import com.github.stephenc.javaisotools.loopfs.udf.exceptions.InvalidDescriptor;

public abstract class UDFDescriptor {
    public DescriptorTag tag;
    public final int TAG_LENGTH = 16;

    public UDFDescriptor() {
    }

    public UDFDescriptor(byte[] bytes) throws InvalidDescriptor {
        this.deserialize(bytes);
        this.verifyTagIdentifier();
    }

    public abstract int getExpectedTagIdentifier();

    public abstract void deserialize(byte[] var1) throws InvalidDescriptor;

    public void verifyTagIdentifier() throws InvalidDescriptor {
        Integer tagId = this.tag.identifier;
        if (tagId.intValue() != this.getExpectedTagIdentifier()) {
            throw new InvalidDescriptor("Unexpected tag identifier: " + tagId.toString());
        }
    }

    public void deserializeTag(byte[] bytes) throws InvalidDescriptor {
        this.tag = new DescriptorTag(bytes);
    }
}

