/*
 * Decompiled with CFR 0.152.
 */
package com.github.stephenc.javaisotools.loopfs.udf.descriptor;

import com.github.stephenc.javaisotools.loopfs.udf.UDFUtil;
import com.github.stephenc.javaisotools.loopfs.udf.descriptor.UDFDescriptor;
import com.github.stephenc.javaisotools.loopfs.udf.descriptor.element.RegId;
import com.github.stephenc.javaisotools.loopfs.udf.exceptions.InvalidDescriptor;

public class PartitionDescriptor
extends UDFDescriptor {
    public Long volumeDescriptorSeq;
    public Integer flags;
    public Integer partitionNumber;
    public RegId contents;
    public byte[] contentsUse;
    public Long accessType;
    public Long startingLocation;
    public Long length;
    public RegId implIdentifier;
    public byte[] implUse;
    public final int LEN_VD_SEQ = 4;
    public final int LEN_FLAGS = 2;
    public final int LEN_PT_NUMBER = 2;
    public final int LEN_CONTENTS = 32;
    public final int LEN_CONTENTS_USE = 128;
    public final int LEN_ACCESS_TYPE = 4;
    public final int LEN_START_LOCATION = 4;
    public final int LEN_LENGTH = 4;
    public final int LEN_IMPL_ID = 32;
    public final int LEN_IMPL_USE = 128;
    public final int LEN_RESERVED = 156;
    public final int BP_VD_SEQ = 16;
    public final int BP_FLAGS = 20;
    public final int BP_PT_NUMBER = 22;
    public final int BP_CONTENTS = 24;
    public final int BP_CONTENTS_USE = 56;
    public final int BP_ACCESS_TYPE = 184;
    public final int BP_START_LOCATION = 188;
    public final int BP_LENGTH = 192;
    public final int BP_IMPL_ID = 196;
    public final int BP_IMPL_USE = 228;
    public final int BP_RESERVED = 356;
    public final int EP_VD_SEQ = 20;
    public final int EP_FLAGS = 22;
    public final int EP_PT_NUMBER = 24;
    public final int EP_CONTENTS = 56;
    public final int EP_CONTENTS_USE = 184;
    public final int EP_ACCESS_TYPE = 188;
    public final int EP_START_LOCATION = 192;
    public final int EP_LENGTH = 196;
    public final int EP_IMPL_ID = 228;
    public final int EP_IMPL_USE = 356;
    public final int EP_RESERVED = 512;
    public final int MINIMUM_LENGTH = 512;

    public PartitionDescriptor() {
    }

    public PartitionDescriptor(byte[] bytes) throws InvalidDescriptor {
        super(bytes);
    }

    @Override
    public int getExpectedTagIdentifier() {
        return 5;
    }

    @Override
    public void deserialize(byte[] bytes) throws InvalidDescriptor {
        if (bytes.length < 512) {
            throw new InvalidDescriptor("Partition descriptor too short");
        }
        this.deserializeTag(bytes);
        this.volumeDescriptorSeq = UDFUtil.getUInt32(bytes, 16);
        this.flags = UDFUtil.getUInt16(bytes, 20);
        this.partitionNumber = UDFUtil.getUInt16(bytes, 22);
        byte[] fragment = UDFUtil.getBytes(bytes, 24, 32);
        this.contents = new RegId(fragment);
        this.contentsUse = UDFUtil.getBytes(bytes, 56, 128);
        this.accessType = UDFUtil.getUInt32(bytes, 184);
        this.startingLocation = UDFUtil.getUInt32(bytes, 188);
        this.length = UDFUtil.getUInt32(bytes, 192);
        fragment = UDFUtil.getBytes(bytes, 196, 32);
        this.implIdentifier = new RegId(fragment);
        this.implUse = UDFUtil.getBytes(bytes, 228, 128);
    }
}

