/*
 * Decompiled with CFR 0.152.
 */
package com.github.stephenc.javaisotools.loopfs.udf.descriptor;

import com.github.stephenc.javaisotools.loopfs.udf.UDFUtil;
import com.github.stephenc.javaisotools.loopfs.udf.descriptor.UDFDescriptor;
import com.github.stephenc.javaisotools.loopfs.udf.descriptor.element.CharSpec;
import com.github.stephenc.javaisotools.loopfs.udf.descriptor.element.DString;
import com.github.stephenc.javaisotools.loopfs.udf.descriptor.element.LongAD;
import com.github.stephenc.javaisotools.loopfs.udf.descriptor.element.RegId;
import com.github.stephenc.javaisotools.loopfs.udf.descriptor.element.Timestamp;
import com.github.stephenc.javaisotools.loopfs.udf.exceptions.InvalidDescriptor;

public class FileSetDescriptor
extends UDFDescriptor {
    public Timestamp recordDateTime;
    public Integer interchangeLevel;
    public Integer maxInterchangeLevel;
    public Long charsetList;
    public Long maxCharsetList;
    public Long fileSetNum;
    public Long fileSetDescriptorNum;
    public CharSpec lvIdentifierCharset;
    public DString lvIdentifier;
    public CharSpec fileSetCharset;
    public DString fileSetIdentifier;
    public DString copyrightFileId;
    public DString abstractFileId;
    public LongAD rootICB;
    public RegId domainIdentifier;
    public LongAD nextExtent;
    public LongAD sysStreamDirICB;
    public final int LEN_RECORD_DT = 12;
    public final int LEN_INTERCH_LVL = 2;
    public final int LEN_MAX_INTERCH_LVL = 2;
    public final int LEN_CHARSET_LIST = 4;
    public final int LEN_MAX_CHARSET_LIST = 4;
    public final int LEN_FSET_NUM = 4;
    public final int LEN_FSET_DESC_NUM = 4;
    public final int LEN_LV_ID_CHARSET = 64;
    public final int LEN_LV_ID = 128;
    public final int LEN_FSET_CHARSET = 64;
    public final int LEN_FSET_ID = 32;
    public final int LEN_COPYRIGHT_FID = 32;
    public final int LEN_ABSTRACT_FID = 32;
    public final int LEN_ROOT_DIR_ICB = 16;
    public final int LEN_DOMAIN_ID = 32;
    public final int LEN_NEXT_EXTENT = 16;
    public final int LEN_STREAM_DIR_ICB = 16;
    public final int LEN_RESERVED = 32;
    public final int BP_RECORD_DT = 16;
    public final int BP_INTERCH_LVL = 28;
    public final int BP_MAX_INTERCH_LVL = 30;
    public final int BP_CHARSET_LIST = 32;
    public final int BP_MAX_CHARSET_LIST = 36;
    public final int BP_FSET_NUM = 40;
    public final int BP_FSET_DESC_NUM = 44;
    public final int BP_LV_ID_CHARSET = 48;
    public final int BP_LV_ID = 112;
    public final int BP_FSET_CHARSET = 240;
    public final int BP_FSET_ID = 304;
    public final int BP_COPYRIGHT_FID = 336;
    public final int BP_ABSTRACT_FID = 368;
    public final int BP_ROOT_DIR_ICB = 400;
    public final int BP_DOMAIN_ID = 416;
    public final int BP_NEXT_EXTENT = 448;
    public final int BP_STREAM_DIR_ICB = 464;
    public final int BP_RESERVED = 480;
    public final int EP_RECORD_DT = 28;
    public final int EP_INTERCH_LVL = 30;
    public final int EP_MAX_INTERCH_LVL = 32;
    public final int EP_CHARSET_LIST = 36;
    public final int EP_MAX_CHARSET_LIST = 40;
    public final int EP_FSET_NUM = 44;
    public final int EP_FSET_DESC_NUM = 48;
    public final int EP_LV_ID_CHARSET = 112;
    public final int EP_LV_ID = 240;
    public final int EP_FSET_CHARSET = 304;
    public final int EP_FSET_ID = 336;
    public final int EP_COPYRIGHT_FID = 368;
    public final int EP_ABSTRACT_FID = 400;
    public final int EP_ROOT_DIR_ICB = 416;
    public final int EP_DOMAIN_ID = 448;
    public final int EP_NEXT_EXTENT = 464;
    public final int EP_STREAM_DIR_ICB = 480;
    public final int EP_RESERVED = 512;
    public final int MINIMUM_LENGTH = 512;

    public FileSetDescriptor() {
    }

    public FileSetDescriptor(byte[] bytes) throws InvalidDescriptor {
        super(bytes);
    }

    @Override
    public int getExpectedTagIdentifier() {
        return 256;
    }

    @Override
    public void deserialize(byte[] bytes) throws InvalidDescriptor {
        if (bytes.length < 512) {
            throw new InvalidDescriptor("File set descriptor too short");
        }
        this.deserializeTag(bytes);
        byte[] fragment = UDFUtil.getBytes(bytes, 16, 12);
        this.recordDateTime = new Timestamp(fragment);
        this.interchangeLevel = UDFUtil.getUInt16(bytes, 28);
        this.maxInterchangeLevel = UDFUtil.getUInt16(bytes, 30);
        this.charsetList = UDFUtil.getUInt32(bytes, 32);
        this.maxCharsetList = UDFUtil.getUInt32(bytes, 36);
        this.fileSetNum = UDFUtil.getUInt32(bytes, 40);
        this.fileSetDescriptorNum = UDFUtil.getUInt32(bytes, 44);
        fragment = UDFUtil.getBytes(bytes, 48, 64);
        this.lvIdentifierCharset = new CharSpec(fragment);
        fragment = UDFUtil.getBytes(bytes, 112, 128);
        this.lvIdentifier = new DString(fragment);
        fragment = UDFUtil.getBytes(bytes, 240, 64);
        this.fileSetCharset = new CharSpec(fragment);
        fragment = UDFUtil.getBytes(bytes, 304, 32);
        this.fileSetIdentifier = new DString(fragment);
        fragment = UDFUtil.getBytes(bytes, 336, 32);
        this.copyrightFileId = new DString(fragment);
        fragment = UDFUtil.getBytes(bytes, 368, 32);
        this.abstractFileId = new DString(fragment);
        fragment = UDFUtil.getBytes(bytes, 400, 16);
        this.rootICB = new LongAD(fragment);
        fragment = UDFUtil.getBytes(bytes, 416, 32);
        this.domainIdentifier = new RegId(fragment);
        fragment = UDFUtil.getBytes(bytes, 448, 16);
        this.nextExtent = new LongAD(fragment);
        fragment = UDFUtil.getBytes(bytes, 464, 16);
        this.sysStreamDirICB = new LongAD(fragment);
    }
}

