/*
 * Decompiled with CFR 0.152.
 */
package com.github.stephenc.javaisotools.loopfs.udf.descriptor;

import com.github.stephenc.javaisotools.loopfs.udf.UDFUtil;
import com.github.stephenc.javaisotools.loopfs.udf.descriptor.UDFDescriptor;
import com.github.stephenc.javaisotools.loopfs.udf.descriptor.element.DString;
import com.github.stephenc.javaisotools.loopfs.udf.descriptor.element.LongAD;
import com.github.stephenc.javaisotools.loopfs.udf.exceptions.InvalidDescriptor;

public class FileIdentifierDescriptor
extends UDFDescriptor {
    public Integer version;
    public Integer characteristics;
    public Integer fileIdLength;
    public LongAD icb;
    public Integer implUseLength;
    public byte[] implUse;
    public DString fileId;
    protected Integer consumption;
    public final int LEN_VERSION = 2;
    public final int LEN_CHARACTERISTICS = 1;
    public final int LEN_LEN_FID = 1;
    public final int LEN_ICB = 16;
    public final int LEN_LEN_IMPL_USE = 2;
    public final int BP_VERSION = 16;
    public final int BP_CHARACTERISTICS = 18;
    public final int BP_LEN_FID = 19;
    public final int BP_ICB = 20;
    public final int BP_LEN_IMPL_USE = 36;
    public final int BP_IMPL_USE = 38;
    public final int EP_VERSION = 18;
    public final int EP_CHARACTERISTICS = 19;
    public final int EP_LEN_FID = 20;
    public final int EP_ICB = 36;
    public final int EP_LEN_IMPL_USE = 38;
    public final int MINIMUM_LENGTH = 40;

    public FileIdentifierDescriptor() {
    }

    public FileIdentifierDescriptor(byte[] bytes) throws InvalidDescriptor {
        super(bytes);
    }

    @Override
    public int getExpectedTagIdentifier() {
        return 257;
    }

    @Override
    public void deserialize(byte[] bytes) throws InvalidDescriptor {
        if (bytes.length < 40) {
            throw new InvalidDescriptor("File identifier descriptor too short");
        }
        this.deserializeTag(bytes);
        this.version = UDFUtil.getUInt16(bytes, 16);
        this.characteristics = UDFUtil.getUInt8(bytes, 18);
        this.fileIdLength = UDFUtil.getUInt8(bytes, 19);
        byte[] fragment = UDFUtil.getBytes(bytes, 20, 16);
        this.icb = new LongAD(fragment);
        this.implUseLength = UDFUtil.getUInt16(bytes, 36);
        this.implUse = UDFUtil.getBytes(bytes, 38, this.implUseLength);
        Integer bpFileIdentifier = 38 + this.implUseLength;
        fragment = UDFUtil.getBytes(bytes, bpFileIdentifier, this.fileIdLength);
        this.fileId = new DString(fragment);
        Integer bytesConsumed = bpFileIdentifier + this.fileIdLength;
        Integer divisor = 4;
        Integer paddingLength = divisor - bytesConsumed % divisor;
        this.consumption = bytesConsumed + paddingLength;
    }

    public Integer getConsumption() {
        return this.consumption;
    }
}

