/*
 * Decompiled with CFR 0.152.
 */
package com.github.stephenc.javaisotools.loopfs.udf.descriptor;

import com.github.stephenc.javaisotools.loopfs.udf.UDFUtil;
import com.github.stephenc.javaisotools.loopfs.udf.descriptor.UDFDescriptor;
import com.github.stephenc.javaisotools.loopfs.udf.descriptor.element.ExtentAD;
import com.github.stephenc.javaisotools.loopfs.udf.exceptions.InvalidDescriptor;

public class AnchorDescriptor
extends UDFDescriptor {
    public ExtentAD mainVolumeExtent;
    public ExtentAD reserveVolumeExtent;
    public final int LEN_MV_EXTENT = 8;
    public final int LEN_RV_EXTENT = 8;
    public final int LEN_RESERVED = 480;
    public final int BP_MV_EXTENT = 16;
    public final int BP_RV_EXTENT = 24;
    public final int BP_RESERVED = 32;
    public final int EP_MV_EXTENT = 24;
    public final int EP_RV_EXTENT = 32;
    public final int MINIMUM_LENGTH = 512;

    public AnchorDescriptor() {
    }

    public AnchorDescriptor(byte[] bytes) throws InvalidDescriptor {
        super(bytes);
    }

    @Override
    public int getExpectedTagIdentifier() {
        return 2;
    }

    @Override
    public void deserialize(byte[] bytes) throws InvalidDescriptor {
        if (bytes.length < 512) {
            throw new InvalidDescriptor("Anchor descriptor too short");
        }
        this.deserializeTag(bytes);
        byte[] mvBytes = UDFUtil.getBytes(bytes, 16, 8);
        byte[] rvBytes = UDFUtil.getBytes(bytes, 24, 8);
        this.mainVolumeExtent = new ExtentAD(mvBytes);
        this.reserveVolumeExtent = new ExtentAD(rvBytes);
    }
}

