/*
 * Decompiled with CFR 0.152.
 */
package com.github.stephenc.javaisotools.loopfs.udf;

import com.github.stephenc.javaisotools.loopfs.spi.AbstractBlockFileSystem;
import com.github.stephenc.javaisotools.loopfs.spi.SeekableInput;
import com.github.stephenc.javaisotools.loopfs.spi.SeekableInputFile;
import com.github.stephenc.javaisotools.loopfs.spi.VolumeDescriptorSet;
import com.github.stephenc.javaisotools.loopfs.udf.UDFEntryInputStream;
import com.github.stephenc.javaisotools.loopfs.udf.UDFEntryIterator;
import com.github.stephenc.javaisotools.loopfs.udf.UDFFileEntry;
import com.github.stephenc.javaisotools.loopfs.udf.UDFVolumeDescriptorSet;
import com.github.stephenc.javaisotools.loopfs.udf.descriptor.AnchorDescriptor;
import com.github.stephenc.javaisotools.loopfs.udf.descriptor.element.ExtentAD;
import com.github.stephenc.javaisotools.loopfs.udf.exceptions.InvalidDescriptor;
import com.github.stephenc.javaisotools.loopfs.udf.exceptions.UnsupportedStandard;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;

public class UDFFileSystem
extends AbstractBlockFileSystem<UDFFileEntry> {
    private AnchorDescriptor anchor;

    public UDFFileSystem(File file, boolean readOnly) throws IOException {
        this((SeekableInput)new SeekableInputFile(file), readOnly, 2048);
    }

    public UDFFileSystem(SeekableInput file, boolean readOnly, Integer sectorSize) throws IOException {
        super(file, readOnly, sectorSize.intValue(), 16);
        try {
            this.verifyStandard();
        }
        catch (UnsupportedStandard ex) {
            throw new IOException("Unsupported standard");
        }
        try {
            this.loadAnchor();
        }
        catch (InvalidDescriptor ex) {
            throw new IOException("Invalid Anchor Volume Pointer Descriptor");
        }
        this.setReservedBlocks(this.anchor.mainVolumeExtent.location.intValue());
    }

    public InputStream getInputStream(UDFFileEntry entry) {
        this.ensureOpen();
        return new UDFEntryInputStream(entry, this);
    }

    public int readBytes(long startPos, byte[] buffer, int offset, int len) throws IOException {
        return this.readData(startPos, buffer, offset, len);
    }

    public int readFileContent(UDFFileEntry entry, long entryOffset, byte[] buffer, int bufferOffset, int len) throws IOException {
        if (entry.isDirectory()) {
            throw new IOException("Entry is a directory");
        }
        int bs = 2048;
        int read = 0;
        long offset = 0L;
        long processed = 0L;
        long endPosition = (long)len + entryOffset;
        for (ExtentAD ead : entry.getADs()) {
            if (ead.length == 0L) continue;
            long fragLen = ead.length;
            long fragPos = this.getPDStartPos() + ead.location;
            if ((offset += fragLen) <= entryOffset) {
                processed += fragLen;
                continue;
            }
            long off = processed < entryOffset ? entryOffset - processed : 0L;
            long ln = offset < endPosition ? offset - entryOffset : endPosition - Math.max(processed, entryOffset);
            if (ln == 0L) break;
            long startPos = (long)bs * fragPos + off;
            int extentRead = this.readData(startPos, buffer, bufferOffset, (int)ln);
            processed += fragLen;
            if ((long)extentRead < ln) {
                read += extentRead;
                break;
            }
            read = (int)((long)read + ln);
            bufferOffset = (int)((long)bufferOffset + ln);
            if (read == len) break;
            if (read <= len) continue;
            throw new IOException("byte array has been read is longer than expected");
        }
        return read;
    }

    protected Iterator<UDFFileEntry> iterator(UDFFileEntry root) {
        UDFVolumeDescriptorSet ds = this.getUDFDescriptorSet();
        UDFFileEntry rootEntry = (UDFFileEntry)ds.getRootEntry();
        return new UDFEntryIterator(this, rootEntry);
    }

    protected VolumeDescriptorSet<UDFFileEntry> createVolumeDescriptorSet() {
        return new UDFVolumeDescriptorSet(this);
    }

    private void loadAnchor() throws IOException, InvalidDescriptor {
        byte[] buffer = new byte[2048];
        this.readBlock(256L, buffer);
        this.anchor = new AnchorDescriptor(buffer);
    }

    public AnchorDescriptor getAnchor() {
        return this.anchor;
    }

    public UDFVolumeDescriptorSet getUDFDescriptorSet() {
        return (UDFVolumeDescriptorSet)this.getVolumeDescriptorSet();
    }

    public long getPDStartPos() {
        UDFVolumeDescriptorSet ds = this.getUDFDescriptorSet();
        return ds.getPDStartPos();
    }

    private void verifyStandard() throws UnsupportedStandard {
    }
}

