/*
 * Decompiled with CFR 0.152.
 */
package com.uwetrottmann.tmdb2;

import com.uwetrottmann.tmdb2.Tmdb;
import com.uwetrottmann.tmdb2.entities.GuestSession;
import com.uwetrottmann.tmdb2.entities.RequestToken;
import com.uwetrottmann.tmdb2.entities.Session;
import com.uwetrottmann.tmdb2.exceptions.TmdbAuthenticationFailedException;
import com.uwetrottmann.tmdb2.services.AuthenticationService;
import java.io.IOException;
import javax.annotation.Nullable;
import okhttp3.Authenticator;
import okhttp3.HttpUrl;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.Route;

public class TmdbAuthenticator
implements Authenticator {
    private final Tmdb tmdb;

    public TmdbAuthenticator(Tmdb tmdb) {
        this.tmdb = tmdb;
    }

    public Request authenticate(@Nullable Route route, Response response) throws IOException {
        return TmdbAuthenticator.handleRequest(response, this.tmdb);
    }

    @Nullable
    public static Request handleRequest(Response response, Tmdb tmdb) throws IOException {
        if (((String)response.request().url().pathSegments().get(0)).equals("authentication")) {
            return null;
        }
        if (TmdbAuthenticator.responseCount(response) >= 2) {
            throw new TmdbAuthenticationFailedException(30, "Authentication failed: You do not have permissions to access the service.");
        }
        HttpUrl.Builder urlBuilder = response.request().url().newBuilder();
        if (tmdb.useAccountSession()) {
            if (tmdb.getUsername() == null || tmdb.getPassword() == null) {
                throw new TmdbAuthenticationFailedException(26, "You must provide a username and password.");
            }
            String session = TmdbAuthenticator.acquireAccountSession(tmdb);
            if (session == null) {
                return null;
            }
            urlBuilder.setEncodedQueryParameter("session_id", session);
        } else if (tmdb.useGuestSession()) {
            String session = TmdbAuthenticator.acquireGuestSession(tmdb);
            if (session == null) {
                return null;
            }
            urlBuilder.setEncodedQueryParameter("guest_session_id", tmdb.getGuestSessionId());
        } else {
            throw new TmdbAuthenticationFailedException(30, "Authentication failed: You do not have permissions to access the service.");
        }
        return response.request().newBuilder().url(urlBuilder.build()).build();
    }

    @Nullable
    public static String acquireAccountSession(Tmdb tmdb) throws IOException {
        AuthenticationService authService = (AuthenticationService)tmdb.getRetrofit().create(AuthenticationService.class);
        RequestToken token = (RequestToken)authService.requestToken().execute().body();
        if (token == null) {
            return null;
        }
        token = (RequestToken)authService.validateToken(tmdb.getUsername(), tmdb.getPassword(), token.request_token).execute().body();
        if (token == null) {
            return null;
        }
        Session session = (Session)authService.createSession(token.request_token).execute().body();
        if (session == null) {
            return null;
        }
        tmdb.setSessionId(session.session_id);
        return session.session_id;
    }

    @Nullable
    public static String acquireGuestSession(Tmdb tmdb) throws IOException {
        AuthenticationService authService = (AuthenticationService)tmdb.getRetrofit().create(AuthenticationService.class);
        GuestSession session = (GuestSession)authService.createGuestSession().execute().body();
        if (session == null) {
            return null;
        }
        tmdb.setGuestSessionId(session.guest_session_id);
        return session.guest_session_id;
    }

    private static int responseCount(Response response) {
        int result = 1;
        while ((response = response.priorResponse()) != null) {
            ++result;
        }
        return result;
    }
}

