/*
 * Decompiled with CFR 0.152.
 */
package org.fourthline.cling.support.contentdirectory.ui;

import javax.swing.JTree;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import org.fourthline.cling.controlpoint.ActionCallback;
import org.fourthline.cling.controlpoint.ControlPoint;
import org.fourthline.cling.model.meta.Service;
import org.fourthline.cling.support.contentdirectory.callback.Browse;
import org.fourthline.cling.support.contentdirectory.ui.ContentBrowseActionCallback;
import org.fourthline.cling.support.contentdirectory.ui.ContentBrowseActionCallbackCreator;
import org.fourthline.cling.support.contentdirectory.ui.ContentTreeCellRenderer;
import org.fourthline.cling.support.contentdirectory.ui.ContentTreeExpandListener;
import org.fourthline.cling.support.model.container.Container;

public abstract class ContentTree
extends JTree
implements ContentBrowseActionCallbackCreator {
    protected Container rootContainer;
    protected DefaultMutableTreeNode rootNode;

    protected ContentTree() {
    }

    public ContentTree(ControlPoint controlPoint, Service service) {
        this.init(controlPoint, service);
    }

    public void init(ControlPoint controlPoint, Service service) {
        this.rootContainer = this.createRootContainer(service);
        this.rootNode = new DefaultMutableTreeNode(this.rootContainer){

            @Override
            public boolean isLeaf() {
                return false;
            }
        };
        DefaultTreeModel treeModel = new DefaultTreeModel(this.rootNode);
        this.setModel(treeModel);
        this.getSelectionModel().setSelectionMode(1);
        this.addTreeWillExpandListener(this.createContainerTreeExpandListener(controlPoint, service, treeModel));
        this.setCellRenderer(this.createContainerTreeCellRenderer());
        controlPoint.execute(this.createContentBrowseActionCallback(service, treeModel, this.getRootNode()));
    }

    public Container getRootContainer() {
        return this.rootContainer;
    }

    public DefaultMutableTreeNode getRootNode() {
        return this.rootNode;
    }

    public DefaultMutableTreeNode getSelectedNode() {
        return (DefaultMutableTreeNode)this.getLastSelectedPathComponent();
    }

    protected Container createRootContainer(Service service) {
        Container rootContainer = new Container();
        rootContainer.setId("0");
        rootContainer.setTitle("Content Directory on " + service.getDevice().getDisplayString());
        return rootContainer;
    }

    protected TreeWillExpandListener createContainerTreeExpandListener(ControlPoint controlPoint, Service service, DefaultTreeModel treeModel) {
        return new ContentTreeExpandListener(controlPoint, service, treeModel, this);
    }

    protected DefaultTreeCellRenderer createContainerTreeCellRenderer() {
        return new ContentTreeCellRenderer();
    }

    @Override
    public ActionCallback createContentBrowseActionCallback(Service service, DefaultTreeModel treeModel, DefaultMutableTreeNode treeNode) {
        return new ContentBrowseActionCallback(service, treeModel, treeNode){

            @Override
            public void updateStatusUI(Browse.Status status, DefaultMutableTreeNode treeNode, DefaultTreeModel treeModel) {
                ContentTree.this.updateStatus(status, treeNode, treeModel);
            }

            @Override
            public void failureUI(String failureMessage) {
                ContentTree.this.failure(failureMessage);
            }
        };
    }

    public void updateStatus(Browse.Status status, DefaultMutableTreeNode treeNode, DefaultTreeModel treeModel) {
        switch (status) {
            case LOADING: 
            case NO_CONTENT: {
                treeNode.removeAllChildren();
                int index = treeNode.getChildCount() <= 0 ? 0 : treeNode.getChildCount();
                treeModel.insertNodeInto(new DefaultMutableTreeNode(status.getDefaultMessage()), treeNode, index);
                treeModel.nodeStructureChanged(treeNode);
            }
        }
    }

    public abstract void failure(String var1);
}

