/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.jsonrpc.notification;

import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.node.ObjectNode;
import org.tinymediamanager.jsonrpc.api.model.GlobalModel;
import org.tinymediamanager.jsonrpc.notification.AbstractEvent;

public class PlayerEvent {

    public static class PlayerSeek
    extends Player {
        public static final String TYPE = "Player.Notifications.Player.Seek";
        public final GlobalModel.Time time;
        public final GlobalModel.Time seekoffset;

        public PlayerSeek(ObjectNode node) {
            super(node);
            this.time = new GlobalModel.Time((JsonNode)((ObjectNode)node.get("time")));
            this.seekoffset = new GlobalModel.Time((JsonNode)((ObjectNode)node.get("seekoffset")));
        }
    }

    public static class Player {
        public static final String TYPE = "Player.Notifications.Player";
        public final int playerId;
        public final int speed;

        public Player(ObjectNode node) {
            this.playerId = node.get("playerid").getIntValue();
            this.speed = node.get("speed").getValueAsInt(0);
        }
    }

    public static class Item {
        public static final String TYPE = "Player.Notifications.Item";
        public final int type;
        public final int id;
        public final String title;
        public final int year;
        public final int episode;
        public final int season;
        public final String showtitle;
        public final String album;
        public final String artist;
        public final int track;

        public Item(ObjectNode node) {
            this.type = Type.parse(node.get("type").getTextValue());
            this.id = AbstractEvent.parseInt(node, "id");
            this.title = AbstractEvent.parseString(node, "title");
            this.year = AbstractEvent.parseInt(node, "year");
            this.episode = AbstractEvent.parseInt(node, "episode");
            this.season = AbstractEvent.parseInt(node, "season");
            this.showtitle = AbstractEvent.parseString(node, "showtitle");
            this.album = AbstractEvent.parseString(node, "album");
            this.artist = AbstractEvent.parseString(node, "artist");
            this.track = AbstractEvent.parseInt(node, "track");
        }

        public String toString() {
            return Type.stringValue(this.type) + "(" + this.id + ")";
        }

        public static class Type {
            public static final int UNKNOWN = 0;
            public static final int MOVIE = 1;
            public static final int EPISODE = 2;
            public static final int MUSICVIDEO = 3;
            public static final int SONG = 4;

            public static int parse(String type) {
                if (type.equals("unknown")) {
                    return 0;
                }
                if (type.equals("movie")) {
                    return 1;
                }
                if (type.equals("episode")) {
                    return 2;
                }
                if (type.equals("musicvideo")) {
                    return 3;
                }
                if (type.equals("song")) {
                    return 4;
                }
                return 0;
            }

            public static String stringValue(int type) {
                switch (type) {
                    case 1: {
                        return "Movie";
                    }
                    case 2: {
                        return "Episode";
                    }
                    case 3: {
                        return "Musicvideo";
                    }
                    case 4: {
                        return "Song";
                    }
                }
                return "Unknown";
            }
        }
    }

    public static class Data {
        public static final String TYPE = "Player.Notifications.Data";
        public final Item item;
        public final Player player;

        public Data(ObjectNode node) {
            this.item = new Item((ObjectNode)node.get("item"));
            this.player = new Player((ObjectNode)node.get("player"));
        }
    }

    public static class Seek
    extends AbstractEvent {
        public static final int ID = 5;
        public static final String METHOD = "Player.OnSeek";
        public final Data data;

        public Seek(ObjectNode node) {
            super(node);
            this.data = new Data((ObjectNode)node.get("data"));
        }

        public String toString() {
            return "SEEK: Item " + this.data.item + " with player " + this.data.player.playerId + " to " + this.data.player.time + " at " + this.data.player.seekoffset + ".";
        }

        @Override
        public int getId() {
            return 5;
        }

        @Override
        public String getMethod() {
            return METHOD;
        }

        public static class Data {
            public final Item item;
            public final PlayerSeek player;

            public Data(ObjectNode node) {
                this.item = new Item((ObjectNode)node.get("item"));
                this.player = new PlayerSeek((ObjectNode)node.get("player"));
            }
        }
    }

    public static class SpeedChanged
    extends AbstractEvent {
        public static final int ID = 4;
        public static final String METHOD = "Player.OnSpeedChanged";
        public final Data data;

        public SpeedChanged(ObjectNode node) {
            super(node);
            this.data = new Data((ObjectNode)node.get("data"));
        }

        public String toString() {
            return "SPEED-CHANGE: Item " + this.data.item + " with player " + this.data.player.playerId + " at speed " + this.data.player.speed + ".";
        }

        @Override
        public int getId() {
            return 4;
        }

        @Override
        public String getMethod() {
            return METHOD;
        }
    }

    public static class Stop
    extends AbstractEvent {
        public static final int ID = 3;
        public static final String METHOD = "Player.OnStop";
        public final Data data;

        public Stop(ObjectNode node) {
            super(node);
            this.data = new Data((ObjectNode)node.get("data"));
        }

        public String toString() {
            return "STOP: Item " + this.data.item + ".";
        }

        @Override
        public int getId() {
            return 3;
        }

        @Override
        public String getMethod() {
            return METHOD;
        }

        public static class Data {
            public final Item item;

            public Data(ObjectNode node) {
                this.item = new Item((ObjectNode)node.get("item"));
            }
        }
    }

    public static class Pause
    extends AbstractEvent {
        public static final int ID = 2;
        public static final String METHOD = "Player.OnPause";
        public final Data data;

        public Pause(ObjectNode node) {
            super(node);
            this.data = new Data((ObjectNode)node.get("data"));
        }

        public String toString() {
            return "PAUSE: Item " + this.data.item + " with player " + this.data.player.playerId + " at speed " + this.data.player.speed + ".";
        }

        @Override
        public int getId() {
            return 2;
        }

        @Override
        public String getMethod() {
            return METHOD;
        }
    }

    public static class Play
    extends AbstractEvent {
        public static final int ID = 1;
        public static final String METHOD = "Player.OnPlay";
        public final Data data;

        public Play(ObjectNode node) {
            super(node);
            this.data = new Data((ObjectNode)node.get("data"));
        }

        public String toString() {
            return "PLAY: Item " + this.data.item + " with player " + this.data.player.playerId + " at speed " + this.data.player.speed + ".";
        }

        @Override
        public int getId() {
            return 1;
        }

        @Override
        public String getMethod() {
            return METHOD;
        }
    }
}

