/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.jsonrpc.io;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.net.ConnectException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.codehaus.jackson.JsonFactory;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.node.ObjectNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.jsonrpc.api.AbstractCall;
import org.tinymediamanager.jsonrpc.config.HostConfig;
import org.tinymediamanager.jsonrpc.io.ApiCallback;
import org.tinymediamanager.jsonrpc.io.ApiException;
import org.tinymediamanager.jsonrpc.io.ConnectionListener;
import org.tinymediamanager.jsonrpc.notification.AbstractEvent;

public class JavaConnectionManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(JavaConnectionManager.class);
    private final List<ConnectionListener> connectionListener = new ArrayList<ConnectionListener>();
    private final Map<String, CallRequest<?>> mCallRequests = new ConcurrentHashMap();
    private final Map<String, AbstractCall<?>> mCalls = new ConcurrentHashMap();
    private boolean isConnected = false;
    private Socket socket;
    private BufferedWriter bufferedWriter;
    private HostConfig hostConfig;
    private static final ObjectMapper OM = new ObjectMapper();

    public <T> JavaConnectionManager call(AbstractCall<T> call, ApiCallback<T> callback) {
        if (this.isConnected) {
            this.mCallRequests.put(call.getId(), new CallRequest<T>(call, callback));
            this.mCalls.put(call.getId(), call);
            this.writeSocket(call);
        } else {
            LOGGER.error("Cannot send call - NOT connected!");
        }
        return this;
    }

    public void registerConnectionListener(ConnectionListener listener) {
        if (listener != null) {
            this.connectionListener.add(listener);
        }
    }

    public void unregisterConnectionListener(ConnectionListener listener) {
        if (listener != null) {
            this.connectionListener.remove(listener);
        }
    }

    public boolean isConnected() {
        return this.isConnected;
    }

    public void connect(HostConfig config) throws ApiException {
        if (this.isConnected) {
            this.disconnect();
        }
        this.hostConfig = config;
        try {
            InetSocketAddress address = new InetSocketAddress(config.mAddress, config.mTcpPort);
            this.socket = new Socket();
            this.socket.setSoTimeout(0);
            this.socket.connect(address);
            this.bufferedWriter = new BufferedWriter(new OutputStreamWriter(this.socket.getOutputStream()));
            this.startParsingIncomingMessages();
            this.isConnected = true;
            this.notifyConnected();
        }
        catch (UnknownHostException e) {
            this.disconnect();
            throw new ApiException(7, e.getMessage(), e);
        }
        catch (ConnectException e) {
            this.disconnect();
            throw new ApiException(5, e.getMessage(), e);
        }
        catch (IOException e) {
            this.disconnect();
            throw new ApiException(2, e.getMessage(), e);
        }
    }

    public HostConfig getHostConfig() {
        return this.hostConfig;
    }

    public void reconnect() throws ApiException {
        this.connect(this.hostConfig);
    }

    private void startParsingIncomingMessages() {
        new Thread(){

            @Override
            public void run() {
                JsonFactory jf = OM.getJsonFactory();
                try {
                    JsonNode node;
                    JsonParser jp = jf.createJsonParser(JavaConnectionManager.this.socket.getInputStream());
                    while ((node = OM.readTree(jp)) != null) {
                        JavaConnectionManager.this.notifyClients(node);
                    }
                }
                catch (Exception e) {
                    LOGGER.warn("Error parsing incoming message: {}", (Object)e.getMessage());
                    JavaConnectionManager.this.disconnect();
                }
            }
        }.start();
    }

    public void disconnect() {
        if (this.isConnected) {
            try {
                if (this.bufferedWriter != null) {
                    this.bufferedWriter.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            try {
                if (this.socket != null) {
                    this.socket.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.notifyDisconnect();
            this.isConnected = false;
        }
    }

    private void notifyClients(JsonNode node) {
        if (node.has("error")) {
            String id = node.get("id").getValueAsText();
            if (this.mCallRequests.containsKey(id)) {
                CallRequest<?> callRequest = this.mCallRequests.remove(id);
                this.mCalls.remove(id);
                ApiCallback callback = ((CallRequest)callRequest).mCallback;
                AbstractCall call = ((CallRequest)callRequest).mCall;
                JsonNode errorNode = node.get("error");
                int errorCode = -1;
                if (errorNode.has("code")) {
                    errorCode = errorNode.get("code").getIntValue();
                }
                String message = "";
                if (errorNode.has("message")) {
                    message = errorNode.get("message").getTextValue();
                }
                String hint = "";
                if (errorNode.has("data")) {
                    hint = errorNode.get("data").toString();
                }
                callback.onError(errorCode, message, hint);
            } else {
                LOGGER.error("No such request for id {}: ERROR={}", (Object)id, (Object)node.toString());
            }
        } else if (node.has("id")) {
            String id = node.get("id").getValueAsText();
            if (this.mCallRequests.containsKey(id)) {
                CallRequest<?> callRequest = this.mCallRequests.remove(id);
                this.mCalls.remove(id);
                ApiCallback callback = ((CallRequest)callRequest).mCallback;
                AbstractCall call = ((CallRequest)callRequest).mCall;
                call.setResponse(node);
                callback.onResponse(call);
            } else {
                LOGGER.error("No such request for id {}: DATA={}", (Object)id, (Object)node.toString());
            }
        } else {
            AbstractEvent event = AbstractEvent.parse((ObjectNode)node);
            if (event != null) {
                for (ConnectionListener listener : this.connectionListener) {
                    listener.notificationReceived(event);
                }
            }
        }
    }

    private void writeSocket(AbstractCall<?> call) {
        String data = call.getRequest().toString();
        LOGGER.debug("CALL: {}", (Object)data);
        try {
            this.bufferedWriter.write(data + "\n");
            this.bufferedWriter.flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void notifyDisconnect() {
        for (ConnectionListener listener : this.connectionListener) {
            listener.disconnected();
        }
    }

    private void notifyConnected() {
        for (ConnectionListener listener : this.connectionListener) {
            listener.connected();
        }
    }

    private static class CallRequest<T> {
        private final AbstractCall<T> mCall;
        private final ApiCallback<T> mCallback;

        public CallRequest(AbstractCall<T> call, ApiCallback<T> callback) {
            this.mCall = call;
            this.mCallback = callback;
        }

        public void update(AbstractCall<?> call) {
            this.mCall.copyResponse(call);
        }

        public void respond() {
            this.mCallback.onResponse(this.mCall);
        }

        public void error(int code, String message, String hint) {
            this.mCallback.onError(code, message, hint);
        }
    }
}

