/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.jsonrpc.api.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.node.ArrayNode;
import org.codehaus.jackson.node.ObjectNode;
import org.tinymediamanager.jsonrpc.api.AbstractModel;
import org.tinymediamanager.jsonrpc.api.model.GlobalModel;
import org.tinymediamanager.jsonrpc.api.model.NotificationsModel;

public final class PlayerModel {

    public static interface Type {
        public static final String VIDEO = "video";
        public static final String AUDIO = "audio";
        public static final String PICTURE = "picture";
        public static final Set<String> values = new HashSet<String>(Arrays.asList("video", "audio", "picture"));
    }

    public static interface Repeat {
        public static final String OFF = "off";
        public static final String ONE = "one";
        public static final String ALL = "all";
        public static final Set<String> values = new HashSet<String>(Arrays.asList("off", "one", "all"));
    }

    public static interface PropertyName {
        public static final String TYPE = "type";
        public static final String PARTYMODE = "partymode";
        public static final String SPEED = "speed";
        public static final String TIME = "time";
        public static final String PERCENTAGE = "percentage";
        public static final String TOTALTIME = "totaltime";
        public static final String PLAYLISTID = "playlistid";
        public static final String POSITION = "position";
        public static final String REPEAT = "repeat";
        public static final String SHUFFLED = "shuffled";
        public static final String CANSEEK = "canseek";
        public static final String CANCHANGESPEED = "canchangespeed";
        public static final String CANMOVE = "canmove";
        public static final String CANZOOM = "canzoom";
        public static final String CANROTATE = "canrotate";
        public static final String CANSHUFFLE = "canshuffle";
        public static final String CANREPEAT = "canrepeat";
        public static final String CURRENTAUDIOSTREAM = "currentaudiostream";
        public static final String AUDIOSTREAMS = "audiostreams";
        public static final String SUBTITLEENABLED = "subtitleenabled";
        public static final String CURRENTSUBTITLE = "currentsubtitle";
        public static final String SUBTITLES = "subtitles";
        public static final String LIVE = "live";
        public static final Set<String> values = new HashSet<String>(Arrays.asList("type", "partymode", "speed", "time", "percentage", "totaltime", "playlistid", "position", "repeat", "shuffled", "canseek", "canchangespeed", "canmove", "canzoom", "canrotate", "canshuffle", "canrepeat", "currentaudiostream", "audiostreams", "subtitleenabled", "currentsubtitle", "subtitles", "live"));
    }

    public static class Subtitle
    extends AbstractModel {
        public static final String API_TYPE = "Player.Subtitle";
        public static final String INDEX = "index";
        public static final String LANGUAGE = "language";
        public static final String NAME = "name";
        public final Integer index;
        public final String language;
        public final String name;

        public Subtitle(Integer index, String language, String name) {
            this.index = index;
            this.language = language;
            this.name = name;
        }

        public Subtitle(JsonNode node) {
            this.index = node.get(INDEX).getIntValue();
            this.language = node.get(LANGUAGE).getTextValue();
            this.name = node.get(NAME).getTextValue();
        }

        @Override
        public JsonNode toJsonNode() {
            ObjectNode node = OM.createObjectNode();
            node.put(INDEX, this.index);
            node.put(LANGUAGE, this.language);
            node.put(NAME, this.name);
            return node;
        }

        static List<Subtitle> getPlayerModelSubtitleList(JsonNode node, String key) {
            if (node.has(key)) {
                ArrayNode a = (ArrayNode)node.get(key);
                ArrayList<Subtitle> l = new ArrayList<Subtitle>(a.size());
                for (int i = 0; i < a.size(); ++i) {
                    l.add(new Subtitle(a.get(i)));
                }
                return l;
            }
            return new ArrayList<Subtitle>(0);
        }
    }

    public static class Speed
    extends AbstractModel {
        public static final String API_TYPE = "Player.Speed";
        public static final String SPEED = "speed";
        public final Integer speed;

        public Speed(Integer speed) {
            this.speed = speed;
        }

        public Speed(JsonNode node) {
            this.speed = Speed.parseInt(node, SPEED);
        }

        @Override
        public JsonNode toJsonNode() {
            ObjectNode node = OM.createObjectNode();
            node.put(SPEED, this.speed);
            return node;
        }

        static List<Speed> getPlayerModelSpeedList(JsonNode node, String key) {
            if (node.has(key)) {
                ArrayNode a = (ArrayNode)node.get(key);
                ArrayList<Speed> l = new ArrayList<Speed>(a.size());
                for (int i = 0; i < a.size(); ++i) {
                    l.add(new Speed(a.get(i)));
                }
                return l;
            }
            return new ArrayList<Speed>(0);
        }
    }

    public static class PropertyValue
    extends AbstractModel {
        public static final String API_TYPE = "Player.Property.Value";
        public static final String AUDIOSTREAMS = "audiostreams";
        public static final String CANCHANGESPEED = "canchangespeed";
        public static final String CANMOVE = "canmove";
        public static final String CANREPEAT = "canrepeat";
        public static final String CANROTATE = "canrotate";
        public static final String CANSEEK = "canseek";
        public static final String CANSHUFFLE = "canshuffle";
        public static final String CANZOOM = "canzoom";
        public static final String CURRENTAUDIOSTREAM = "currentaudiostream";
        public static final String CURRENTSUBTITLE = "currentsubtitle";
        public static final String LIVE = "live";
        public static final String PARTYMODE = "partymode";
        public static final String PERCENTAGE = "percentage";
        public static final String PLAYLISTID = "playlistid";
        public static final String POSITION = "position";
        public static final String REPEAT = "repeat";
        public static final String SHUFFLED = "shuffled";
        public static final String SPEED = "speed";
        public static final String SUBTITLEENABLED = "subtitleenabled";
        public static final String SUBTITLES = "subtitles";
        public static final String TIME = "time";
        public static final String TOTALTIME = "totaltime";
        public static final String TYPE = "type";
        public final List<AudioStream> audiostreams;
        public final Boolean canchangespeed;
        public final Boolean canmove;
        public final Boolean canrepeat;
        public final Boolean canrotate;
        public final Boolean canseek;
        public final Boolean canshuffle;
        public final Boolean canzoom;
        public final AudioStream currentaudiostream;
        public final Subtitle currentsubtitle;
        public final Boolean live;
        public final Boolean partymode;
        public final Double percentage;
        public final Integer playlistid;
        public final Integer position;
        public final String repeat;
        public final Boolean shuffled;
        public final Integer speed;
        public final Boolean subtitleenabled;
        public final List<Subtitle> subtitles;
        public final GlobalModel.Time time;
        public final GlobalModel.Time totaltime;
        public final String type;

        public PropertyValue(List<AudioStream> audiostreams, Boolean canchangespeed, Boolean canmove, Boolean canrepeat, Boolean canrotate, Boolean canseek, Boolean canshuffle, Boolean canzoom, AudioStream currentaudiostream, Subtitle currentsubtitle, Boolean live, Boolean partymode, Double percentage, Integer playlistid, Integer position, String repeat, Boolean shuffled, Integer speed, Boolean subtitleenabled, List<Subtitle> subtitles, GlobalModel.Time time, GlobalModel.Time totaltime, String type) {
            this.audiostreams = audiostreams;
            this.canchangespeed = canchangespeed;
            this.canmove = canmove;
            this.canrepeat = canrepeat;
            this.canrotate = canrotate;
            this.canseek = canseek;
            this.canshuffle = canshuffle;
            this.canzoom = canzoom;
            this.currentaudiostream = currentaudiostream;
            this.currentsubtitle = currentsubtitle;
            this.live = live;
            this.partymode = partymode;
            this.percentage = percentage;
            this.playlistid = playlistid;
            this.position = position;
            this.repeat = repeat;
            this.shuffled = shuffled;
            this.speed = speed;
            this.subtitleenabled = subtitleenabled;
            this.subtitles = subtitles;
            this.time = time;
            this.totaltime = totaltime;
            this.type = type;
        }

        public PropertyValue(JsonNode node) {
            this.audiostreams = AudioStream.getPlayerModelAudioStreamList(node, AUDIOSTREAMS);
            this.canchangespeed = PropertyValue.parseBoolean(node, CANCHANGESPEED);
            this.canmove = PropertyValue.parseBoolean(node, CANMOVE);
            this.canrepeat = PropertyValue.parseBoolean(node, CANREPEAT);
            this.canrotate = PropertyValue.parseBoolean(node, CANROTATE);
            this.canseek = PropertyValue.parseBoolean(node, CANSEEK);
            this.canshuffle = PropertyValue.parseBoolean(node, CANSHUFFLE);
            this.canzoom = PropertyValue.parseBoolean(node, CANZOOM);
            this.currentaudiostream = node.has(CURRENTAUDIOSTREAM) ? new AudioStream(node.get(CURRENTAUDIOSTREAM)) : null;
            this.currentsubtitle = node.has(CURRENTSUBTITLE) ? new Subtitle(node.get(CURRENTSUBTITLE)) : null;
            this.live = PropertyValue.parseBoolean(node, LIVE);
            this.partymode = PropertyValue.parseBoolean(node, PARTYMODE);
            this.percentage = PropertyValue.parseDouble(node, PERCENTAGE);
            this.playlistid = PropertyValue.parseInt(node, PLAYLISTID);
            this.position = PropertyValue.parseInt(node, POSITION);
            this.repeat = PropertyValue.parseString(node, REPEAT);
            this.shuffled = PropertyValue.parseBoolean(node, SHUFFLED);
            this.speed = PropertyValue.parseInt(node, SPEED);
            this.subtitleenabled = PropertyValue.parseBoolean(node, SUBTITLEENABLED);
            this.subtitles = Subtitle.getPlayerModelSubtitleList(node, SUBTITLES);
            this.time = node.has(TIME) ? new GlobalModel.Time(node.get(TIME)) : null;
            this.totaltime = node.has(TOTALTIME) ? new GlobalModel.Time(node.get(TOTALTIME)) : null;
            this.type = PropertyValue.parseString(node, TYPE);
        }

        @Override
        public JsonNode toJsonNode() {
            ObjectNode node = OM.createObjectNode();
            ArrayNode audiostreamsArray = OM.createArrayNode();
            for (AudioStream item : this.audiostreams) {
                audiostreamsArray.add(item.toJsonNode());
            }
            node.put(AUDIOSTREAMS, (JsonNode)audiostreamsArray);
            node.put(CANCHANGESPEED, this.canchangespeed);
            node.put(CANMOVE, this.canmove);
            node.put(CANREPEAT, this.canrepeat);
            node.put(CANROTATE, this.canrotate);
            node.put(CANSEEK, this.canseek);
            node.put(CANSHUFFLE, this.canshuffle);
            node.put(CANZOOM, this.canzoom);
            node.put(CURRENTAUDIOSTREAM, this.currentaudiostream == null ? null : this.currentaudiostream.toJsonNode());
            node.put(CURRENTSUBTITLE, this.currentsubtitle == null ? null : this.currentsubtitle.toJsonNode());
            node.put(LIVE, this.live);
            node.put(PARTYMODE, this.partymode);
            node.put(PERCENTAGE, this.percentage);
            node.put(PLAYLISTID, this.playlistid);
            node.put(POSITION, this.position);
            node.put(REPEAT, this.repeat);
            node.put(SHUFFLED, this.shuffled);
            node.put(SPEED, this.speed);
            node.put(SUBTITLEENABLED, this.subtitleenabled);
            ArrayNode subtitlesArray = OM.createArrayNode();
            for (Subtitle item : this.subtitles) {
                subtitlesArray.add(item.toJsonNode());
            }
            node.put(SUBTITLES, (JsonNode)subtitlesArray);
            node.put(TIME, this.time == null ? null : this.time.toJsonNode());
            node.put(TOTALTIME, this.totaltime == null ? null : this.totaltime.toJsonNode());
            node.put(TYPE, this.type);
            return node;
        }

        static List<PropertyValue> getPlayerModelPropertyValueList(JsonNode node, String key) {
            if (node.has(key)) {
                ArrayNode a = (ArrayNode)node.get(key);
                ArrayList<PropertyValue> l = new ArrayList<PropertyValue>(a.size());
                for (int i = 0; i < a.size(); ++i) {
                    l.add(new PropertyValue(a.get(i)));
                }
                return l;
            }
            return new ArrayList<PropertyValue>(0);
        }

        public static interface Type {
            public static final String VIDEO = "video";
            public static final String AUDIO = "audio";
            public static final String PICTURE = "picture";
            public static final Set<String> values = new HashSet<String>(Arrays.asList("video", "audio", "picture"));
        }

        public static interface Repeat {
            public static final String OFF = "off";
            public static final String ONE = "one";
            public static final String ALL = "all";
            public static final Set<String> values = new HashSet<String>(Arrays.asList("off", "one", "all"));
        }
    }

    public static class PositionTime
    extends AbstractModel {
        public static final String API_TYPE = "Player.Position.Time";
        public static final String HOURS = "hours";
        public static final String MILLISECONDS = "milliseconds";
        public static final String MINUTES = "minutes";
        public static final String SECONDS = "seconds";
        public final Integer hours;
        public final Integer milliseconds;
        public final Integer minutes;
        public final Integer seconds;

        public PositionTime(Integer hours, Integer milliseconds, Integer minutes, Integer seconds) {
            this.hours = hours;
            this.milliseconds = milliseconds;
            this.minutes = minutes;
            this.seconds = seconds;
        }

        @Override
        public JsonNode toJsonNode() {
            ObjectNode node = OM.createObjectNode();
            node.put(HOURS, this.hours);
            node.put(MILLISECONDS, this.milliseconds);
            node.put(MINUTES, this.minutes);
            node.put(SECONDS, this.seconds);
            return node;
        }
    }

    public static class NotificationsPlayerSeek
    extends NotificationsPlayer {
        public static final String API_TYPE = "Player.Notifications.Player.Seek";
        public static final String SEEKOFFSET = "seekoffset";
        public static final String TIME = "time";
        public final GlobalModel.Time seekoffset = null;
        public final GlobalModel.Time time = null;

        @Override
        public JsonNode toJsonNode() {
            ObjectNode node = (ObjectNode)super.toJsonNode();
            node.put(SEEKOFFSET, this.seekoffset == null ? null : this.seekoffset.toJsonNode());
            node.put(TIME, this.time == null ? null : this.time.toJsonNode());
            return node;
        }

        public NotificationsPlayerSeek() {
            super(null, null);
        }
    }

    public static class NotificationsPlayer
    extends AbstractModel {
        public static final String API_TYPE = "Player.Notifications.Player";
        public static final String PLAYERID = "playerid";
        public static final String SPEED = "speed";
        public final Integer playerid;
        public final Integer speed;

        public NotificationsPlayer(Integer playerid, Integer speed) {
            this.playerid = playerid;
            this.speed = speed;
        }

        @Override
        public JsonNode toJsonNode() {
            ObjectNode node = OM.createObjectNode();
            node.put(PLAYERID, this.playerid);
            node.put(SPEED, this.speed);
            return node;
        }
    }

    public static class NotificationsData
    extends AbstractModel {
        public static final String API_TYPE = "Player.Notifications.Data";
        public static final String ITEM = "item";
        public static final String PLAYER = "player";
        public final NotificationsModel.Item item;
        public final NotificationsPlayer player;

        public NotificationsData(NotificationsModel.Item item, NotificationsPlayer player) {
            this.item = item;
            this.player = player;
        }

        @Override
        public JsonNode toJsonNode() {
            ObjectNode node = OM.createObjectNode();
            node.put(ITEM, this.item == null ? null : this.item.toJsonNode());
            node.put(PLAYER, this.player == null ? null : this.player.toJsonNode());
            return node;
        }
    }

    public static class AudioStream
    extends AbstractModel {
        public static final String API_TYPE = "Player.Audio.Stream";
        public static final String BITRATE = "bitrate";
        public static final String CHANNELS = "channels";
        public static final String CODEC = "codec";
        public static final String INDEX = "index";
        public static final String LANGUAGE = "language";
        public static final String NAME = "name";
        public final Integer bitrate;
        public final Integer channels;
        public final String codec;
        public final Integer index;
        public final String language;
        public final String name;

        public AudioStream(Integer bitrate, Integer channels, String codec, Integer index, String language, String name) {
            this.bitrate = bitrate;
            this.channels = channels;
            this.codec = codec;
            this.index = index;
            this.language = language;
            this.name = name;
        }

        public AudioStream(JsonNode node) {
            this.bitrate = node.get(BITRATE).getIntValue();
            this.channels = node.get(CHANNELS).getIntValue();
            this.codec = node.get(CODEC).getTextValue();
            this.index = node.get(INDEX).getIntValue();
            this.language = node.get(LANGUAGE).getTextValue();
            this.name = node.get(NAME).getTextValue();
        }

        @Override
        public JsonNode toJsonNode() {
            ObjectNode node = OM.createObjectNode();
            node.put(BITRATE, this.bitrate);
            node.put(CHANNELS, this.channels);
            node.put(CODEC, this.codec);
            node.put(INDEX, this.index);
            node.put(LANGUAGE, this.language);
            node.put(NAME, this.name);
            return node;
        }

        static List<AudioStream> getPlayerModelAudioStreamList(JsonNode node, String key) {
            if (node.has(key)) {
                ArrayNode a = (ArrayNode)node.get(key);
                ArrayList<AudioStream> l = new ArrayList<AudioStream>(a.size());
                for (int i = 0; i < a.size(); ++i) {
                    l.add(new AudioStream(a.get(i)));
                }
                return l;
            }
            return new ArrayList<AudioStream>(0);
        }
    }
}

