/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.jsonrpc.api.call;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.node.ArrayNode;
import org.codehaus.jackson.node.ObjectNode;
import org.tinymediamanager.jsonrpc.api.AbstractCall;
import org.tinymediamanager.jsonrpc.api.AbstractModel;
import org.tinymediamanager.jsonrpc.api.model.LibraryModel;
import org.tinymediamanager.jsonrpc.api.model.ListModel;
import org.tinymediamanager.jsonrpc.api.model.MediaModel;
import org.tinymediamanager.jsonrpc.api.model.VideoModel;

public final class VideoLibrary {

    public static class SetTVShowDetails
    extends AbstractCall<String> {
        public static final String API_TYPE = "VideoLibrary.SetTVShowDetails";

        public SetTVShowDetails(Integer tvshowid, String title, Integer playcount, String[] studio, String plot, String[] genre, Double rating, String mpaa, String imdbnumber, String premiered, String votes, String lastplayed, String originaltitle, String sorttitle, String episodeguide, String thumbnail, String fanart, String[] tag, MediaModel.ArtworkSet art, Integer userrating) {
            this.addParameter("tvshowid", tvshowid);
            this.addParameter("title", title);
            this.addParameter("playcount", playcount);
            this.addParameter("studio", studio);
            this.addParameter("plot", plot);
            this.addParameter("genre", genre);
            this.addParameter("rating", rating);
            this.addParameter("mpaa", mpaa);
            this.addParameter("imdbnumber", imdbnumber);
            this.addParameter("premiered", premiered);
            this.addParameter("votes", votes);
            this.addParameter("lastplayed", lastplayed);
            this.addParameter("originaltitle", originaltitle);
            this.addParameter("sorttitle", sorttitle);
            this.addParameter("episodeguide", episodeguide);
            this.addParameter("thumbnail", thumbnail);
            this.addParameter("fanart", fanart);
            this.addParameter("tag", tag);
            this.addParameter("art", (AbstractModel)art);
            this.addParameter("userrating", userrating);
        }

        @Override
        protected String parseOne(JsonNode node) {
            return node.getTextValue();
        }

        @Override
        public String getName() {
            return API_TYPE;
        }

        @Override
        protected boolean returnsList() {
            return false;
        }
    }

    public static class SetSeasonDetails
    extends AbstractCall<String> {
        public static final String API_TYPE = "VideoLibrary.SetSeasonDetails";

        public SetSeasonDetails(Integer seasonid, MediaModel.ArtworkSet art) {
            this.addParameter("seasonid", seasonid);
            this.addParameter("art", (AbstractModel)art);
        }

        public SetSeasonDetails(Integer seasonid) {
            this.addParameter("seasonid", seasonid);
        }

        @Override
        protected String parseOne(JsonNode node) {
            return node.getTextValue();
        }

        @Override
        public String getName() {
            return API_TYPE;
        }

        @Override
        protected boolean returnsList() {
            return false;
        }
    }

    public static class SetMusicVideoDetails
    extends AbstractCall<String> {
        public static final String API_TYPE = "VideoLibrary.SetMusicVideoDetails";

        public SetMusicVideoDetails(Integer musicvideoid, String title, Integer playcount, Integer runtime, String[] director, String[] studio, Integer year, String plot, String album, String[] artist, String[] genre, Integer track, String lastplayed, String thumbnail, String fanart, String[] tag, MediaModel.ArtworkSet art, VideoModel.Resume resume, Integer userrating) {
            this.addParameter("musicvideoid", musicvideoid);
            this.addParameter("title", title);
            this.addParameter("playcount", playcount);
            this.addParameter("runtime", runtime);
            this.addParameter("director", director);
            this.addParameter("studio", studio);
            this.addParameter("year", year);
            this.addParameter("plot", plot);
            this.addParameter("album", album);
            this.addParameter("artist", artist);
            this.addParameter("genre", genre);
            this.addParameter("track", track);
            this.addParameter("lastplayed", lastplayed);
            this.addParameter("thumbnail", thumbnail);
            this.addParameter("fanart", fanart);
            this.addParameter("tag", tag);
            this.addParameter("art", (AbstractModel)art);
            this.addParameter("resume", (AbstractModel)resume);
            this.addParameter("userrating", userrating);
        }

        @Override
        protected String parseOne(JsonNode node) {
            return node.getTextValue();
        }

        @Override
        public String getName() {
            return API_TYPE;
        }

        @Override
        protected boolean returnsList() {
            return false;
        }
    }

    public static class SetMovieSetDetails
    extends AbstractCall<String> {
        public static final String API_TYPE = "VideoLibrary.SetMovieSetDetails";

        public SetMovieSetDetails(Integer setid, String title, MediaModel.ArtworkSet art) {
            this.addParameter("setid", setid);
            this.addParameter("title", title);
            this.addParameter("art", (AbstractModel)art);
        }

        public SetMovieSetDetails(Integer setid) {
            this.addParameter("setid", setid);
        }

        public SetMovieSetDetails(Integer setid, String title) {
            this.addParameter("setid", setid);
            this.addParameter("title", title);
        }

        public SetMovieSetDetails(Integer setid, MediaModel.ArtworkSet art) {
            this.addParameter("setid", setid);
            this.addParameter("art", (AbstractModel)art);
        }

        @Override
        protected String parseOne(JsonNode node) {
            return node.getTextValue();
        }

        @Override
        public String getName() {
            return API_TYPE;
        }

        @Override
        protected boolean returnsList() {
            return false;
        }
    }

    public static class SetMovieDetails
    extends AbstractCall<String> {
        public static final String API_TYPE = "VideoLibrary.SetMovieDetails";

        public SetMovieDetails(Integer movieid, String title, Integer playcount, Integer runtime, String[] director, String[] studio, Integer year, String plot, String[] genre, Double rating, String mpaa, String imdbnumber, String votes, String lastplayed, String originaltitle, String trailer, String tagline, String plotoutline, String[] writer, String[] country, Integer top250, String sorttitle, String set, String[] showlink, String thumbnail, String fanart, String[] tag, MediaModel.ArtworkSet art, VideoModel.Resume resume, Integer userrating) {
            this.addParameter("movieid", movieid);
            this.addParameter("title", title);
            this.addParameter("playcount", playcount);
            this.addParameter("runtime", runtime);
            this.addParameter("director", director);
            this.addParameter("studio", studio);
            this.addParameter("year", year);
            this.addParameter("plot", plot);
            this.addParameter("genre", genre);
            this.addParameter("rating", rating);
            this.addParameter("mpaa", mpaa);
            this.addParameter("imdbnumber", imdbnumber);
            this.addParameter("votes", votes);
            this.addParameter("lastplayed", lastplayed);
            this.addParameter("originaltitle", originaltitle);
            this.addParameter("trailer", trailer);
            this.addParameter("tagline", tagline);
            this.addParameter("plotoutline", plotoutline);
            this.addParameter("writer", writer);
            this.addParameter("country", country);
            this.addParameter("top250", top250);
            this.addParameter("sorttitle", sorttitle);
            this.addParameter("set", set);
            this.addParameter("showlink", showlink);
            this.addParameter("thumbnail", thumbnail);
            this.addParameter("fanart", fanart);
            this.addParameter("tag", tag);
            this.addParameter("art", (AbstractModel)art);
            this.addParameter("resume", (AbstractModel)resume);
            this.addParameter("userrating", userrating);
        }

        @Override
        protected String parseOne(JsonNode node) {
            return node.getTextValue();
        }

        @Override
        public String getName() {
            return API_TYPE;
        }

        @Override
        protected boolean returnsList() {
            return false;
        }
    }

    public static class SetEpisodeDetails
    extends AbstractCall<String> {
        public static final String API_TYPE = "VideoLibrary.SetEpisodeDetails";

        public SetEpisodeDetails(Integer episodeid, String title, Integer playcount, Integer runtime, String[] director, String plot, Double rating, String votes, String lastplayed, String[] writer, String firstaired, String productioncode, Integer season, Integer episode, String originaltitle, String thumbnail, String fanart, MediaModel.ArtworkSet art, VideoModel.Resume resume, Integer userrating) {
            this.addParameter("episodeid", episodeid);
            this.addParameter("title", title);
            this.addParameter("playcount", playcount);
            this.addParameter("runtime", runtime);
            this.addParameter("director", director);
            this.addParameter("plot", plot);
            this.addParameter("rating", rating);
            this.addParameter("votes", votes);
            this.addParameter("lastplayed", lastplayed);
            this.addParameter("writer", writer);
            this.addParameter("firstaired", firstaired);
            this.addParameter("productioncode", productioncode);
            this.addParameter("season", season);
            this.addParameter("episode", episode);
            this.addParameter("originaltitle", originaltitle);
            this.addParameter("thumbnail", thumbnail);
            this.addParameter("fanart", fanart);
            this.addParameter("art", (AbstractModel)art);
            this.addParameter("resume", (AbstractModel)resume);
            this.addParameter("userrating", userrating);
        }

        @Override
        protected String parseOne(JsonNode node) {
            return node.getTextValue();
        }

        @Override
        public String getName() {
            return API_TYPE;
        }

        @Override
        protected boolean returnsList() {
            return false;
        }
    }

    public static class Scan
    extends AbstractCall<String> {
        public static final String API_TYPE = "VideoLibrary.Scan";

        public Scan(String directory, Boolean showdialogs) {
            this.addParameter("directory", directory);
            this.addParameter("showdialogs", showdialogs);
        }

        public Scan() {
        }

        public Scan(String directory) {
            this.addParameter("directory", directory);
        }

        @Override
        protected String parseOne(JsonNode node) {
            return node.getTextValue();
        }

        @Override
        public String getName() {
            return API_TYPE;
        }

        @Override
        protected boolean returnsList() {
            return false;
        }
    }

    public static class RemoveTVShow
    extends AbstractCall<String> {
        public static final String API_TYPE = "VideoLibrary.RemoveTVShow";

        public RemoveTVShow(Integer tvshowid) {
            this.addParameter("tvshowid", tvshowid);
        }

        @Override
        protected String parseOne(JsonNode node) {
            return node.getTextValue();
        }

        @Override
        public String getName() {
            return API_TYPE;
        }

        @Override
        protected boolean returnsList() {
            return false;
        }
    }

    public static class RemoveMusicVideo
    extends AbstractCall<String> {
        public static final String API_TYPE = "VideoLibrary.RemoveMusicVideo";

        public RemoveMusicVideo(Integer musicvideoid) {
            this.addParameter("musicvideoid", musicvideoid);
        }

        @Override
        protected String parseOne(JsonNode node) {
            return node.getTextValue();
        }

        @Override
        public String getName() {
            return API_TYPE;
        }

        @Override
        protected boolean returnsList() {
            return false;
        }
    }

    public static class RemoveMovie
    extends AbstractCall<String> {
        public static final String API_TYPE = "VideoLibrary.RemoveMovie";

        public RemoveMovie(Integer movieid) {
            this.addParameter("movieid", movieid);
        }

        @Override
        protected String parseOne(JsonNode node) {
            return node.getTextValue();
        }

        @Override
        public String getName() {
            return API_TYPE;
        }

        @Override
        protected boolean returnsList() {
            return false;
        }
    }

    public static class RemoveEpisode
    extends AbstractCall<String> {
        public static final String API_TYPE = "VideoLibrary.RemoveEpisode";

        public RemoveEpisode(Integer episodeid) {
            this.addParameter("episodeid", episodeid);
        }

        @Override
        protected String parseOne(JsonNode node) {
            return node.getTextValue();
        }

        @Override
        public String getName() {
            return API_TYPE;
        }

        @Override
        protected boolean returnsList() {
            return false;
        }
    }

    public static class RefreshTVShow
    extends AbstractCall<String> {
        public static final String API_TYPE = "VideoLibrary.RefreshTVShow";

        public RefreshTVShow(Integer tvshowid, Boolean ignorenfo, Boolean refreshepisodes, String title) {
            this.addParameter("tvshowid", tvshowid);
            this.addParameter("ignorenfo", ignorenfo);
            this.addParameter("refreshepisodes", refreshepisodes);
            this.addParameter("title", title);
        }

        public RefreshTVShow(Integer tvshowid) {
            this.addParameter("tvshowid", tvshowid);
        }

        public RefreshTVShow(Integer tvshowid, Boolean ignorenfo) {
            this.addParameter("tvshowid", tvshowid);
            this.addParameter("ignorenfo", ignorenfo);
        }

        public RefreshTVShow(Integer tvshowid, Boolean ignorenfo, Boolean refreshepisodes) {
            this.addParameter("tvshowid", tvshowid);
            this.addParameter("ignorenfo", ignorenfo);
            this.addParameter("refreshepisodes", refreshepisodes);
        }

        public RefreshTVShow(Integer tvshowid, String title) {
            this.addParameter("tvshowid", tvshowid);
            this.addParameter("title", title);
        }

        public RefreshTVShow(Integer tvshowid, Boolean ignorenfo, String title) {
            this.addParameter("tvshowid", tvshowid);
            this.addParameter("ignorenfo", ignorenfo);
            this.addParameter("title", title);
        }

        @Override
        protected String parseOne(JsonNode node) {
            return node.getTextValue();
        }

        @Override
        public String getName() {
            return API_TYPE;
        }

        @Override
        protected boolean returnsList() {
            return false;
        }
    }

    public static class RefreshMusicVideo
    extends AbstractCall<String> {
        public static final String API_TYPE = "VideoLibrary.RefreshMusicVideo";

        public RefreshMusicVideo(Integer musicvideoid, Boolean ignorenfo, String title) {
            this.addParameter("musicvideoid", musicvideoid);
            this.addParameter("ignorenfo", ignorenfo);
            this.addParameter("title", title);
        }

        public RefreshMusicVideo(Integer musicvideoid) {
            this.addParameter("musicvideoid", musicvideoid);
        }

        public RefreshMusicVideo(Integer musicvideoid, Boolean ignorenfo) {
            this.addParameter("musicvideoid", musicvideoid);
            this.addParameter("ignorenfo", ignorenfo);
        }

        public RefreshMusicVideo(Integer musicvideoid, String title) {
            this.addParameter("musicvideoid", musicvideoid);
            this.addParameter("title", title);
        }

        @Override
        protected String parseOne(JsonNode node) {
            return node.getTextValue();
        }

        @Override
        public String getName() {
            return API_TYPE;
        }

        @Override
        protected boolean returnsList() {
            return false;
        }
    }

    public static class RefreshMovie
    extends AbstractCall<String> {
        public static final String API_TYPE = "VideoLibrary.RefreshMovie";

        public RefreshMovie(Integer movieid, Boolean ignorenfo, String title) {
            this.addParameter("movieid", movieid);
            this.addParameter("ignorenfo", ignorenfo);
            this.addParameter("title", title);
        }

        public RefreshMovie(Integer movieid) {
            this.addParameter("movieid", movieid);
        }

        public RefreshMovie(Integer movieid, Boolean ignorenfo) {
            this.addParameter("movieid", movieid);
            this.addParameter("ignorenfo", ignorenfo);
        }

        public RefreshMovie(Integer movieid, String title) {
            this.addParameter("movieid", movieid);
            this.addParameter("title", title);
        }

        @Override
        protected String parseOne(JsonNode node) {
            return node.getTextValue();
        }

        @Override
        public String getName() {
            return API_TYPE;
        }

        @Override
        protected boolean returnsList() {
            return false;
        }
    }

    public static class RefreshEpisode
    extends AbstractCall<String> {
        public static final String API_TYPE = "VideoLibrary.RefreshEpisode";

        public RefreshEpisode(Integer episodeid, Boolean ignorenfo, String title) {
            this.addParameter("episodeid", episodeid);
            this.addParameter("ignorenfo", ignorenfo);
            this.addParameter("title", title);
        }

        public RefreshEpisode(Integer episodeid) {
            this.addParameter("episodeid", episodeid);
        }

        public RefreshEpisode(Integer episodeid, Boolean ignorenfo) {
            this.addParameter("episodeid", episodeid);
            this.addParameter("ignorenfo", ignorenfo);
        }

        public RefreshEpisode(Integer episodeid, String title) {
            this.addParameter("episodeid", episodeid);
            this.addParameter("title", title);
        }

        @Override
        protected String parseOne(JsonNode node) {
            return node.getTextValue();
        }

        @Override
        public String getName() {
            return API_TYPE;
        }

        @Override
        protected boolean returnsList() {
            return false;
        }
    }

    public static class GetTVShows
    extends AbstractCall<VideoModel.TVShowDetail> {
        public static final String API_TYPE = "VideoLibrary.GetTVShows";
        public static final String RESULT = "tvshows";

        public GetTVShows(ListModel.Limits limits, ListModel.Sort sort, FilterGenreId filter, String ... properties) {
            this.addParameter("limits", (AbstractModel)limits);
            this.addParameter("sort", (AbstractModel)sort);
            this.addParameter("filter", (AbstractModel)filter);
            this.addParameter("properties", properties);
        }

        public GetTVShows(ListModel.Limits limits, ListModel.Sort sort, FilterGenre filter, String ... properties) {
            this.addParameter("limits", (AbstractModel)limits);
            this.addParameter("sort", (AbstractModel)sort);
            this.addParameter("filter", (AbstractModel)filter);
            this.addParameter("properties", properties);
        }

        public GetTVShows(ListModel.Limits limits, ListModel.Sort sort, FilterYear filter, String ... properties) {
            this.addParameter("limits", (AbstractModel)limits);
            this.addParameter("sort", (AbstractModel)sort);
            this.addParameter("filter", (AbstractModel)filter);
            this.addParameter("properties", properties);
        }

        public GetTVShows(ListModel.Limits limits, ListModel.Sort sort, FilterActor filter, String ... properties) {
            this.addParameter("limits", (AbstractModel)limits);
            this.addParameter("sort", (AbstractModel)sort);
            this.addParameter("filter", (AbstractModel)filter);
            this.addParameter("properties", properties);
        }

        public GetTVShows(ListModel.Limits limits, ListModel.Sort sort, FilterStudio filter, String ... properties) {
            this.addParameter("limits", (AbstractModel)limits);
            this.addParameter("sort", (AbstractModel)sort);
            this.addParameter("filter", (AbstractModel)filter);
            this.addParameter("properties", properties);
        }

        public GetTVShows(ListModel.Limits limits, ListModel.Sort sort, FilterTag filter, String ... properties) {
            this.addParameter("limits", (AbstractModel)limits);
            this.addParameter("sort", (AbstractModel)sort);
            this.addParameter("filter", (AbstractModel)filter);
            this.addParameter("properties", properties);
        }

        public GetTVShows(ListModel.Limits limits, ListModel.Sort sort, ListModel.TVShowFilter filter, String ... properties) {
            this.addParameter("limits", (AbstractModel)limits);
            this.addParameter("sort", (AbstractModel)sort);
            this.addParameter("filter", (AbstractModel)filter);
            this.addParameter("properties", properties);
        }

        public GetTVShows(String ... properties) {
            this.addParameter("properties", properties);
        }

        public GetTVShows(ListModel.Limits limits, String ... properties) {
            this.addParameter("limits", (AbstractModel)limits);
            this.addParameter("properties", properties);
        }

        public GetTVShows(ListModel.Sort sort, String ... properties) {
            this.addParameter("sort", (AbstractModel)sort);
            this.addParameter("properties", properties);
        }

        public GetTVShows(ListModel.Limits limits, ListModel.Sort sort, String ... properties) {
            this.addParameter("limits", (AbstractModel)limits);
            this.addParameter("sort", (AbstractModel)sort);
            this.addParameter("properties", properties);
        }

        public GetTVShows(FilterGenreId filter, String ... properties) {
            this.addParameter("filter", (AbstractModel)filter);
            this.addParameter("properties", properties);
        }

        public GetTVShows(ListModel.Limits limits, FilterGenreId filter, String ... properties) {
            this.addParameter("limits", (AbstractModel)limits);
            this.addParameter("filter", (AbstractModel)filter);
            this.addParameter("properties", properties);
        }

        public GetTVShows(FilterGenre filter, String ... properties) {
            this.addParameter("filter", (AbstractModel)filter);
            this.addParameter("properties", properties);
        }

        public GetTVShows(ListModel.Limits limits, FilterGenre filter, String ... properties) {
            this.addParameter("limits", (AbstractModel)limits);
            this.addParameter("filter", (AbstractModel)filter);
            this.addParameter("properties", properties);
        }

        public GetTVShows(FilterYear filter, String ... properties) {
            this.addParameter("filter", (AbstractModel)filter);
            this.addParameter("properties", properties);
        }

        public GetTVShows(ListModel.Limits limits, FilterYear filter, String ... properties) {
            this.addParameter("limits", (AbstractModel)limits);
            this.addParameter("filter", (AbstractModel)filter);
            this.addParameter("properties", properties);
        }

        public GetTVShows(FilterActor filter, String ... properties) {
            this.addParameter("filter", (AbstractModel)filter);
            this.addParameter("properties", properties);
        }

        public GetTVShows(ListModel.Limits limits, FilterActor filter, String ... properties) {
            this.addParameter("limits", (AbstractModel)limits);
            this.addParameter("filter", (AbstractModel)filter);
            this.addParameter("properties", properties);
        }

        public GetTVShows(FilterStudio filter, String ... properties) {
            this.addParameter("filter", (AbstractModel)filter);
            this.addParameter("properties", properties);
        }

        public GetTVShows(ListModel.Limits limits, FilterStudio filter, String ... properties) {
            this.addParameter("limits", (AbstractModel)limits);
            this.addParameter("filter", (AbstractModel)filter);
            this.addParameter("properties", properties);
        }

        public GetTVShows(FilterTag filter, String ... properties) {
            this.addParameter("filter", (AbstractModel)filter);
            this.addParameter("properties", properties);
        }

        public GetTVShows(ListModel.Limits limits, FilterTag filter, String ... properties) {
            this.addParameter("limits", (AbstractModel)limits);
            this.addParameter("filter", (AbstractModel)filter);
            this.addParameter("properties", properties);
        }

        public GetTVShows(ListModel.TVShowFilter filter, String ... properties) {
            this.addParameter("filter", (AbstractModel)filter);
            this.addParameter("properties", properties);
        }

        public GetTVShows(ListModel.Limits limits, ListModel.TVShowFilter filter, String ... properties) {
            this.addParameter("limits", (AbstractModel)limits);
            this.addParameter("filter", (AbstractModel)filter);
            this.addParameter("properties", properties);
        }

        @Override
        protected ArrayList<VideoModel.TVShowDetail> parseMany(JsonNode node) {
            ArrayNode tvshows = this.parseResults(node, RESULT);
            if (tvshows != null) {
                ArrayList<VideoModel.TVShowDetail> ret = new ArrayList<VideoModel.TVShowDetail>(tvshows.size());
                for (int i = 0; i < tvshows.size(); ++i) {
                    ObjectNode item = (ObjectNode)tvshows.get(i);
                    ret.add(new VideoModel.TVShowDetail((JsonNode)item));
                }
                return ret;
            }
            return new ArrayList<VideoModel.TVShowDetail>(0);
        }

        @Override
        public String getName() {
            return API_TYPE;
        }

        @Override
        protected boolean returnsList() {
            return true;
        }

        public static class FilterTag
        extends AbstractModel {
            public static final String TAG = "tag";
            public final String tag;

            public FilterTag(String tag) {
                this.tag = tag;
            }

            @Override
            public JsonNode toJsonNode() {
                ObjectNode node = OM.createObjectNode();
                node.put(TAG, this.tag);
                return node;
            }
        }

        public static class FilterStudio
        extends AbstractModel {
            public static final String STUDIO = "studio";
            public final String studio;

            public FilterStudio(String studio) {
                this.studio = studio;
            }

            @Override
            public JsonNode toJsonNode() {
                ObjectNode node = OM.createObjectNode();
                node.put(STUDIO, this.studio);
                return node;
            }
        }

        public static class FilterActor
        extends AbstractModel {
            public static final String ACTOR = "actor";
            public final String actor;

            public FilterActor(String actor) {
                this.actor = actor;
            }

            @Override
            public JsonNode toJsonNode() {
                ObjectNode node = OM.createObjectNode();
                node.put(ACTOR, this.actor);
                return node;
            }
        }

        public static class FilterYear
        extends AbstractModel {
            public static final String YEAR = "year";
            public final Integer year;

            public FilterYear(Integer year) {
                this.year = year;
            }

            @Override
            public JsonNode toJsonNode() {
                ObjectNode node = OM.createObjectNode();
                node.put(YEAR, this.year);
                return node;
            }
        }

        public static class FilterGenre
        extends AbstractModel {
            public static final String GENRE = "genre";
            public final String genre;

            public FilterGenre(String genre) {
                this.genre = genre;
            }

            @Override
            public JsonNode toJsonNode() {
                ObjectNode node = OM.createObjectNode();
                node.put(GENRE, this.genre);
                return node;
            }
        }

        public static class FilterGenreId
        extends AbstractModel {
            public static final String GENREID = "genreid";
            public final Integer genreid;

            public FilterGenreId(Integer genreid) {
                this.genreid = genreid;
            }

            @Override
            public JsonNode toJsonNode() {
                ObjectNode node = OM.createObjectNode();
                node.put(GENREID, this.genreid);
                return node;
            }
        }
    }

    public static class GetTVShowDetails
    extends AbstractCall<VideoModel.TVShowDetail> {
        public static final String API_TYPE = "VideoLibrary.GetTVShowDetails";
        public static final String RESULT = "tvshowdetails";

        public GetTVShowDetails(Integer tvshowid, String ... properties) {
            this.addParameter("tvshowid", tvshowid);
            this.addParameter("properties", properties);
        }

        @Override
        protected VideoModel.TVShowDetail parseOne(JsonNode node) {
            return new VideoModel.TVShowDetail((JsonNode)((ObjectNode)node.get(RESULT)));
        }

        @Override
        public String getName() {
            return API_TYPE;
        }

        @Override
        protected boolean returnsList() {
            return false;
        }
    }

    public static class GetSeasons
    extends AbstractCall<VideoModel.SeasonDetail> {
        public static final String API_TYPE = "VideoLibrary.GetSeasons";
        public static final String RESULT = "seasons";

        public GetSeasons(Integer tvshowid, ListModel.Limits limits, ListModel.Sort sort, String ... properties) {
            this.addParameter("tvshowid", tvshowid);
            this.addParameter("limits", (AbstractModel)limits);
            this.addParameter("sort", (AbstractModel)sort);
            this.addParameter("properties", properties);
        }

        public GetSeasons(Integer tvshowid, String ... properties) {
            this.addParameter("tvshowid", tvshowid);
            this.addParameter("properties", properties);
        }

        public GetSeasons(Integer tvshowid, ListModel.Limits limits, String ... properties) {
            this.addParameter("tvshowid", tvshowid);
            this.addParameter("limits", (AbstractModel)limits);
            this.addParameter("properties", properties);
        }

        public GetSeasons(Integer tvshowid, ListModel.Sort sort, String ... properties) {
            this.addParameter("tvshowid", tvshowid);
            this.addParameter("sort", (AbstractModel)sort);
            this.addParameter("properties", properties);
        }

        @Override
        protected ArrayList<VideoModel.SeasonDetail> parseMany(JsonNode node) {
            ArrayNode seasons = this.parseResults(node, RESULT);
            if (seasons != null) {
                ArrayList<VideoModel.SeasonDetail> ret = new ArrayList<VideoModel.SeasonDetail>(seasons.size());
                for (int i = 0; i < seasons.size(); ++i) {
                    ObjectNode item = (ObjectNode)seasons.get(i);
                    ret.add(new VideoModel.SeasonDetail((JsonNode)item));
                }
                return ret;
            }
            return new ArrayList<VideoModel.SeasonDetail>(0);
        }

        @Override
        public String getName() {
            return API_TYPE;
        }

        @Override
        protected boolean returnsList() {
            return true;
        }
    }

    public static class GetRecentlyAddedMusicVideos
    extends AbstractCall<VideoModel.MusicVideoDetail> {
        public static final String API_TYPE = "VideoLibrary.GetRecentlyAddedMusicVideos";
        public static final String RESULT = "musicvideos";

        public GetRecentlyAddedMusicVideos(ListModel.Limits limits, ListModel.Sort sort, String ... properties) {
            this.addParameter("limits", (AbstractModel)limits);
            this.addParameter("sort", (AbstractModel)sort);
            this.addParameter("properties", properties);
        }

        public GetRecentlyAddedMusicVideos(String ... properties) {
            this.addParameter("properties", properties);
        }

        public GetRecentlyAddedMusicVideos(ListModel.Limits limits, String ... properties) {
            this.addParameter("limits", (AbstractModel)limits);
            this.addParameter("properties", properties);
        }

        @Override
        protected ArrayList<VideoModel.MusicVideoDetail> parseMany(JsonNode node) {
            ArrayNode musicvideos = this.parseResults(node, RESULT);
            if (musicvideos != null) {
                ArrayList<VideoModel.MusicVideoDetail> ret = new ArrayList<VideoModel.MusicVideoDetail>(musicvideos.size());
                for (int i = 0; i < musicvideos.size(); ++i) {
                    ObjectNode item = (ObjectNode)musicvideos.get(i);
                    ret.add(new VideoModel.MusicVideoDetail((JsonNode)item));
                }
                return ret;
            }
            return new ArrayList<VideoModel.MusicVideoDetail>(0);
        }

        @Override
        public String getName() {
            return API_TYPE;
        }

        @Override
        protected boolean returnsList() {
            return true;
        }
    }

    public static class GetRecentlyAddedMovies
    extends AbstractCall<VideoModel.MovieDetail> {
        public static final String API_TYPE = "VideoLibrary.GetRecentlyAddedMovies";
        public static final String RESULT = "movies";

        public GetRecentlyAddedMovies(ListModel.Limits limits, ListModel.Sort sort, String ... properties) {
            this.addParameter("limits", (AbstractModel)limits);
            this.addParameter("sort", (AbstractModel)sort);
            this.addParameter("properties", properties);
        }

        public GetRecentlyAddedMovies(String ... properties) {
            this.addParameter("properties", properties);
        }

        public GetRecentlyAddedMovies(ListModel.Limits limits, String ... properties) {
            this.addParameter("limits", (AbstractModel)limits);
            this.addParameter("properties", properties);
        }

        @Override
        protected ArrayList<VideoModel.MovieDetail> parseMany(JsonNode node) {
            ArrayNode movies = this.parseResults(node, RESULT);
            if (movies != null) {
                ArrayList<VideoModel.MovieDetail> ret = new ArrayList<VideoModel.MovieDetail>(movies.size());
                for (int i = 0; i < movies.size(); ++i) {
                    ObjectNode item = (ObjectNode)movies.get(i);
                    ret.add(new VideoModel.MovieDetail((JsonNode)item));
                }
                return ret;
            }
            return new ArrayList<VideoModel.MovieDetail>(0);
        }

        @Override
        public String getName() {
            return API_TYPE;
        }

        @Override
        protected boolean returnsList() {
            return true;
        }
    }

    public static class GetRecentlyAddedEpisodes
    extends AbstractCall<VideoModel.EpisodeDetail> {
        public static final String API_TYPE = "VideoLibrary.GetRecentlyAddedEpisodes";
        public static final String RESULT = "episodes";

        public GetRecentlyAddedEpisodes(ListModel.Limits limits, ListModel.Sort sort, String ... properties) {
            this.addParameter("limits", (AbstractModel)limits);
            this.addParameter("sort", (AbstractModel)sort);
            this.addParameter("properties", properties);
        }

        public GetRecentlyAddedEpisodes(String ... properties) {
            this.addParameter("properties", properties);
        }

        public GetRecentlyAddedEpisodes(ListModel.Limits limits, String ... properties) {
            this.addParameter("limits", (AbstractModel)limits);
            this.addParameter("properties", properties);
        }

        @Override
        protected ArrayList<VideoModel.EpisodeDetail> parseMany(JsonNode node) {
            ArrayNode episodes = this.parseResults(node, RESULT);
            if (episodes != null) {
                ArrayList<VideoModel.EpisodeDetail> ret = new ArrayList<VideoModel.EpisodeDetail>(episodes.size());
                for (int i = 0; i < episodes.size(); ++i) {
                    ObjectNode item = (ObjectNode)episodes.get(i);
                    ret.add(new VideoModel.EpisodeDetail((JsonNode)item));
                }
                return ret;
            }
            return new ArrayList<VideoModel.EpisodeDetail>(0);
        }

        @Override
        public String getName() {
            return API_TYPE;
        }

        @Override
        protected boolean returnsList() {
            return true;
        }
    }

    public static class GetMusicVideos
    extends AbstractCall<VideoModel.MusicVideoDetail> {
        public static final String API_TYPE = "VideoLibrary.GetMusicVideos";
        public static final String RESULT = "musicvideos";

        public GetMusicVideos(ListModel.Limits limits, ListModel.Sort sort, FilterArtist filter, String ... properties) {
            this.addParameter("limits", (AbstractModel)limits);
            this.addParameter("sort", (AbstractModel)sort);
            this.addParameter("filter", (AbstractModel)filter);
            this.addParameter("properties", properties);
        }

        public GetMusicVideos(ListModel.Limits limits, ListModel.Sort sort, FilterGenreId filter, String ... properties) {
            this.addParameter("limits", (AbstractModel)limits);
            this.addParameter("sort", (AbstractModel)sort);
            this.addParameter("filter", (AbstractModel)filter);
            this.addParameter("properties", properties);
        }

        public GetMusicVideos(ListModel.Limits limits, ListModel.Sort sort, FilterGenre filter, String ... properties) {
            this.addParameter("limits", (AbstractModel)limits);
            this.addParameter("sort", (AbstractModel)sort);
            this.addParameter("filter", (AbstractModel)filter);
            this.addParameter("properties", properties);
        }

        public GetMusicVideos(ListModel.Limits limits, ListModel.Sort sort, FilterYear filter, String ... properties) {
            this.addParameter("limits", (AbstractModel)limits);
            this.addParameter("sort", (AbstractModel)sort);
            this.addParameter("filter", (AbstractModel)filter);
            this.addParameter("properties", properties);
        }

        public GetMusicVideos(ListModel.Limits limits, ListModel.Sort sort, FilterDirector filter, String ... properties) {
            this.addParameter("limits", (AbstractModel)limits);
            this.addParameter("sort", (AbstractModel)sort);
            this.addParameter("filter", (AbstractModel)filter);
            this.addParameter("properties", properties);
        }

        public GetMusicVideos(ListModel.Limits limits, ListModel.Sort sort, FilterStudio filter, String ... properties) {
            this.addParameter("limits", (AbstractModel)limits);
            this.addParameter("sort", (AbstractModel)sort);
            this.addParameter("filter", (AbstractModel)filter);
            this.addParameter("properties", properties);
        }

        public GetMusicVideos(ListModel.Limits limits, ListModel.Sort sort, FilterTag filter, String ... properties) {
            this.addParameter("limits", (AbstractModel)limits);
            this.addParameter("sort", (AbstractModel)sort);
            this.addParameter("filter", (AbstractModel)filter);
            this.addParameter("properties", properties);
        }

        public GetMusicVideos(ListModel.Limits limits, ListModel.Sort sort, ListModel.MusicVideoFilter filter, String ... properties) {
            this.addParameter("limits", (AbstractModel)limits);
            this.addParameter("sort", (AbstractModel)sort);
            this.addParameter("filter", (AbstractModel)filter);
            this.addParameter("properties", properties);
        }

        public GetMusicVideos(String ... properties) {
            this.addParameter("properties", properties);
        }

        public GetMusicVideos(ListModel.Limits limits, String ... properties) {
            this.addParameter("limits", (AbstractModel)limits);
            this.addParameter("properties", properties);
        }

        public GetMusicVideos(ListModel.Sort sort, String ... properties) {
            this.addParameter("sort", (AbstractModel)sort);
            this.addParameter("properties", properties);
        }

        public GetMusicVideos(ListModel.Limits limits, ListModel.Sort sort, String ... properties) {
            this.addParameter("limits", (AbstractModel)limits);
            this.addParameter("sort", (AbstractModel)sort);
            this.addParameter("properties", properties);
        }

        public GetMusicVideos(FilterArtist filter, String ... properties) {
            this.addParameter("filter", (AbstractModel)filter);
            this.addParameter("properties", properties);
        }

        public GetMusicVideos(ListModel.Limits limits, FilterArtist filter, String ... properties) {
            this.addParameter("limits", (AbstractModel)limits);
            this.addParameter("filter", (AbstractModel)filter);
            this.addParameter("properties", properties);
        }

        public GetMusicVideos(FilterGenreId filter, String ... properties) {
            this.addParameter("filter", (AbstractModel)filter);
            this.addParameter("properties", properties);
        }

        public GetMusicVideos(ListModel.Limits limits, FilterGenreId filter, String ... properties) {
            this.addParameter("limits", (AbstractModel)limits);
            this.addParameter("filter", (AbstractModel)filter);
            this.addParameter("properties", properties);
        }

        public GetMusicVideos(FilterGenre filter, String ... properties) {
            this.addParameter("filter", (AbstractModel)filter);
            this.addParameter("properties", properties);
        }

        public GetMusicVideos(ListModel.Limits limits, FilterGenre filter, String ... properties) {
            this.addParameter("limits", (AbstractModel)limits);
            this.addParameter("filter", (AbstractModel)filter);
            this.addParameter("properties", properties);
        }

        public GetMusicVideos(FilterYear filter, String ... properties) {
            this.addParameter("filter", (AbstractModel)filter);
            this.addParameter("properties", properties);
        }

        public GetMusicVideos(ListModel.Limits limits, FilterYear filter, String ... properties) {
            this.addParameter("limits", (AbstractModel)limits);
            this.addParameter("filter", (AbstractModel)filter);
            this.addParameter("properties", properties);
        }

        public GetMusicVideos(FilterDirector filter, String ... properties) {
            this.addParameter("filter", (AbstractModel)filter);
            this.addParameter("properties", properties);
        }

        public GetMusicVideos(ListModel.Limits limits, FilterDirector filter, String ... properties) {
            this.addParameter("limits", (AbstractModel)limits);
            this.addParameter("filter", (AbstractModel)filter);
            this.addParameter("properties", properties);
        }

        public GetMusicVideos(FilterStudio filter, String ... properties) {
            this.addParameter("filter", (AbstractModel)filter);
            this.addParameter("properties", properties);
        }

        public GetMusicVideos(ListModel.Limits limits, FilterStudio filter, String ... properties) {
            this.addParameter("limits", (AbstractModel)limits);
            this.addParameter("filter", (AbstractModel)filter);
            this.addParameter("properties", properties);
        }

        public GetMusicVideos(FilterTag filter, String ... properties) {
            this.addParameter("filter", (AbstractModel)filter);
            this.addParameter("properties", properties);
        }

        public GetMusicVideos(ListModel.Limits limits, FilterTag filter, String ... properties) {
            this.addParameter("limits", (AbstractModel)limits);
            this.addParameter("filter", (AbstractModel)filter);
            this.addParameter("properties", properties);
        }

        public GetMusicVideos(ListModel.MusicVideoFilter filter, String ... properties) {
            this.addParameter("filter", (AbstractModel)filter);
            this.addParameter("properties", properties);
        }

        public GetMusicVideos(ListModel.Limits limits, ListModel.MusicVideoFilter filter, String ... properties) {
            this.addParameter("limits", (AbstractModel)limits);
            this.addParameter("filter", (AbstractModel)filter);
            this.addParameter("properties", properties);
        }

        @Override
        protected ArrayList<VideoModel.MusicVideoDetail> parseMany(JsonNode node) {
            ArrayNode musicvideos = this.parseResults(node, RESULT);
            if (musicvideos != null) {
                ArrayList<VideoModel.MusicVideoDetail> ret = new ArrayList<VideoModel.MusicVideoDetail>(musicvideos.size());
                for (int i = 0; i < musicvideos.size(); ++i) {
                    ObjectNode item = (ObjectNode)musicvideos.get(i);
                    ret.add(new VideoModel.MusicVideoDetail((JsonNode)item));
                }
                return ret;
            }
            return new ArrayList<VideoModel.MusicVideoDetail>(0);
        }

        @Override
        public String getName() {
            return API_TYPE;
        }

        @Override
        protected boolean returnsList() {
            return true;
        }

        public static class FilterTag
        extends AbstractModel {
            public static final String TAG = "tag";
            public final String tag;

            public FilterTag(String tag) {
                this.tag = tag;
            }

            @Override
            public JsonNode toJsonNode() {
                ObjectNode node = OM.createObjectNode();
                node.put(TAG, this.tag);
                return node;
            }
        }

        public static class FilterStudio
        extends AbstractModel {
            public static final String STUDIO = "studio";
            public final String studio;

            public FilterStudio(String studio) {
                this.studio = studio;
            }

            @Override
            public JsonNode toJsonNode() {
                ObjectNode node = OM.createObjectNode();
                node.put(STUDIO, this.studio);
                return node;
            }
        }

        public static class FilterDirector
        extends AbstractModel {
            public static final String DIRECTOR = "director";
            public final String director;

            public FilterDirector(String director) {
                this.director = director;
            }

            @Override
            public JsonNode toJsonNode() {
                ObjectNode node = OM.createObjectNode();
                node.put(DIRECTOR, this.director);
                return node;
            }
        }

        public static class FilterYear
        extends AbstractModel {
            public static final String YEAR = "year";
            public final Integer year;

            public FilterYear(Integer year) {
                this.year = year;
            }

            @Override
            public JsonNode toJsonNode() {
                ObjectNode node = OM.createObjectNode();
                node.put(YEAR, this.year);
                return node;
            }
        }

        public static class FilterGenre
        extends AbstractModel {
            public static final String GENRE = "genre";
            public final String genre;

            public FilterGenre(String genre) {
                this.genre = genre;
            }

            @Override
            public JsonNode toJsonNode() {
                ObjectNode node = OM.createObjectNode();
                node.put(GENRE, this.genre);
                return node;
            }
        }

        public static class FilterGenreId
        extends AbstractModel {
            public static final String GENREID = "genreid";
            public final Integer genreid;

            public FilterGenreId(Integer genreid) {
                this.genreid = genreid;
            }

            @Override
            public JsonNode toJsonNode() {
                ObjectNode node = OM.createObjectNode();
                node.put(GENREID, this.genreid);
                return node;
            }
        }

        public static class FilterArtist
        extends AbstractModel {
            public static final String ARTIST = "artist";
            public final String artist;

            public FilterArtist(String artist) {
                this.artist = artist;
            }

            @Override
            public JsonNode toJsonNode() {
                ObjectNode node = OM.createObjectNode();
                node.put(ARTIST, this.artist);
                return node;
            }
        }
    }

    public static class GetMusicVideoDetails
    extends AbstractCall<VideoModel.MusicVideoDetail> {
        public static final String API_TYPE = "VideoLibrary.GetMusicVideoDetails";
        public static final String RESULT = "musicvideodetails";

        public GetMusicVideoDetails(Integer musicvideoid, String ... properties) {
            this.addParameter("musicvideoid", musicvideoid);
            this.addParameter("properties", properties);
        }

        @Override
        protected VideoModel.MusicVideoDetail parseOne(JsonNode node) {
            return new VideoModel.MusicVideoDetail((JsonNode)((ObjectNode)node.get(RESULT)));
        }

        @Override
        public String getName() {
            return API_TYPE;
        }

        @Override
        protected boolean returnsList() {
            return false;
        }
    }

    public static class GetMovies
    extends AbstractCall<VideoModel.MovieDetail> {
        public static final String API_TYPE = "VideoLibrary.GetMovies";
        public static final String RESULT = "movies";

        public GetMovies(ListModel.Limits limits, ListModel.Sort sort, FilterGenreId filter, String ... properties) {
            this.addParameter("limits", (AbstractModel)limits);
            this.addParameter("sort", (AbstractModel)sort);
            this.addParameter("filter", (AbstractModel)filter);
            this.addParameter("properties", properties);
        }

        public GetMovies(ListModel.Limits limits, ListModel.Sort sort, FilterGenre filter, String ... properties) {
            this.addParameter("limits", (AbstractModel)limits);
            this.addParameter("sort", (AbstractModel)sort);
            this.addParameter("filter", (AbstractModel)filter);
            this.addParameter("properties", properties);
        }

        public GetMovies(ListModel.Limits limits, ListModel.Sort sort, FilterYear filter, String ... properties) {
            this.addParameter("limits", (AbstractModel)limits);
            this.addParameter("sort", (AbstractModel)sort);
            this.addParameter("filter", (AbstractModel)filter);
            this.addParameter("properties", properties);
        }

        public GetMovies(ListModel.Limits limits, ListModel.Sort sort, FilterActor filter, String ... properties) {
            this.addParameter("limits", (AbstractModel)limits);
            this.addParameter("sort", (AbstractModel)sort);
            this.addParameter("filter", (AbstractModel)filter);
            this.addParameter("properties", properties);
        }

        public GetMovies(ListModel.Limits limits, ListModel.Sort sort, FilterDirector filter, String ... properties) {
            this.addParameter("limits", (AbstractModel)limits);
            this.addParameter("sort", (AbstractModel)sort);
            this.addParameter("filter", (AbstractModel)filter);
            this.addParameter("properties", properties);
        }

        public GetMovies(ListModel.Limits limits, ListModel.Sort sort, FilterStudio filter, String ... properties) {
            this.addParameter("limits", (AbstractModel)limits);
            this.addParameter("sort", (AbstractModel)sort);
            this.addParameter("filter", (AbstractModel)filter);
            this.addParameter("properties", properties);
        }

        public GetMovies(ListModel.Limits limits, ListModel.Sort sort, FilterCountry filter, String ... properties) {
            this.addParameter("limits", (AbstractModel)limits);
            this.addParameter("sort", (AbstractModel)sort);
            this.addParameter("filter", (AbstractModel)filter);
            this.addParameter("properties", properties);
        }

        public GetMovies(ListModel.Limits limits, ListModel.Sort sort, FilterSetId filter, String ... properties) {
            this.addParameter("limits", (AbstractModel)limits);
            this.addParameter("sort", (AbstractModel)sort);
            this.addParameter("filter", (AbstractModel)filter);
            this.addParameter("properties", properties);
        }

        public GetMovies(ListModel.Limits limits, ListModel.Sort sort, FilterSet filter, String ... properties) {
            this.addParameter("limits", (AbstractModel)limits);
            this.addParameter("sort", (AbstractModel)sort);
            this.addParameter("filter", (AbstractModel)filter);
            this.addParameter("properties", properties);
        }

        public GetMovies(ListModel.Limits limits, ListModel.Sort sort, FilterTag filter, String ... properties) {
            this.addParameter("limits", (AbstractModel)limits);
            this.addParameter("sort", (AbstractModel)sort);
            this.addParameter("filter", (AbstractModel)filter);
            this.addParameter("properties", properties);
        }

        public GetMovies(ListModel.Limits limits, ListModel.Sort sort, ListModel.MovieFilter filter, String ... properties) {
            this.addParameter("limits", (AbstractModel)limits);
            this.addParameter("sort", (AbstractModel)sort);
            this.addParameter("filter", (AbstractModel)filter);
            this.addParameter("properties", properties);
        }

        public GetMovies(String ... properties) {
            this.addParameter("properties", properties);
        }

        public GetMovies(ListModel.Limits limits, String ... properties) {
            this.addParameter("limits", (AbstractModel)limits);
            this.addParameter("properties", properties);
        }

        public GetMovies(ListModel.Sort sort, String ... properties) {
            this.addParameter("sort", (AbstractModel)sort);
            this.addParameter("properties", properties);
        }

        public GetMovies(ListModel.Limits limits, ListModel.Sort sort, String ... properties) {
            this.addParameter("limits", (AbstractModel)limits);
            this.addParameter("sort", (AbstractModel)sort);
            this.addParameter("properties", properties);
        }

        public GetMovies(FilterGenreId filter, String ... properties) {
            this.addParameter("filter", (AbstractModel)filter);
            this.addParameter("properties", properties);
        }

        public GetMovies(ListModel.Limits limits, FilterGenreId filter, String ... properties) {
            this.addParameter("limits", (AbstractModel)limits);
            this.addParameter("filter", (AbstractModel)filter);
            this.addParameter("properties", properties);
        }

        public GetMovies(FilterGenre filter, String ... properties) {
            this.addParameter("filter", (AbstractModel)filter);
            this.addParameter("properties", properties);
        }

        public GetMovies(ListModel.Limits limits, FilterGenre filter, String ... properties) {
            this.addParameter("limits", (AbstractModel)limits);
            this.addParameter("filter", (AbstractModel)filter);
            this.addParameter("properties", properties);
        }

        public GetMovies(FilterYear filter, String ... properties) {
            this.addParameter("filter", (AbstractModel)filter);
            this.addParameter("properties", properties);
        }

        public GetMovies(ListModel.Limits limits, FilterYear filter, String ... properties) {
            this.addParameter("limits", (AbstractModel)limits);
            this.addParameter("filter", (AbstractModel)filter);
            this.addParameter("properties", properties);
        }

        public GetMovies(FilterActor filter, String ... properties) {
            this.addParameter("filter", (AbstractModel)filter);
            this.addParameter("properties", properties);
        }

        public GetMovies(ListModel.Limits limits, FilterActor filter, String ... properties) {
            this.addParameter("limits", (AbstractModel)limits);
            this.addParameter("filter", (AbstractModel)filter);
            this.addParameter("properties", properties);
        }

        public GetMovies(FilterDirector filter, String ... properties) {
            this.addParameter("filter", (AbstractModel)filter);
            this.addParameter("properties", properties);
        }

        public GetMovies(ListModel.Limits limits, FilterDirector filter, String ... properties) {
            this.addParameter("limits", (AbstractModel)limits);
            this.addParameter("filter", (AbstractModel)filter);
            this.addParameter("properties", properties);
        }

        public GetMovies(FilterStudio filter, String ... properties) {
            this.addParameter("filter", (AbstractModel)filter);
            this.addParameter("properties", properties);
        }

        public GetMovies(ListModel.Limits limits, FilterStudio filter, String ... properties) {
            this.addParameter("limits", (AbstractModel)limits);
            this.addParameter("filter", (AbstractModel)filter);
            this.addParameter("properties", properties);
        }

        public GetMovies(FilterCountry filter, String ... properties) {
            this.addParameter("filter", (AbstractModel)filter);
            this.addParameter("properties", properties);
        }

        public GetMovies(ListModel.Limits limits, FilterCountry filter, String ... properties) {
            this.addParameter("limits", (AbstractModel)limits);
            this.addParameter("filter", (AbstractModel)filter);
            this.addParameter("properties", properties);
        }

        public GetMovies(FilterSetId filter, String ... properties) {
            this.addParameter("filter", (AbstractModel)filter);
            this.addParameter("properties", properties);
        }

        public GetMovies(ListModel.Limits limits, FilterSetId filter, String ... properties) {
            this.addParameter("limits", (AbstractModel)limits);
            this.addParameter("filter", (AbstractModel)filter);
            this.addParameter("properties", properties);
        }

        public GetMovies(FilterSet filter, String ... properties) {
            this.addParameter("filter", (AbstractModel)filter);
            this.addParameter("properties", properties);
        }

        public GetMovies(ListModel.Limits limits, FilterSet filter, String ... properties) {
            this.addParameter("limits", (AbstractModel)limits);
            this.addParameter("filter", (AbstractModel)filter);
            this.addParameter("properties", properties);
        }

        public GetMovies(FilterTag filter, String ... properties) {
            this.addParameter("filter", (AbstractModel)filter);
            this.addParameter("properties", properties);
        }

        public GetMovies(ListModel.Limits limits, FilterTag filter, String ... properties) {
            this.addParameter("limits", (AbstractModel)limits);
            this.addParameter("filter", (AbstractModel)filter);
            this.addParameter("properties", properties);
        }

        public GetMovies(ListModel.MovieFilter filter, String ... properties) {
            this.addParameter("filter", (AbstractModel)filter);
            this.addParameter("properties", properties);
        }

        public GetMovies(ListModel.Limits limits, ListModel.MovieFilter filter, String ... properties) {
            this.addParameter("limits", (AbstractModel)limits);
            this.addParameter("filter", (AbstractModel)filter);
            this.addParameter("properties", properties);
        }

        @Override
        protected ArrayList<VideoModel.MovieDetail> parseMany(JsonNode node) {
            ArrayNode movies = this.parseResults(node, RESULT);
            if (movies != null) {
                ArrayList<VideoModel.MovieDetail> ret = new ArrayList<VideoModel.MovieDetail>(movies.size());
                for (int i = 0; i < movies.size(); ++i) {
                    ObjectNode item = (ObjectNode)movies.get(i);
                    ret.add(new VideoModel.MovieDetail((JsonNode)item));
                }
                return ret;
            }
            return new ArrayList<VideoModel.MovieDetail>(0);
        }

        @Override
        public String getName() {
            return API_TYPE;
        }

        @Override
        protected boolean returnsList() {
            return true;
        }

        public static class FilterTag
        extends AbstractModel {
            public static final String TAG = "tag";
            public final String tag;

            public FilterTag(String tag) {
                this.tag = tag;
            }

            @Override
            public JsonNode toJsonNode() {
                ObjectNode node = OM.createObjectNode();
                node.put(TAG, this.tag);
                return node;
            }
        }

        public static class FilterSet
        extends AbstractModel {
            public static final String SET = "set";
            public final String set;

            public FilterSet(String set) {
                this.set = set;
            }

            @Override
            public JsonNode toJsonNode() {
                ObjectNode node = OM.createObjectNode();
                node.put(SET, this.set);
                return node;
            }
        }

        public static class FilterSetId
        extends AbstractModel {
            public static final String SETID = "setid";
            public final Integer setid;

            public FilterSetId(Integer setid) {
                this.setid = setid;
            }

            @Override
            public JsonNode toJsonNode() {
                ObjectNode node = OM.createObjectNode();
                node.put(SETID, this.setid);
                return node;
            }
        }

        public static class FilterCountry
        extends AbstractModel {
            public static final String COUNTRY = "country";
            public final String country;

            public FilterCountry(String country) {
                this.country = country;
            }

            @Override
            public JsonNode toJsonNode() {
                ObjectNode node = OM.createObjectNode();
                node.put(COUNTRY, this.country);
                return node;
            }
        }

        public static class FilterStudio
        extends AbstractModel {
            public static final String STUDIO = "studio";
            public final String studio;

            public FilterStudio(String studio) {
                this.studio = studio;
            }

            @Override
            public JsonNode toJsonNode() {
                ObjectNode node = OM.createObjectNode();
                node.put(STUDIO, this.studio);
                return node;
            }
        }

        public static class FilterDirector
        extends AbstractModel {
            public static final String DIRECTOR = "director";
            public final String director;

            public FilterDirector(String director) {
                this.director = director;
            }

            @Override
            public JsonNode toJsonNode() {
                ObjectNode node = OM.createObjectNode();
                node.put(DIRECTOR, this.director);
                return node;
            }
        }

        public static class FilterActor
        extends AbstractModel {
            public static final String ACTOR = "actor";
            public final String actor;

            public FilterActor(String actor) {
                this.actor = actor;
            }

            @Override
            public JsonNode toJsonNode() {
                ObjectNode node = OM.createObjectNode();
                node.put(ACTOR, this.actor);
                return node;
            }
        }

        public static class FilterYear
        extends AbstractModel {
            public static final String YEAR = "year";
            public final Integer year;

            public FilterYear(Integer year) {
                this.year = year;
            }

            @Override
            public JsonNode toJsonNode() {
                ObjectNode node = OM.createObjectNode();
                node.put(YEAR, this.year);
                return node;
            }
        }

        public static class FilterGenre
        extends AbstractModel {
            public static final String GENRE = "genre";
            public final String genre;

            public FilterGenre(String genre) {
                this.genre = genre;
            }

            @Override
            public JsonNode toJsonNode() {
                ObjectNode node = OM.createObjectNode();
                node.put(GENRE, this.genre);
                return node;
            }
        }

        public static class FilterGenreId
        extends AbstractModel {
            public static final String GENREID = "genreid";
            public final Integer genreid;

            public FilterGenreId(Integer genreid) {
                this.genreid = genreid;
            }

            @Override
            public JsonNode toJsonNode() {
                ObjectNode node = OM.createObjectNode();
                node.put(GENREID, this.genreid);
                return node;
            }
        }
    }

    public static class GetMovieSets
    extends AbstractCall<VideoModel.MovieSetDetail> {
        public static final String API_TYPE = "VideoLibrary.GetMovieSets";
        public static final String RESULT = "sets";

        public GetMovieSets(ListModel.Limits limits, ListModel.Sort sort, String ... properties) {
            this.addParameter("limits", (AbstractModel)limits);
            this.addParameter("sort", (AbstractModel)sort);
            this.addParameter("properties", properties);
        }

        public GetMovieSets(String ... properties) {
            this.addParameter("properties", properties);
        }

        public GetMovieSets(ListModel.Limits limits, String ... properties) {
            this.addParameter("limits", (AbstractModel)limits);
            this.addParameter("properties", properties);
        }

        @Override
        protected ArrayList<VideoModel.MovieSetDetail> parseMany(JsonNode node) {
            ArrayNode sets = this.parseResults(node, RESULT);
            if (sets != null) {
                ArrayList<VideoModel.MovieSetDetail> ret = new ArrayList<VideoModel.MovieSetDetail>(sets.size());
                for (int i = 0; i < sets.size(); ++i) {
                    ObjectNode item = (ObjectNode)sets.get(i);
                    ret.add(new VideoModel.MovieSetDetail((JsonNode)item));
                }
                return ret;
            }
            return new ArrayList<VideoModel.MovieSetDetail>(0);
        }

        @Override
        public String getName() {
            return API_TYPE;
        }

        @Override
        protected boolean returnsList() {
            return true;
        }
    }

    public static class GetMovieSetDetails
    extends AbstractCall<VideoModel.MovieSetExtendedDetail> {
        public static final String API_TYPE = "VideoLibrary.GetMovieSetDetails";
        public static final String RESULT = "setdetails";

        public GetMovieSetDetails(Integer setid, Movie movies, String ... properties) {
            this.addParameter("setid", setid);
            this.addParameter("movies", (AbstractModel)movies);
            this.addParameter("properties", properties);
        }

        public GetMovieSetDetails(Integer setid, String ... properties) {
            this.addParameter("setid", setid);
            this.addParameter("properties", properties);
        }

        @Override
        protected VideoModel.MovieSetExtendedDetail parseOne(JsonNode node) {
            return new VideoModel.MovieSetExtendedDetail((JsonNode)((ObjectNode)node.get(RESULT)));
        }

        @Override
        public String getName() {
            return API_TYPE;
        }

        @Override
        protected boolean returnsList() {
            return false;
        }

        public static class Movie
        extends AbstractModel {
            public static final String LIMITS = "limits";
            public static final String PROPERTIES = "properties";
            public static final String SORT = "sort";
            public final ListModel.Limits limits;
            public final String properties;
            public final ListModel.Sort sort;

            public Movie(ListModel.Limits limits, String properties, ListModel.Sort sort) {
                this.limits = limits;
                this.properties = properties;
                this.sort = sort;
            }

            @Override
            public JsonNode toJsonNode() {
                ObjectNode node = OM.createObjectNode();
                node.put(LIMITS, this.limits == null ? null : this.limits.toJsonNode());
                node.put(PROPERTIES, this.properties);
                node.put(SORT, this.sort == null ? null : this.sort.toJsonNode());
                return node;
            }

            public static interface Property {
                public static final String TITLE = "title";
                public static final String GENRE = "genre";
                public static final String YEAR = "year";
                public static final String RATING = "rating";
                public static final String DIRECTOR = "director";
                public static final String TRAILER = "trailer";
                public static final String TAGLINE = "tagline";
                public static final String PLOT = "plot";
                public static final String PLOTOUTLINE = "plotoutline";
                public static final String ORIGINALTITLE = "originaltitle";
                public static final String LASTPLAYED = "lastplayed";
                public static final String PLAYCOUNT = "playcount";
                public static final String WRITER = "writer";
                public static final String STUDIO = "studio";
                public static final String MPAA = "mpaa";
                public static final String CAST = "cast";
                public static final String COUNTRY = "country";
                public static final String IMDBNUMBER = "imdbnumber";
                public static final String RUNTIME = "runtime";
                public static final String SET = "set";
                public static final String SHOWLINK = "showlink";
                public static final String STREAMDETAILS = "streamdetails";
                public static final String TOP250 = "top250";
                public static final String VOTES = "votes";
                public static final String FANART = "fanart";
                public static final String THUMBNAIL = "thumbnail";
                public static final String FILE = "file";
                public static final String SORTTITLE = "sorttitle";
                public static final String RESUME = "resume";
                public static final String SETID = "setid";
                public static final String DATEADDED = "dateadded";
                public static final String TAG = "tag";
                public static final String ART = "art";
                public static final String USERRATING = "userrating";
                public static final Set<String> values = new HashSet<String>(Arrays.asList("title", "genre", "year", "rating", "director", "trailer", "tagline", "plot", "plotoutline", "originaltitle", "lastplayed", "playcount", "writer", "studio", "mpaa", "cast", "country", "imdbnumber", "runtime", "set", "showlink", "streamdetails", "top250", "votes", "fanart", "thumbnail", "file", "sorttitle", "resume", "setid", "dateadded", "tag", "art", "userrating"));
            }
        }
    }

    public static class GetMovieDetails
    extends AbstractCall<VideoModel.MovieDetail> {
        public static final String API_TYPE = "VideoLibrary.GetMovieDetails";
        public static final String RESULT = "moviedetails";

        public GetMovieDetails(Integer movieid, String ... properties) {
            this.addParameter("movieid", movieid);
            this.addParameter("properties", properties);
        }

        @Override
        protected VideoModel.MovieDetail parseOne(JsonNode node) {
            return new VideoModel.MovieDetail((JsonNode)((ObjectNode)node.get(RESULT)));
        }

        @Override
        public String getName() {
            return API_TYPE;
        }

        @Override
        protected boolean returnsList() {
            return false;
        }
    }

    public static class GetGenres
    extends AbstractCall<LibraryModel.GenreDetail> {
        public static final String API_TYPE = "VideoLibrary.GetGenres";
        public static final String RESULT = "genres";

        public GetGenres(String type, ListModel.Limits limits, ListModel.Sort sort, String ... properties) {
            this.addParameter("type", type);
            this.addParameter("limits", (AbstractModel)limits);
            this.addParameter("sort", (AbstractModel)sort);
            this.addParameter("properties", properties);
        }

        public GetGenres(String type, String ... properties) {
            this.addParameter("type", type);
            this.addParameter("properties", properties);
        }

        public GetGenres(String type, ListModel.Limits limits, String ... properties) {
            this.addParameter("type", type);
            this.addParameter("limits", (AbstractModel)limits);
            this.addParameter("properties", properties);
        }

        @Override
        protected ArrayList<LibraryModel.GenreDetail> parseMany(JsonNode node) {
            ArrayNode genres = this.parseResults(node, RESULT);
            if (genres != null) {
                ArrayList<LibraryModel.GenreDetail> ret = new ArrayList<LibraryModel.GenreDetail>(genres.size());
                for (int i = 0; i < genres.size(); ++i) {
                    ObjectNode item = (ObjectNode)genres.get(i);
                    ret.add(new LibraryModel.GenreDetail((JsonNode)item));
                }
                return ret;
            }
            return new ArrayList<LibraryModel.GenreDetail>(0);
        }

        @Override
        public String getName() {
            return API_TYPE;
        }

        @Override
        protected boolean returnsList() {
            return true;
        }

        public static interface Type {
            public static final String MOVIE = "movie";
            public static final String TVSHOW = "tvshow";
            public static final String MUSICVIDEO = "musicvideo";
            public static final Set<String> values = new HashSet<String>(Arrays.asList("movie", "tvshow", "musicvideo"));
        }
    }

    public static class GetEpisodes
    extends AbstractCall<VideoModel.EpisodeDetail> {
        public static final String API_TYPE = "VideoLibrary.GetEpisodes";
        public static final String RESULT = "episodes";

        public GetEpisodes(Integer tvshowid, Integer season, ListModel.Limits limits, ListModel.Sort sort, FilterGenreId filter, String ... properties) {
            this.addParameter("tvshowid", tvshowid);
            this.addParameter("season", season);
            this.addParameter("limits", (AbstractModel)limits);
            this.addParameter("sort", (AbstractModel)sort);
            this.addParameter("filter", (AbstractModel)filter);
            this.addParameter("properties", properties);
        }

        public GetEpisodes(Integer tvshowid, Integer season, ListModel.Limits limits, ListModel.Sort sort, FilterGenre filter, String ... properties) {
            this.addParameter("tvshowid", tvshowid);
            this.addParameter("season", season);
            this.addParameter("limits", (AbstractModel)limits);
            this.addParameter("sort", (AbstractModel)sort);
            this.addParameter("filter", (AbstractModel)filter);
            this.addParameter("properties", properties);
        }

        public GetEpisodes(Integer tvshowid, Integer season, ListModel.Limits limits, ListModel.Sort sort, FilterYear filter, String ... properties) {
            this.addParameter("tvshowid", tvshowid);
            this.addParameter("season", season);
            this.addParameter("limits", (AbstractModel)limits);
            this.addParameter("sort", (AbstractModel)sort);
            this.addParameter("filter", (AbstractModel)filter);
            this.addParameter("properties", properties);
        }

        public GetEpisodes(Integer tvshowid, Integer season, ListModel.Limits limits, ListModel.Sort sort, FilterActor filter, String ... properties) {
            this.addParameter("tvshowid", tvshowid);
            this.addParameter("season", season);
            this.addParameter("limits", (AbstractModel)limits);
            this.addParameter("sort", (AbstractModel)sort);
            this.addParameter("filter", (AbstractModel)filter);
            this.addParameter("properties", properties);
        }

        public GetEpisodes(Integer tvshowid, Integer season, ListModel.Limits limits, ListModel.Sort sort, FilterDirector filter, String ... properties) {
            this.addParameter("tvshowid", tvshowid);
            this.addParameter("season", season);
            this.addParameter("limits", (AbstractModel)limits);
            this.addParameter("sort", (AbstractModel)sort);
            this.addParameter("filter", (AbstractModel)filter);
            this.addParameter("properties", properties);
        }

        public GetEpisodes(Integer tvshowid, Integer season, ListModel.Limits limits, ListModel.Sort sort, ListModel.EpisodeFilter filter, String ... properties) {
            this.addParameter("tvshowid", tvshowid);
            this.addParameter("season", season);
            this.addParameter("limits", (AbstractModel)limits);
            this.addParameter("sort", (AbstractModel)sort);
            this.addParameter("filter", (AbstractModel)filter);
            this.addParameter("properties", properties);
        }

        public GetEpisodes(String ... properties) {
            this.addParameter("properties", properties);
        }

        public GetEpisodes(Integer tvshowid, String ... properties) {
            this.addParameter("tvshowid", tvshowid);
            this.addParameter("properties", properties);
        }

        public GetEpisodes(Integer tvshowid, Integer season, String ... properties) {
            this.addParameter("tvshowid", tvshowid);
            this.addParameter("season", season);
            this.addParameter("properties", properties);
        }

        public GetEpisodes(ListModel.Limits limits, String ... properties) {
            this.addParameter("limits", (AbstractModel)limits);
            this.addParameter("properties", properties);
        }

        public GetEpisodes(Integer tvshowid, ListModel.Limits limits, String ... properties) {
            this.addParameter("tvshowid", tvshowid);
            this.addParameter("limits", (AbstractModel)limits);
            this.addParameter("properties", properties);
        }

        public GetEpisodes(Integer tvshowid, Integer season, ListModel.Limits limits, String ... properties) {
            this.addParameter("tvshowid", tvshowid);
            this.addParameter("season", season);
            this.addParameter("limits", (AbstractModel)limits);
            this.addParameter("properties", properties);
        }

        public GetEpisodes(ListModel.Sort sort, String ... properties) {
            this.addParameter("sort", (AbstractModel)sort);
            this.addParameter("properties", properties);
        }

        public GetEpisodes(Integer tvshowid, ListModel.Sort sort, String ... properties) {
            this.addParameter("tvshowid", tvshowid);
            this.addParameter("sort", (AbstractModel)sort);
            this.addParameter("properties", properties);
        }

        public GetEpisodes(Integer tvshowid, Integer season, ListModel.Sort sort, String ... properties) {
            this.addParameter("tvshowid", tvshowid);
            this.addParameter("season", season);
            this.addParameter("sort", (AbstractModel)sort);
            this.addParameter("properties", properties);
        }

        public GetEpisodes(ListModel.Limits limits, ListModel.Sort sort, String ... properties) {
            this.addParameter("limits", (AbstractModel)limits);
            this.addParameter("sort", (AbstractModel)sort);
            this.addParameter("properties", properties);
        }

        public GetEpisodes(Integer tvshowid, ListModel.Limits limits, ListModel.Sort sort, String ... properties) {
            this.addParameter("tvshowid", tvshowid);
            this.addParameter("limits", (AbstractModel)limits);
            this.addParameter("sort", (AbstractModel)sort);
            this.addParameter("properties", properties);
        }

        public GetEpisodes(Integer tvshowid, Integer season, ListModel.Limits limits, ListModel.Sort sort, String ... properties) {
            this.addParameter("tvshowid", tvshowid);
            this.addParameter("season", season);
            this.addParameter("limits", (AbstractModel)limits);
            this.addParameter("sort", (AbstractModel)sort);
            this.addParameter("properties", properties);
        }

        public GetEpisodes(FilterGenreId filter, String ... properties) {
            this.addParameter("filter", (AbstractModel)filter);
            this.addParameter("properties", properties);
        }

        public GetEpisodes(Integer tvshowid, FilterGenreId filter, String ... properties) {
            this.addParameter("tvshowid", tvshowid);
            this.addParameter("filter", (AbstractModel)filter);
            this.addParameter("properties", properties);
        }

        public GetEpisodes(Integer tvshowid, Integer season, FilterGenreId filter, String ... properties) {
            this.addParameter("tvshowid", tvshowid);
            this.addParameter("season", season);
            this.addParameter("filter", (AbstractModel)filter);
            this.addParameter("properties", properties);
        }

        public GetEpisodes(ListModel.Limits limits, FilterGenreId filter, String ... properties) {
            this.addParameter("limits", (AbstractModel)limits);
            this.addParameter("filter", (AbstractModel)filter);
            this.addParameter("properties", properties);
        }

        public GetEpisodes(Integer tvshowid, ListModel.Limits limits, FilterGenreId filter, String ... properties) {
            this.addParameter("tvshowid", tvshowid);
            this.addParameter("limits", (AbstractModel)limits);
            this.addParameter("filter", (AbstractModel)filter);
            this.addParameter("properties", properties);
        }

        public GetEpisodes(Integer tvshowid, Integer season, ListModel.Limits limits, FilterGenreId filter, String ... properties) {
            this.addParameter("tvshowid", tvshowid);
            this.addParameter("season", season);
            this.addParameter("limits", (AbstractModel)limits);
            this.addParameter("filter", (AbstractModel)filter);
            this.addParameter("properties", properties);
        }

        public GetEpisodes(ListModel.Sort sort, FilterGenreId filter, String ... properties) {
            this.addParameter("sort", (AbstractModel)sort);
            this.addParameter("filter", (AbstractModel)filter);
            this.addParameter("properties", properties);
        }

        public GetEpisodes(Integer tvshowid, ListModel.Sort sort, FilterGenreId filter, String ... properties) {
            this.addParameter("tvshowid", tvshowid);
            this.addParameter("sort", (AbstractModel)sort);
            this.addParameter("filter", (AbstractModel)filter);
            this.addParameter("properties", properties);
        }

        public GetEpisodes(Integer tvshowid, Integer season, ListModel.Sort sort, FilterGenreId filter, String ... properties) {
            this.addParameter("tvshowid", tvshowid);
            this.addParameter("season", season);
            this.addParameter("sort", (AbstractModel)sort);
            this.addParameter("filter", (AbstractModel)filter);
            this.addParameter("properties", properties);
        }

        public GetEpisodes(ListModel.Limits limits, ListModel.Sort sort, FilterGenreId filter, String ... properties) {
            this.addParameter("limits", (AbstractModel)limits);
            this.addParameter("sort", (AbstractModel)sort);
            this.addParameter("filter", (AbstractModel)filter);
            this.addParameter("properties", properties);
        }

        public GetEpisodes(Integer tvshowid, ListModel.Limits limits, ListModel.Sort sort, FilterGenreId filter, String ... properties) {
            this.addParameter("tvshowid", tvshowid);
            this.addParameter("limits", (AbstractModel)limits);
            this.addParameter("sort", (AbstractModel)sort);
            this.addParameter("filter", (AbstractModel)filter);
            this.addParameter("properties", properties);
        }

        public GetEpisodes(FilterGenre filter, String ... properties) {
            this.addParameter("filter", (AbstractModel)filter);
            this.addParameter("properties", properties);
        }

        public GetEpisodes(Integer tvshowid, FilterGenre filter, String ... properties) {
            this.addParameter("tvshowid", tvshowid);
            this.addParameter("filter", (AbstractModel)filter);
            this.addParameter("properties", properties);
        }

        public GetEpisodes(Integer tvshowid, Integer season, FilterGenre filter, String ... properties) {
            this.addParameter("tvshowid", tvshowid);
            this.addParameter("season", season);
            this.addParameter("filter", (AbstractModel)filter);
            this.addParameter("properties", properties);
        }

        public GetEpisodes(ListModel.Limits limits, FilterGenre filter, String ... properties) {
            this.addParameter("limits", (AbstractModel)limits);
            this.addParameter("filter", (AbstractModel)filter);
            this.addParameter("properties", properties);
        }

        public GetEpisodes(Integer tvshowid, ListModel.Limits limits, FilterGenre filter, String ... properties) {
            this.addParameter("tvshowid", tvshowid);
            this.addParameter("limits", (AbstractModel)limits);
            this.addParameter("filter", (AbstractModel)filter);
            this.addParameter("properties", properties);
        }

        public GetEpisodes(Integer tvshowid, Integer season, ListModel.Limits limits, FilterGenre filter, String ... properties) {
            this.addParameter("tvshowid", tvshowid);
            this.addParameter("season", season);
            this.addParameter("limits", (AbstractModel)limits);
            this.addParameter("filter", (AbstractModel)filter);
            this.addParameter("properties", properties);
        }

        public GetEpisodes(ListModel.Sort sort, FilterGenre filter, String ... properties) {
            this.addParameter("sort", (AbstractModel)sort);
            this.addParameter("filter", (AbstractModel)filter);
            this.addParameter("properties", properties);
        }

        public GetEpisodes(Integer tvshowid, ListModel.Sort sort, FilterGenre filter, String ... properties) {
            this.addParameter("tvshowid", tvshowid);
            this.addParameter("sort", (AbstractModel)sort);
            this.addParameter("filter", (AbstractModel)filter);
            this.addParameter("properties", properties);
        }

        public GetEpisodes(Integer tvshowid, Integer season, ListModel.Sort sort, FilterGenre filter, String ... properties) {
            this.addParameter("tvshowid", tvshowid);
            this.addParameter("season", season);
            this.addParameter("sort", (AbstractModel)sort);
            this.addParameter("filter", (AbstractModel)filter);
            this.addParameter("properties", properties);
        }

        public GetEpisodes(ListModel.Limits limits, ListModel.Sort sort, FilterGenre filter, String ... properties) {
            this.addParameter("limits", (AbstractModel)limits);
            this.addParameter("sort", (AbstractModel)sort);
            this.addParameter("filter", (AbstractModel)filter);
            this.addParameter("properties", properties);
        }

        public GetEpisodes(Integer tvshowid, ListModel.Limits limits, ListModel.Sort sort, FilterGenre filter, String ... properties) {
            this.addParameter("tvshowid", tvshowid);
            this.addParameter("limits", (AbstractModel)limits);
            this.addParameter("sort", (AbstractModel)sort);
            this.addParameter("filter", (AbstractModel)filter);
            this.addParameter("properties", properties);
        }

        public GetEpisodes(FilterYear filter, String ... properties) {
            this.addParameter("filter", (AbstractModel)filter);
            this.addParameter("properties", properties);
        }

        public GetEpisodes(Integer tvshowid, FilterYear filter, String ... properties) {
            this.addParameter("tvshowid", tvshowid);
            this.addParameter("filter", (AbstractModel)filter);
            this.addParameter("properties", properties);
        }

        public GetEpisodes(Integer tvshowid, Integer season, FilterYear filter, String ... properties) {
            this.addParameter("tvshowid", tvshowid);
            this.addParameter("season", season);
            this.addParameter("filter", (AbstractModel)filter);
            this.addParameter("properties", properties);
        }

        public GetEpisodes(ListModel.Limits limits, FilterYear filter, String ... properties) {
            this.addParameter("limits", (AbstractModel)limits);
            this.addParameter("filter", (AbstractModel)filter);
            this.addParameter("properties", properties);
        }

        public GetEpisodes(Integer tvshowid, ListModel.Limits limits, FilterYear filter, String ... properties) {
            this.addParameter("tvshowid", tvshowid);
            this.addParameter("limits", (AbstractModel)limits);
            this.addParameter("filter", (AbstractModel)filter);
            this.addParameter("properties", properties);
        }

        public GetEpisodes(Integer tvshowid, Integer season, ListModel.Limits limits, FilterYear filter, String ... properties) {
            this.addParameter("tvshowid", tvshowid);
            this.addParameter("season", season);
            this.addParameter("limits", (AbstractModel)limits);
            this.addParameter("filter", (AbstractModel)filter);
            this.addParameter("properties", properties);
        }

        public GetEpisodes(ListModel.Sort sort, FilterYear filter, String ... properties) {
            this.addParameter("sort", (AbstractModel)sort);
            this.addParameter("filter", (AbstractModel)filter);
            this.addParameter("properties", properties);
        }

        public GetEpisodes(Integer tvshowid, ListModel.Sort sort, FilterYear filter, String ... properties) {
            this.addParameter("tvshowid", tvshowid);
            this.addParameter("sort", (AbstractModel)sort);
            this.addParameter("filter", (AbstractModel)filter);
            this.addParameter("properties", properties);
        }

        public GetEpisodes(Integer tvshowid, Integer season, ListModel.Sort sort, FilterYear filter, String ... properties) {
            this.addParameter("tvshowid", tvshowid);
            this.addParameter("season", season);
            this.addParameter("sort", (AbstractModel)sort);
            this.addParameter("filter", (AbstractModel)filter);
            this.addParameter("properties", properties);
        }

        public GetEpisodes(ListModel.Limits limits, ListModel.Sort sort, FilterYear filter, String ... properties) {
            this.addParameter("limits", (AbstractModel)limits);
            this.addParameter("sort", (AbstractModel)sort);
            this.addParameter("filter", (AbstractModel)filter);
            this.addParameter("properties", properties);
        }

        public GetEpisodes(Integer tvshowid, ListModel.Limits limits, ListModel.Sort sort, FilterYear filter, String ... properties) {
            this.addParameter("tvshowid", tvshowid);
            this.addParameter("limits", (AbstractModel)limits);
            this.addParameter("sort", (AbstractModel)sort);
            this.addParameter("filter", (AbstractModel)filter);
            this.addParameter("properties", properties);
        }

        public GetEpisodes(FilterActor filter, String ... properties) {
            this.addParameter("filter", (AbstractModel)filter);
            this.addParameter("properties", properties);
        }

        public GetEpisodes(Integer tvshowid, FilterActor filter, String ... properties) {
            this.addParameter("tvshowid", tvshowid);
            this.addParameter("filter", (AbstractModel)filter);
            this.addParameter("properties", properties);
        }

        public GetEpisodes(Integer tvshowid, Integer season, FilterActor filter, String ... properties) {
            this.addParameter("tvshowid", tvshowid);
            this.addParameter("season", season);
            this.addParameter("filter", (AbstractModel)filter);
            this.addParameter("properties", properties);
        }

        public GetEpisodes(ListModel.Limits limits, FilterActor filter, String ... properties) {
            this.addParameter("limits", (AbstractModel)limits);
            this.addParameter("filter", (AbstractModel)filter);
            this.addParameter("properties", properties);
        }

        public GetEpisodes(Integer tvshowid, ListModel.Limits limits, FilterActor filter, String ... properties) {
            this.addParameter("tvshowid", tvshowid);
            this.addParameter("limits", (AbstractModel)limits);
            this.addParameter("filter", (AbstractModel)filter);
            this.addParameter("properties", properties);
        }

        public GetEpisodes(Integer tvshowid, Integer season, ListModel.Limits limits, FilterActor filter, String ... properties) {
            this.addParameter("tvshowid", tvshowid);
            this.addParameter("season", season);
            this.addParameter("limits", (AbstractModel)limits);
            this.addParameter("filter", (AbstractModel)filter);
            this.addParameter("properties", properties);
        }

        public GetEpisodes(ListModel.Sort sort, FilterActor filter, String ... properties) {
            this.addParameter("sort", (AbstractModel)sort);
            this.addParameter("filter", (AbstractModel)filter);
            this.addParameter("properties", properties);
        }

        public GetEpisodes(Integer tvshowid, ListModel.Sort sort, FilterActor filter, String ... properties) {
            this.addParameter("tvshowid", tvshowid);
            this.addParameter("sort", (AbstractModel)sort);
            this.addParameter("filter", (AbstractModel)filter);
            this.addParameter("properties", properties);
        }

        public GetEpisodes(Integer tvshowid, Integer season, ListModel.Sort sort, FilterActor filter, String ... properties) {
            this.addParameter("tvshowid", tvshowid);
            this.addParameter("season", season);
            this.addParameter("sort", (AbstractModel)sort);
            this.addParameter("filter", (AbstractModel)filter);
            this.addParameter("properties", properties);
        }

        public GetEpisodes(ListModel.Limits limits, ListModel.Sort sort, FilterActor filter, String ... properties) {
            this.addParameter("limits", (AbstractModel)limits);
            this.addParameter("sort", (AbstractModel)sort);
            this.addParameter("filter", (AbstractModel)filter);
            this.addParameter("properties", properties);
        }

        public GetEpisodes(Integer tvshowid, ListModel.Limits limits, ListModel.Sort sort, FilterActor filter, String ... properties) {
            this.addParameter("tvshowid", tvshowid);
            this.addParameter("limits", (AbstractModel)limits);
            this.addParameter("sort", (AbstractModel)sort);
            this.addParameter("filter", (AbstractModel)filter);
            this.addParameter("properties", properties);
        }

        public GetEpisodes(FilterDirector filter, String ... properties) {
            this.addParameter("filter", (AbstractModel)filter);
            this.addParameter("properties", properties);
        }

        public GetEpisodes(Integer tvshowid, FilterDirector filter, String ... properties) {
            this.addParameter("tvshowid", tvshowid);
            this.addParameter("filter", (AbstractModel)filter);
            this.addParameter("properties", properties);
        }

        public GetEpisodes(Integer tvshowid, Integer season, FilterDirector filter, String ... properties) {
            this.addParameter("tvshowid", tvshowid);
            this.addParameter("season", season);
            this.addParameter("filter", (AbstractModel)filter);
            this.addParameter("properties", properties);
        }

        public GetEpisodes(ListModel.Limits limits, FilterDirector filter, String ... properties) {
            this.addParameter("limits", (AbstractModel)limits);
            this.addParameter("filter", (AbstractModel)filter);
            this.addParameter("properties", properties);
        }

        public GetEpisodes(Integer tvshowid, ListModel.Limits limits, FilterDirector filter, String ... properties) {
            this.addParameter("tvshowid", tvshowid);
            this.addParameter("limits", (AbstractModel)limits);
            this.addParameter("filter", (AbstractModel)filter);
            this.addParameter("properties", properties);
        }

        public GetEpisodes(Integer tvshowid, Integer season, ListModel.Limits limits, FilterDirector filter, String ... properties) {
            this.addParameter("tvshowid", tvshowid);
            this.addParameter("season", season);
            this.addParameter("limits", (AbstractModel)limits);
            this.addParameter("filter", (AbstractModel)filter);
            this.addParameter("properties", properties);
        }

        public GetEpisodes(ListModel.Sort sort, FilterDirector filter, String ... properties) {
            this.addParameter("sort", (AbstractModel)sort);
            this.addParameter("filter", (AbstractModel)filter);
            this.addParameter("properties", properties);
        }

        public GetEpisodes(Integer tvshowid, ListModel.Sort sort, FilterDirector filter, String ... properties) {
            this.addParameter("tvshowid", tvshowid);
            this.addParameter("sort", (AbstractModel)sort);
            this.addParameter("filter", (AbstractModel)filter);
            this.addParameter("properties", properties);
        }

        public GetEpisodes(Integer tvshowid, Integer season, ListModel.Sort sort, FilterDirector filter, String ... properties) {
            this.addParameter("tvshowid", tvshowid);
            this.addParameter("season", season);
            this.addParameter("sort", (AbstractModel)sort);
            this.addParameter("filter", (AbstractModel)filter);
            this.addParameter("properties", properties);
        }

        public GetEpisodes(ListModel.Limits limits, ListModel.Sort sort, FilterDirector filter, String ... properties) {
            this.addParameter("limits", (AbstractModel)limits);
            this.addParameter("sort", (AbstractModel)sort);
            this.addParameter("filter", (AbstractModel)filter);
            this.addParameter("properties", properties);
        }

        public GetEpisodes(Integer tvshowid, ListModel.Limits limits, ListModel.Sort sort, FilterDirector filter, String ... properties) {
            this.addParameter("tvshowid", tvshowid);
            this.addParameter("limits", (AbstractModel)limits);
            this.addParameter("sort", (AbstractModel)sort);
            this.addParameter("filter", (AbstractModel)filter);
            this.addParameter("properties", properties);
        }

        public GetEpisodes(ListModel.EpisodeFilter filter, String ... properties) {
            this.addParameter("filter", (AbstractModel)filter);
            this.addParameter("properties", properties);
        }

        public GetEpisodes(Integer tvshowid, ListModel.EpisodeFilter filter, String ... properties) {
            this.addParameter("tvshowid", tvshowid);
            this.addParameter("filter", (AbstractModel)filter);
            this.addParameter("properties", properties);
        }

        public GetEpisodes(Integer tvshowid, Integer season, ListModel.EpisodeFilter filter, String ... properties) {
            this.addParameter("tvshowid", tvshowid);
            this.addParameter("season", season);
            this.addParameter("filter", (AbstractModel)filter);
            this.addParameter("properties", properties);
        }

        public GetEpisodes(ListModel.Limits limits, ListModel.EpisodeFilter filter, String ... properties) {
            this.addParameter("limits", (AbstractModel)limits);
            this.addParameter("filter", (AbstractModel)filter);
            this.addParameter("properties", properties);
        }

        public GetEpisodes(Integer tvshowid, ListModel.Limits limits, ListModel.EpisodeFilter filter, String ... properties) {
            this.addParameter("tvshowid", tvshowid);
            this.addParameter("limits", (AbstractModel)limits);
            this.addParameter("filter", (AbstractModel)filter);
            this.addParameter("properties", properties);
        }

        public GetEpisodes(Integer tvshowid, Integer season, ListModel.Limits limits, ListModel.EpisodeFilter filter, String ... properties) {
            this.addParameter("tvshowid", tvshowid);
            this.addParameter("season", season);
            this.addParameter("limits", (AbstractModel)limits);
            this.addParameter("filter", (AbstractModel)filter);
            this.addParameter("properties", properties);
        }

        public GetEpisodes(ListModel.Sort sort, ListModel.EpisodeFilter filter, String ... properties) {
            this.addParameter("sort", (AbstractModel)sort);
            this.addParameter("filter", (AbstractModel)filter);
            this.addParameter("properties", properties);
        }

        public GetEpisodes(Integer tvshowid, ListModel.Sort sort, ListModel.EpisodeFilter filter, String ... properties) {
            this.addParameter("tvshowid", tvshowid);
            this.addParameter("sort", (AbstractModel)sort);
            this.addParameter("filter", (AbstractModel)filter);
            this.addParameter("properties", properties);
        }

        public GetEpisodes(Integer tvshowid, Integer season, ListModel.Sort sort, ListModel.EpisodeFilter filter, String ... properties) {
            this.addParameter("tvshowid", tvshowid);
            this.addParameter("season", season);
            this.addParameter("sort", (AbstractModel)sort);
            this.addParameter("filter", (AbstractModel)filter);
            this.addParameter("properties", properties);
        }

        public GetEpisodes(ListModel.Limits limits, ListModel.Sort sort, ListModel.EpisodeFilter filter, String ... properties) {
            this.addParameter("limits", (AbstractModel)limits);
            this.addParameter("sort", (AbstractModel)sort);
            this.addParameter("filter", (AbstractModel)filter);
            this.addParameter("properties", properties);
        }

        public GetEpisodes(Integer tvshowid, ListModel.Limits limits, ListModel.Sort sort, ListModel.EpisodeFilter filter, String ... properties) {
            this.addParameter("tvshowid", tvshowid);
            this.addParameter("limits", (AbstractModel)limits);
            this.addParameter("sort", (AbstractModel)sort);
            this.addParameter("filter", (AbstractModel)filter);
            this.addParameter("properties", properties);
        }

        @Override
        protected ArrayList<VideoModel.EpisodeDetail> parseMany(JsonNode node) {
            ArrayNode episodes = this.parseResults(node, RESULT);
            if (episodes != null) {
                ArrayList<VideoModel.EpisodeDetail> ret = new ArrayList<VideoModel.EpisodeDetail>(episodes.size());
                for (int i = 0; i < episodes.size(); ++i) {
                    ObjectNode item = (ObjectNode)episodes.get(i);
                    ret.add(new VideoModel.EpisodeDetail((JsonNode)item));
                }
                return ret;
            }
            return new ArrayList<VideoModel.EpisodeDetail>(0);
        }

        @Override
        public String getName() {
            return API_TYPE;
        }

        @Override
        protected boolean returnsList() {
            return true;
        }

        public static class FilterDirector
        extends AbstractModel {
            public static final String DIRECTOR = "director";
            public final String director;

            public FilterDirector(String director) {
                this.director = director;
            }

            @Override
            public JsonNode toJsonNode() {
                ObjectNode node = OM.createObjectNode();
                node.put(DIRECTOR, this.director);
                return node;
            }
        }

        public static class FilterActor
        extends AbstractModel {
            public static final String ACTOR = "actor";
            public final String actor;

            public FilterActor(String actor) {
                this.actor = actor;
            }

            @Override
            public JsonNode toJsonNode() {
                ObjectNode node = OM.createObjectNode();
                node.put(ACTOR, this.actor);
                return node;
            }
        }

        public static class FilterYear
        extends AbstractModel {
            public static final String YEAR = "year";
            public final Integer year;

            public FilterYear(Integer year) {
                this.year = year;
            }

            @Override
            public JsonNode toJsonNode() {
                ObjectNode node = OM.createObjectNode();
                node.put(YEAR, this.year);
                return node;
            }
        }

        public static class FilterGenre
        extends AbstractModel {
            public static final String GENRE = "genre";
            public final String genre;

            public FilterGenre(String genre) {
                this.genre = genre;
            }

            @Override
            public JsonNode toJsonNode() {
                ObjectNode node = OM.createObjectNode();
                node.put(GENRE, this.genre);
                return node;
            }
        }

        public static class FilterGenreId
        extends AbstractModel {
            public static final String GENREID = "genreid";
            public final Integer genreid;

            public FilterGenreId(Integer genreid) {
                this.genreid = genreid;
            }

            @Override
            public JsonNode toJsonNode() {
                ObjectNode node = OM.createObjectNode();
                node.put(GENREID, this.genreid);
                return node;
            }
        }
    }

    public static class GetEpisodeDetails
    extends AbstractCall<VideoModel.EpisodeDetail> {
        public static final String API_TYPE = "VideoLibrary.GetEpisodeDetails";
        public static final String RESULT = "episodedetails";

        public GetEpisodeDetails(Integer episodeid, String ... properties) {
            this.addParameter("episodeid", episodeid);
            this.addParameter("properties", properties);
        }

        @Override
        protected VideoModel.EpisodeDetail parseOne(JsonNode node) {
            return new VideoModel.EpisodeDetail((JsonNode)((ObjectNode)node.get(RESULT)));
        }

        @Override
        public String getName() {
            return API_TYPE;
        }

        @Override
        protected boolean returnsList() {
            return false;
        }
    }

    public static class Export
    extends AbstractCall<String> {
        public static final String API_TYPE = "VideoLibrary.Export";

        public Export(OptionsPath options) {
            this.addParameter("options", (AbstractModel)options);
        }

        public Export(OptionsActorthumbsImagesOverwrite options) {
            this.addParameter("options", (AbstractModel)options);
        }

        @Override
        protected String parseOne(JsonNode node) {
            return node.getTextValue();
        }

        @Override
        public String getName() {
            return API_TYPE;
        }

        @Override
        protected boolean returnsList() {
            return false;
        }

        public static class OptionsActorthumbsImagesOverwrite
        extends AbstractModel {
            public static final String ACTORTHUMBS = "actorthumbs";
            public static final String IMAGES = "images";
            public static final String OVERWRITE = "overwrite";
            public final Boolean actorthumbs;
            public final Boolean images;
            public final Boolean overwrite;

            public OptionsActorthumbsImagesOverwrite(Boolean actorthumbs, Boolean images, Boolean overwrite) {
                this.actorthumbs = actorthumbs;
                this.images = images;
                this.overwrite = overwrite;
            }

            @Override
            public JsonNode toJsonNode() {
                ObjectNode node = OM.createObjectNode();
                node.put(ACTORTHUMBS, this.actorthumbs);
                node.put(IMAGES, this.images);
                node.put(OVERWRITE, this.overwrite);
                return node;
            }
        }

        public static class OptionsPath
        extends AbstractModel {
            public static final String PATH = "path";
            public final String path;

            public OptionsPath(String path) {
                this.path = path;
            }

            @Override
            public JsonNode toJsonNode() {
                ObjectNode node = OM.createObjectNode();
                node.put(PATH, this.path);
                return node;
            }
        }
    }

    public static class Clean
    extends AbstractCall<String> {
        public static final String API_TYPE = "VideoLibrary.Clean";

        public Clean(Boolean showdialogs) {
            this.addParameter("showdialogs", showdialogs);
        }

        @Override
        protected String parseOne(JsonNode node) {
            return node.getTextValue();
        }

        @Override
        public String getName() {
            return API_TYPE;
        }

        @Override
        protected boolean returnsList() {
            return false;
        }
    }
}

