/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.jsonrpc.api.call;

import java.util.ArrayList;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.node.ArrayNode;
import org.codehaus.jackson.node.ObjectNode;
import org.tinymediamanager.jsonrpc.api.AbstractCall;
import org.tinymediamanager.jsonrpc.api.AbstractModel;
import org.tinymediamanager.jsonrpc.api.model.SettingModel;

public final class Settings {

    public static class SetSettingValue
    extends AbstractCall<Boolean> {
        public static final String API_TYPE = "Settings.SetSettingValue";

        public SetSettingValue(String setting, SettingModel.ValueExtended value) {
            this.addParameter("setting", setting);
            this.addParameter("value", (AbstractModel)value);
        }

        @Override
        protected Boolean parseOne(JsonNode node) {
            return node.getBooleanValue();
        }

        @Override
        public String getName() {
            return API_TYPE;
        }

        @Override
        protected boolean returnsList() {
            return false;
        }
    }

    public static class ResetSettingValue
    extends AbstractCall<String> {
        public static final String API_TYPE = "Settings.ResetSettingValue";

        public ResetSettingValue(String setting) {
            this.addParameter("setting", setting);
        }

        @Override
        protected String parseOne(JsonNode node) {
            return node.getTextValue();
        }

        @Override
        public String getName() {
            return API_TYPE;
        }

        @Override
        protected boolean returnsList() {
            return false;
        }
    }

    public static class GetSettingValue
    extends AbstractCall<SettingModel.ValueExtended> {
        public static final String API_TYPE = "Settings.GetSettingValue";
        public static final String RESULT = "value";

        public GetSettingValue(String setting) {
            this.addParameter("setting", setting);
        }

        @Override
        protected SettingModel.ValueExtended parseOne(JsonNode node) {
            return new SettingModel.ValueExtended((JsonNode)((ObjectNode)node.get(RESULT)));
        }

        @Override
        public String getName() {
            return API_TYPE;
        }

        @Override
        protected boolean returnsList() {
            return false;
        }
    }

    public static class GetSections
    extends AbstractCall<SettingModel.SectionDetail> {
        public static final String API_TYPE = "Settings.GetSections";
        public static final String RESULT = "sections";

        public GetSections(String level, String ... properties) {
            this.addParameter("level", level);
            this.addParameter("properties", properties);
        }

        @Override
        protected ArrayList<SettingModel.SectionDetail> parseMany(JsonNode node) {
            ArrayNode sections = this.parseResults(node, RESULT);
            if (sections != null) {
                ArrayList<SettingModel.SectionDetail> ret = new ArrayList<SettingModel.SectionDetail>(sections.size());
                for (int i = 0; i < sections.size(); ++i) {
                    ObjectNode item = (ObjectNode)sections.get(i);
                    ret.add(new SettingModel.SectionDetail((JsonNode)item));
                }
                return ret;
            }
            return new ArrayList<SettingModel.SectionDetail>(0);
        }

        @Override
        public String getName() {
            return API_TYPE;
        }

        @Override
        protected boolean returnsList() {
            return true;
        }
    }

    public static class GetCategories
    extends AbstractCall<SettingModel.CategoryDetail> {
        public static final String API_TYPE = "Settings.GetCategories";
        public static final String RESULT = "categories";

        public GetCategories(String level, String section, String ... properties) {
            this.addParameter("level", level);
            this.addParameter("section", section);
            this.addParameter("properties", properties);
        }

        public GetCategories(String properties) {
            this.addParameter("properties", properties);
        }

        public GetCategories(String level, String properties) {
            this.addParameter("level", level);
            this.addParameter("properties", properties);
        }

        @Override
        protected ArrayList<SettingModel.CategoryDetail> parseMany(JsonNode node) {
            ArrayNode categories = this.parseResults(node, RESULT);
            if (categories != null) {
                ArrayList<SettingModel.CategoryDetail> ret = new ArrayList<SettingModel.CategoryDetail>(categories.size());
                for (int i = 0; i < categories.size(); ++i) {
                    ObjectNode item = (ObjectNode)categories.get(i);
                    ret.add(new SettingModel.CategoryDetail((JsonNode)item));
                }
                return ret;
            }
            return new ArrayList<SettingModel.CategoryDetail>(0);
        }

        @Override
        public String getName() {
            return API_TYPE;
        }

        @Override
        protected boolean returnsList() {
            return true;
        }
    }
}

