/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.jsonrpc.api.call;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.node.ArrayNode;
import org.codehaus.jackson.node.ObjectNode;
import org.tinymediamanager.jsonrpc.api.AbstractCall;
import org.tinymediamanager.jsonrpc.api.AbstractModel;
import org.tinymediamanager.jsonrpc.api.model.GlobalModel;
import org.tinymediamanager.jsonrpc.api.model.ListModel;
import org.tinymediamanager.jsonrpc.api.model.PVRModel;

public final class PVR {

    public static class Scan
    extends AbstractCall<String> {
        public static final String API_TYPE = "PVR.Scan";

        @Override
        protected String parseOne(JsonNode node) {
            return node.getTextValue();
        }

        @Override
        public String getName() {
            return API_TYPE;
        }

        @Override
        protected boolean returnsList() {
            return false;
        }
    }

    public static class Record
    extends AbstractCall<String> {
        public static final String API_TYPE = "PVR.Record";

        public Record(GlobalModel.Toggle record, String channel) {
            this.addParameter("record", (AbstractModel)record);
            this.addParameter("channel", channel);
        }

        public Record(GlobalModel.Toggle record, Integer channel) {
            this.addParameter("record", (AbstractModel)record);
            this.addParameter("channel", channel);
        }

        public Record() {
        }

        public Record(GlobalModel.Toggle record) {
            this.addParameter("record", (AbstractModel)record);
        }

        @Override
        protected String parseOne(JsonNode node) {
            return node.getTextValue();
        }

        @Override
        public String getName() {
            return API_TYPE;
        }

        @Override
        protected boolean returnsList() {
            return false;
        }

        public static interface Channel {
            public static final String CURRENT = "current";
            public static final Set<String> values = new HashSet<String>(Arrays.asList("current"));
        }
    }

    public static class GetTimers
    extends AbstractCall<PVRModel.TimerDetail> {
        public static final String API_TYPE = "PVR.GetTimers";
        public static final String RESULT = "timers";

        public GetTimers(ListModel.Limits limits, String ... properties) {
            this.addParameter("limits", (AbstractModel)limits);
            this.addParameter("properties", properties);
        }

        @Override
        protected ArrayList<PVRModel.TimerDetail> parseMany(JsonNode node) {
            ArrayNode timers = this.parseResults(node, RESULT);
            if (timers != null) {
                ArrayList<PVRModel.TimerDetail> ret = new ArrayList<PVRModel.TimerDetail>(timers.size());
                for (int i = 0; i < timers.size(); ++i) {
                    ObjectNode item = (ObjectNode)timers.get(i);
                    ret.add(new PVRModel.TimerDetail((JsonNode)item));
                }
                return ret;
            }
            return new ArrayList<PVRModel.TimerDetail>(0);
        }

        @Override
        public String getName() {
            return API_TYPE;
        }

        @Override
        protected boolean returnsList() {
            return true;
        }
    }

    public static class GetTimerDetails
    extends AbstractCall<PVRModel.TimerDetail> {
        public static final String API_TYPE = "PVR.GetTimerDetails";
        public static final String RESULT = "timerdetails";

        public GetTimerDetails(Integer timerid, String ... properties) {
            this.addParameter("timerid", timerid);
            this.addParameter("properties", properties);
        }

        @Override
        protected PVRModel.TimerDetail parseOne(JsonNode node) {
            return new PVRModel.TimerDetail((JsonNode)((ObjectNode)node.get(RESULT)));
        }

        @Override
        public String getName() {
            return API_TYPE;
        }

        @Override
        protected boolean returnsList() {
            return false;
        }
    }

    public static class GetRecordings
    extends AbstractCall<PVRModel.RecordingDetail> {
        public static final String API_TYPE = "PVR.GetRecordings";
        public static final String RESULT = "recordings";

        public GetRecordings(ListModel.Limits limits, String ... properties) {
            this.addParameter("limits", (AbstractModel)limits);
            this.addParameter("properties", properties);
        }

        @Override
        protected ArrayList<PVRModel.RecordingDetail> parseMany(JsonNode node) {
            ArrayNode recordings = this.parseResults(node, RESULT);
            if (recordings != null) {
                ArrayList<PVRModel.RecordingDetail> ret = new ArrayList<PVRModel.RecordingDetail>(recordings.size());
                for (int i = 0; i < recordings.size(); ++i) {
                    ObjectNode item = (ObjectNode)recordings.get(i);
                    ret.add(new PVRModel.RecordingDetail((JsonNode)item));
                }
                return ret;
            }
            return new ArrayList<PVRModel.RecordingDetail>(0);
        }

        @Override
        public String getName() {
            return API_TYPE;
        }

        @Override
        protected boolean returnsList() {
            return true;
        }
    }

    public static class GetRecordingDetails
    extends AbstractCall<PVRModel.RecordingDetail> {
        public static final String API_TYPE = "PVR.GetRecordingDetails";
        public static final String RESULT = "recordingdetails";

        public GetRecordingDetails(Integer recordingid, String ... properties) {
            this.addParameter("recordingid", recordingid);
            this.addParameter("properties", properties);
        }

        @Override
        protected PVRModel.RecordingDetail parseOne(JsonNode node) {
            return new PVRModel.RecordingDetail((JsonNode)((ObjectNode)node.get(RESULT)));
        }

        @Override
        public String getName() {
            return API_TYPE;
        }

        @Override
        protected boolean returnsList() {
            return false;
        }
    }

    public static class GetProperties
    extends AbstractCall<PVRModel.PropertyValue> {
        public static final String API_TYPE = "PVR.GetProperties";

        public GetProperties(String ... properties) {
            this.addParameter("properties", properties);
        }

        @Override
        protected PVRModel.PropertyValue parseOne(JsonNode node) {
            return new PVRModel.PropertyValue(node);
        }

        @Override
        public String getName() {
            return API_TYPE;
        }

        @Override
        protected boolean returnsList() {
            return false;
        }
    }

    public static class GetChannels
    extends AbstractCall<PVRModel.ChannelDetail> {
        public static final String API_TYPE = "PVR.GetChannels";
        public static final String RESULT = "channels";

        public GetChannels(PVRModel.ChannelGroupId channelgroupid, ListModel.Limits limits, String ... properties) {
            this.addParameter("channelgroupid", (AbstractModel)channelgroupid);
            this.addParameter("limits", (AbstractModel)limits);
            this.addParameter("properties", properties);
        }

        public GetChannels(PVRModel.ChannelGroupId channelgroupid, String ... properties) {
            this.addParameter("channelgroupid", (AbstractModel)channelgroupid);
            this.addParameter("properties", properties);
        }

        @Override
        protected ArrayList<PVRModel.ChannelDetail> parseMany(JsonNode node) {
            ArrayNode channels = this.parseResults(node, RESULT);
            if (channels != null) {
                ArrayList<PVRModel.ChannelDetail> ret = new ArrayList<PVRModel.ChannelDetail>(channels.size());
                for (int i = 0; i < channels.size(); ++i) {
                    ObjectNode item = (ObjectNode)channels.get(i);
                    ret.add(new PVRModel.ChannelDetail((JsonNode)item));
                }
                return ret;
            }
            return new ArrayList<PVRModel.ChannelDetail>(0);
        }

        @Override
        public String getName() {
            return API_TYPE;
        }

        @Override
        protected boolean returnsList() {
            return true;
        }
    }

    public static class GetChannelGroups
    extends AbstractCall<PVRModel.ChannelGroupDetail> {
        public static final String API_TYPE = "PVR.GetChannelGroups";
        public static final String RESULT = "channelgroups";

        public GetChannelGroups(String channeltype, ListModel.Limits limits) {
            this.addParameter("channeltype", channeltype);
            this.addParameter("limits", (AbstractModel)limits);
        }

        public GetChannelGroups(String channeltype) {
            this.addParameter("channeltype", channeltype);
        }

        @Override
        protected ArrayList<PVRModel.ChannelGroupDetail> parseMany(JsonNode node) {
            ArrayNode channelgroups = this.parseResults(node, RESULT);
            if (channelgroups != null) {
                ArrayList<PVRModel.ChannelGroupDetail> ret = new ArrayList<PVRModel.ChannelGroupDetail>(channelgroups.size());
                for (int i = 0; i < channelgroups.size(); ++i) {
                    ObjectNode item = (ObjectNode)channelgroups.get(i);
                    ret.add(new PVRModel.ChannelGroupDetail((JsonNode)item));
                }
                return ret;
            }
            return new ArrayList<PVRModel.ChannelGroupDetail>(0);
        }

        @Override
        public String getName() {
            return API_TYPE;
        }

        @Override
        protected boolean returnsList() {
            return true;
        }
    }

    public static class GetChannelGroupDetails
    extends AbstractCall<PVRModel.ChannelGroupExtendedDetail> {
        public static final String API_TYPE = "PVR.GetChannelGroupDetails";
        public static final String RESULT = "channelgroupdetails";

        public GetChannelGroupDetails(PVRModel.ChannelGroupId channelgroupid, Channel channels) {
            this.addParameter("channelgroupid", (AbstractModel)channelgroupid);
            this.addParameter("channels", (AbstractModel)channels);
        }

        public GetChannelGroupDetails(PVRModel.ChannelGroupId channelgroupid) {
            this.addParameter("channelgroupid", (AbstractModel)channelgroupid);
        }

        @Override
        protected PVRModel.ChannelGroupExtendedDetail parseOne(JsonNode node) {
            return new PVRModel.ChannelGroupExtendedDetail((JsonNode)((ObjectNode)node.get(RESULT)));
        }

        @Override
        public String getName() {
            return API_TYPE;
        }

        @Override
        protected boolean returnsList() {
            return false;
        }

        public static class Channel
        extends AbstractModel {
            public static final String LIMITS = "limits";
            public static final String PROPERTIES = "properties";
            public final ListModel.Limits limits;
            public final String properties;

            public Channel(ListModel.Limits limits, String properties) {
                this.limits = limits;
                this.properties = properties;
            }

            @Override
            public JsonNode toJsonNode() {
                ObjectNode node = OM.createObjectNode();
                node.put(LIMITS, this.limits == null ? null : this.limits.toJsonNode());
                node.put(PROPERTIES, this.properties);
                return node;
            }

            public static interface Property {
                public static final String THUMBNAIL = "thumbnail";
                public static final String CHANNELTYPE = "channeltype";
                public static final String HIDDEN = "hidden";
                public static final String LOCKED = "locked";
                public static final String CHANNEL = "channel";
                public static final String LASTPLAYED = "lastplayed";
                public static final String BROADCASTNOW = "broadcastnow";
                public static final String BROADCASTNEXT = "broadcastnext";
                public static final Set<String> values = new HashSet<String>(Arrays.asList("thumbnail", "channeltype", "hidden", "locked", "channel", "lastplayed", "broadcastnow", "broadcastnext"));
            }
        }
    }

    public static class GetChannelDetails
    extends AbstractCall<PVRModel.ChannelDetail> {
        public static final String API_TYPE = "PVR.GetChannelDetails";
        public static final String RESULT = "channeldetails";

        public GetChannelDetails(Integer channelid, String ... properties) {
            this.addParameter("channelid", channelid);
            this.addParameter("properties", properties);
        }

        @Override
        protected PVRModel.ChannelDetail parseOne(JsonNode node) {
            return new PVRModel.ChannelDetail((JsonNode)((ObjectNode)node.get(RESULT)));
        }

        @Override
        public String getName() {
            return API_TYPE;
        }

        @Override
        protected boolean returnsList() {
            return false;
        }
    }

    public static class GetBroadcasts
    extends AbstractCall<PVRModel.BroadcastDetail> {
        public static final String API_TYPE = "PVR.GetBroadcasts";
        public static final String RESULT = "broadcasts";

        public GetBroadcasts(Integer channelid, ListModel.Limits limits, String ... properties) {
            this.addParameter("channelid", channelid);
            this.addParameter("limits", (AbstractModel)limits);
            this.addParameter("properties", properties);
        }

        public GetBroadcasts(Integer channelid, String ... properties) {
            this.addParameter("channelid", channelid);
            this.addParameter("properties", properties);
        }

        @Override
        protected ArrayList<PVRModel.BroadcastDetail> parseMany(JsonNode node) {
            ArrayNode broadcasts = this.parseResults(node, RESULT);
            if (broadcasts != null) {
                ArrayList<PVRModel.BroadcastDetail> ret = new ArrayList<PVRModel.BroadcastDetail>(broadcasts.size());
                for (int i = 0; i < broadcasts.size(); ++i) {
                    ObjectNode item = (ObjectNode)broadcasts.get(i);
                    ret.add(new PVRModel.BroadcastDetail((JsonNode)item));
                }
                return ret;
            }
            return new ArrayList<PVRModel.BroadcastDetail>(0);
        }

        @Override
        public String getName() {
            return API_TYPE;
        }

        @Override
        protected boolean returnsList() {
            return true;
        }
    }

    public static class GetBroadcastDetails
    extends AbstractCall<PVRModel.BroadcastDetail> {
        public static final String API_TYPE = "PVR.GetBroadcastDetails";
        public static final String RESULT = "broadcastdetails";

        public GetBroadcastDetails(Integer broadcastid, String ... properties) {
            this.addParameter("broadcastid", broadcastid);
            this.addParameter("properties", properties);
        }

        @Override
        protected PVRModel.BroadcastDetail parseOne(JsonNode node) {
            return new PVRModel.BroadcastDetail((JsonNode)((ObjectNode)node.get(RESULT)));
        }

        @Override
        public String getName() {
            return API_TYPE;
        }

        @Override
        protected boolean returnsList() {
            return false;
        }
    }
}

