/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.jsonrpc.api.call;

import java.util.ArrayList;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.node.ArrayNode;
import org.codehaus.jackson.node.ObjectNode;
import org.tinymediamanager.jsonrpc.api.AbstractCall;
import org.tinymediamanager.jsonrpc.api.model.FavouriteModel;

public final class Favourites {

    public static class GetFavourites
    extends AbstractCall<FavouriteModel.FavouriteDetail> {
        public static final String API_TYPE = "Favourites.GetFavourites";
        public static final String RESULT = "favourites";

        public GetFavourites(String type, String ... properties) {
            this.addParameter("type", type);
            this.addParameter("properties", properties);
        }

        @Override
        protected ArrayList<FavouriteModel.FavouriteDetail> parseMany(JsonNode node) {
            ArrayNode favourites = this.parseResults(node, RESULT);
            if (favourites != null) {
                ArrayList<FavouriteModel.FavouriteDetail> ret = new ArrayList<FavouriteModel.FavouriteDetail>(favourites.size());
                for (int i = 0; i < favourites.size(); ++i) {
                    ObjectNode item = (ObjectNode)favourites.get(i);
                    ret.add(new FavouriteModel.FavouriteDetail((JsonNode)item));
                }
                return ret;
            }
            return new ArrayList<FavouriteModel.FavouriteDetail>(0);
        }

        @Override
        public String getName() {
            return API_TYPE;
        }

        @Override
        protected boolean returnsList() {
            return true;
        }
    }

    public static class AddFavourite
    extends AbstractCall<String> {
        public static final String API_TYPE = "Favourites.AddFavourite";

        public AddFavourite(String title, String type, String path, String window, String windowparameter, String thumbnail) {
            this.addParameter("title", title);
            this.addParameter("type", type);
            this.addParameter("path", path);
            this.addParameter("window", window);
            this.addParameter("windowparameter", windowparameter);
            this.addParameter("thumbnail", thumbnail);
        }

        @Override
        protected String parseOne(JsonNode node) {
            return node.getTextValue();
        }

        @Override
        public String getName() {
            return API_TYPE;
        }

        @Override
        protected boolean returnsList() {
            return false;
        }
    }
}

