/*
 * Decompiled with CFR 0.152.
 */
package org.mp4parser;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.mp4parser.AbstractBoxParser;
import org.mp4parser.ParsableBox;
import org.mp4parser.tools.Hex;

public class PropertyBoxParserImpl
extends AbstractBoxParser {
    static Properties BOX_MAP_CACHE = null;
    static String[] EMPTY_STRING_ARRAY = new String[0];
    Properties mapping;
    Pattern constuctorPattern = Pattern.compile("(.*)\\((.*?)\\)");
    StringBuilder buildLookupStrings = new StringBuilder();
    ThreadLocal<String> clazzName = new ThreadLocal();
    ThreadLocal<String[]> param = new ThreadLocal();

    public PropertyBoxParserImpl(String ... customProperties) {
        if (BOX_MAP_CACHE != null) {
            this.mapping = new Properties(BOX_MAP_CACHE);
        } else {
            InputStream is = this.getClass().getResourceAsStream("/isoparser2-default.properties");
            try {
                this.mapping = new Properties();
                try {
                    this.mapping.load(is);
                    ClassLoader cl = Thread.currentThread().getContextClassLoader();
                    if (cl == null) {
                        cl = ClassLoader.getSystemClassLoader();
                    }
                    Enumeration<URL> enumeration = cl.getResources("isoparser-custom.properties");
                    while (enumeration.hasMoreElements()) {
                        URL url = enumeration.nextElement();
                        InputStream customIS = url.openStream();
                        try {
                            this.mapping.load(customIS);
                        }
                        finally {
                            customIS.close();
                        }
                    }
                    String[] stringArray = customProperties;
                    int n = customProperties.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String customProperty = stringArray[n2];
                        this.mapping.load(this.getClass().getResourceAsStream(customProperty));
                        ++n2;
                    }
                    BOX_MAP_CACHE = this.mapping;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            finally {
                try {
                    is.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public PropertyBoxParserImpl(Properties mapping) {
        this.mapping = mapping;
    }

    @Override
    public ParsableBox createBox(String type, byte[] userType, String parent) {
        this.invoke(type, userType, parent);
        String[] param = this.param.get();
        try {
            Class<?> clazz = Class.forName(this.clazzName.get());
            if (param.length > 0) {
                Class[] constructorArgsClazz = new Class[param.length];
                Object[] constructorArgs = new Object[param.length];
                int i = 0;
                while (i < param.length) {
                    if ("userType".equals(param[i])) {
                        constructorArgs[i] = userType;
                        constructorArgsClazz[i] = byte[].class;
                    } else if ("type".equals(param[i])) {
                        constructorArgs[i] = type;
                        constructorArgsClazz[i] = String.class;
                    } else if ("parent".equals(param[i])) {
                        constructorArgs[i] = parent;
                        constructorArgsClazz[i] = String.class;
                    } else {
                        throw new InternalError("No such param: " + param[i]);
                    }
                    ++i;
                }
                Constructor<?> constructorObject = clazz.getConstructor(constructorArgsClazz);
                return (ParsableBox)constructorObject.newInstance(constructorArgs);
            }
            return (ParsableBox)clazz.newInstance();
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
    }

    public void invoke(String type, byte[] userType, String parent) {
        String constructor;
        if (userType != null) {
            if (!"uuid".equals(type)) {
                throw new RuntimeException("we have a userType but no uuid box type. Something's wrong");
            }
            constructor = this.mapping.getProperty("uuid[" + Hex.encodeHex(userType).toUpperCase() + "]");
            if (constructor == null) {
                constructor = this.mapping.getProperty(String.valueOf(parent) + "-uuid[" + Hex.encodeHex(userType).toUpperCase() + "]");
            }
            if (constructor == null) {
                constructor = this.mapping.getProperty("uuid");
            }
        } else {
            constructor = this.mapping.getProperty(type);
            if (constructor == null) {
                String lookup = this.buildLookupStrings.append(parent).append('-').append(type).toString();
                this.buildLookupStrings.setLength(0);
                constructor = this.mapping.getProperty(lookup);
            }
        }
        if (constructor == null) {
            constructor = this.mapping.getProperty("default");
        }
        if (constructor == null) {
            throw new RuntimeException("No box object found for " + type);
        }
        if (!constructor.endsWith(")")) {
            this.param.set(EMPTY_STRING_ARRAY);
            this.clazzName.set(constructor);
        } else {
            Matcher m = this.constuctorPattern.matcher(constructor);
            boolean matches = m.matches();
            if (!matches) {
                throw new RuntimeException("Cannot work with that constructor: " + constructor);
            }
            this.clazzName.set(m.group(1));
            if (m.group(2).length() == 0) {
                this.param.set(EMPTY_STRING_ARRAY);
            } else {
                this.param.set(m.group(2).length() > 0 ? m.group(2).split(",") : new String[]{});
            }
        }
    }
}

