/*
 * Decompiled with CFR 0.152.
 */
package com.github.kiulian.downloader.model;

import com.github.kiulian.downloader.OnYoutubeDownloadListener;
import com.github.kiulian.downloader.YoutubeException;
import com.github.kiulian.downloader.model.Extension;
import com.github.kiulian.downloader.model.Filter;
import com.github.kiulian.downloader.model.Utils;
import com.github.kiulian.downloader.model.VideoDetails;
import com.github.kiulian.downloader.model.formats.AudioFormat;
import com.github.kiulian.downloader.model.formats.AudioVideoFormat;
import com.github.kiulian.downloader.model.formats.Format;
import com.github.kiulian.downloader.model.formats.VideoFormat;
import com.github.kiulian.downloader.model.quality.AudioQuality;
import com.github.kiulian.downloader.model.quality.VideoQuality;
import com.github.kiulian.downloader.model.subtitles.SubtitlesInfo;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.CancellationException;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;

public class YoutubeVideo {
    private static final int BUFFER_SIZE = 4096;
    private static final int PART_LENGTH = 0x200000;
    private VideoDetails videoDetails;
    private List<Format> formats;
    private List<SubtitlesInfo> subtitlesInfo;
    private final String clientVersion;

    public YoutubeVideo(VideoDetails videoDetails, List<Format> list, List<SubtitlesInfo> list2, String string) {
        this.videoDetails = videoDetails;
        this.formats = list;
        this.subtitlesInfo = list2;
        this.clientVersion = string;
    }

    public VideoDetails details() {
        return this.videoDetails;
    }

    public List<Format> formats() {
        return this.formats;
    }

    public List<SubtitlesInfo> subtitles() {
        return this.subtitlesInfo;
    }

    public List<Format> findFormats(Filter<Format> filter) {
        return filter.select(this.formats);
    }

    public Format findFormatByItag(int n) {
        for (int i = 0; i < this.formats.size(); ++i) {
            Format format = this.formats.get(i);
            if (format.itag().id() != n) continue;
            return format;
        }
        return null;
    }

    public List<AudioVideoFormat> videoWithAudioFormats() {
        LinkedList<AudioVideoFormat> linkedList = new LinkedList<AudioVideoFormat>();
        for (int i = 0; i < this.formats.size(); ++i) {
            Format format = this.formats.get(i);
            if (!(format instanceof AudioVideoFormat)) continue;
            linkedList.add((AudioVideoFormat)format);
        }
        return linkedList;
    }

    public List<VideoFormat> videoFormats() {
        LinkedList<VideoFormat> linkedList = new LinkedList<VideoFormat>();
        for (int i = 0; i < this.formats.size(); ++i) {
            Format format = this.formats.get(i);
            if (!(format instanceof VideoFormat)) continue;
            linkedList.add((VideoFormat)format);
        }
        return linkedList;
    }

    public List<VideoFormat> findVideoWithQuality(VideoQuality videoQuality) {
        LinkedList<VideoFormat> linkedList = new LinkedList<VideoFormat>();
        for (int i = 0; i < this.formats.size(); ++i) {
            Format format = this.formats.get(i);
            if (!(format instanceof VideoFormat) || ((VideoFormat)format).videoQuality() != videoQuality) continue;
            linkedList.add((VideoFormat)format);
        }
        return linkedList;
    }

    public List<VideoFormat> findVideoWithExtension(Extension extension) {
        LinkedList<VideoFormat> linkedList = new LinkedList<VideoFormat>();
        for (int i = 0; i < this.formats.size(); ++i) {
            Format format = this.formats.get(i);
            if (!(format instanceof VideoFormat) || !format.extension().equals(extension)) continue;
            linkedList.add((VideoFormat)format);
        }
        return linkedList;
    }

    public List<AudioFormat> audioFormats() {
        LinkedList<AudioFormat> linkedList = new LinkedList<AudioFormat>();
        for (int i = 0; i < this.formats.size(); ++i) {
            Format format = this.formats.get(i);
            if (!(format instanceof AudioFormat)) continue;
            linkedList.add((AudioFormat)format);
        }
        return linkedList;
    }

    public List<AudioFormat> findAudioWithQuality(AudioQuality audioQuality) {
        LinkedList<AudioFormat> linkedList = new LinkedList<AudioFormat>();
        for (int i = 0; i < this.formats.size(); ++i) {
            Format format = this.formats.get(i);
            if (!(format instanceof AudioFormat) || ((AudioFormat)format).audioQuality() != audioQuality) continue;
            linkedList.add((AudioFormat)format);
        }
        return linkedList;
    }

    public List<AudioFormat> findAudioWithExtension(Extension extension) {
        LinkedList<AudioFormat> linkedList = new LinkedList<AudioFormat>();
        for (int i = 0; i < this.formats.size(); ++i) {
            Format format = this.formats.get(i);
            if (!(format instanceof AudioFormat) || format.extension() != extension) continue;
            linkedList.add((AudioFormat)format);
        }
        return linkedList;
    }

    public File download(Format format, File file) throws IOException, YoutubeException {
        return this.download(format, file, this.videoDetails.title());
    }

    public File download(Format format, File file, String string) throws IOException, YoutubeException {
        return this.download(format, file, string, false);
    }

    public File download(Format format, File file, String string, boolean bl) throws IOException, YoutubeException {
        File file2 = this.initDownload(format, file, string, bl);
        return this.basicDownload(format, file2, null);
    }

    public Future<File> downloadAsync(Format format, File file) throws YoutubeException.LiveVideoException, IOException {
        return this.downloadAsync(format, file, this.videoDetails.title());
    }

    public Future<File> downloadAsync(Format format, File file, String string) throws YoutubeException.LiveVideoException, IOException {
        return this.downloadAsync(format, file, string, false, null);
    }

    public Future<File> downloadAsync(Format format, File file, OnYoutubeDownloadListener onYoutubeDownloadListener) throws IOException, YoutubeException {
        return this.downloadAsync(format, file, this.videoDetails.title(), onYoutubeDownloadListener);
    }

    public Future<File> downloadAsync(Format format, File file, String string, OnYoutubeDownloadListener onYoutubeDownloadListener) throws IOException, YoutubeException {
        return this.downloadAsync(format, file, string, false, onYoutubeDownloadListener);
    }

    public Future<File> downloadAsync(Format format, File file, String string, boolean bl, OnYoutubeDownloadListener onYoutubeDownloadListener) throws YoutubeException.LiveVideoException, IOException {
        File file2 = this.initDownload(format, file, string, bl);
        FutureTask<File> futureTask = new FutureTask<File>(() -> this.basicDownload(format, file2, onYoutubeDownloadListener));
        Thread thread = new Thread(futureTask, "YtDownloader");
        thread.setDaemon(true);
        thread.start();
        return futureTask;
    }

    private File initDownload(Format format, File file, String string, boolean bl) throws IOException, YoutubeException.LiveVideoException {
        this.videoDetails.checkDownload();
        Utils.createOutDir(file);
        return Utils.getOutputFile(string, format, file, bl);
    }

    private File basicDownload(Format format, File file, OnYoutubeDownloadListener onYoutubeDownloadListener) throws IOException {
        FileOutputStream fileOutputStream;
        boolean bl;
        block9: {
            bl = false;
            fileOutputStream = null;
            try {
                fileOutputStream = new FileOutputStream(file);
                if (format.isAdaptive() && format.contentLength() != null) {
                    this.downloadByPart(format, fileOutputStream, onYoutubeDownloadListener);
                } else {
                    this.downloadStraight(format, fileOutputStream, onYoutubeDownloadListener);
                }
                if (onYoutubeDownloadListener == null) break block9;
                onYoutubeDownloadListener.onFinished(file);
            }
            catch (IOException | CancellationException exception) {
                try {
                    bl = true;
                    if (onYoutubeDownloadListener != null) {
                        onYoutubeDownloadListener.onError(exception);
                    }
                    throw exception;
                }
                catch (Throwable throwable) {
                    Utils.closeSilently(fileOutputStream);
                    if (bl) {
                        file.delete();
                    }
                    throw throwable;
                }
            }
        }
        Utils.closeSilently(fileOutputStream);
        if (bl) {
            file.delete();
        }
        return file;
    }

    private void downloadStraight(Format format, OutputStream outputStream, OnYoutubeDownloadListener onYoutubeDownloadListener) throws IOException {
        URLConnection uRLConnection = new URL(format.url()).openConnection();
        int n = uRLConnection.getContentLength();
        InputStream inputStream = uRLConnection.getInputStream();
        byte[] byArray = new byte[4096];
        if (onYoutubeDownloadListener == null) {
            YoutubeVideo.copyAndCloseInput(inputStream, outputStream, byArray);
        } else {
            YoutubeVideo.copyAndCloseInput(inputStream, outputStream, byArray, 0L, n, onYoutubeDownloadListener);
        }
    }

    private void downloadByPart(Format format, OutputStream outputStream, OnYoutubeDownloadListener onYoutubeDownloadListener) throws IOException {
        long l = 0L;
        int n = 0;
        String string = "&cver=" + this.clientVersion + "&range=";
        long l2 = format.contentLength();
        byte[] byArray = new byte[4096];
        while (l < l2) {
            long l3 = 0x200000L;
            if (l + l3 > l2) {
                l3 = (int)(l2 - l);
            }
            String string2 = format.url() + string + l + "-" + (l + l3 - 1L) + "&rn=" + ++n;
            URL uRL = new URL(string2);
            InputStream inputStream = uRL.openStream();
            if (onYoutubeDownloadListener == null) {
                l += YoutubeVideo.copyAndCloseInput(inputStream, outputStream, byArray);
                continue;
            }
            l += YoutubeVideo.copyAndCloseInput(inputStream, outputStream, byArray, l, l2, onYoutubeDownloadListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static long copyAndCloseInput(InputStream inputStream, OutputStream outputStream, byte[] byArray, long l, long l2, OnYoutubeDownloadListener onYoutubeDownloadListener) throws IOException {
        long l3 = 0L;
        try {
            long l4;
            int n = 0;
            long l5 = l4 = l == 0L ? 0L : l * 100L / l2;
            while ((n = inputStream.read(byArray)) != -1) {
                if (Thread.interrupted()) {
                    throw new CancellationException("Downloading is canceled");
                }
                outputStream.write(byArray, 0, n);
                long l6 = (l + (l3 += (long)n)) * 100L / l2;
                if (l6 <= l4) continue;
                onYoutubeDownloadListener.onDownloading((int)l6);
                l4 = l6;
            }
        }
        finally {
            Utils.closeSilently(inputStream);
        }
        return l3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static long copyAndCloseInput(InputStream inputStream, OutputStream outputStream, byte[] byArray) throws IOException {
        long l = 0L;
        try {
            int n = 0;
            while ((n = inputStream.read(byArray)) != -1) {
                if (Thread.interrupted()) {
                    throw new CancellationException("Downloading is canceled");
                }
                outputStream.write(byArray, 0, n);
                l += (long)n;
            }
        }
        finally {
            Utils.closeSilently(inputStream);
        }
        return l;
    }
}

