/*
 * Decompiled with CFR 0.152.
 */
package com.github.kiulian.downloader.model;

import com.github.kiulian.downloader.model.formats.Format;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;

public class Utils {
    private static final char[] ILLEGAL_FILENAME_CHARACTERS = new char[]{'/', '\n', '\r', '\t', '\u0000', '\f', '`', '?', '*', '\\', '<', '>', '|', '\"', ':'};

    private static String removeIllegalChars(String string) {
        for (char c : ILLEGAL_FILENAME_CHARACTERS) {
            string = string.replace(c, '_');
        }
        return string;
    }

    static void createOutDir(File file) throws IOException {
        boolean bl;
        if (!file.exists() && !(bl = file.mkdirs())) {
            throw new IOException("Could not create output directory: " + file);
        }
    }

    static File getOutputFile(String string, Format format, File file, boolean bl) {
        String string2 = Utils.removeIllegalChars(string) + "." + format.extension().value();
        File file2 = new File(file, string2);
        if (!bl) {
            int n = 1;
            while (file2.exists()) {
                string2 = Utils.removeIllegalChars(string) + "(" + n++ + ")." + format.extension().value();
                file2 = new File(file, string2);
            }
        }
        return file2;
    }

    public static void closeSilently(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

