/*
 * Decompiled with CFR 0.152.
 */
package com.github.kiulian.downloader.extractor;

import com.github.kiulian.downloader.YoutubeException;
import com.github.kiulian.downloader.extractor.Extractor;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DefaultExtractor
implements Extractor {
    private static final List<Pattern> YT_PLAYER_CONFIG_PATTERNS = Arrays.asList(Pattern.compile(";ytplayer\\.config = (\\{.*?\\})\\;ytplayer"), Pattern.compile(";ytplayer\\.config = (\\{.*?\\})\\;"), Pattern.compile("ytInitialPlayerResponse\\s*=\\s*(\\{.+?\\})\\;var meta"));
    private static final List<Pattern> YT_INITIAL_DATA_PATTERNS = Arrays.asList(Pattern.compile("window\\[\"ytInitialData\"\\] = (\\{.*?\\});"), Pattern.compile("ytInitialData = (\\{.*?\\});"));
    private static final String DEFAULT_USER_AGENT = "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/72.0.3626.121 Safari/537.36";
    private static final String DEFAULT_ACCEPT_LANG = "en-US,en;";
    private static final int DEFAULT_RETRY_ON_FAILURE = 3;
    private Map<String, String> requestProperties = new HashMap<String, String>();
    private int retryOnFailure = 3;

    public DefaultExtractor() {
        this.setRequestProperty("User-Agent", DEFAULT_USER_AGENT);
        this.setRequestProperty("Accept-language", DEFAULT_ACCEPT_LANG);
    }

    @Override
    public void setRequestProperty(String string, String string2) {
        this.requestProperties.put(string, string2);
    }

    @Override
    public void setRetryOnFailure(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("retry count should be > 0");
        }
        this.retryOnFailure = n;
    }

    @Override
    public String extractYtPlayerConfig(String string) throws YoutubeException {
        for (Pattern pattern : YT_PLAYER_CONFIG_PATTERNS) {
            Matcher matcher = pattern.matcher(string);
            if (!matcher.find()) continue;
            return matcher.group(1);
        }
        throw new YoutubeException.BadPageException("Could not parse web page");
    }

    @Override
    public String extractYtInitialData(String string) throws YoutubeException {
        for (Pattern pattern : YT_INITIAL_DATA_PATTERNS) {
            Matcher matcher = pattern.matcher(string);
            if (!matcher.find()) continue;
            return matcher.group(1);
        }
        throw new YoutubeException.BadPageException("Could not parse web page");
    }

    @Override
    public String loadUrl(String string) throws YoutubeException {
        int n = this.retryOnFailure;
        String string2 = "";
        while (n-- >= 0) {
            try {
                String string3;
                HttpURLConnection httpURLConnection = (HttpURLConnection)new URL(string).openConnection();
                for (Map.Entry<String, String> object2 : this.requestProperties.entrySet()) {
                    httpURLConnection.setRequestProperty(object2.getKey(), object2.getValue());
                }
                int n2 = httpURLConnection.getResponseCode();
                if (n2 != 200) {
                    string2 = String.format("Could not load url: %s, response code: %d", string, n2);
                    continue;
                }
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(httpURLConnection.getInputStream(), "UTF-8"));
                StringBuilder stringBuilder = new StringBuilder();
                while ((string3 = bufferedReader.readLine()) != null) {
                    stringBuilder.append(string3).append('\n');
                }
                bufferedReader.close();
                return stringBuilder.toString();
            }
            catch (IOException iOException) {
                string2 = String.format("Could not load url: %s, exception: %s", string, iOException.getMessage());
            }
        }
        throw new YoutubeException.VideoUnavailableException(string2);
    }
}

