/*
 * Decompiled with CFR 0.152.
 */
package org.fourthline.cling.model.message.header;

import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.fourthline.cling.model.message.header.InvalidHeaderException;
import org.fourthline.cling.model.message.header.UpnpHeader;

public class MaxAgeHeader
extends UpnpHeader<Integer> {
    public static final Pattern MAX_AGE_REGEX = Pattern.compile(".*max-age\\s*=\\s*([0-9]+).*");

    public MaxAgeHeader(Integer maxAge) {
        this.setValue(maxAge);
    }

    public MaxAgeHeader() {
        this.setValue(1800);
    }

    @Override
    public void setString(String s) throws InvalidHeaderException {
        Matcher matcher = MAX_AGE_REGEX.matcher(s.toLowerCase(Locale.ROOT));
        if (!matcher.matches()) {
            throw new InvalidHeaderException("Invalid cache-control value, can't parse max-age seconds: " + s);
        }
        Integer maxAge = Integer.parseInt(matcher.group(1));
        this.setValue(maxAge);
    }

    @Override
    public String getString() {
        return "max-age=" + ((Integer)this.getValue()).toString();
    }
}

