/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.tvshows.filters;

import java.util.List;
import java.util.ResourceBundle;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import org.tinymediamanager.core.tvshow.entities.TvShow;
import org.tinymediamanager.core.tvshow.entities.TvShowEpisode;
import org.tinymediamanager.ui.components.TmmLabel;
import org.tinymediamanager.ui.tvshows.filters.AbstractTvShowUIFilter;

public class TvShowWatchedFilter
extends AbstractTvShowUIFilter {
    private JComboBox<WatchedFlag> comboBox;

    @Override
    public String getId() {
        return "tvShowWatched";
    }

    @Override
    public String getFilterValueAsString() {
        try {
            return ((WatchedFlag)((Object)this.comboBox.getSelectedItem())).name();
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public void setFilterValue(Object value) {
        WatchedFlag watchedFlag;
        if (value == null) {
            return;
        }
        if (value instanceof WatchedFlag) {
            this.comboBox.setSelectedItem(value);
        } else if (value instanceof String && (watchedFlag = WatchedFlag.valueOf((String)value)) != null) {
            this.comboBox.setSelectedItem((Object)watchedFlag);
        }
    }

    @Override
    protected JLabel createLabel() {
        return new TmmLabel(BUNDLE.getString("metatag.watched"));
    }

    @Override
    protected JComponent createFilterComponent() {
        this.comboBox = new JComboBox<WatchedFlag>(WatchedFlag.values());
        return this.comboBox;
    }

    @Override
    protected boolean accept(TvShow tvShow, List<TvShowEpisode> episodes, boolean invert) {
        for (TvShowEpisode episode : episodes) {
            if (episode.isDummy() || !(invert ^ episode.isWatched() == (this.comboBox.getSelectedItem() == WatchedFlag.WATCHED))) continue;
            return true;
        }
        return false;
    }

    static /* synthetic */ ResourceBundle access$000() {
        return BUNDLE;
    }

    static /* synthetic */ ResourceBundle access$100() {
        return BUNDLE;
    }

    private static enum WatchedFlag {
        WATCHED(TvShowWatchedFilter.access$000().getString("metatag.watched")),
        NOT_WATCHED(TvShowWatchedFilter.access$100().getString("metatag.notwatched"));

        private String title;

        private WatchedFlag(String title) {
            this.title = title;
        }

        public String toString() {
            return this.title;
        }
    }
}

