/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.tvshows.filters;

import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.JLabel;
import org.tinymediamanager.core.MediaFileType;
import org.tinymediamanager.core.entities.MediaFile;
import org.tinymediamanager.core.tvshow.TvShowList;
import org.tinymediamanager.core.tvshow.entities.TvShow;
import org.tinymediamanager.core.tvshow.entities.TvShowEpisode;
import org.tinymediamanager.ui.components.TmmLabel;
import org.tinymediamanager.ui.tvshows.filters.AbstractCheckComboBoxTvShowUIFilter;

public class TvShowVideoContainerFilter
extends AbstractCheckComboBoxTvShowUIFilter<String> {
    private TvShowList tvShowList = TvShowList.getInstance();

    public TvShowVideoContainerFilter() {
        this.buildAndInstallContainerArray();
        PropertyChangeListener propertyChangeListener = evt -> this.buildAndInstallContainerArray();
        this.tvShowList.addPropertyChangeListener("videoContainer", propertyChangeListener);
    }

    @Override
    public String getId() {
        return "tvShowVideoContainer";
    }

    @Override
    protected boolean accept(TvShow tvShow, List<TvShowEpisode> episodes, boolean invert) {
        List selectedValues = this.checkComboBox.getSelectedItems();
        for (TvShowEpisode episode : episodes) {
            List<MediaFile> mfs = episode.getMediaFiles(MediaFileType.VIDEO);
            for (MediaFile mf : mfs) {
                if (!(invert ^ selectedValues.contains(mf.getContainerFormat()))) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    protected JLabel createLabel() {
        return new TmmLabel(BUNDLE.getString("metatag.container"));
    }

    private void buildAndInstallContainerArray() {
        ArrayList<String> containers = new ArrayList<String>(this.tvShowList.getVideoContainersInEpisodes());
        Collections.sort(containers);
        this.setValues(containers);
    }

    @Override
    protected String parseTypeToString(String type) throws Exception {
        return type;
    }

    @Override
    protected String parseStringToType(String string) throws Exception {
        return string;
    }
}

