/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.tvshows.filters;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.swing.JLabel;
import org.tinymediamanager.core.MediaAiredStatus;
import org.tinymediamanager.core.tvshow.entities.TvShow;
import org.tinymediamanager.core.tvshow.entities.TvShowEpisode;
import org.tinymediamanager.ui.components.TmmLabel;
import org.tinymediamanager.ui.tvshows.filters.AbstractCheckComboBoxTvShowUIFilter;

public class TvShowStatusFilter
extends AbstractCheckComboBoxTvShowUIFilter<MediaAiredStatus> {
    public TvShowStatusFilter() {
        this.buildAndInstallCertificationArray();
    }

    @Override
    public String getId() {
        return "tvShowStatus";
    }

    @Override
    protected boolean accept(TvShow tvShow, List<TvShowEpisode> episodes, boolean invert) {
        List airedStatuses = this.checkComboBox.getSelectedItems();
        return invert ^ airedStatuses.contains((Object)tvShow.getStatus());
    }

    @Override
    protected JLabel createLabel() {
        return new TmmLabel(BUNDLE.getString("metatag.status"));
    }

    private void buildAndInstallCertificationArray() {
        List<MediaAiredStatus> airedStatuses = Arrays.asList(MediaAiredStatus.values());
        Collections.sort(airedStatuses);
        this.setValues(airedStatuses);
    }

    @Override
    protected String parseTypeToString(MediaAiredStatus type) throws Exception {
        return type.name();
    }

    @Override
    protected MediaAiredStatus parseStringToType(String string) throws Exception {
        return MediaAiredStatus.valueOf(string);
    }
}

