/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.tvshows.filters;

import java.util.List;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import org.tinymediamanager.core.MediaSource;
import org.tinymediamanager.core.tvshow.entities.TvShow;
import org.tinymediamanager.core.tvshow.entities.TvShowEpisode;
import org.tinymediamanager.ui.components.TmmLabel;
import org.tinymediamanager.ui.tvshows.filters.AbstractCheckComboBoxTvShowUIFilter;

public class TvShowMediaSourceFilter
extends AbstractCheckComboBoxTvShowUIFilter<MediaSource> {
    public TvShowMediaSourceFilter() {
        this.buildAndInstallMediaSources();
        MediaSource.addListener(evt -> SwingUtilities.invokeLater(this::buildAndInstallMediaSources));
    }

    @Override
    public String getId() {
        return "tvShowMediaSource";
    }

    @Override
    public boolean accept(TvShow tvShow, List<TvShowEpisode> episodes, boolean invert) {
        List selectedItems = this.checkComboBox.getSelectedItems();
        for (TvShowEpisode episode : episodes) {
            if (!(invert ^ selectedItems.contains(episode.getMediaSource()))) continue;
            return true;
        }
        return false;
    }

    @Override
    protected JLabel createLabel() {
        return new TmmLabel(BUNDLE.getString("metatag.source"));
    }

    private void buildAndInstallMediaSources() {
        this.setValues(MediaSource.values());
    }

    @Override
    protected String parseTypeToString(MediaSource type) throws Exception {
        return type.name();
    }

    @Override
    protected MediaSource parseStringToType(String string) throws Exception {
        return MediaSource.getMediaSource(string);
    }
}

