/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.tvshows.filters;

import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTextField;
import org.apache.commons.lang3.StringUtils;
import org.tinymediamanager.core.entities.Person;
import org.tinymediamanager.core.tvshow.entities.TvShow;
import org.tinymediamanager.core.tvshow.entities.TvShowEpisode;
import org.tinymediamanager.scraper.util.StrgUtils;
import org.tinymediamanager.ui.components.TmmLabel;
import org.tinymediamanager.ui.tvshows.filters.AbstractTvShowUIFilter;

public class TvShowCastFilter
extends AbstractTvShowUIFilter {
    private JTextField textField;

    @Override
    public String getId() {
        return "tvShowCast";
    }

    @Override
    public String getFilterValueAsString() {
        return this.textField.getText();
    }

    @Override
    public void setFilterValue(Object value) {
        if (value instanceof String) {
            this.textField.setText((String)value);
        }
    }

    @Override
    protected boolean accept(TvShow tvShow, List<TvShowEpisode> episodes, boolean invert) {
        String filterText = StrgUtils.normalizeString(this.textField.getText());
        if (StringUtils.isBlank((CharSequence)filterText)) {
            return true;
        }
        try {
            Pattern pattern = Pattern.compile(filterText, 2);
            boolean foundShow = false;
            for (Person actor : tvShow.getActors()) {
                Matcher matcher = pattern.matcher(StrgUtils.normalizeString(actor.getName()));
                if (!matcher.find()) continue;
                foundShow = true;
            }
            if (!invert && foundShow) {
                return true;
            }
            if (invert && foundShow) {
                return false;
            }
            for (TvShowEpisode episode : episodes) {
                Matcher matcher;
                boolean foundGuest = false;
                boolean foundWriter = false;
                boolean foundDirector = false;
                for (Person director : episode.getDirectors()) {
                    if (!StringUtils.isNotBlank((CharSequence)director.getName()) || !(matcher = pattern.matcher(StrgUtils.normalizeString(director.getName()))).find()) continue;
                    foundDirector = true;
                    break;
                }
                for (Person writer : episode.getWriters()) {
                    if (!StringUtils.isNotBlank((CharSequence)writer.getName()) || !(matcher = pattern.matcher(StrgUtils.normalizeString(writer.getName()))).find()) continue;
                    foundWriter = true;
                    break;
                }
                for (Person actor : episode.getGuests()) {
                    if (!StringUtils.isNotBlank((CharSequence)actor.getName()) || !(matcher = pattern.matcher(StrgUtils.normalizeString(actor.getName()))).find()) continue;
                    foundGuest = true;
                    break;
                }
                if (invert && !foundDirector && !foundWriter && !foundGuest) {
                    return true;
                }
                if (invert || !foundDirector && !foundWriter && !foundGuest) continue;
                return true;
            }
        }
        catch (Exception e) {
            return true;
        }
        return false;
    }

    @Override
    protected JLabel createLabel() {
        return new TmmLabel(BUNDLE.getString("movieextendedsearch.cast"));
    }

    @Override
    protected JComponent createFilterComponent() {
        this.textField = new JTextField();
        return this.textField;
    }
}

