/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.tvshows.dialogs;

import ca.odell.glazedlists.BasicEventList;
import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.GlazedLists;
import ca.odell.glazedlists.ObservableElementList;
import ca.odell.glazedlists.gui.WritableTableFormat;
import ca.odell.glazedlists.swing.AutoCompleteSupport;
import ca.odell.glazedlists.swing.GlazedListsSwing;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLayer;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SpinnerDateModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.table.TableModel;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang3.StringUtils;
import org.jdesktop.beansbinding.AutoBinding;
import org.jdesktop.beansbinding.BeanProperty;
import org.jdesktop.beansbinding.Binding;
import org.jdesktop.beansbinding.BindingGroup;
import org.jdesktop.beansbinding.Property;
import org.jdesktop.observablecollections.ObservableCollections;
import org.jdesktop.swingbinding.JListBinding;
import org.jdesktop.swingbinding.JTableBinding;
import org.jdesktop.swingbinding.SwingBindings;
import org.tinymediamanager.core.AbstractModelObject;
import org.tinymediamanager.core.MediaAiredStatus;
import org.tinymediamanager.core.MediaCertification;
import org.tinymediamanager.core.MediaFileType;
import org.tinymediamanager.core.entities.MediaFile;
import org.tinymediamanager.core.entities.MediaGenres;
import org.tinymediamanager.core.entities.MediaRating;
import org.tinymediamanager.core.entities.MediaTrailer;
import org.tinymediamanager.core.entities.Person;
import org.tinymediamanager.core.threading.TmmTaskManager;
import org.tinymediamanager.core.tvshow.TvShowList;
import org.tinymediamanager.core.tvshow.TvShowModuleManager;
import org.tinymediamanager.core.tvshow.entities.TvShow;
import org.tinymediamanager.core.tvshow.entities.TvShowEpisode;
import org.tinymediamanager.scraper.ScraperType;
import org.tinymediamanager.scraper.entities.MediaType;
import org.tinymediamanager.thirdparty.trakttv.SyncTraktTvTask;
import org.tinymediamanager.ui.IconManager;
import org.tinymediamanager.ui.MainWindow;
import org.tinymediamanager.ui.ShadowLayerUI;
import org.tinymediamanager.ui.TableColumnResizer;
import org.tinymediamanager.ui.TableSpinnerEditor;
import org.tinymediamanager.ui.TmmUIHelper;
import org.tinymediamanager.ui.UIConstants;
import org.tinymediamanager.ui.components.FlatButton;
import org.tinymediamanager.ui.components.ImageLabel;
import org.tinymediamanager.ui.components.LinkLabel;
import org.tinymediamanager.ui.components.MainTabbedPane;
import org.tinymediamanager.ui.components.MediaIdTable;
import org.tinymediamanager.ui.components.MediaRatingTable;
import org.tinymediamanager.ui.components.PersonTable;
import org.tinymediamanager.ui.components.TmmLabel;
import org.tinymediamanager.ui.components.combobox.AutocompleteComboBox;
import org.tinymediamanager.ui.components.datepicker.DatePicker;
import org.tinymediamanager.ui.components.datepicker.YearSpinner;
import org.tinymediamanager.ui.components.table.TmmTable;
import org.tinymediamanager.ui.components.table.TmmTableFormat;
import org.tinymediamanager.ui.components.table.TmmTableModel;
import org.tinymediamanager.ui.dialogs.IdEditorDialog;
import org.tinymediamanager.ui.dialogs.ImageChooserDialog;
import org.tinymediamanager.ui.dialogs.PersonEditorDialog;
import org.tinymediamanager.ui.dialogs.RatingEditorDialog;
import org.tinymediamanager.ui.dialogs.TmmDialog;
import org.tinymediamanager.ui.renderer.LeftDotTableCellRenderer;

public class TvShowEditorDialog
extends TmmDialog {
    private static final long serialVersionUID = 3270218410302989845L;
    private static final Insets BUTTON_MARGIN = UIConstants.SMALL_BUTTON_MARGIN;
    private static final String ORIGINAL_IMAGE_SIZE = "originalImageSize";
    private static final String SPACER = "        ";
    private TvShow tvShowToEdit;
    private TvShowList tvShowList = TvShowList.getInstance();
    private EventList<Person> actors;
    private List<MediaGenres> genres = ObservableCollections.observableList(new ArrayList());
    private EventList<MediaIdTable.MediaId> ids;
    private EventList<MediaRatingTable.MediaRating> mediaRatings;
    private List<String> tags = ObservableCollections.observableList(new ArrayList());
    private EventList<EpisodeEditorContainer> episodes;
    private List<String> extrafanarts = null;
    private List<MediaTrailer> trailers = ObservableCollections.observableList(new ArrayList());
    private MediaRating userMediaRating;
    private boolean continueQueue = true;
    private boolean navigateBack = false;
    private int queueIndex;
    private int queueSize;
    private JTextField tfTitle;
    private YearSpinner spYear;
    private JTextArea taPlot;
    private TmmTable tableActors;
    private ImageLabel lblPoster;
    private ImageLabel lblFanart;
    private ImageLabel lblBanner;
    private JSpinner spRuntime;
    private JTextField tfStudio;
    private JList<MediaGenres> listGenres;
    private AutocompleteComboBox<MediaGenres> cbGenres;
    private AutoCompleteSupport<MediaGenres> cbGenresAutoCompleteSupport;
    private JSpinner spRating;
    private JComboBox<MediaCertification> cbCertification;
    private JComboBox<MediaAiredStatus> cbStatus;
    private AutocompleteComboBox<String> cbTags;
    private AutoCompleteSupport<String> cbTagsAutoCompleteSupport;
    private JList<String> listTags;
    private JSpinner spDateAdded;
    private DatePicker dpPremiered;
    private TmmTable tableEpisodes;
    private JTextField tfSorttitle;
    private JTextField tfNote;
    private JTextField tfPoster;
    private JTextField tfFanart;
    private JTextField tfLogo;
    private JTextField tfClearLogo;
    private JTextField tfBanner;
    private JTextField tfClearArt;
    private JTextField tfThumb;
    private ImageLabel lblLogo;
    private ImageLabel lblClearlogo;
    private ImageLabel lblClearart;
    private ImageLabel lblThumb;
    private ImageLabel lblCharacterart;
    private ImageLabel lblKeyart;
    private TmmTable tableIds;
    private TmmTable tableRatings;
    private JTextField tfOriginalTitle;
    private JTextField tfCountry;
    private JTextField tfCharacterart;
    private JTextField tfKeyart;
    private TmmTable tableTrailer;

    public TvShowEditorDialog(TvShow tvShow, int queueIndex, int queueSize) {
        super(BUNDLE.getString("tvshow.edit") + (queueSize > 1 ? " " + (queueIndex + 1) + "/" + queueSize : "") + "  < " + tvShow.getPathNIO() + " >", "tvShowEditor");
        List<MediaCertification> availableCertifications;
        this.tvShowToEdit = tvShow;
        this.queueIndex = queueIndex;
        this.queueSize = queueSize;
        this.ids = MediaIdTable.convertIdMapToEventList(this.tvShowToEdit.getIds());
        this.mediaRatings = MediaRatingTable.convertRatingMapToEventList(this.tvShowToEdit.getRatings(), false);
        this.userMediaRating = this.tvShowToEdit.getRating("user");
        this.actors = new ObservableElementList((EventList)GlazedLists.threadSafeList((EventList)new BasicEventList()), GlazedLists.beanConnector(Person.class));
        this.episodes = new ObservableElementList((EventList)GlazedLists.threadSafeList((EventList)new BasicEventList()), GlazedLists.beanConnector(EpisodeEditorContainer.class));
        this.initComponents();
        this.bindingGroup = this.initDataBindings();
        this.tfTitle.setText(tvShow.getTitle());
        this.tfOriginalTitle.setText(tvShow.getOriginalTitle());
        this.tfSorttitle.setText(tvShow.getSortTitle());
        this.taPlot.setText(tvShow.getPlot());
        this.lblPoster.setImagePath(tvShow.getArtworkFilename(MediaFileType.POSTER));
        this.lblFanart.setImagePath(tvShow.getArtworkFilename(MediaFileType.FANART));
        this.lblLogo.setImagePath(tvShow.getArtworkFilename(MediaFileType.LOGO));
        this.lblClearlogo.setImagePath(tvShow.getArtworkFilename(MediaFileType.CLEARLOGO));
        this.lblClearart.setImagePath(tvShow.getArtworkFilename(MediaFileType.CLEARART));
        this.lblThumb.setImagePath(tvShow.getArtworkFilename(MediaFileType.THUMB));
        this.lblBanner.setImagePath(tvShow.getArtworkFilename(MediaFileType.BANNER));
        this.lblCharacterart.setImagePath(tvShow.getArtworkFilename(MediaFileType.CHARACTERART));
        this.lblKeyart.setImagePath(tvShow.getArtworkFilename(MediaFileType.KEYART));
        this.tfPoster.setText(tvShow.getArtworkUrl(MediaFileType.POSTER));
        this.tfFanart.setText(tvShow.getArtworkUrl(MediaFileType.FANART));
        this.tfLogo.setText(tvShow.getArtworkUrl(MediaFileType.LOGO));
        this.tfClearLogo.setText(tvShow.getArtworkUrl(MediaFileType.CLEARLOGO));
        this.tfClearArt.setText(tvShow.getArtworkUrl(MediaFileType.CLEARART));
        this.tfThumb.setText(tvShow.getArtworkUrl(MediaFileType.THUMB));
        this.tfBanner.setText(tvShow.getArtworkUrl(MediaFileType.BANNER));
        this.tfCharacterart.setText(tvShow.getArtworkUrl(MediaFileType.CHARACTERART));
        this.tfKeyart.setText(tvShow.getArtworkUrl(MediaFileType.KEYART));
        this.tfStudio.setText(tvShow.getProductionCompany());
        this.tfCountry.setText(tvShow.getCountry());
        this.tfNote.setText(tvShow.getNote());
        this.cbStatus.setSelectedItem((Object)tvShow.getStatus());
        this.spRuntime.setValue(tvShow.getRuntime());
        int year = tvShow.getYear();
        this.spYear.setValue(year);
        this.spDateAdded.setValue(tvShow.getDateAdded());
        this.spRating.setModel(new SpinnerNumberModel(this.userMediaRating.getRating(), 0.0, 10.0, 0.1));
        for (Person person : tvShow.getActors()) {
            this.actors.add((Object)new Person(person));
        }
        this.genres.addAll(tvShow.getGenres());
        this.tags.addAll(this.tvShowToEdit.getTags());
        if (TvShowModuleManager.SETTINGS.isImageExtraFanart()) {
            this.extrafanarts = new ArrayList<String>(this.tvShowToEdit.getExtraFanartUrls());
        }
        if (!(availableCertifications = MediaCertification.getCertificationsforCountry(TvShowModuleManager.SETTINGS.getCertificationCountry())).contains((Object)this.tvShowToEdit.getCertification())) {
            availableCertifications.add(0, this.tvShowToEdit.getCertification());
        }
        for (MediaCertification cert : availableCertifications) {
            this.cbCertification.addItem(cert);
        }
        this.cbCertification.setSelectedItem((Object)this.tvShowToEdit.getCertification());
        ArrayList<TvShowEpisode> arrayList = new ArrayList<TvShowEpisode>(this.tvShowToEdit.getEpisodes());
        arrayList.sort(Comparator.comparing(s -> s.getMediaFiles(MediaFileType.VIDEO).get(0).getFile()));
        for (TvShowEpisode episode : arrayList) {
            EpisodeEditorContainer container = new EpisodeEditorContainer();
            container.tvShowEpisode = episode;
            container.dvdOrder = episode.isDvdOrder();
            container.season = episode.getSeason();
            container.episode = episode.getEpisode();
            this.episodes.add((Object)container);
        }
        this.trailers.addAll(tvShow.getTrailer());
        this.tableEpisodes.getColumnModel().getColumn(1).setCellRenderer(new LeftDotTableCellRenderer());
        this.tableEpisodes.getColumnModel().getColumn(2).setCellEditor(new TableSpinnerEditor());
        this.tableEpisodes.getColumnModel().getColumn(3).setCellEditor(new TableSpinnerEditor());
        TableColumnResizer.adjustColumnPreferredWidths(this.tableActors, 6);
        TableColumnResizer.adjustColumnPreferredWidths(this.tableEpisodes, 6);
        this.tableTrailer.getColumnModel().getColumn(0).setHeaderValue(BUNDLE.getString("metatag.nfo"));
        this.tableTrailer.getColumnModel().getColumn(1).setHeaderValue(BUNDLE.getString("metatag.name"));
        this.tableTrailer.getColumnModel().getColumn(2).setHeaderValue(BUNDLE.getString("metatag.source"));
        this.tableTrailer.getColumnModel().getColumn(3).setHeaderValue(BUNDLE.getString("metatag.quality"));
        this.tableTrailer.getColumnModel().getColumn(4).setHeaderValue(BUNDLE.getString("metatag.url"));
        this.tableTrailer.getColumnModel().getColumn(0).setMaxWidth(55);
        this.tableTrailer.adjustColumnPreferredWidths(5);
        this.tableTrailer.getModel().addTableModelListener(arg0 -> {
            int row;
            MediaTrailer changedTrailer;
            if (arg0.getColumn() == 0 && (changedTrailer = this.trailers.get(row = arg0.getFirstRow())).getInNfo().booleanValue()) {
                for (MediaTrailer trailer : this.trailers) {
                    if (trailer == changedTrailer) continue;
                    trailer.setInNfo(Boolean.FALSE);
                }
            }
        });
    }

    private void initComponents() {
        MainTabbedPane tabbedPane = new MainTabbedPane(){
            private static final long serialVersionUID = 71548865608767532L;

            @Override
            public void updateUI() {
                this.putClientProperty("bottomBorder", Boolean.FALSE);
                super.updateUI();
            }
        };
        JLayer<JComponent> rootLayer = new JLayer<JComponent>(tabbedPane, new ShadowLayerUI());
        this.getContentPane().add(rootLayer, "Center");
        JPanel details1Panel = new JPanel();
        tabbedPane.addTab(BUNDLE.getString("metatag.details"), details1Panel);
        details1Panel.setLayout((LayoutManager)new MigLayout("", "[][grow][50lp:75lp][][60lp:75lp][100lp:n][][25lp:n][200lp:250lp,grow]", "[][][][100lp:175lp][][][][][][][75lp:100lp][]"));
        TmmLabel lblTitle = new TmmLabel(BUNDLE.getString("metatag.title"));
        details1Panel.add((Component)lblTitle, "cell 0 0,alignx right");
        this.tfTitle = new JTextField();
        details1Panel.add((Component)this.tfTitle, "cell 1 0 6 1,growx");
        this.lblPoster = new ImageLabel();
        this.lblPoster.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                ImageChooserDialog dialog = new ImageChooserDialog(TvShowEditorDialog.this, new HashMap<String, Object>(TvShowEditorDialog.this.tvShowToEdit.getIds()), ImageChooserDialog.ImageType.POSTER, TvShowEditorDialog.this.tvShowList.getAvailableArtworkScrapers(), TvShowEditorDialog.this.lblPoster, null, null, MediaType.TV_SHOW);
                dialog.setLocationRelativeTo(MainWindow.getActiveInstance());
                dialog.setVisible(true);
                TvShowEditorDialog.this.updateArtworkUrl(TvShowEditorDialog.this.lblPoster, TvShowEditorDialog.this.tfPoster);
            }
        });
        this.lblPoster.setCursor(Cursor.getPredefinedCursor(12));
        details1Panel.add((Component)new TmmLabel(BUNDLE.getString("mediafiletype.poster")), "cell 8 0");
        LinkLabel lblPosterSize = new LinkLabel();
        details1Panel.add((Component)lblPosterSize, "cell 8 0");
        FlatButton btnDeletePoster = new FlatButton(SPACER, IconManager.DELETE_GRAY);
        btnDeletePoster.setToolTipText(BUNDLE.getString("Button.deleteartwork.desc"));
        btnDeletePoster.addActionListener(e -> {
            this.lblPoster.clearImage();
            this.tfPoster.setText("");
        });
        details1Panel.add((Component)btnDeletePoster, "cell 8 0");
        details1Panel.add((Component)this.lblPoster, "cell 8 1 1 6, grow");
        this.lblPoster.addPropertyChangeListener(ORIGINAL_IMAGE_SIZE, e -> this.setImageSizeAndCreateLink(lblPosterSize, this.lblPoster, MediaFileType.POSTER));
        TmmLabel lblOriginalTitleT = new TmmLabel(BUNDLE.getString("metatag.originaltitle"));
        details1Panel.add((Component)lblOriginalTitleT, "cell 0 1,alignx right");
        this.tfOriginalTitle = new JTextField();
        details1Panel.add((Component)this.tfOriginalTitle, "cell 1 1 6 1,growx");
        TmmLabel lblSortTitle = new TmmLabel(BUNDLE.getString("metatag.sorttitle"));
        details1Panel.add((Component)lblSortTitle, "cell 0 2,alignx right");
        this.tfSorttitle = new JTextField();
        details1Panel.add((Component)this.tfSorttitle, "cell 1 2 6 1,growx");
        TmmLabel lblPlot = new TmmLabel(BUNDLE.getString("metatag.plot"));
        details1Panel.add((Component)lblPlot, "cell 0 3,alignx right,aligny top");
        JScrollPane scrollPanePlot = new JScrollPane();
        details1Panel.add((Component)scrollPanePlot, "cell 1 3 6 1,grow");
        this.taPlot = new JTextArea();
        this.taPlot.setLineWrap(true);
        this.taPlot.setWrapStyleWord(true);
        this.taPlot.setForeground(UIManager.getColor("TextField.foreground"));
        scrollPanePlot.setViewportView(this.taPlot);
        TmmLabel lblYear = new TmmLabel(BUNDLE.getString("metatag.year"));
        details1Panel.add((Component)lblYear, "cell 0 4,alignx right");
        this.spYear = new YearSpinner();
        details1Panel.add((Component)this.spYear, "cell 1 4,growx");
        TmmLabel lblpremiered = new TmmLabel(BUNDLE.getString("metatag.premiered"));
        details1Panel.add((Component)lblpremiered, "cell 3 4,alignx right");
        this.dpPremiered = new DatePicker(this.tvShowToEdit.getFirstAired());
        details1Panel.add((Component)this.dpPremiered, "cell 4 4 2 1,growx");
        TmmLabel lblStudio = new TmmLabel(BUNDLE.getString("metatag.studio"));
        details1Panel.add((Component)lblStudio, "cell 0 5,alignx right");
        this.tfStudio = new JTextField();
        details1Panel.add((Component)this.tfStudio, "cell 1 5 6 1,growx");
        TmmLabel lblCountryT = new TmmLabel(BUNDLE.getString("metatag.country"));
        details1Panel.add((Component)lblCountryT, "cell 0 6,alignx trailing");
        this.tfCountry = new JTextField();
        details1Panel.add((Component)this.tfCountry, "cell 1 6 6 1,growx");
        TmmLabel lblRuntime = new TmmLabel(BUNDLE.getString("metatag.runtime"));
        details1Panel.add((Component)lblRuntime, "cell 0 7,alignx right");
        this.spRuntime = new JSpinner();
        details1Panel.add((Component)this.spRuntime, "flowx,cell 1 7,growx");
        TmmLabel lblMin = new TmmLabel(BUNDLE.getString("metatag.minutes"));
        details1Panel.add((Component)lblMin, "cell 1 7");
        TmmLabel lblStatus = new TmmLabel(BUNDLE.getString("metatag.status"));
        details1Panel.add((Component)lblStatus, "cell 3 7,alignx right");
        this.cbStatus = new JComboBox<MediaAiredStatus>(MediaAiredStatus.values());
        details1Panel.add(this.cbStatus, "cell 4 7,growx");
        TmmLabel lblCertification = new TmmLabel(BUNDLE.getString("metatag.certification"));
        details1Panel.add((Component)lblCertification, "cell 0 8,alignx right");
        this.cbCertification = new JComboBox();
        details1Panel.add(this.cbCertification, "cell 1 8,growx");
        TmmLabel lblRating = new TmmLabel(BUNDLE.getString("metatag.userrating"));
        details1Panel.add((Component)lblRating, "cell 0 9,alignx right");
        this.spRating = new JSpinner();
        details1Panel.add((Component)this.spRating, "cell 1 9,growx");
        TmmLabel lblRatingsT = new TmmLabel(BUNDLE.getString("metatag.ratings"));
        details1Panel.add((Component)lblRatingsT, "flowy,cell 0 10,alignx right,aligny top");
        JScrollPane scrollPaneRatings = new JScrollPane();
        details1Panel.add((Component)scrollPaneRatings, "cell 1 10 4 1,growx");
        this.tableRatings = new MediaRatingTable(this.mediaRatings);
        this.tableRatings.configureScrollPane(scrollPaneRatings);
        scrollPaneRatings.setViewportView(this.tableRatings);
        this.lblFanart = new ImageLabel();
        this.lblFanart.setCursor(Cursor.getPredefinedCursor(12));
        this.lblFanart.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                ImageChooserDialog dialog = new ImageChooserDialog(TvShowEditorDialog.this, new HashMap<String, Object>(TvShowEditorDialog.this.tvShowToEdit.getIds()), ImageChooserDialog.ImageType.FANART, TvShowEditorDialog.this.tvShowList.getAvailableArtworkScrapers(), TvShowEditorDialog.this.lblFanart, null, TvShowEditorDialog.this.extrafanarts, MediaType.TV_SHOW);
                dialog.setLocationRelativeTo(MainWindow.getActiveInstance());
                dialog.setVisible(true);
                TvShowEditorDialog.this.updateArtworkUrl(TvShowEditorDialog.this.lblFanart, TvShowEditorDialog.this.tfFanart);
            }
        });
        details1Panel.add((Component)new TmmLabel(BUNDLE.getString("mediafiletype.fanart")), "cell 8 8");
        LinkLabel lblFanartSize = new LinkLabel();
        details1Panel.add((Component)lblFanartSize, "cell 8 8");
        FlatButton btnDeleteFanart = new FlatButton(SPACER, IconManager.DELETE_GRAY);
        btnDeleteFanart.setToolTipText(BUNDLE.getString("Button.deleteartwork.desc"));
        btnDeleteFanart.addActionListener(e -> {
            this.lblFanart.clearImage();
            this.tfFanart.setText("");
        });
        details1Panel.add((Component)btnDeleteFanart, "cell 8 8");
        details1Panel.add((Component)this.lblFanart, "cell 8 9 1 4,grow");
        this.lblFanart.addPropertyChangeListener(ORIGINAL_IMAGE_SIZE, e -> this.setImageSizeAndCreateLink(lblFanartSize, this.lblFanart, MediaFileType.FANART));
        JButton btnAddRating = new JButton(new AddRatingAction());
        btnAddRating.setMargin(BUTTON_MARGIN);
        details1Panel.add((Component)btnAddRating, "cell 0 10,alignx right,aligny top");
        JButton btnRemoveRating = new JButton(new RemoveRatingAction());
        btnRemoveRating.setMargin(BUTTON_MARGIN);
        details1Panel.add((Component)btnRemoveRating, "cell 0 10,alignx right,aligny top");
        TmmLabel lblNoteT = new TmmLabel(BUNDLE.getString("metatag.note"));
        details1Panel.add((Component)lblNoteT, "cell 0 11,alignx trailing");
        this.tfNote = new JTextField();
        details1Panel.add((Component)this.tfNote, "cell 1 11 6 1,growx");
        JPanel details2Panel = new JPanel();
        tabbedPane.addTab(BUNDLE.getString("metatag.details2"), details2Panel);
        details2Panel.setLayout((LayoutManager)new MigLayout("", "[][150lp:400lp,grow][20lp:n][][150lp:300lp,grow]", "[][:150lp:200lp,grow][20lp:n][100lp:150lp,grow][][100lp,grow 200]"));
        TmmLabel lblActors = new TmmLabel(BUNDLE.getString("metatag.actors"));
        details2Panel.add((Component)lblActors, "flowy,cell 0 0 1 2,alignx right,aligny top");
        JScrollPane scrollPaneActors = new JScrollPane();
        details2Panel.add((Component)scrollPaneActors, "cell 1 0 1 2,grow");
        this.tableActors = new PersonTable(this.actors, true);
        this.tableActors.configureScrollPane(scrollPaneActors);
        JButton btnAddActor = new JButton(new AddActorAction());
        btnAddActor.setMargin(BUTTON_MARGIN);
        details2Panel.add((Component)btnAddActor, "cell 0 0,alignx right");
        JButton btnRemoveActor = new JButton(new RemoveActorAction());
        btnRemoveActor.setMargin(BUTTON_MARGIN);
        details2Panel.add((Component)btnRemoveActor, "cell 0 0,alignx right,aligny top");
        JButton btnMoveActorUp = new JButton(new MoveActorUpAction());
        btnMoveActorUp.setMargin(BUTTON_MARGIN);
        details2Panel.add((Component)btnMoveActorUp, "cell 0 0,alignx right");
        JButton btnMoveActorDown = new JButton(new MoveActorDownAction());
        btnMoveActorDown.setMargin(BUTTON_MARGIN);
        details2Panel.add((Component)btnMoveActorDown, "cell 0 0,alignx right,aligny top");
        TmmLabel lblDateAdded = new TmmLabel(BUNDLE.getString("metatag.dateadded"));
        details2Panel.add((Component)lblDateAdded, "cell 3 0,alignx right");
        this.spDateAdded = new JSpinner(new SpinnerDateModel());
        details2Panel.add((Component)this.spDateAdded, "cell 4 0");
        TmmLabel lblIds = new TmmLabel("Ids");
        details2Panel.add((Component)lblIds, "flowy,cell 3 1,alignx right,aligny top");
        JScrollPane scrollPaneIds = new JScrollPane();
        details2Panel.add((Component)scrollPaneIds, "cell 4 1,grow");
        this.tableIds = new MediaIdTable(this.ids);
        this.tableIds.configureScrollPane(scrollPaneIds);
        JButton btnAddId = new JButton(new AddIdAction());
        btnAddId.setMargin(BUTTON_MARGIN);
        details2Panel.add((Component)btnAddId, "cell 3 1,alignx right");
        JButton btnRemoveId = new JButton(new RemoveIdAction());
        btnRemoveId.setMargin(BUTTON_MARGIN);
        details2Panel.add((Component)btnRemoveId, "cell 3 1,alignx right,aligny top");
        TmmLabel lblGenres = new TmmLabel(BUNDLE.getString("metatag.genre"));
        details2Panel.add((Component)lblGenres, "flowy,cell 0 3,alignx right,aligny top");
        JScrollPane scrollPaneGenres = new JScrollPane();
        details2Panel.add((Component)scrollPaneGenres, "cell 1 3,grow");
        this.listGenres = new JList();
        scrollPaneGenres.setViewportView(this.listGenres);
        JButton btnAddGenre = new JButton(new AddGenreAction());
        btnAddGenre.setMargin(BUTTON_MARGIN);
        details2Panel.add((Component)btnAddGenre, "cell 0 3,alignx right");
        JButton btnRemoveGenre = new JButton(new RemoveGenreAction());
        btnRemoveGenre.setMargin(BUTTON_MARGIN);
        details2Panel.add((Component)btnRemoveGenre, "cell 0 3,alignx right,aligny top");
        JButton btnMoveGenreUp = new JButton(new MoveGenreUpAction());
        btnMoveGenreUp.setMargin(BUTTON_MARGIN);
        details2Panel.add((Component)btnMoveGenreUp, "cell 0 3,alignx right,aligny top");
        JButton btnMoveGenreDown = new JButton(new MoveGenreDownAction());
        btnMoveGenreDown.setMargin(BUTTON_MARGIN);
        details2Panel.add((Component)btnMoveGenreDown, "cell 0 3,alignx right,aligny top");
        this.cbGenres = new AutocompleteComboBox<MediaGenres>(MediaGenres.values());
        this.cbGenresAutoCompleteSupport = this.cbGenres.getAutoCompleteSupport();
        InputMap im = this.cbGenres.getInputMap(1);
        Object enterAction = im.get(KeyStroke.getKeyStroke(10, 0));
        this.cbGenres.getActionMap().put(enterAction, new AddGenreAction());
        details2Panel.add(this.cbGenres, "cell 1 4,growx");
        TmmLabel lblTags = new TmmLabel(BUNDLE.getString("metatag.tags"));
        details2Panel.add((Component)lblTags, "flowy,cell 3 3,alignx right,aligny top");
        JScrollPane scrollPaneTags = new JScrollPane();
        details2Panel.add((Component)scrollPaneTags, "cell 4 3,grow");
        this.listTags = new JList();
        scrollPaneTags.setViewportView(this.listTags);
        JButton btnAddTag = new JButton(new AddTagAction());
        btnAddTag.setMargin(BUTTON_MARGIN);
        details2Panel.add((Component)btnAddTag, "cell 3 3,alignx right");
        JButton btnRemoveTag = new JButton(new RemoveTagAction());
        btnRemoveTag.setMargin(BUTTON_MARGIN);
        details2Panel.add((Component)btnRemoveTag, "cell 3 3,alignx right,aligny top");
        JButton btnMoveTagUp = new JButton(new MoveTagUpAction());
        btnMoveTagUp.setMargin(BUTTON_MARGIN);
        details2Panel.add((Component)btnMoveTagUp, "cell 3 3,alignx right,aligny top");
        JButton btnMoveTagDown = new JButton(new MoveTagDownAction());
        btnMoveTagDown.setMargin(BUTTON_MARGIN);
        details2Panel.add((Component)btnMoveTagDown, "cell 3 3,alignx right,aligny top");
        this.cbTags = new AutocompleteComboBox<String>(this.tvShowList.getTagsInTvShows());
        this.cbTagsAutoCompleteSupport = this.cbTags.getAutoCompleteSupport();
        im = this.cbTags.getInputMap(1);
        enterAction = im.get(KeyStroke.getKeyStroke(10, 0));
        this.cbTags.getActionMap().put(enterAction, new AddTagAction());
        details2Panel.add(this.cbTags, "cell 4 4,growx");
        JPanel artworkPanel = new JPanel();
        tabbedPane.addTab(BUNDLE.getString("metatag.extraartwork"), null, artworkPanel, null);
        artworkPanel.setLayout((LayoutManager)new MigLayout("", "[200lp:300lp,grow][20lp:n][200lp:300lp,grow][20lp:n][100lp:200lp,grow]", "[][100lp:125lp,grow][20lp:n][][100lp:125lp,grow][20lp:n][][100lp:150lp,grow]"));
        TmmLabel lblClearlogoT = new TmmLabel(BUNDLE.getString("mediafiletype.clearlogo"));
        artworkPanel.add((Component)lblClearlogoT, "cell 0 0");
        LinkLabel lblClearlogoSize = new LinkLabel();
        artworkPanel.add((Component)lblClearlogoSize, "cell 0 0");
        FlatButton btnDeleteClearLogo = new FlatButton(SPACER, IconManager.DELETE_GRAY);
        btnDeleteClearLogo.setToolTipText(BUNDLE.getString("Button.deleteartwork.desc"));
        btnDeleteClearLogo.addActionListener(e -> {
            this.lblClearlogo.clearImage();
            this.tfClearLogo.setText("");
        });
        artworkPanel.add((Component)btnDeleteClearLogo, "cell 0 0");
        this.lblClearlogo = new ImageLabel();
        this.lblClearlogo.setCursor(Cursor.getPredefinedCursor(12));
        this.lblClearlogo.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                ImageChooserDialog dialog = new ImageChooserDialog(TvShowEditorDialog.this, new HashMap<String, Object>(TvShowEditorDialog.this.tvShowToEdit.getIds()), ImageChooserDialog.ImageType.CLEARLOGO, TvShowEditorDialog.this.tvShowList.getAvailableArtworkScrapers(), TvShowEditorDialog.this.lblClearlogo, null, null, MediaType.TV_SHOW);
                dialog.setLocationRelativeTo(MainWindow.getActiveInstance());
                dialog.setVisible(true);
                TvShowEditorDialog.this.updateArtworkUrl(TvShowEditorDialog.this.lblClearlogo, TvShowEditorDialog.this.tfClearLogo);
            }
        });
        artworkPanel.add((Component)this.lblClearlogo, "cell 0 1,grow");
        this.lblClearlogo.addPropertyChangeListener(ORIGINAL_IMAGE_SIZE, e -> this.setImageSizeAndCreateLink(lblClearlogoSize, this.lblClearlogo, MediaFileType.CLEARLOGO));
        TmmLabel lblBannerT = new TmmLabel(BUNDLE.getString("mediafiletype.banner"));
        artworkPanel.add((Component)lblBannerT, "cell 2 0 3 1");
        LinkLabel lblBannerSize = new LinkLabel();
        artworkPanel.add((Component)lblBannerSize, "cell 2 0 3 1");
        FlatButton btnDeleteBanner = new FlatButton(SPACER, IconManager.DELETE_GRAY);
        btnDeleteBanner.setToolTipText(BUNDLE.getString("Button.deleteartwork.desc"));
        btnDeleteBanner.addActionListener(e -> {
            this.lblBanner.clearImage();
            this.tfBanner.setText("");
        });
        artworkPanel.add((Component)btnDeleteBanner, "cell 2 0 3 1");
        this.lblBanner = new ImageLabel();
        this.lblBanner.setCursor(Cursor.getPredefinedCursor(12));
        this.lblBanner.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                ImageChooserDialog dialog = new ImageChooserDialog(TvShowEditorDialog.this, new HashMap<String, Object>(TvShowEditorDialog.this.tvShowToEdit.getIds()), ImageChooserDialog.ImageType.BANNER, TvShowEditorDialog.this.tvShowList.getAvailableArtworkScrapers(), TvShowEditorDialog.this.lblBanner, null, null, MediaType.TV_SHOW);
                dialog.setLocationRelativeTo(MainWindow.getActiveInstance());
                dialog.setVisible(true);
                TvShowEditorDialog.this.updateArtworkUrl(TvShowEditorDialog.this.lblBanner, TvShowEditorDialog.this.tfBanner);
            }
        });
        artworkPanel.add((Component)this.lblBanner, "cell 2 1 3 1,grow");
        this.lblBanner.addPropertyChangeListener(ORIGINAL_IMAGE_SIZE, e -> this.setImageSizeAndCreateLink(lblBannerSize, this.lblBanner, MediaFileType.BANNER));
        TmmLabel lblClearartT = new TmmLabel(BUNDLE.getString("mediafiletype.clearart"));
        artworkPanel.add((Component)lblClearartT, "cell 2 3");
        LinkLabel lblClearartSize = new LinkLabel();
        artworkPanel.add((Component)lblClearartSize, "cell 2 3");
        FlatButton btnDeleteClearart = new FlatButton(SPACER, IconManager.DELETE_GRAY);
        btnDeleteClearart.setToolTipText(BUNDLE.getString("Button.deleteartwork.desc"));
        btnDeleteClearart.addActionListener(e -> {
            this.lblClearart.clearImage();
            this.tfClearArt.setText("");
        });
        artworkPanel.add((Component)btnDeleteClearart, "cell 2 3");
        this.lblClearart = new ImageLabel();
        this.lblClearart.setCursor(Cursor.getPredefinedCursor(12));
        this.lblClearart.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                ImageChooserDialog dialog = new ImageChooserDialog(TvShowEditorDialog.this, new HashMap<String, Object>(TvShowEditorDialog.this.tvShowToEdit.getIds()), ImageChooserDialog.ImageType.CLEARART, TvShowEditorDialog.this.tvShowList.getAvailableArtworkScrapers(), TvShowEditorDialog.this.lblClearart, null, null, MediaType.TV_SHOW);
                dialog.setLocationRelativeTo(MainWindow.getActiveInstance());
                dialog.setVisible(true);
                TvShowEditorDialog.this.updateArtworkUrl(TvShowEditorDialog.this.lblClearart, TvShowEditorDialog.this.tfClearArt);
            }
        });
        artworkPanel.add((Component)this.lblClearart, "cell 2 4,grow");
        this.lblClearart.addPropertyChangeListener(ORIGINAL_IMAGE_SIZE, e -> this.setImageSizeAndCreateLink(lblClearartSize, this.lblClearart, MediaFileType.CLEARART));
        TmmLabel lblLogoT = new TmmLabel(BUNDLE.getString("mediafiletype.logo"));
        artworkPanel.add((Component)lblLogoT, "cell 0 3");
        LinkLabel lblLogoSize = new LinkLabel();
        artworkPanel.add((Component)lblLogoSize, "cell 0 3");
        FlatButton btnDeleteLogo = new FlatButton(SPACER, IconManager.DELETE_GRAY);
        btnDeleteLogo.setToolTipText(BUNDLE.getString("Button.deleteartwork.desc"));
        btnDeleteLogo.addActionListener(e -> {
            this.lblLogo.clearImage();
            this.tfLogo.setText("");
        });
        artworkPanel.add((Component)btnDeleteLogo, "cell 0 3");
        this.lblLogo = new ImageLabel();
        this.lblLogo.setCursor(Cursor.getPredefinedCursor(12));
        this.lblLogo.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                ImageChooserDialog dialog = new ImageChooserDialog(TvShowEditorDialog.this, new HashMap<String, Object>(TvShowEditorDialog.this.tvShowToEdit.getIds()), ImageChooserDialog.ImageType.LOGO, TvShowEditorDialog.this.tvShowList.getAvailableArtworkScrapers(), TvShowEditorDialog.this.lblLogo, null, null, MediaType.TV_SHOW);
                dialog.setLocationRelativeTo(MainWindow.getActiveInstance());
                dialog.setVisible(true);
                TvShowEditorDialog.this.updateArtworkUrl(TvShowEditorDialog.this.lblLogo, TvShowEditorDialog.this.tfLogo);
            }
        });
        artworkPanel.add((Component)this.lblLogo, "cell 0 4,grow");
        this.lblLogo.addPropertyChangeListener(ORIGINAL_IMAGE_SIZE, e -> this.setImageSizeAndCreateLink(lblLogoSize, this.lblLogo, MediaFileType.LOGO));
        TmmLabel lblKeyartT = new TmmLabel(BUNDLE.getString("mediafiletype.keyart"));
        artworkPanel.add((Component)lblKeyartT, "cell 4 3");
        LinkLabel lblKeyartSize = new LinkLabel();
        artworkPanel.add((Component)lblKeyartSize, "cell 4 3");
        FlatButton btnDeleteKeyart = new FlatButton(SPACER, IconManager.DELETE_GRAY);
        btnDeleteKeyart.setToolTipText(BUNDLE.getString("Button.deleteartwork.desc"));
        btnDeleteKeyart.addActionListener(e -> {
            this.lblKeyart.clearImage();
            this.tfKeyart.setText("");
        });
        artworkPanel.add((Component)btnDeleteKeyart, "cell 4 3");
        this.lblKeyart = new ImageLabel();
        this.lblKeyart.setCursor(Cursor.getPredefinedCursor(12));
        this.lblKeyart.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                ImageChooserDialog dialog = new ImageChooserDialog(TvShowEditorDialog.this, new HashMap<String, Object>(TvShowEditorDialog.this.tvShowToEdit.getIds()), ImageChooserDialog.ImageType.KEYART, TvShowEditorDialog.this.tvShowList.getAvailableArtworkScrapers(), TvShowEditorDialog.this.lblKeyart, null, null, MediaType.TV_SHOW);
                dialog.setLocationRelativeTo(MainWindow.getActiveInstance());
                dialog.setVisible(true);
                TvShowEditorDialog.this.updateArtworkUrl(TvShowEditorDialog.this.lblKeyart, TvShowEditorDialog.this.tfKeyart);
            }
        });
        artworkPanel.add((Component)this.lblKeyart, "cell 4 4 1 4,grow");
        this.lblKeyart.addPropertyChangeListener(ORIGINAL_IMAGE_SIZE, e -> this.setImageSizeAndCreateLink(lblKeyartSize, this.lblKeyart, MediaFileType.KEYART));
        TmmLabel lblThumbT = new TmmLabel(BUNDLE.getString("mediafiletype.thumb"));
        artworkPanel.add((Component)lblThumbT, "cell 0 6");
        LinkLabel lblThumbSize = new LinkLabel();
        artworkPanel.add((Component)lblThumbSize, "cell 0 6");
        FlatButton btnDeleteThumb = new FlatButton(SPACER, IconManager.DELETE_GRAY);
        btnDeleteThumb.setToolTipText(BUNDLE.getString("Button.deleteartwork.desc"));
        btnDeleteThumb.addActionListener(e -> {
            this.lblThumb.clearImage();
            this.tfThumb.setText("");
        });
        artworkPanel.add((Component)btnDeleteThumb, "cell 0 6");
        this.lblThumb = new ImageLabel();
        this.lblThumb.setCursor(Cursor.getPredefinedCursor(12));
        this.lblThumb.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                ImageChooserDialog dialog = new ImageChooserDialog(TvShowEditorDialog.this, new HashMap<String, Object>(TvShowEditorDialog.this.tvShowToEdit.getIds()), ImageChooserDialog.ImageType.THUMB, TvShowEditorDialog.this.tvShowList.getAvailableArtworkScrapers(), TvShowEditorDialog.this.lblThumb, null, null, MediaType.TV_SHOW);
                dialog.setLocationRelativeTo(MainWindow.getActiveInstance());
                dialog.setVisible(true);
                TvShowEditorDialog.this.updateArtworkUrl(TvShowEditorDialog.this.lblThumb, TvShowEditorDialog.this.tfThumb);
            }
        });
        artworkPanel.add((Component)this.lblThumb, "cell 0 7,grow");
        this.lblThumb.addPropertyChangeListener(ORIGINAL_IMAGE_SIZE, e -> this.setImageSizeAndCreateLink(lblThumbSize, this.lblThumb, MediaFileType.THUMB));
        TmmLabel lblCharacterartT = new TmmLabel(BUNDLE.getString("mediafiletype.characterart"));
        artworkPanel.add((Component)lblCharacterartT, "cell 2 6");
        LinkLabel lblCharacterartSize = new LinkLabel();
        artworkPanel.add((Component)lblCharacterartSize, "cell 2 6");
        FlatButton btnDeleteCharacterart = new FlatButton(SPACER, IconManager.DELETE_GRAY);
        btnDeleteCharacterart.setToolTipText(BUNDLE.getString("Button.deleteartwork.desc"));
        btnDeleteCharacterart.addActionListener(e -> {
            this.lblCharacterart.clearImage();
            this.tfCharacterart.setText("");
        });
        artworkPanel.add((Component)btnDeleteCharacterart, "cell 2 6");
        this.lblCharacterart = new ImageLabel();
        this.lblCharacterart.setCursor(Cursor.getPredefinedCursor(12));
        this.lblCharacterart.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                ImageChooserDialog dialog = new ImageChooserDialog(TvShowEditorDialog.this, new HashMap<String, Object>(TvShowEditorDialog.this.tvShowToEdit.getIds()), ImageChooserDialog.ImageType.CHARACTERART, TvShowEditorDialog.this.tvShowList.getAvailableArtworkScrapers(), TvShowEditorDialog.this.lblCharacterart, null, null, MediaType.TV_SHOW);
                dialog.setLocationRelativeTo(MainWindow.getActiveInstance());
                dialog.setVisible(true);
                TvShowEditorDialog.this.updateArtworkUrl(TvShowEditorDialog.this.lblCharacterart, TvShowEditorDialog.this.tfCharacterart);
            }
        });
        artworkPanel.add((Component)this.lblCharacterart, "cell 2 7, grow");
        this.lblCharacterart.addPropertyChangeListener(ORIGINAL_IMAGE_SIZE, e -> this.setImageSizeAndCreateLink(lblCharacterartSize, this.lblCharacterart, MediaFileType.CHARACTERART));
        artworkPanel = new JPanel();
        tabbedPane.addTab(BUNDLE.getString("edit.artwork"), null, artworkPanel, null);
        artworkPanel.setLayout((LayoutManager)new MigLayout("", "[][grow]", "[][][][][][][][][]"));
        TmmLabel lblPosterT = new TmmLabel(BUNDLE.getString("mediafiletype.poster"));
        artworkPanel.add((Component)lblPosterT, "cell 0 0,alignx right");
        this.tfPoster = new JTextField();
        artworkPanel.add((Component)this.tfPoster, "cell 1 0,growx");
        TmmLabel lblFanartT = new TmmLabel(BUNDLE.getString("mediafiletype.fanart"));
        artworkPanel.add((Component)lblFanartT, "cell 0 1,alignx right");
        this.tfFanart = new JTextField();
        artworkPanel.add((Component)this.tfFanart, "cell 1 1,growx");
        lblLogoT = new TmmLabel(BUNDLE.getString("mediafiletype.logo"));
        artworkPanel.add((Component)lblLogoT, "cell 0 2,alignx right");
        this.tfLogo = new JTextField();
        artworkPanel.add((Component)this.tfLogo, "cell 1 2,growx");
        TmmLabel lblClearLogoT = new TmmLabel(BUNDLE.getString("mediafiletype.clearlogo"));
        artworkPanel.add((Component)lblClearLogoT, "cell 0 3,alignx right");
        this.tfClearLogo = new JTextField();
        artworkPanel.add((Component)this.tfClearLogo, "cell 1 3,growx");
        lblBannerT = new TmmLabel(BUNDLE.getString("mediafiletype.banner"));
        artworkPanel.add((Component)lblBannerT, "cell 0 4,alignx right");
        this.tfBanner = new JTextField();
        artworkPanel.add((Component)this.tfBanner, "cell 1 4,growx");
        TmmLabel lblClearArtT = new TmmLabel(BUNDLE.getString("mediafiletype.clearart"));
        artworkPanel.add((Component)lblClearArtT, "cell 0 5,alignx right");
        this.tfClearArt = new JTextField();
        artworkPanel.add((Component)this.tfClearArt, "cell 1 5,growx");
        lblThumbT = new TmmLabel(BUNDLE.getString("mediafiletype.thumb"));
        artworkPanel.add((Component)lblThumbT, "cell 0 6,alignx right");
        this.tfThumb = new JTextField();
        artworkPanel.add((Component)this.tfThumb, "cell 1 6,growx");
        lblCharacterartT = new TmmLabel(BUNDLE.getString("mediafiletype.characterart"));
        artworkPanel.add((Component)lblCharacterartT, "cell 0 7,alignx trailing");
        this.tfCharacterart = new JTextField();
        artworkPanel.add((Component)this.tfCharacterart, "cell 1 7,growx");
        lblKeyartT = new TmmLabel(BUNDLE.getString("mediafiletype.keyart"));
        artworkPanel.add((Component)lblKeyartT, "cell 0 8,alignx trailing");
        this.tfKeyart = new JTextField();
        artworkPanel.add((Component)this.tfKeyart, "cell 1 8,growx");
        JPanel episodesPanel = new JPanel();
        tabbedPane.addTab(BUNDLE.getString("metatag.episodes"), episodesPanel);
        episodesPanel.setLayout((LayoutManager)new MigLayout("", "[][grow]", "[][100px:n,grow]"));
        JButton btnCloneEpisode = new JButton(new CloneEpisodeAction());
        btnCloneEpisode.setMargin(BUTTON_MARGIN);
        episodesPanel.add((Component)btnCloneEpisode, "cell 0 0");
        JScrollPane scrollPaneEpisodes = new JScrollPane();
        episodesPanel.add((Component)scrollPaneEpisodes, "cell 1 0 1 2,grow");
        TmmTableModel<EpisodeEditorContainer> episodeTableModel = new TmmTableModel<EpisodeEditorContainer>((EventList<EpisodeEditorContainer>)GlazedListsSwing.swingThreadProxyList(this.episodes), new EpisodeTableFormat());
        this.tableEpisodes = new TmmTable((TableModel)((Object)episodeTableModel));
        this.tableEpisodes.configureScrollPane(scrollPaneEpisodes);
        JButton btnRemoveEpisode = new JButton(new RemoveEpisodeAction());
        btnRemoveEpisode.setMargin(BUTTON_MARGIN);
        episodesPanel.add((Component)btnRemoveEpisode, "cell 0 1,aligny top");
        JPanel trailerPanel = new JPanel();
        tabbedPane.addTab(BUNDLE.getString("Settings.trailer"), null, trailerPanel, null);
        trailerPanel.setLayout((LayoutManager)new MigLayout("", "[][grow]", "[][][]"));
        TmmLabel lblTrailer = new TmmLabel(BUNDLE.getString("metatag.trailer"));
        trailerPanel.add((Component)lblTrailer, "flowy,cell 0 10,alignx right,aligny top");
        JButton btnAddTrailer = new JButton(new AddTrailerAction());
        btnAddTrailer.setMargin(BUTTON_MARGIN);
        trailerPanel.add((Component)btnAddTrailer, "cell 0 10,alignx right,aligny top");
        JButton btnRemoveTrailer = new JButton(new RemoveTrailerAction());
        btnRemoveTrailer.setMargin(BUTTON_MARGIN);
        trailerPanel.add((Component)btnRemoveTrailer, "cell 0 10,alignx right,aligny top");
        JScrollPane scrollPaneTrailer = new JScrollPane();
        trailerPanel.add((Component)scrollPaneTrailer, "cell 1 10 7 1,grow");
        this.tableTrailer = new TmmTable();
        this.tableTrailer.putClientProperty("terminateEditOnFocusLost", Boolean.TRUE);
        this.tableTrailer.configureScrollPane(scrollPaneTrailer);
        scrollPaneTrailer.setViewportView(this.tableTrailer);
        if (this.queueSize > 1) {
            JButton btnAbort = new JButton(new AbortAction());
            this.addButton(btnAbort);
            if (this.queueIndex > 0) {
                JButton backButton = new JButton(new NavigateBackAction());
                this.addButton(backButton);
            }
        }
        JButton cancelButton = new JButton(new CancelAction());
        this.addButton(cancelButton);
        JButton okButton = new JButton(new OKAction());
        this.addDefaultButton(okButton);
    }

    private void updateArtworkUrl(ImageLabel imageLabel, JTextField textField) {
        if (StringUtils.isNotBlank((CharSequence)imageLabel.getImageUrl())) {
            textField.setText(imageLabel.getImageUrl());
        }
    }

    private void processArtwork(MediaFileType type, ImageLabel imageLabel, JTextField textField) {
        if (StringUtils.isAllBlank((CharSequence[])new CharSequence[]{imageLabel.getImagePath(), imageLabel.getImageUrl()}) && StringUtils.isNotBlank((CharSequence)this.tvShowToEdit.getArtworkFilename(type))) {
            this.tvShowToEdit.deleteMediaFiles(type);
        }
        if (StringUtils.isNotEmpty((CharSequence)textField.getText()) && !textField.getText().equals(this.tvShowToEdit.getArtworkUrl(type))) {
            this.tvShowToEdit.setArtworkUrl(textField.getText(), type);
            this.tvShowToEdit.downloadArtwork(type);
        } else if (StringUtils.isEmpty((CharSequence)textField.getText())) {
            this.tvShowToEdit.removeArtworkUrl(type);
        }
    }

    public boolean showDialog() {
        this.setVisible(true);
        return this.continueQueue;
    }

    @Override
    public void dispose() {
        super.dispose();
        this.dpPremiered.cleanup();
    }

    public boolean isContinueQueue() {
        return this.continueQueue;
    }

    public boolean isNavigateBack() {
        return this.navigateBack;
    }

    protected BindingGroup initDataBindings() {
        JListBinding jListBinding = SwingBindings.createJListBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, this.genres, this.listGenres);
        jListBinding.bind();
        JListBinding jListBinding_1 = SwingBindings.createJListBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, this.tags, this.listTags);
        jListBinding_1.bind();
        JTableBinding jTableBinding_2 = SwingBindings.createJTableBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, this.trailers, (JTable)this.tableTrailer);
        BeanProperty trailerBeanProperty = BeanProperty.create((String)"inNfo");
        jTableBinding_2.addColumnBinding((Property)trailerBeanProperty).setColumnClass(Boolean.class);
        BeanProperty trailerBeanProperty_1 = BeanProperty.create((String)"name");
        jTableBinding_2.addColumnBinding((Property)trailerBeanProperty_1);
        BeanProperty trailerBeanProperty_2 = BeanProperty.create((String)"provider");
        jTableBinding_2.addColumnBinding((Property)trailerBeanProperty_2);
        BeanProperty trailerBeanProperty_3 = BeanProperty.create((String)"quality");
        jTableBinding_2.addColumnBinding((Property)trailerBeanProperty_3);
        BeanProperty trailerBeanProperty_4 = BeanProperty.create((String)"url");
        jTableBinding_2.addColumnBinding((Property)trailerBeanProperty_4);
        jTableBinding_2.bind();
        BindingGroup bindingGroup = new BindingGroup();
        bindingGroup.addBinding((Binding)jListBinding);
        bindingGroup.addBinding((Binding)jListBinding_1);
        bindingGroup.addBinding((Binding)jTableBinding_2);
        return bindingGroup;
    }

    private void setImageSizeAndCreateLink(LinkLabel lblSize, ImageLabel imageLabel, MediaFileType type) {
        TmmUIHelper.createLinkForImage(lblSize, imageLabel);
        if (imageLabel.getOriginalImageSize().width == 0 && imageLabel.getOriginalImageSize().height == 0) {
            lblSize.setText("");
            return;
        }
        Dimension dimension = this.tvShowToEdit.getArtworkDimension(type);
        if (dimension.width == 0 && dimension.height == 0) {
            lblSize.setText(imageLabel.getOriginalImageSize().width + "x" + imageLabel.getOriginalImageSize().height);
        } else {
            lblSize.setText(dimension.width + "x" + dimension.height);
        }
    }

    private class RemoveTrailerAction
    extends AbstractAction {
        private static final long serialVersionUID = -6956921050689930101L;

        public RemoveTrailerAction() {
            this.putValue("ShortDescription", BUNDLE.getString("trailer.remove"));
            this.putValue("SmallIcon", IconManager.REMOVE_INV);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int row = TvShowEditorDialog.this.tableTrailer.getSelectedRow();
            if (row > -1) {
                row = TvShowEditorDialog.this.tableTrailer.convertRowIndexToModel(row);
                TvShowEditorDialog.this.trailers.remove(row);
            }
        }
    }

    private class AddTrailerAction
    extends AbstractAction {
        private static final long serialVersionUID = -4446154040952056823L;

        public AddTrailerAction() {
            this.putValue("ShortDescription", BUNDLE.getString("trailer.add"));
            this.putValue("SmallIcon", IconManager.ADD_INV);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            MediaTrailer trailer = new MediaTrailer();
            trailer.setName("unknown");
            trailer.setProvider("unknown");
            trailer.setQuality("unknown");
            trailer.setUrl("http://");
            TvShowEditorDialog.this.trailers.add(0, trailer);
        }
    }

    private static class EpisodeTableFormat
    extends TmmTableFormat<EpisodeEditorContainer>
    implements WritableTableFormat<EpisodeEditorContainer> {
        EpisodeTableFormat() {
            TmmTableFormat.Column col = new TmmTableFormat.Column(BUNDLE.getString("metatag.title"), "name", EpisodeEditorContainer::getEpisodeTitle, String.class);
            col.setColumnResizeable(true);
            this.addColumn(col);
            col = new TmmTableFormat.Column(BUNDLE.getString("metatag.filename"), "filename", EpisodeEditorContainer::getMediaFilename, String.class);
            col.setColumnResizeable(true);
            this.addColumn(col);
            col = new TmmTableFormat.Column(BUNDLE.getString("metatag.season"), "season", EpisodeEditorContainer::getSeason, Integer.class);
            col.setColumnResizeable(false);
            this.addColumn(col);
            col = new TmmTableFormat.Column(BUNDLE.getString("metatag.episode"), "episode", EpisodeEditorContainer::getEpisode, Integer.class);
            col.setColumnResizeable(false);
            this.addColumn(col);
            col = new TmmTableFormat.Column(BUNDLE.getString("metatag.dvdorder"), "name", EpisodeEditorContainer::isDvdOrder, Boolean.class);
            col.setColumnResizeable(false);
            this.addColumn(col);
        }

        public boolean isEditable(EpisodeEditorContainer episodeEditorContainer, int i) {
            switch (i) {
                case 2: 
                case 3: 
                case 4: {
                    return true;
                }
            }
            return false;
        }

        public EpisodeEditorContainer setColumnValue(EpisodeEditorContainer episodeEditorContainer, Object o, int i) {
            switch (i) {
                case 2: {
                    episodeEditorContainer.setSeason((Integer)o);
                    break;
                }
                case 3: {
                    episodeEditorContainer.setEpisode((Integer)o);
                    break;
                }
                case 4: {
                    episodeEditorContainer.setDvdOrder((Boolean)o);
                    break;
                }
            }
            return episodeEditorContainer;
        }
    }

    private class RemoveEpisodeAction
    extends AbstractAction {
        private static final long serialVersionUID = -8233854057648972649L;

        RemoveEpisodeAction() {
            this.putValue("ShortDescription", BUNDLE.getString("tvshowepisode.remove"));
            this.putValue("SmallIcon", IconManager.REMOVE_INV);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int row = TvShowEditorDialog.this.tableEpisodes.getSelectedRow();
            if (row > -1) {
                row = TvShowEditorDialog.this.tableEpisodes.convertRowIndexToModel(row);
                TvShowEditorDialog.this.episodes.remove(row);
            }
        }
    }

    private class CloneEpisodeAction
    extends AbstractAction {
        private static final long serialVersionUID = -3255090541823134232L;

        CloneEpisodeAction() {
            this.putValue("ShortDescription", BUNDLE.getString("tvshowepisode.clone"));
            this.putValue("SmallIcon", IconManager.COPY_INV);
            this.putValue("SwingLargeIconKey", IconManager.COPY_INV);
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            int row = TvShowEditorDialog.this.tableEpisodes.getSelectedRow();
            if (row > -1) {
                row = TvShowEditorDialog.this.tableEpisodes.convertRowIndexToModel(row);
                EpisodeEditorContainer origContainer = (EpisodeEditorContainer)TvShowEditorDialog.this.episodes.get(row);
                EpisodeEditorContainer newContainer = new EpisodeEditorContainer();
                newContainer.tvShowEpisode = new TvShowEpisode(origContainer.tvShowEpisode);
                newContainer.tvShowEpisode.setTitle(origContainer.tvShowEpisode.getTitle() + " (clone)");
                newContainer.episode = -1;
                newContainer.season = newContainer.tvShowEpisode.getSeason();
                TvShowEditorDialog.this.episodes.add(row + 1, (Object)newContainer);
            }
        }
    }

    private class EpisodeEditorContainer
    extends AbstractModelObject {
        TvShowEpisode tvShowEpisode;
        int season;
        int episode;
        boolean dvdOrder = false;

        private EpisodeEditorContainer() {
        }

        public String getEpisodeTitle() {
            return this.tvShowEpisode.getTitle();
        }

        public String getMediaFilename() {
            List<MediaFile> mfs = this.tvShowEpisode.getMediaFiles(MediaFileType.VIDEO);
            if (mfs != null && !mfs.isEmpty()) {
                return mfs.get(0).getFile().toString();
            }
            return "";
        }

        public int getEpisode() {
            return this.episode;
        }

        public void setEpisode(int newValue) {
            int oldValue = this.episode;
            this.episode = newValue;
            this.firePropertyChange("episode", oldValue, newValue);
        }

        public int getSeason() {
            return this.season;
        }

        public void setSeason(int newValue) {
            int oldValue = this.season;
            this.season = newValue;
            this.firePropertyChange("season", oldValue, newValue);
        }

        public boolean isDvdOrder() {
            return this.dvdOrder;
        }

        public void setDvdOrder(boolean newValue) {
            boolean oldValue = this.dvdOrder;
            this.dvdOrder = newValue;
            this.firePropertyChange("dvdOrder", oldValue, newValue);
        }
    }

    private class NavigateBackAction
    extends AbstractAction {
        private static final long serialVersionUID = -1652218154720642310L;

        private NavigateBackAction() {
            this.putValue("Name", BUNDLE.getString("Button.back"));
            this.putValue("SmallIcon", IconManager.BACK_INV);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            TvShowEditorDialog.this.navigateBack = true;
            TvShowEditorDialog.this.setVisible(false);
        }
    }

    private class AbortAction
    extends AbstractAction {
        private static final long serialVersionUID = -7652218354710642510L;

        AbortAction() {
            this.putValue("Name", BUNDLE.getString("Button.abortqueue"));
            this.putValue("ShortDescription", BUNDLE.getString("tvshow.edit.abortqueue.desc"));
            this.putValue("SmallIcon", IconManager.STOP_INV);
            this.putValue("SwingLargeIconKey", IconManager.STOP_INV);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            TvShowEditorDialog.this.continueQueue = false;
            TvShowEditorDialog.this.setVisible(false);
        }
    }

    private class MoveTagDownAction
    extends AbstractAction {
        private static final long serialVersionUID = -1135108943010008069L;

        MoveTagDownAction() {
            this.putValue("ShortDescription", BUNDLE.getString("movie.edit.movetagdown"));
            this.putValue("SmallIcon", IconManager.ARROW_DOWN_INV);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int row = TvShowEditorDialog.this.listTags.getSelectedIndex();
            if (row < TvShowEditorDialog.this.tags.size() - 1) {
                Collections.rotate(TvShowEditorDialog.this.tags.subList(row, row + 2), -1);
                TvShowEditorDialog.this.listTags.getSelectionModel().setSelectionInterval(row + 1, row + 1);
            }
        }
    }

    private class MoveTagUpAction
    extends AbstractAction {
        private static final long serialVersionUID = -6855661707692602266L;

        MoveTagUpAction() {
            this.putValue("ShortDescription", BUNDLE.getString("movie.edit.movetagup"));
            this.putValue("SmallIcon", IconManager.ARROW_UP_INV);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int row = TvShowEditorDialog.this.listTags.getSelectedIndex();
            if (row > 0) {
                Collections.rotate(TvShowEditorDialog.this.tags.subList(row - 1, row + 1), 1);
                TvShowEditorDialog.this.listTags.getSelectionModel().setSelectionInterval(row - 1, row - 1);
            }
        }
    }

    private class RemoveTagAction
    extends AbstractAction {
        private static final long serialVersionUID = -1580945350962234235L;

        RemoveTagAction() {
            this.putValue("ShortDescription", BUNDLE.getString("tag.remove"));
            this.putValue("SmallIcon", IconManager.REMOVE_INV);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            for (String tag : TvShowEditorDialog.this.listTags.getSelectedValuesList()) {
                TvShowEditorDialog.this.tags.remove(tag);
            }
        }
    }

    private class RemoveIdAction
    extends AbstractAction {
        private static final long serialVersionUID = -7079826950827356996L;

        RemoveIdAction() {
            this.putValue("ShortDescription", BUNDLE.getString("id.remove"));
            this.putValue("SmallIcon", IconManager.REMOVE_INV);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int row = TvShowEditorDialog.this.tableIds.getSelectedRow();
            if (row > -1) {
                row = TvShowEditorDialog.this.tableIds.convertRowIndexToModel(row);
                TvShowEditorDialog.this.ids.remove(row);
            }
        }
    }

    private class AddIdAction
    extends AbstractAction {
        private static final long serialVersionUID = 2903255414553349267L;

        AddIdAction() {
            this.putValue("ShortDescription", BUNDLE.getString("id.add"));
            this.putValue("SmallIcon", IconManager.ADD_INV);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            MediaIdTable.MediaId mediaId = new MediaIdTable.MediaId();
            IdEditorDialog dialog = new IdEditorDialog(SwingUtilities.getWindowAncestor(TvShowEditorDialog.this.tableIds), BUNDLE.getString("id.add"), mediaId, ScraperType.TV_SHOW);
            dialog.setVisible(true);
            if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{mediaId.key, mediaId.value})) {
                TvShowEditorDialog.this.ids.add((Object)mediaId);
            }
        }
    }

    private class AddTagAction
    extends AbstractAction {
        private static final long serialVersionUID = 9160043031922897785L;

        AddTagAction() {
            this.putValue("ShortDescription", BUNDLE.getString("tag.add"));
            this.putValue("SmallIcon", IconManager.ADD_INV);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JTextField tf;
            String selectedText;
            String newTag = (String)TvShowEditorDialog.this.cbTags.getSelectedItem();
            if (StringUtils.isBlank((CharSequence)newTag)) {
                return;
            }
            Component editorComponent = TvShowEditorDialog.this.cbTags.getEditor().getEditorComponent();
            if (editorComponent instanceof JTextField && (selectedText = (tf = (JTextField)editorComponent).getSelectedText()) != null) {
                tf.setSelectionStart(0);
                tf.setSelectionEnd(0);
                tf.setCaretPosition(tf.getText().length());
                return;
            }
            boolean tagFound = false;
            for (String tag : TvShowEditorDialog.this.tags) {
                if (!tag.equals(newTag)) continue;
                tagFound = true;
                break;
            }
            if (!tagFound) {
                TvShowEditorDialog.this.tags.add(newTag);
                if (editorComponent instanceof JTextField) {
                    TvShowEditorDialog.this.cbTagsAutoCompleteSupport.setFirstItem((Object)"");
                    TvShowEditorDialog.this.cbTags.setSelectedIndex(0);
                    TvShowEditorDialog.this.cbTagsAutoCompleteSupport.removeFirstItem();
                }
            }
        }
    }

    private class MoveGenreDownAction
    extends AbstractAction {
        private static final long serialVersionUID = -1135108943010008069L;

        MoveGenreDownAction() {
            this.putValue("ShortDescription", BUNDLE.getString("movie.edit.movegenredown"));
            this.putValue("SmallIcon", IconManager.ARROW_DOWN_INV);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int row = TvShowEditorDialog.this.listGenres.getSelectedIndex();
            if (row < TvShowEditorDialog.this.genres.size() - 1) {
                Collections.rotate(TvShowEditorDialog.this.genres.subList(row, row + 2), -1);
                TvShowEditorDialog.this.listGenres.getSelectionModel().setSelectionInterval(row + 1, row + 1);
            }
        }
    }

    private class MoveGenreUpAction
    extends AbstractAction {
        private static final long serialVersionUID = -6855661707692602266L;

        MoveGenreUpAction() {
            this.putValue("ShortDescription", BUNDLE.getString("movie.edit.movegenreup"));
            this.putValue("SmallIcon", IconManager.ARROW_UP_INV);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int row = TvShowEditorDialog.this.listGenres.getSelectedIndex();
            if (row > 0) {
                Collections.rotate(TvShowEditorDialog.this.genres.subList(row - 1, row + 1), 1);
                TvShowEditorDialog.this.listGenres.getSelectionModel().setSelectionInterval(row - 1, row - 1);
            }
        }
    }

    private class RemoveGenreAction
    extends AbstractAction {
        private static final long serialVersionUID = -5459615776560234688L;

        RemoveGenreAction() {
            this.putValue("ShortDescription", BUNDLE.getString("genre.remove"));
            this.putValue("SmallIcon", IconManager.REMOVE_INV);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            for (MediaGenres genre : TvShowEditorDialog.this.listGenres.getSelectedValuesList()) {
                TvShowEditorDialog.this.genres.remove(genre);
            }
        }
    }

    private class AddGenreAction
    extends AbstractAction {
        private static final long serialVersionUID = 6666302391216952247L;

        AddGenreAction() {
            this.putValue("ShortDescription", BUNDLE.getString("genre.add"));
            this.putValue("SmallIcon", IconManager.ADD_INV);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JTextField tf;
            String selectedText;
            MediaGenres newGenre = null;
            Object item = TvShowEditorDialog.this.cbGenres.getSelectedItem();
            Component editorComponent = TvShowEditorDialog.this.cbGenres.getEditor().getEditorComponent();
            if (editorComponent instanceof JTextField && (selectedText = (tf = (JTextField)editorComponent).getSelectedText()) != null) {
                tf.setSelectionStart(0);
                tf.setSelectionEnd(0);
                tf.setCaretPosition(tf.getText().length());
                return;
            }
            if (item instanceof MediaGenres) {
                newGenre = (MediaGenres)item;
            }
            if (item instanceof String) {
                newGenre = MediaGenres.getGenre((String)item);
            }
            if (newGenre != null && !TvShowEditorDialog.this.genres.contains(newGenre)) {
                TvShowEditorDialog.this.genres.add(newGenre);
                if (editorComponent instanceof JTextField) {
                    TvShowEditorDialog.this.cbGenresAutoCompleteSupport.setFirstItem(null);
                    TvShowEditorDialog.this.cbGenres.setSelectedIndex(0);
                    TvShowEditorDialog.this.cbGenresAutoCompleteSupport.removeFirstItem();
                }
            }
        }
    }

    private class MoveActorDownAction
    extends AbstractAction {
        private static final long serialVersionUID = -6564146895819191932L;

        MoveActorDownAction() {
            this.putValue("ShortDescription", BUNDLE.getString("movie.edit.moveactordown"));
            this.putValue("SmallIcon", IconManager.ARROW_DOWN_INV);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int row = TvShowEditorDialog.this.tableActors.getSelectedRow();
            if (row < TvShowEditorDialog.this.actors.size() - 1) {
                Collections.rotate(TvShowEditorDialog.this.actors.subList(row, row + 2), -1);
                TvShowEditorDialog.this.tableActors.getSelectionModel().setSelectionInterval(row + 1, row + 1);
            }
        }
    }

    private class MoveActorUpAction
    extends AbstractAction {
        private static final long serialVersionUID = 5775423424097844658L;

        MoveActorUpAction() {
            this.putValue("ShortDescription", BUNDLE.getString("movie.edit.moveactorup"));
            this.putValue("SmallIcon", IconManager.ARROW_UP_INV);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int row = TvShowEditorDialog.this.tableActors.getSelectedRow();
            if (row > 0) {
                Collections.rotate(TvShowEditorDialog.this.actors.subList(row - 1, row + 1), 1);
                TvShowEditorDialog.this.tableActors.getSelectionModel().setSelectionInterval(row - 1, row - 1);
            }
        }
    }

    private class RemoveActorAction
    extends AbstractAction {
        private static final long serialVersionUID = 6970920169867315771L;

        RemoveActorAction() {
            this.putValue("ShortDescription", BUNDLE.getString("cast.actor.remove"));
            this.putValue("SmallIcon", IconManager.REMOVE_INV);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int row = TvShowEditorDialog.this.tableActors.getSelectedRow();
            if (row > -1) {
                row = TvShowEditorDialog.this.tableActors.convertRowIndexToModel(row);
                TvShowEditorDialog.this.actors.remove(row);
            }
        }
    }

    private class AddActorAction
    extends AbstractAction {
        private static final long serialVersionUID = -5879601617842300526L;

        AddActorAction() {
            this.putValue("ShortDescription", BUNDLE.getString("cast.actor.add"));
            this.putValue("SmallIcon", IconManager.ADD_INV);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Person actor = new Person(Person.Type.ACTOR, BUNDLE.getString("cast.actor.unknown"), BUNDLE.getString("cast.role.unknown"));
            PersonEditorDialog dialog = new PersonEditorDialog(SwingUtilities.getWindowAncestor(TvShowEditorDialog.this.tableActors), BUNDLE.getString("cast.actor.add"), actor);
            dialog.setVisible(true);
            if (StringUtils.isNotBlank((CharSequence)actor.getName()) && !actor.getName().equals(BUNDLE.getString("cast.actor.unknown"))) {
                TvShowEditorDialog.this.actors.add(0, (Object)actor);
            }
        }
    }

    private class RemoveRatingAction
    extends AbstractAction {
        private static final long serialVersionUID = -7079821950827356996L;

        private RemoveRatingAction() {
            this.putValue("ShortDescription", BUNDLE.getString("rating.remove"));
            this.putValue("SmallIcon", IconManager.REMOVE_INV);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int row = TvShowEditorDialog.this.tableRatings.getSelectedRow();
            if (row > -1) {
                row = TvShowEditorDialog.this.tableRatings.convertRowIndexToModel(row);
                TvShowEditorDialog.this.mediaRatings.remove(row);
            }
        }
    }

    private class AddRatingAction
    extends AbstractAction {
        private static final long serialVersionUID = 2903255414533349267L;

        private AddRatingAction() {
            this.putValue("ShortDescription", BUNDLE.getString("rating.add"));
            this.putValue("SmallIcon", IconManager.ADD_INV);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            MediaRatingTable.MediaRating mediaRating = new MediaRatingTable.MediaRating("");
            mediaRating.maxValue = 10;
            mediaRating.votes = 1;
            RatingEditorDialog dialog = new RatingEditorDialog(SwingUtilities.getWindowAncestor(TvShowEditorDialog.this.tableActors), BUNDLE.getString("rating.add"), mediaRating);
            dialog.setVisible(true);
            if (StringUtils.isNotBlank((CharSequence)mediaRating.key) && mediaRating.value > 0.0f && mediaRating.maxValue > 0 && mediaRating.votes > 0) {
                TvShowEditorDialog.this.mediaRatings.add((Object)mediaRating);
            }
        }
    }

    private class CancelAction
    extends AbstractAction {
        private static final long serialVersionUID = -4617793684152607277L;

        CancelAction() {
            this.putValue("Name", BUNDLE.getString("Button.cancel"));
            this.putValue("ShortDescription", BUNDLE.getString("edit.discard"));
            this.putValue("SmallIcon", IconManager.CANCEL_INV);
            this.putValue("SwingLargeIconKey", IconManager.CANCEL_INV);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            TvShowEditorDialog.this.setVisible(false);
        }
    }

    private class OKAction
    extends AbstractAction {
        private static final long serialVersionUID = 6699599213348390696L;

        OKAction() {
            this.putValue("Name", BUNDLE.getString("Button.ok"));
            this.putValue("ShortDescription", BUNDLE.getString("tvshow.change"));
            this.putValue("SmallIcon", IconManager.APPLY_INV);
            this.putValue("SwingLargeIconKey", IconManager.APPLY_INV);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            TvShowEditorDialog.this.tvShowToEdit.setTitle(TvShowEditorDialog.this.tfTitle.getText());
            TvShowEditorDialog.this.tvShowToEdit.setOriginalTitle(TvShowEditorDialog.this.tfOriginalTitle.getText());
            TvShowEditorDialog.this.tvShowToEdit.setSortTitle(TvShowEditorDialog.this.tfSorttitle.getText());
            TvShowEditorDialog.this.tvShowToEdit.setYear((Integer)TvShowEditorDialog.this.spYear.getValue());
            TvShowEditorDialog.this.tvShowToEdit.setPlot(TvShowEditorDialog.this.taPlot.getText());
            TvShowEditorDialog.this.tvShowToEdit.setRuntime((Integer)TvShowEditorDialog.this.spRuntime.getValue());
            for (Iterator id : TvShowEditorDialog.this.ids) {
                try {
                    Integer n = Integer.parseInt(((MediaIdTable.MediaId)((Object)id)).value);
                    TvShowEditorDialog.this.tvShowToEdit.setId(((MediaIdTable.MediaId)((Object)id)).key, n);
                }
                catch (NumberFormatException numberFormatException) {
                    TvShowEditorDialog.this.tvShowToEdit.setId(((MediaIdTable.MediaId)((Object)id)).key, ((MediaIdTable.MediaId)((Object)id)).value);
                }
            }
            ArrayList removeIds = new ArrayList();
            for (Map.Entry entry : TvShowEditorDialog.this.tvShowToEdit.getIds().entrySet()) {
                MediaIdTable.MediaId id = new MediaIdTable.MediaId((String)entry.getKey());
                if (TvShowEditorDialog.this.ids.contains((Object)id)) continue;
                removeIds.add(entry.getKey());
            }
            for (String string : removeIds) {
                TvShowEditorDialog.this.tvShowToEdit.setId(string, null);
            }
            Object certification = TvShowEditorDialog.this.cbCertification.getSelectedItem();
            if (certification instanceof MediaCertification) {
                TvShowEditorDialog.this.tvShowToEdit.setCertification((MediaCertification)((Object)certification));
            }
            TvShowEditorDialog.this.processArtwork(MediaFileType.POSTER, TvShowEditorDialog.this.lblPoster, TvShowEditorDialog.this.tfPoster);
            TvShowEditorDialog.this.processArtwork(MediaFileType.FANART, TvShowEditorDialog.this.lblFanart, TvShowEditorDialog.this.tfFanart);
            TvShowEditorDialog.this.processArtwork(MediaFileType.LOGO, TvShowEditorDialog.this.lblLogo, TvShowEditorDialog.this.tfLogo);
            TvShowEditorDialog.this.processArtwork(MediaFileType.CLEARLOGO, TvShowEditorDialog.this.lblClearlogo, TvShowEditorDialog.this.tfClearLogo);
            TvShowEditorDialog.this.processArtwork(MediaFileType.BANNER, TvShowEditorDialog.this.lblBanner, TvShowEditorDialog.this.tfBanner);
            TvShowEditorDialog.this.processArtwork(MediaFileType.CLEARART, TvShowEditorDialog.this.lblClearart, TvShowEditorDialog.this.tfClearArt);
            TvShowEditorDialog.this.processArtwork(MediaFileType.THUMB, TvShowEditorDialog.this.lblThumb, TvShowEditorDialog.this.tfThumb);
            TvShowEditorDialog.this.processArtwork(MediaFileType.CHARACTERART, TvShowEditorDialog.this.lblCharacterart, TvShowEditorDialog.this.tfCharacterart);
            TvShowEditorDialog.this.processArtwork(MediaFileType.KEYART, TvShowEditorDialog.this.lblKeyart, TvShowEditorDialog.this.tfKeyart);
            if (!(TvShowEditorDialog.this.extrafanarts == null || TvShowEditorDialog.this.extrafanarts.size() == TvShowEditorDialog.this.tvShowToEdit.getExtraFanartUrls().size() && TvShowEditorDialog.this.extrafanarts.containsAll(TvShowEditorDialog.this.tvShowToEdit.getExtraFanartUrls()) && TvShowEditorDialog.this.tvShowToEdit.getExtraFanartUrls().containsAll(TvShowEditorDialog.this.extrafanarts))) {
                TvShowEditorDialog.this.tvShowToEdit.setExtraFanartUrls(TvShowEditorDialog.this.extrafanarts);
                TvShowEditorDialog.this.tvShowToEdit.downloadArtwork(MediaFileType.EXTRAFANART);
            }
            TvShowEditorDialog.this.tvShowToEdit.setProductionCompany(TvShowEditorDialog.this.tfStudio.getText());
            TvShowEditorDialog.this.tvShowToEdit.setCountry(TvShowEditorDialog.this.tfCountry.getText());
            TvShowEditorDialog.this.tvShowToEdit.setNote(TvShowEditorDialog.this.tfNote.getText());
            TvShowEditorDialog.this.tvShowToEdit.setActors((List<Person>)TvShowEditorDialog.this.actors);
            TvShowEditorDialog.this.tvShowToEdit.setGenres(TvShowEditorDialog.this.genres);
            TvShowEditorDialog.this.tvShowToEdit.setTags(TvShowEditorDialog.this.tags);
            TvShowEditorDialog.this.tvShowToEdit.setDateAdded((Date)TvShowEditorDialog.this.spDateAdded.getValue());
            TvShowEditorDialog.this.tvShowToEdit.setFirstAired(TvShowEditorDialog.this.dpPremiered.getDate());
            TvShowEditorDialog.this.tvShowToEdit.setStatus((MediaAiredStatus)((Object)TvShowEditorDialog.this.cbStatus.getSelectedItem()));
            HashMap<String, MediaRating> hashMap = new HashMap<String, MediaRating>();
            if ((Double)TvShowEditorDialog.this.spRating.getValue() > 0.0) {
                hashMap.put("user", new MediaRating("user", (Double)TvShowEditorDialog.this.spRating.getValue(), 1, 10));
            }
            for (MediaRatingTable.MediaRating mediaRating : TvShowEditorDialog.this.mediaRatings) {
                if (!StringUtils.isNotBlank((CharSequence)mediaRating.key) || !(mediaRating.value > 0.0f)) continue;
                hashMap.put(mediaRating.key, new MediaRating(mediaRating.key, mediaRating.value, mediaRating.votes, mediaRating.maxValue));
            }
            TvShowEditorDialog.this.tvShowToEdit.setRatings(hashMap);
            for (int i = TvShowEditorDialog.this.tvShowToEdit.getEpisodeCount() - 1; i >= 0; --i) {
                boolean found = false;
                TvShowEpisode episode = TvShowEditorDialog.this.tvShowToEdit.getEpisodes().get(i);
                for (EpisodeEditorContainer container : TvShowEditorDialog.this.episodes) {
                    if (container.tvShowEpisode != episode) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                TvShowEditorDialog.this.tvShowToEdit.removeEpisode(episode);
            }
            for (EpisodeEditorContainer container : TvShowEditorDialog.this.episodes) {
                boolean found = false;
                boolean shouldStore = false;
                if (container.dvdOrder != container.tvShowEpisode.isDvdOrder()) {
                    container.tvShowEpisode.setDvdOrder(container.dvdOrder);
                    shouldStore = true;
                }
                if (container.episode != container.tvShowEpisode.getEpisode()) {
                    if (container.dvdOrder) {
                        container.tvShowEpisode.setDvdEpisode(container.episode);
                    } else {
                        container.tvShowEpisode.setAiredEpisode(container.episode);
                    }
                    shouldStore = true;
                }
                if (container.season != container.tvShowEpisode.getSeason()) {
                    if (container.dvdOrder) {
                        container.tvShowEpisode.setDvdSeason(container.season);
                    } else {
                        container.tvShowEpisode.setAiredSeason(container.season);
                    }
                    shouldStore = true;
                }
                for (TvShowEpisode episode : TvShowEditorDialog.this.tvShowToEdit.getEpisodes()) {
                    if (container.tvShowEpisode != episode) continue;
                    found = true;
                    break;
                }
                if (!found) {
                    container.tvShowEpisode.writeNFO();
                    container.tvShowEpisode.saveToDb();
                    TvShowEditorDialog.this.tvShowToEdit.addEpisode(container.tvShowEpisode);
                    continue;
                }
                if (!shouldStore) continue;
                container.tvShowEpisode.writeNFO();
                container.tvShowEpisode.saveToDb();
            }
            TvShowEditorDialog.this.tvShowToEdit.removeAllTrailers();
            for (MediaTrailer trailer : TvShowEditorDialog.this.trailers) {
                TvShowEditorDialog.this.tvShowToEdit.addTrailer(trailer);
            }
            TvShowEditorDialog.this.tvShowToEdit.writeNFO();
            TvShowEditorDialog.this.tvShowToEdit.saveToDb();
            if (TvShowModuleManager.SETTINGS.getSyncTrakt()) {
                SyncTraktTvTask task = new SyncTraktTvTask(null, Collections.singletonList(TvShowEditorDialog.this.tvShowToEdit));
                TmmTaskManager.getInstance().addUnnamedTask(task);
            }
            TvShowEditorDialog.this.setVisible(false);
        }
    }
}

