/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.tvshows.dialogs;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import net.miginfocom.swing.MigLayout;
import org.tinymediamanager.core.MediaSource;
import org.tinymediamanager.core.entities.MediaGenres;
import org.tinymediamanager.core.threading.TmmTaskManager;
import org.tinymediamanager.core.tvshow.TvShowList;
import org.tinymediamanager.core.tvshow.TvShowModuleManager;
import org.tinymediamanager.core.tvshow.entities.TvShow;
import org.tinymediamanager.core.tvshow.entities.TvShowEpisode;
import org.tinymediamanager.scraper.util.ListUtils;
import org.tinymediamanager.thirdparty.trakttv.SyncTraktTvTask;
import org.tinymediamanager.ui.IconManager;
import org.tinymediamanager.ui.components.ReadOnlyTextArea;
import org.tinymediamanager.ui.components.TmmLabel;
import org.tinymediamanager.ui.components.combobox.AutocompleteComboBox;
import org.tinymediamanager.ui.dialogs.TmmDialog;

public class TvShowBulkEditorDialog
extends TmmDialog {
    private static final long serialVersionUID = 3527478264068979388L;
    private TvShowList tvShowList = TvShowList.getInstance();
    private List<TvShow> tvShowsToEdit;
    private List<TvShowEpisode> tvShowEpisodesToEdit;
    private boolean episodesChanged = false;
    private boolean tvShowsChanged = false;

    public TvShowBulkEditorDialog(List<TvShow> tvShows, List<TvShowEpisode> episodes) {
        super(BUNDLE.getString("tvshow.bulkedit"), "tvShowBulkEditor");
        this.tvShowsToEdit = tvShows;
        this.tvShowEpisodesToEdit = episodes;
        this.initComponents();
    }

    private void initComponents() {
        JPanel panelContent = new JPanel();
        this.getContentPane().add((Component)panelContent, "Center");
        panelContent.setLayout((LayoutManager)new MigLayout("", "[20lp:n][][200lp:350lp,grow][]", "[][][][][][][shrink 0][][][][][][][][][grow]"));
        TmmLabel lblTvShowT = new TmmLabel(BUNDLE.getString("metatag.tvshow"));
        panelContent.add((Component)lblTvShowT, "cell 0 0 4 1, growx");
        TmmLabel lblGenres = new TmmLabel(BUNDLE.getString("metatag.genre"));
        panelContent.add((Component)lblGenres, "cell 1 1,alignx right");
        AutocompleteComboBox<MediaGenres> cbGenres = new AutocompleteComboBox<MediaGenres>(MediaGenres.values());
        panelContent.add(cbGenres, "cell 2 1, growx, wmin 0");
        cbGenres.setEditable(true);
        JButton btnAddGenre = new JButton();
        panelContent.add((Component)btnAddGenre, "flowx,cell 3 1");
        btnAddGenre.setIcon(IconManager.ADD_INV);
        btnAddGenre.setMargin(new Insets(2, 2, 2, 2));
        btnAddGenre.addActionListener(e -> {
            this.tvShowsChanged = true;
            this.setCursor(Cursor.getPredefinedCursor(3));
            MediaGenres genre = null;
            Object item = cbGenres.getSelectedItem();
            if (item instanceof MediaGenres) {
                genre = (MediaGenres)item;
            }
            if (item instanceof String) {
                genre = MediaGenres.getGenre((String)item);
            }
            if (genre != null) {
                for (TvShow tvShow : this.tvShowsToEdit) {
                    tvShow.addGenre(genre);
                }
            }
            this.setCursor(Cursor.getPredefinedCursor(0));
        });
        JButton btnRemoveGenre = new JButton();
        panelContent.add((Component)btnRemoveGenre, "cell 3 1");
        btnRemoveGenre.setIcon(IconManager.REMOVE_INV);
        btnRemoveGenre.setMargin(new Insets(2, 2, 2, 2));
        btnRemoveGenre.addActionListener(e -> {
            this.tvShowsChanged = true;
            this.setCursor(Cursor.getPredefinedCursor(3));
            MediaGenres genre = (MediaGenres)cbGenres.getSelectedItem();
            for (TvShow tvShow : this.tvShowsToEdit) {
                tvShow.removeGenre(genre);
            }
            this.setCursor(Cursor.getPredefinedCursor(0));
        });
        TmmLabel lblTags = new TmmLabel(BUNDLE.getString("metatag.tags"));
        panelContent.add((Component)lblTags, "cell 1 2,alignx right");
        AutocompleteComboBox<String> cbTags = new AutocompleteComboBox<String>(ListUtils.asSortedList(this.tvShowList.getTagsInTvShows()));
        panelContent.add(cbTags, "cell 2 2, growx, wmin 0");
        cbTags.setEditable(true);
        JButton btnAddTag = new JButton();
        panelContent.add((Component)btnAddTag, "flowx,cell 3 2");
        btnAddTag.setIcon(IconManager.ADD_INV);
        btnAddTag.setMargin(new Insets(2, 2, 2, 2));
        btnAddTag.addActionListener(e -> {
            this.tvShowsChanged = true;
            this.setCursor(Cursor.getPredefinedCursor(3));
            String tag = (String)cbTags.getSelectedItem();
            for (TvShow tvShow : this.tvShowsToEdit) {
                tvShow.addToTags(tag);
            }
            this.setCursor(Cursor.getPredefinedCursor(0));
        });
        JButton btnRemoveTag = new JButton();
        panelContent.add((Component)btnRemoveTag, "cell 3 2");
        btnRemoveTag.setIcon(IconManager.REMOVE_INV);
        btnRemoveTag.setMargin(new Insets(2, 2, 2, 2));
        btnRemoveTag.addActionListener(e -> {
            this.tvShowsChanged = true;
            this.setCursor(Cursor.getPredefinedCursor(3));
            String tag = (String)cbTags.getSelectedItem();
            for (TvShow tvShow : this.tvShowsToEdit) {
                tvShow.removeFromTags(tag);
            }
            this.setCursor(Cursor.getPredefinedCursor(0));
        });
        TmmLabel lblCountry = new TmmLabel(BUNDLE.getString("metatag.country"));
        panelContent.add((Component)lblCountry, "cell 1 3,alignx right");
        JTextField tfCountry = new JTextField();
        panelContent.add((Component)tfCountry, "cell 2 3, growx, wmin 0");
        JButton btnChgCountry = new JButton();
        panelContent.add((Component)btnChgCountry, "flowx, cell 3 3");
        btnChgCountry.setIcon(IconManager.APPLY_INV);
        btnChgCountry.setMargin(new Insets(2, 2, 2, 2));
        btnChgCountry.addActionListener(e -> {
            this.tvShowsChanged = true;
            this.setCursor(Cursor.getPredefinedCursor(3));
            for (TvShow tvShow : this.tvShowsToEdit) {
                tvShow.setCountry(tfCountry.getText());
            }
            this.setCursor(Cursor.getPredefinedCursor(0));
        });
        TmmLabel lblStudio = new TmmLabel(BUNDLE.getString("metatag.studio"));
        panelContent.add((Component)lblStudio, "cell 1 4,alignx right");
        JTextField tfStudio = new JTextField();
        panelContent.add((Component)tfStudio, "cell 2 4, growx, wmin 0");
        JButton btnChgStudio = new JButton();
        panelContent.add((Component)btnChgStudio, "flowx, cell 3 4");
        btnChgStudio.setIcon(IconManager.APPLY_INV);
        btnChgStudio.setMargin(new Insets(2, 2, 2, 2));
        btnChgStudio.addActionListener(e -> {
            this.tvShowsChanged = true;
            this.setCursor(Cursor.getPredefinedCursor(3));
            for (TvShow tvShow : this.tvShowsToEdit) {
                tvShow.setProductionCompany(tfStudio.getText());
            }
            this.setCursor(Cursor.getPredefinedCursor(0));
        });
        TmmLabel lblTvShowNoteT = new TmmLabel(BUNDLE.getString("metatag.note"));
        panelContent.add((Component)lblTvShowNoteT, "cell 1 5,alignx right");
        JTextField tfTvShowNote = new JTextField();
        panelContent.add((Component)tfTvShowNote, "cell 2 5,growx");
        JButton btnTvShowNote = new JButton();
        btnTvShowNote.setIcon(IconManager.APPLY_INV);
        btnTvShowNote.setMargin(new Insets(2, 2, 2, 2));
        btnTvShowNote.addActionListener(e -> {
            this.tvShowsChanged = true;
            this.setCursor(Cursor.getPredefinedCursor(3));
            for (TvShow tvShow : this.tvShowsToEdit) {
                tvShow.setNote(tfTvShowNote.getText());
            }
            this.setCursor(Cursor.getPredefinedCursor(0));
        });
        panelContent.add((Component)btnTvShowNote, "cell 3 5");
        JSeparator separator = new JSeparator();
        panelContent.add((Component)separator, "cell 0 6 4 1, growx");
        TmmLabel lblEpisodeT = new TmmLabel(BUNDLE.getString("metatag.episode"));
        panelContent.add((Component)lblEpisodeT, "cell 0 7 4 1, growx");
        ReadOnlyTextArea textArea = new ReadOnlyTextArea(BUNDLE.getString("tvshow.bulkedit.episodesfromshows"));
        textArea.setWrapStyleWord(true);
        panelContent.add((Component)textArea, "cell 1 8 2 1,grow, wmin 0");
        TmmLabel lblWatched = new TmmLabel(BUNDLE.getString("metatag.watched"));
        panelContent.add((Component)lblWatched, "cell 1 9,alignx right");
        JCheckBox chckbxWatched = new JCheckBox("");
        panelContent.add((Component)chckbxWatched, "cell 2 9");
        JButton btnWatched = new JButton();
        panelContent.add((Component)btnWatched, "cell 3 9");
        btnWatched.setMargin(new Insets(2, 2, 2, 2));
        btnWatched.setIcon(IconManager.APPLY_INV);
        btnWatched.addActionListener(e -> {
            this.episodesChanged = true;
            this.setCursor(Cursor.getPredefinedCursor(3));
            for (TvShowEpisode episode : this.tvShowEpisodesToEdit) {
                episode.setWatched(chckbxWatched.isSelected());
            }
            this.setCursor(Cursor.getPredefinedCursor(0));
        });
        TmmLabel lblSeason = new TmmLabel(BUNDLE.getString("metatag.season"));
        panelContent.add((Component)lblSeason, "cell 1 10,alignx right");
        JSpinner spSeason = new JSpinner();
        panelContent.add((Component)spSeason, "cell 2 10");
        spSeason.setPreferredSize(new Dimension(40, 20));
        spSeason.setMinimumSize(new Dimension(40, 20));
        JButton btnSeason = new JButton();
        panelContent.add((Component)btnSeason, "cell 3 10");
        btnSeason.setIcon(IconManager.APPLY_INV);
        btnSeason.setMargin(new Insets(2, 2, 2, 2));
        btnSeason.addActionListener(arg0 -> {
            this.episodesChanged = true;
            this.setCursor(Cursor.getPredefinedCursor(3));
            for (TvShowEpisode episode : this.tvShowEpisodesToEdit) {
                Integer season = (Integer)spSeason.getValue();
                episode.setSeason(season);
            }
            this.setCursor(Cursor.getPredefinedCursor(0));
        });
        TmmLabel lblDvdOrder = new TmmLabel(BUNDLE.getString("metatag.dvdorder"));
        panelContent.add((Component)lblDvdOrder, "cell 1 11,alignx right");
        JCheckBox cbDvdOrder = new JCheckBox("");
        panelContent.add((Component)cbDvdOrder, "cell 2 11");
        JButton btnDvdOrder = new JButton();
        panelContent.add((Component)btnDvdOrder, "cell 3 11");
        btnDvdOrder.setIcon(IconManager.APPLY_INV);
        btnDvdOrder.setMargin(new Insets(2, 2, 2, 2));
        btnDvdOrder.addActionListener(arg0 -> {
            this.episodesChanged = true;
            this.setCursor(Cursor.getPredefinedCursor(3));
            for (TvShowEpisode episode : this.tvShowEpisodesToEdit) {
                episode.setDvdOrder(cbDvdOrder.isSelected());
            }
            this.setCursor(Cursor.getPredefinedCursor(0));
        });
        TmmLabel lblTagsEpisode = new TmmLabel(BUNDLE.getString("metatag.tags"));
        panelContent.add((Component)lblTagsEpisode, "cell 1 12,alignx right");
        AutocompleteComboBox<Object> cbTagsEpisode = new AutocompleteComboBox<Object>(this.tvShowList.getTagsInEpisodes().toArray());
        panelContent.add(cbTagsEpisode, "cell 2 12,growx,wmin 0");
        cbTagsEpisode.setEditable(true);
        JButton btnAddTagEpisode = new JButton();
        panelContent.add((Component)btnAddTagEpisode, "flowx,cell 3 12");
        btnAddTagEpisode.setIcon(IconManager.ADD_INV);
        btnAddTagEpisode.setMargin(new Insets(2, 2, 2, 2));
        btnAddTagEpisode.addActionListener(e -> {
            this.episodesChanged = true;
            this.setCursor(Cursor.getPredefinedCursor(3));
            String tag = (String)cbTagsEpisode.getSelectedItem();
            for (TvShowEpisode episode : this.tvShowEpisodesToEdit) {
                episode.addToTags(tag);
            }
            this.setCursor(Cursor.getPredefinedCursor(0));
        });
        JButton btnRemoveTagEpisode = new JButton();
        panelContent.add((Component)btnRemoveTagEpisode, "cell 3 12");
        btnRemoveTagEpisode.setIcon(IconManager.REMOVE_INV);
        btnRemoveTagEpisode.setMargin(new Insets(2, 2, 2, 2));
        btnRemoveTagEpisode.addActionListener(e -> {
            this.episodesChanged = true;
            this.setCursor(Cursor.getPredefinedCursor(3));
            String tag = (String)cbTagsEpisode.getSelectedItem();
            for (TvShowEpisode episode : this.tvShowEpisodesToEdit) {
                episode.removeFromTags(tag);
            }
            this.setCursor(Cursor.getPredefinedCursor(0));
        });
        TmmLabel lblMediasourceEpisode = new TmmLabel(BUNDLE.getString("metatag.source"));
        panelContent.add((Component)lblMediasourceEpisode, "cell 1 13,alignx right");
        JComboBox<MediaSource> cbMediaSourceEpisode = new JComboBox<MediaSource>(MediaSource.values());
        panelContent.add(cbMediaSourceEpisode, "cell 2 13,growx,wmin 0");
        JButton btnMediaSourceEpisode = new JButton();
        panelContent.add((Component)btnMediaSourceEpisode, "cell 3 13");
        btnMediaSourceEpisode.setMargin(new Insets(2, 2, 2, 2));
        btnMediaSourceEpisode.setIcon(IconManager.APPLY_INV);
        btnMediaSourceEpisode.addActionListener(e -> {
            this.episodesChanged = true;
            Object obj = cbMediaSourceEpisode.getSelectedItem();
            if (obj instanceof MediaSource) {
                MediaSource mediaSource = (MediaSource)obj;
                this.setCursor(Cursor.getPredefinedCursor(3));
                for (TvShowEpisode episode : this.tvShowEpisodesToEdit) {
                    episode.setMediaSource(mediaSource);
                }
                this.setCursor(Cursor.getPredefinedCursor(0));
            }
        });
        TmmLabel lblEpisodeNoteT = new TmmLabel(BUNDLE.getString("metatag.note"));
        panelContent.add((Component)lblEpisodeNoteT, "cell 1 14,alignx right");
        JTextField tfEpisodeNote = new JTextField();
        panelContent.add((Component)tfEpisodeNote, "cell 2 14,growx");
        JButton btnEpisodeNote = new JButton();
        btnEpisodeNote.setMargin(new Insets(2, 2, 2, 2));
        btnEpisodeNote.setIcon(IconManager.APPLY_INV);
        btnEpisodeNote.addActionListener(e -> {
            this.episodesChanged = true;
            this.setCursor(Cursor.getPredefinedCursor(3));
            for (TvShowEpisode episode : this.tvShowEpisodesToEdit) {
                episode.setNote(tfEpisodeNote.getText());
            }
            this.setCursor(Cursor.getPredefinedCursor(0));
        });
        panelContent.add((Component)btnEpisodeNote, "cell 3 14");
        JButton btnClose = new JButton(BUNDLE.getString("Button.close"));
        btnClose.setIcon(IconManager.APPLY_INV);
        btnClose.addActionListener(arg0 -> {
            if (this.tvShowsChanged) {
                this.setCursor(Cursor.getPredefinedCursor(3));
                for (TvShow tvShow : this.tvShowsToEdit) {
                    tvShow.writeNFO();
                    tvShow.saveToDb();
                }
                this.setCursor(Cursor.getPredefinedCursor(0));
            }
            if (this.episodesChanged) {
                this.setCursor(Cursor.getPredefinedCursor(3));
                for (TvShowEpisode tvShowEpisode : this.tvShowEpisodesToEdit) {
                    tvShowEpisode.writeNFO();
                    tvShowEpisode.saveToDb();
                }
                this.setCursor(Cursor.getPredefinedCursor(0));
            }
            if (TvShowModuleManager.SETTINGS.getSyncTrakt()) {
                HashSet<TvShow> tvShows1 = new HashSet<TvShow>();
                for (TvShowEpisode episode : this.tvShowEpisodesToEdit) {
                    tvShows1.add(episode.getTvShow());
                }
                tvShows1.addAll(this.tvShowsToEdit);
                SyncTraktTvTask syncTraktTvTask = new SyncTraktTvTask(null, new ArrayList<TvShow>(tvShows1));
                TmmTaskManager.getInstance().addUnnamedTask(syncTraktTvTask);
            }
            this.setVisible(false);
        });
        this.addDefaultButton(btnClose);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                if (TvShowBulkEditorDialog.this.tvShowsChanged) {
                    TvShowBulkEditorDialog.this.setCursor(Cursor.getPredefinedCursor(3));
                    for (TvShow tvShow : TvShowBulkEditorDialog.this.tvShowsToEdit) {
                        tvShow.writeNFO();
                        tvShow.saveToDb();
                    }
                    TvShowBulkEditorDialog.this.setCursor(Cursor.getPredefinedCursor(0));
                }
                if (TvShowBulkEditorDialog.this.episodesChanged) {
                    TvShowBulkEditorDialog.this.setCursor(Cursor.getPredefinedCursor(3));
                    for (TvShowEpisode episode : TvShowBulkEditorDialog.this.tvShowEpisodesToEdit) {
                        episode.writeNFO();
                        episode.saveToDb();
                    }
                    TvShowBulkEditorDialog.this.setCursor(Cursor.getPredefinedCursor(0));
                }
            }
        });
    }
}

