/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.tvshows.actions;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.KeyStroke;
import org.tinymediamanager.core.UTF8Control;
import org.tinymediamanager.core.threading.TmmTaskManager;
import org.tinymediamanager.core.tvshow.TvShowEpisodeScraperMetadataConfig;
import org.tinymediamanager.core.tvshow.TvShowEpisodeSearchAndScrapeOptions;
import org.tinymediamanager.core.tvshow.TvShowList;
import org.tinymediamanager.core.tvshow.entities.TvShow;
import org.tinymediamanager.core.tvshow.entities.TvShowEpisode;
import org.tinymediamanager.core.tvshow.tasks.TvShowEpisodeScrapeTask;
import org.tinymediamanager.ui.IconManager;
import org.tinymediamanager.ui.MainWindow;
import org.tinymediamanager.ui.actions.TmmAction;
import org.tinymediamanager.ui.tvshows.dialogs.TvShowChooserDialog;
import org.tinymediamanager.ui.tvshows.dialogs.TvShowScrapeMetadataDialog;

public class TvShowScrapeNewItemsAction
extends TmmAction {
    private static final long serialVersionUID = -3365542777082781952L;
    private static final ResourceBundle BUNDLE = ResourceBundle.getBundle("messages", new UTF8Control());

    public TvShowScrapeNewItemsAction() {
        this.putValue("Name", BUNDLE.getString("tvshow.scrape.newitems"));
        this.putValue("SwingLargeIconKey", IconManager.SEARCH);
        this.putValue("SmallIcon", IconManager.SEARCH);
        this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(78, 192));
    }

    @Override
    protected void processAction(ActionEvent e) {
        ArrayList<TvShow> newTvShows = new ArrayList<TvShow>();
        ArrayList<TvShowEpisode> newEpisodes = new ArrayList<TvShowEpisode>();
        for (TvShow tvShow : new ArrayList<TvShow>(TvShowList.getInstance().getTvShows())) {
            if (tvShow.isNewlyAdded() && !tvShow.isScraped()) {
                newTvShows.add(tvShow);
                continue;
            }
            for (TvShowEpisode episode : tvShow.getEpisodes()) {
                if (!episode.isNewlyAdded() || episode.isScraped()) continue;
                newEpisodes.add(episode);
            }
        }
        if (!newTvShows.isEmpty()) {
            int count = newTvShows.size();
            int index = 0;
            do {
                TvShow tvShow = (TvShow)newTvShows.get(index);
                TvShowChooserDialog chooser = new TvShowChooserDialog(tvShow, index, count);
                chooser.setVisible(true);
                if (!chooser.isContinueQueue()) break;
                if (chooser.isNavigateBack()) {
                    --index;
                    continue;
                }
                ++index;
            } while (index < count);
        }
        if (!newEpisodes.isEmpty()) {
            TvShowScrapeMetadataDialog dialog = new TvShowScrapeMetadataDialog(BUNDLE.getString("tvshowepisode.scrape"), true, true, false, true, true);
            dialog.setLocationRelativeTo(MainWindow.getActiveInstance());
            dialog.setVisible(true);
            TvShowEpisodeSearchAndScrapeOptions options = dialog.getTvShowEpisodeSearchAndScrapeOptions();
            List<TvShowEpisodeScraperMetadataConfig> episodeScraperMetadataConfig = dialog.getTvShowEpisodeScraperMetadataConfig();
            if (dialog.shouldStartScrape()) {
                TvShowEpisodeScrapeTask task = new TvShowEpisodeScrapeTask(newEpisodes, options, episodeScraperMetadataConfig);
                TmmTaskManager.getInstance().addUnnamedTask(task);
            }
        }
    }
}

