/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.tvshows.actions;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;
import org.tinymediamanager.core.TmmProperties;
import org.tinymediamanager.core.UTF8Control;
import org.tinymediamanager.core.threading.TmmTaskManager;
import org.tinymediamanager.core.tvshow.entities.TvShow;
import org.tinymediamanager.core.tvshow.entities.TvShowEpisode;
import org.tinymediamanager.core.tvshow.entities.TvShowSeason;
import org.tinymediamanager.core.tvshow.tasks.TvShowRenameTask;
import org.tinymediamanager.ui.MainWindow;
import org.tinymediamanager.ui.TmmFontHelper;
import org.tinymediamanager.ui.actions.TmmAction;
import org.tinymediamanager.ui.tvshows.TvShowUIModule;

public class TvShowRenameAction
extends TmmAction {
    private static final long serialVersionUID = -8988748633666277616L;
    private static final ResourceBundle BUNDLE = ResourceBundle.getBundle("messages", new UTF8Control());

    public TvShowRenameAction() {
        this.putValue("Name", BUNDLE.getString("tvshow.rename"));
        this.putValue("ShortDescription", BUNDLE.getString("tvshow.rename"));
        this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(82, 192));
    }

    @Override
    protected void processAction(ActionEvent e) {
        List<TvShow> selectedTvShows = TvShowUIModule.getInstance().getSelectionModel().getSelectedTvShows();
        HashSet<TvShowEpisode> selectedEpisodes = new HashSet<TvShowEpisode>();
        for (Object obj : TvShowUIModule.getInstance().getSelectionModel().getSelectedObjects()) {
            TvShowEpisode episode;
            if (obj instanceof TvShowEpisode && !selectedTvShows.contains((episode = (TvShowEpisode)obj).getTvShow())) {
                selectedEpisodes.add(episode);
            }
            if (!(obj instanceof TvShowSeason)) continue;
            TvShowSeason season = (TvShowSeason)obj;
            selectedEpisodes.addAll(season.getEpisodes());
        }
        if (selectedEpisodes.isEmpty() && selectedTvShows.isEmpty()) {
            JOptionPane.showMessageDialog(MainWindow.getActiveInstance(), BUNDLE.getString("tmm.nothingselected"));
            return;
        }
        if (!TmmProperties.getInstance().getPropertyAsBoolean("tvshow.hiderenamehint").booleanValue()) {
            JCheckBox checkBox = new JCheckBox(BUNDLE.getString("tmm.donotshowagain"));
            TmmFontHelper.changeFont((JComponent)checkBox, TmmFontHelper.L1);
            checkBox.setBorder(BorderFactory.createEmptyBorder(10, 0, 0, 0));
            Object[] params = new Object[]{BUNDLE.getString("tvshow.rename.desc"), checkBox};
            Object[] options = new Object[]{BUNDLE.getString("Button.yes"), BUNDLE.getString("Button.no")};
            int answer = JOptionPane.showOptionDialog(MainWindow.getActiveInstance(), params, BUNDLE.getString("tvshow.rename"), 0, 3, null, options, null);
            if (checkBox.isSelected()) {
                TmmProperties.getInstance().putProperty("tvshow.hiderenamehint", String.valueOf(checkBox.isSelected()));
            }
            if (answer != 0) {
                return;
            }
        }
        TvShowRenameTask renameTask = new TvShowRenameTask(selectedTvShows, new ArrayList<TvShowEpisode>(selectedEpisodes), true);
        TmmTaskManager.getInstance().addMainTask(renameTask);
    }
}

