/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.tvshows.actions;

import java.awt.event.ActionEvent;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.JOptionPane;
import org.tinymediamanager.core.MediaFileType;
import org.tinymediamanager.core.UTF8Control;
import org.tinymediamanager.core.entities.MediaFile;
import org.tinymediamanager.core.threading.TmmTask;
import org.tinymediamanager.core.threading.TmmTaskHandle;
import org.tinymediamanager.core.threading.TmmTaskManager;
import org.tinymediamanager.core.tvshow.connector.TvShowNfoParser;
import org.tinymediamanager.core.tvshow.entities.TvShow;
import org.tinymediamanager.ui.MainWindow;
import org.tinymediamanager.ui.actions.TmmAction;
import org.tinymediamanager.ui.tvshows.TvShowUIModule;

public class TvShowReadNfoAction
extends TmmAction {
    private static final long serialVersionUID = -6575156436788397648L;
    private static final ResourceBundle BUNDLE = ResourceBundle.getBundle("messages", new UTF8Control());

    public TvShowReadNfoAction() {
        this.putValue("Name", BUNDLE.getString("tvshow.readnfo"));
        this.putValue("ShortDescription", BUNDLE.getString("tvshow.readnfo.desc"));
    }

    @Override
    protected void processAction(ActionEvent e) {
        final List<TvShow> selectedTvShows = TvShowUIModule.getInstance().getSelectionModel().getSelectedTvShows();
        if (selectedTvShows.isEmpty()) {
            JOptionPane.showMessageDialog(MainWindow.getActiveInstance(), BUNDLE.getString("tmm.nothingselected"));
            return;
        }
        TmmTaskManager.getInstance().addUnnamedTask(new TmmTask(BUNDLE.getString("tvshow.rewritenfo"), selectedTvShows.size(), TmmTaskHandle.TaskType.BACKGROUND_TASK){

            @Override
            protected void doInBackground() {
                int i = 0;
                for (TvShow tvShow : selectedTvShows) {
                    TvShow tempTvShow = null;
                    for (MediaFile mf : tvShow.getMediaFiles(MediaFileType.NFO)) {
                        if (tempTvShow == null) {
                            try {
                                tempTvShow = TvShowNfoParser.parseNfo(mf.getFileAsPath()).toTvShow();
                            }
                            catch (Exception exception) {}
                            continue;
                        }
                        if (tempTvShow == null) continue;
                        try {
                            tempTvShow.merge(TvShowNfoParser.parseNfo(mf.getFileAsPath()).toTvShow());
                        }
                        catch (Exception exception) {}
                    }
                    if (tempTvShow != null) {
                        tvShow.forceMerge(tempTvShow);
                        tvShow.saveToDb();
                    }
                    this.publishState(++i);
                    if (!this.cancel) continue;
                    break;
                }
            }
        });
    }
}

