/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.tvshows.actions;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.JOptionPane;
import org.tinymediamanager.core.UTF8Control;
import org.tinymediamanager.core.tvshow.entities.TvShow;
import org.tinymediamanager.core.tvshow.entities.TvShowEpisode;
import org.tinymediamanager.core.tvshow.entities.TvShowSeason;
import org.tinymediamanager.ui.IconManager;
import org.tinymediamanager.ui.MainWindow;
import org.tinymediamanager.ui.actions.TmmAction;
import org.tinymediamanager.ui.tvshows.TvShowUIModule;

public class TvShowChangeToAiredOrderAction
extends TmmAction {
    private static final long serialVersionUID = 7866485217093335182L;
    private static final ResourceBundle BUNDLE = ResourceBundle.getBundle("messages", new UTF8Control());

    public TvShowChangeToAiredOrderAction() {
        this.putValue("Name", BUNDLE.getString("tvshow.changefromdvdorder"));
        this.putValue("ShortDescription", BUNDLE.getString("tvshow.changeorder.desc"));
        this.putValue("SwingLargeIconKey", IconManager.EDIT);
        this.putValue("SmallIcon", IconManager.EDIT);
    }

    @Override
    protected void processAction(ActionEvent e) {
        List<Object> selectedObjects = TvShowUIModule.getInstance().getSelectionModel().getSelectedObjects();
        ArrayList<TvShowEpisode> selectedEpisodes = new ArrayList<TvShowEpisode>();
        for (Object obj : selectedObjects) {
            if (obj instanceof TvShow) {
                TvShow tvShow = (TvShow)obj;
                selectedEpisodes.addAll(tvShow.getEpisodes());
            }
            if (obj instanceof TvShowSeason) {
                TvShowSeason season = (TvShowSeason)obj;
                selectedEpisodes.addAll(season.getEpisodes());
            }
            if (!(obj instanceof TvShowEpisode)) continue;
            TvShowEpisode tvShowEpisode = (TvShowEpisode)obj;
            selectedEpisodes.add(tvShowEpisode);
        }
        if (selectedEpisodes.isEmpty()) {
            JOptionPane.showMessageDialog(MainWindow.getActiveInstance(), BUNDLE.getString("tmm.nothingselected"));
            return;
        }
        for (TvShowEpisode episode : selectedEpisodes) {
            if (!episode.isDvdOrder()) continue;
            episode.setDvdOrder(false);
            episode.setAiredSeason(episode.getDvdSeason());
            episode.setAiredEpisode(episode.getDvdEpisode());
            episode.setDvdEpisode(-1);
            episode.setDvdSeason(-1);
            episode.writeNFO();
            episode.saveToDb();
        }
    }
}

