/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.tvshows.actions;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.JOptionPane;
import org.tinymediamanager.core.UTF8Control;
import org.tinymediamanager.core.tvshow.entities.TvShowSeason;
import org.tinymediamanager.ui.IconManager;
import org.tinymediamanager.ui.MainWindow;
import org.tinymediamanager.ui.actions.TmmAction;
import org.tinymediamanager.ui.tvshows.TvShowUIModule;
import org.tinymediamanager.ui.tvshows.dialogs.TvShowSeasonEditorDialog;

public class TvShowChangeSeasonArtworkAction
extends TmmAction {
    private static final long serialVersionUID = 8356413227405772558L;
    private static final ResourceBundle BUNDLE = ResourceBundle.getBundle("messages", new UTF8Control());

    public TvShowChangeSeasonArtworkAction() {
        this.putValue("Name", BUNDLE.getString("tvshow.changeseasonartwork"));
        this.putValue("SwingLargeIconKey", IconManager.EDIT);
        this.putValue("SmallIcon", IconManager.EDIT);
        this.putValue("ShortDescription", BUNDLE.getString("tvshow.changeseasonartwork"));
    }

    @Override
    protected void processAction(ActionEvent e) {
        List<Object> selectedObjects = TvShowUIModule.getInstance().getSelectionModel().getSelectedObjects();
        ArrayList<TvShowSeason> selectTvShowSeasons = new ArrayList<TvShowSeason>();
        for (Object obj : selectedObjects) {
            if (!(obj instanceof TvShowSeason)) continue;
            selectTvShowSeasons.add((TvShowSeason)obj);
        }
        if (selectTvShowSeasons.isEmpty()) {
            JOptionPane.showMessageDialog(MainWindow.getActiveInstance(), BUNDLE.getString("tmm.nothingselected"));
            return;
        }
        int selectedCount = selectTvShowSeasons.size();
        int index = 0;
        do {
            TvShowSeason season = (TvShowSeason)selectTvShowSeasons.get(index);
            TvShowSeasonEditorDialog editor = new TvShowSeasonEditorDialog(season, index, selectedCount);
            editor.setVisible(true);
            if (!editor.isContinueQueue()) break;
            if (editor.isNavigateBack()) {
                --index;
                continue;
            }
            ++index;
        } while (index < selectedCount);
    }
}

