/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.settings;

import java.awt.Component;
import java.awt.LayoutManager;
import java.util.ResourceBundle;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang3.StringUtils;
import org.jdesktop.beansbinding.AutoBinding;
import org.jdesktop.beansbinding.BeanProperty;
import org.jdesktop.beansbinding.Property;
import org.jdesktop.swingbinding.JListBinding;
import org.jdesktop.swingbinding.SwingBindings;
import org.tinymediamanager.Globals;
import org.tinymediamanager.core.Settings;
import org.tinymediamanager.core.UTF8Control;
import org.tinymediamanager.core.movie.MovieList;
import org.tinymediamanager.core.tvshow.TvShowList;
import org.tinymediamanager.ui.IconManager;
import org.tinymediamanager.ui.TmmFontHelper;
import org.tinymediamanager.ui.components.CollapsiblePanel;
import org.tinymediamanager.ui.components.ReadOnlyTextArea;
import org.tinymediamanager.ui.components.TmmLabel;

class SortTitleSettingsPanel
extends JPanel {
    private static final long serialVersionUID = 1857926059556024932L;
    private static final ResourceBundle BUNDLE = ResourceBundle.getBundle("messages", new UTF8Control());
    private Settings settings = Settings.getInstance();
    private JList<String> listSortPrefixes;
    private JTextField tfSortPrefix;
    private JButton btnRemoveSortPrefix;
    private JButton btnAddSortPrefix;

    SortTitleSettingsPanel() {
        this.initComponents();
        this.initDataBindings();
        this.btnAddSortPrefix.addActionListener(e -> {
            if (StringUtils.isNotEmpty((CharSequence)this.tfSortPrefix.getText())) {
                Globals.settings.addTitlePrefix(this.tfSortPrefix.getText());
                this.tfSortPrefix.setText("");
                MovieList.getInstance().invalidateTitleSortable();
                TvShowList.getInstance().invalidateTitleSortable();
            }
        });
        this.btnRemoveSortPrefix.addActionListener(arg0 -> {
            int row = this.listSortPrefixes.getSelectedIndex();
            if (row != -1) {
                String prefix = Globals.settings.getTitlePrefix().get(row);
                Globals.settings.removeTitlePrefix(prefix);
                MovieList.getInstance().invalidateTitleSortable();
                TvShowList.getInstance().invalidateTitleSortable();
            }
        });
    }

    private void initComponents() {
        this.setLayout((LayoutManager)new MigLayout("", "[grow]", "[]"));
        JPanel panelSorttitle = new JPanel((LayoutManager)new MigLayout("hidemode 1, insets 0", "[20lp!][100lp][][grow]", "[]"));
        TmmLabel lblSorttitleT = new TmmLabel(BUNDLE.getString("Settings.sorting"), TmmFontHelper.H3);
        CollapsiblePanel collapsiblePanel = new CollapsiblePanel((JComponent)panelSorttitle, lblSorttitleT, true);
        this.add((Component)collapsiblePanel, "cell 0 0,growx, wmin 0");
        ReadOnlyTextArea tpSortingHint = new ReadOnlyTextArea(BUNDLE.getString("Settings.sorting.info"));
        panelSorttitle.add((Component)tpSortingHint, "cell 1 0 3 1,growx");
        JScrollPane scrollPane = new JScrollPane();
        panelSorttitle.add((Component)scrollPane, "cell 1 1,grow");
        this.listSortPrefixes = new JList();
        scrollPane.setViewportView(this.listSortPrefixes);
        this.btnRemoveSortPrefix = new JButton(IconManager.REMOVE_INV);
        this.btnRemoveSortPrefix.setToolTipText(BUNDLE.getString("Button.remove"));
        panelSorttitle.add((Component)this.btnRemoveSortPrefix, "cell 2 1,aligny bottom, growx");
        this.tfSortPrefix = new JTextField();
        panelSorttitle.add((Component)this.tfSortPrefix, "cell 1 2,growx");
        this.btnAddSortPrefix = new JButton(IconManager.ADD_INV);
        this.btnAddSortPrefix.setToolTipText(BUNDLE.getString("Button.add"));
        panelSorttitle.add((Component)this.btnAddSortPrefix, "cell 2 2, growx");
    }

    protected void initDataBindings() {
        BeanProperty settingsBeanProperty_1 = BeanProperty.create((String)"titlePrefix");
        JListBinding jListBinding = SwingBindings.createJListBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)settingsBeanProperty_1, this.listSortPrefixes);
        jListBinding.bind();
    }
}

