/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.settings;

import java.awt.Component;
import java.awt.LayoutManager;
import java.util.Map;
import java.util.ResourceBundle;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang3.StringUtils;
import org.tinymediamanager.Globals;
import org.tinymediamanager.core.UTF8Control;
import org.tinymediamanager.thirdparty.trakttv.TraktTv;
import org.tinymediamanager.ui.MainWindow;
import org.tinymediamanager.ui.TmmFontHelper;
import org.tinymediamanager.ui.TmmUIHelper;
import org.tinymediamanager.ui.components.CollapsiblePanel;
import org.tinymediamanager.ui.components.SettingsPanelFactory;
import org.tinymediamanager.ui.components.TmmLabel;

class ExternalServicesSettingsPanel
extends JPanel {
    private static final long serialVersionUID = 7266564870819511988L;
    private static final ResourceBundle BUNDLE = ResourceBundle.getBundle("messages", new UTF8Control());
    private JButton btnGetTraktPin;
    private JButton btnTestTraktConnection;
    private JLabel lblTraktStatus;

    ExternalServicesSettingsPanel() {
        this.initComponents();
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{Globals.settings.getTraktAccessToken(), Globals.settings.getTraktRefreshToken()})) {
            this.lblTraktStatus.setText(BUNDLE.getString("Settings.trakt.status.good"));
        } else {
            this.lblTraktStatus.setText(BUNDLE.getString("Settings.trakt.status.bad"));
        }
        this.btnGetTraktPin.addActionListener(e -> this.getTraktPin());
        this.btnTestTraktConnection.addActionListener(e -> {
            try {
                TraktTv.getInstance().refreshAccessToken();
                JOptionPane.showMessageDialog(MainWindow.getFrame(), BUNDLE.getString("Settings.trakt.testconnection.good"), BUNDLE.getString("Settings.trakt.testconnection"), 1);
            }
            catch (Exception e1) {
                JOptionPane.showMessageDialog(MainWindow.getFrame(), BUNDLE.getString("Settings.trakt.testconnection.bad"), BUNDLE.getString("Settings.trakt.testconnection"), 0);
            }
        });
    }

    private void getTraktPin() {
        try {
            TmmUIHelper.browseUrl("https://trakt.tv/pin/799");
        }
        catch (Exception e1) {
            JOptionPane.showMessageDialog(MainWindow.getFrame(), BUNDLE.getString("Settings.trakt.getpin.fallback"), BUNDLE.getString("Settings.trakt.getpin"), 1);
        }
        String pin = JOptionPane.showInputDialog(MainWindow.getFrame(), (Object)BUNDLE.getString("Settings.trakt.getpin.entercode"));
        String accessToken = "";
        String refreshToken = "";
        try {
            Map<String, String> tokens = TraktTv.getInstance().authenticateViaPin(pin);
            accessToken = tokens.get("accessToken") == null ? "" : tokens.get("accessToken");
            refreshToken = tokens.get("refreshToken") == null ? "" : tokens.get("refreshToken");
        }
        catch (Exception exception) {
            // empty catch block
        }
        Globals.settings.setTraktAccessToken(accessToken);
        Globals.settings.setTraktRefreshToken(refreshToken);
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{Globals.settings.getTraktAccessToken(), Globals.settings.getTraktRefreshToken()})) {
            this.lblTraktStatus.setText(BUNDLE.getString("Settings.trakt.status.good"));
        } else {
            JOptionPane.showMessageDialog(MainWindow.getFrame(), BUNDLE.getString("Settings.trakt.getpin.problem"), BUNDLE.getString("Settings.trakt.getpin"), 0);
            this.lblTraktStatus.setText(BUNDLE.getString("Settings.trakt.status.bad"));
        }
    }

    private void initComponents() {
        this.setLayout((LayoutManager)new MigLayout("", "[grow]", "[]"));
        JPanel panelTrakt = SettingsPanelFactory.createSettingsPanel();
        TmmLabel lblTraktT = new TmmLabel(BUNDLE.getString("Settings.trakt"), TmmFontHelper.H3);
        CollapsiblePanel collapsiblePanel = new CollapsiblePanel((JComponent)panelTrakt, lblTraktT, true);
        this.add((Component)collapsiblePanel, "cell 0 0,growx, wmin 0");
        this.lblTraktStatus = new JLabel("");
        panelTrakt.add((Component)this.lblTraktStatus, "cell 1 0 2 1");
        this.btnGetTraktPin = new JButton(BUNDLE.getString("Settings.trakt.getpin"));
        panelTrakt.add((Component)this.btnGetTraktPin, "cell 1 1 2 1");
        this.btnTestTraktConnection = new JButton(BUNDLE.getString("Settings.trakt.testconnection"));
        panelTrakt.add((Component)this.btnTestTraktConnection, "cell 1 1");
    }
}

