/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.plaf.light;

import com.jtattoo.plaf.AbstractBorderFactory;
import com.jtattoo.plaf.AbstractIconFactory;
import com.jtattoo.plaf.AbstractLookAndFeel;
import com.jtattoo.plaf.AbstractTheme;
import java.util.Properties;
import org.tinymediamanager.ui.plaf.TmmBorders;
import org.tinymediamanager.ui.plaf.TmmLookAndFeel;
import org.tinymediamanager.ui.plaf.light.TmmLightBorderFactory;
import org.tinymediamanager.ui.plaf.light.TmmLightDefaultTheme;
import org.tinymediamanager.ui.plaf.light.TmmLightIconFactory;

public class TmmLightLookAndFeel
extends TmmLookAndFeel {
    private static final long serialVersionUID = 7771660244511173072L;
    private static TmmLightDefaultTheme myTheme = null;

    public static void setTheme(String name) {
        TmmLightLookAndFeel.setTheme((Properties)themesMap.get(name));
        if (myTheme != null) {
            AbstractTheme.setInternalName(name);
        }
    }

    public static void setTheme(String name, String licenseKey, String logoString) {
        Properties props = (Properties)themesMap.get(name);
        if (props != null) {
            props.put("licenseKey", licenseKey);
            props.put("logoString", logoString);
            TmmLightLookAndFeel.setTheme(props);
            if (myTheme != null) {
                AbstractTheme.setInternalName(name);
            }
        }
    }

    public static void setTheme(Properties themesProps) {
        TmmBorders.initDefaults();
        if (myTheme == null) {
            myTheme = new TmmLightDefaultTheme();
        }
        if (myTheme != null && themesProps != null) {
            myTheme.setUpColor();
            myTheme.setProperties(themesProps);
            myTheme.setUpColorArrs();
            AbstractLookAndFeel.setTheme(myTheme);
        }
    }

    public static void setCurrentTheme(Properties themesProps) {
        TmmLightLookAndFeel.setTheme(themesProps);
    }

    @Override
    public String getName() {
        return "tmmLight";
    }

    @Override
    public String getID() {
        return "tmmLight";
    }

    @Override
    public String getDescription() {
        return "The tinyMediaManager light Look and Feel";
    }

    @Override
    public AbstractBorderFactory getBorderFactory() {
        return TmmLightBorderFactory.getInstance();
    }

    @Override
    public AbstractIconFactory getIconFactory() {
        return TmmLightIconFactory.getInstance();
    }

    @Override
    protected void createDefaultTheme() {
        if (myTheme == null) {
            myTheme = new TmmLightDefaultTheme();
        }
        TmmLightLookAndFeel.setTheme(myTheme);
    }
}

