/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.plaf;

import com.jtattoo.plaf.AbstractLookAndFeel;
import com.jtattoo.plaf.BaseToggleButtonUI;
import com.jtattoo.plaf.ColorHelper;
import com.jtattoo.plaf.JTattooUtilities;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.JComponent;
import javax.swing.JMenuBar;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.ComponentUI;

public class TmmToggleButtonUI
extends BaseToggleButtonUI {
    protected boolean isFlatButton = false;
    protected int focusWidth = 2;

    public static ComponentUI createUI(JComponent c) {
        return new TmmToggleButtonUI();
    }

    @Override
    public void installDefaults(AbstractButton b) {
        super.installDefaults(b);
        Object prop = b.getClientProperty("flatButton");
        if (prop != null && prop instanceof Boolean) {
            this.isFlatButton = (Boolean)prop;
        }
        b.setOpaque(false);
        b.setFocusPainted(false);
    }

    @Override
    protected void paintBackground(Graphics g, AbstractButton b) {
        if (this.isFlatButton || !b.isContentAreaFilled() || b.getParent() instanceof JMenuBar) {
            return;
        }
        Graphics2D g2D = (Graphics2D)g;
        Object savedRederingHint = g2D.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
        g2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        int width = b.getWidth();
        int height = b.getHeight();
        int borderRadius = (int)((double)b.getHeight() * 0.9 - (double)(2 * this.focusWidth));
        int x = this.focusWidth;
        int y = this.focusWidth;
        int w = width - 2 * this.focusWidth;
        int h = height - 2 * this.focusWidth;
        ButtonModel model = b.getModel();
        if (b.isRolloverEnabled() && model.isRollover()) {
            g2D.setColor(AbstractLookAndFeel.getFocusColor());
            Composite oldComposite = g2D.getComposite();
            for (int i = this.focusWidth; i > 0; --i) {
                float opacity = 1.0f - 2.0f * (float)i * (float)i / 10.0f;
                g2D.setComposite(AlphaComposite.getInstance(3, opacity));
                g2D.fillRoundRect(x - i, y - i, w + 2 * i, h + 2 * i, borderRadius + i, borderRadius + i);
            }
            g2D.setComposite(oldComposite);
        }
        if (model.isPressed() && model.isArmed() || model.isSelected()) {
            g2D.setColor(AbstractLookAndFeel.getTheme().getPressedBackgroundColor());
        } else {
            g2D.setColor(AbstractLookAndFeel.getButtonBackgroundColor());
        }
        g2D.fillRoundRect(x, y, w, h, borderRadius, borderRadius);
        g2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, savedRederingHint);
    }

    @Override
    protected void paintText(Graphics g, AbstractButton b, Rectangle textRect, String text) {
        ButtonModel model = b.getModel();
        FontMetrics fm = this.getFontMetrics(b, g, b.getFont());
        int mnemIndex = b.getDisplayedMnemonicIndex();
        if (model.isEnabled()) {
            Object sc;
            Color foreground = b.getForeground();
            Color background = b.getBackground();
            int offs = 0;
            if (model.isArmed() && model.isPressed() || model.isSelected()) {
                offs = 0;
            }
            if (!(model.isPressed() && model.isArmed() || !((sc = b.getClientProperty("shadowColor")) instanceof Color))) {
                g.setColor((Color)sc);
                JTattooUtilities.drawStringUnderlineCharAt(b, g, text, mnemIndex, textRect.x + 1, textRect.y + 1 + fm.getAscent());
            }
            if (background instanceof ColorUIResource) {
                if (model.isPressed() && model.isArmed() || model.isSelected()) {
                    g.setColor(AbstractLookAndFeel.getTheme().getPressedForegroundColor());
                } else if (model.isRollover()) {
                    g.setColor(AbstractLookAndFeel.getTheme().getRolloverForegroundColor());
                } else {
                    g.setColor(foreground);
                }
            } else {
                g.setColor(foreground);
            }
            JTattooUtilities.drawStringUnderlineCharAt(b, g, text, mnemIndex, textRect.x + offs, textRect.y + offs + fm.getAscent());
        } else {
            if (ColorHelper.getGrayValue(b.getForeground()) < 128) {
                g.setColor(Color.white);
                JTattooUtilities.drawStringUnderlineCharAt(b, g, text, mnemIndex, textRect.x + 1, textRect.y + 1 + fm.getAscent());
            }
            g.setColor(AbstractLookAndFeel.getDisabledForegroundColor());
            JTattooUtilities.drawStringUnderlineCharAt(b, g, text, mnemIndex, textRect.x, textRect.y + fm.getAscent());
        }
    }

    @Override
    protected void paintFocus(Graphics g, AbstractButton b, Rectangle viewRect, Rectangle textRect, Rectangle iconRect) {
    }

    private FontMetrics getFontMetrics(JComponent c, Graphics g, Font font) {
        if (c != null) {
            return c.getFontMetrics(font);
        }
        return Toolkit.getDefaultToolkit().getFontMetrics(font);
    }
}

