/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.plaf;

import com.jtattoo.plaf.AbstractLookAndFeel;
import com.jtattoo.plaf.BaseScrollPaneUI;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;

public class TmmScrollPaneUI
extends BaseScrollPaneUI {
    public static ComponentUI createUI(JComponent c) {
        return new TmmScrollPaneUI();
    }

    @Override
    protected void installDefaults(JScrollPane scrollpane) {
        LookAndFeel.installColorsAndFont(scrollpane, "ScrollPane.background", "ScrollPane.foreground", "ScrollPane.font");
        Border vpBorder = scrollpane.getViewportBorder();
        if (vpBorder == null || vpBorder instanceof UIResource) {
            vpBorder = UIManager.getBorder("ScrollPane.viewportBorder");
            scrollpane.setViewportBorder(vpBorder);
        }
        LookAndFeel.installProperty(scrollpane, "opaque", Boolean.TRUE);
        Object roundPane = scrollpane.getClientProperty("roundScrollPane");
        if (roundPane != null && "true".equals(roundPane.toString())) {
            LookAndFeel.installColorsAndFont(scrollpane, "ScrollPane.foreground", "ScrollPane.background", "ScrollPane.font");
            LookAndFeel.installBorder(scrollpane, "ScrollPane.border");
            scrollpane.getViewport().setOpaque(false);
            scrollpane.setBackground(AbstractLookAndFeel.getControlColorLight());
            scrollpane.getHorizontalScrollBar().putClientProperty("swapColors", "true");
            scrollpane.getHorizontalScrollBar().updateUI();
            scrollpane.getHorizontalScrollBar().setBorder(new EmptyBorder(0, 1, 0, 1));
            scrollpane.getHorizontalScrollBar().setOpaque(false);
            scrollpane.getVerticalScrollBar().putClientProperty("swapColors", "true");
            scrollpane.getVerticalScrollBar().updateUI();
            scrollpane.getVerticalScrollBar().setBorder(new EmptyBorder(0, 0, 1, 0));
            scrollpane.getVerticalScrollBar().setOpaque(false);
            if (scrollpane.getViewport().getView() instanceof JTable) {
                scrollpane.setColumnHeader(new JViewport());
                scrollpane.getColumnHeader().setOpaque(false);
                JTable table = (JTable)scrollpane.getViewport().getView();
                table.setShowHorizontalLines(false);
                table.setShowVerticalLines(false);
                table.getTableHeader().setOpaque(false);
                TableCellRenderer renderer = table.getTableHeader().getDefaultRenderer();
                ((DefaultTableCellRenderer)renderer).setBorder(null);
                Component component = renderer.getTableCellRendererComponent(table, "", false, false, -1, 0);
                ((JComponent)component).setOpaque(false);
                for (int i = 0; i < table.getColumnCount(); ++i) {
                    table.getColumnModel().getColumn(i).setHeaderRenderer(new HeaderRenderer());
                    table.getColumnModel().getColumn(i).setCellRenderer(new BorderTableCellRenderer(0, 5, 0, 0));
                }
            }
            scrollpane.getViewport().setOpaque(false);
            if (scrollpane.getViewport().getView() instanceof JComponent) {
                ((JComponent)scrollpane.getViewport().getView()).setOpaque(false);
            }
            if (scrollpane.getViewport().getView() instanceof JList) {
                ((JList)scrollpane.getViewport().getView()).setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
                if (((JList)scrollpane.getViewport().getView()).getCellRenderer() != null) {
                    ((DefaultListCellRenderer)((JList)scrollpane.getViewport().getView()).getCellRenderer()).setOpaque(false);
                }
            }
        }
    }

    private static class BorderTableCellRenderer
    extends DefaultTableCellRenderer {
        private static final long serialVersionUID = -6545791732880295743L;
        private Border border;

        public BorderTableCellRenderer() {
            this.border = BorderFactory.createEmptyBorder(0, 2, 0, 0);
        }

        public BorderTableCellRenderer(int top, int left, int bottom, int right) {
            this.border = BorderFactory.createEmptyBorder(top, left, bottom, right);
        }

        public BorderTableCellRenderer(Insets insets) {
            this.border = BorderFactory.createEmptyBorder(insets.top, insets.left, insets.bottom, insets.right);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            this.setForeground(table.getForeground());
            if (isSelected) {
                this.setBackground(table.getSelectionBackground());
                this.setForeground(table.getSelectionForeground());
            } else {
                this.setBackground(table.getBackground());
            }
            Component comp = super.getTableCellRendererComponent(table, "", isSelected, hasFocus, row, column);
            Border defaultBorder = ((JComponent)comp).getBorder();
            this.setBorder(BorderFactory.createCompoundBorder(defaultBorder, this.border));
            if (value != null) {
                this.setValue(value.toString());
            } else {
                this.setValue("");
            }
            return this;
        }
    }

    private static class HeaderRenderer
    extends DefaultTableCellRenderer {
        private static final long serialVersionUID = 7963585655106103416L;
        private static Border defaultBorder = BorderFactory.createMatteBorder(0, 0, 1, 0, AbstractLookAndFeel.getGridColor());

        public HeaderRenderer() {
            this.setHorizontalAlignment(0);
            this.setOpaque(false);
            this.setBorder(defaultBorder);
            this.setOpaque(false);
        }

        @Override
        public void updateUI() {
            super.updateUI();
            this.setBorder(defaultBorder);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean selected, boolean focused, int row, int column) {
            JTableHeader h;
            JTableHeader jTableHeader = h = table != null ? table.getTableHeader() : null;
            if (h != null) {
                this.setEnabled(h.isEnabled());
                this.setComponentOrientation(h.getComponentOrientation());
                this.setForeground(h.getForeground());
                this.setBackground(h.getBackground());
                this.setFont(h.getFont());
            } else {
                this.setEnabled(true);
                this.setComponentOrientation(ComponentOrientation.UNKNOWN);
                this.setForeground(UIManager.getColor("TableHeader.foreground"));
                this.setBackground(UIManager.getColor("TableHeader.background"));
                this.setFont(UIManager.getFont("TableHeader.font"));
            }
            this.setValue(value);
            return this;
        }
    }
}

