/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.plaf;

import com.jtattoo.plaf.BaseProgressBarUI;
import com.jtattoo.plaf.JTattooUtilities;
import java.awt.Composite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.GeneralPath;
import java.awt.geom.RoundRectangle2D;
import javax.swing.JComponent;
import javax.swing.plaf.ComponentUI;

public class TmmProgressBarUI
extends BaseProgressBarUI {
    private static final int PROGRESS_BAR_WIDTH = 6;

    public static ComponentUI createUI(JComponent c) {
        return new TmmProgressBarUI();
    }

    @Override
    public void installUI(JComponent c) {
        super.installUI(c);
        this.progressBar.setOpaque(false);
    }

    @Override
    protected void paintString(Graphics g, int x, int y, int width, int height, int amountFull, Insets b) {
    }

    @Override
    protected void paintDeterminate(Graphics g, JComponent c) {
        if (!(g instanceof Graphics2D)) {
            return;
        }
        Graphics2D g2D = (Graphics2D)g;
        Composite savedComposite = g2D.getComposite();
        RenderingHints savedRenderingHints = g2D.getRenderingHints();
        g2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        Insets b = this.progressBar.getInsets();
        int w = this.progressBar.getWidth() - (b.right + b.left);
        int h = this.progressBar.getHeight() - (b.top + b.bottom);
        int amountFull = this.getAmountFull(b, w, h);
        if (this.progressBar.getOrientation() == 0) {
            int y = b.top + (h - 6) / 2;
            g2D.setColor(this.progressBar.getBackground());
            g2D.fillRoundRect(b.left, y, w, 6, 6, 6);
            g2D.setColor(this.progressBar.getForeground());
            if (JTattooUtilities.isLeftToRight(this.progressBar)) {
                g2D.fillRoundRect(b.left, y, amountFull, 6, 6, 6);
            } else {
                g2D.fillRoundRect(this.progressBar.getWidth() - amountFull - b.right, y, b.right, 6, 6, 6);
            }
        } else {
            int x = b.left + (w - 6) / 2;
            g2D.setColor(this.progressBar.getBackground());
            g2D.fillRoundRect(x, b.top, w, h, 6, 6);
            g2D.setColor(this.progressBar.getForeground());
            g2D.fillRoundRect(x, b.top, w, h - amountFull, 6, 6);
        }
        g2D.setComposite(savedComposite);
        g2D.setRenderingHints(savedRenderingHints);
    }

    @Override
    protected void paintIndeterminate(Graphics g, JComponent c) {
        if (!(g instanceof Graphics2D)) {
            return;
        }
        Graphics2D g2D = (Graphics2D)g;
        Composite savedComposite = g2D.getComposite();
        RenderingHints savedRenderingHints = g2D.getRenderingHints();
        g2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        Insets b = this.progressBar.getInsets();
        int w = this.progressBar.getWidth() - (b.right + b.left);
        int h = this.progressBar.getHeight() - (b.top + b.bottom);
        if (this.progressBar.getOrientation() == 0) {
            int y = b.top + (h - 6) / 2;
            g2D.setColor(this.progressBar.getForeground());
            Area background = new Area(new RoundRectangle2D.Float(b.left, y, w, 6.0f, 6.0f, 6.0f));
            g2D.fill(background);
            this.boxRect = this.getBox(this.boxRect);
            if (this.boxRect != null) {
                w = 20;
                int x = this.getAnimationIndex();
                GeneralPath p = new GeneralPath();
                p.moveTo(this.boxRect.x, this.boxRect.y + this.boxRect.height);
                p.lineTo((float)this.boxRect.x + (float)w * 0.5f, this.boxRect.y + this.boxRect.height);
                p.lineTo(this.boxRect.x + w, this.boxRect.y);
                p.lineTo((float)this.boxRect.x + (float)w * 0.5f, this.boxRect.y);
                p.closePath();
                g2D.setColor(this.progressBar.getBackground());
                for (int i = this.boxRect.width + x; i > -w; i -= w) {
                    Area bar = new Area(AffineTransform.getTranslateInstance(i, 0.0).createTransformedShape(p));
                    bar.intersect(background);
                    g2D.fill(bar);
                }
            }
        } else {
            int x = b.left + (w - 6) / 2;
            g2D.setColor(this.progressBar.getForeground());
            g2D.fillRoundRect(x, b.top, w, h, 6, 6);
        }
        g2D.setComposite(savedComposite);
        g2D.setRenderingHints(savedRenderingHints);
    }

    @Override
    protected int getBoxLength(int availableLength, int otherDimension) {
        return availableLength;
    }
}

