/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.plaf;

import com.jtattoo.plaf.BaseLabelUI;
import java.awt.FontMetrics;
import java.awt.Rectangle;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import javax.swing.plaf.ComponentUI;

public class TmmLabelUI
extends BaseLabelUI {
    private static TmmLabelUI labelUI = null;

    public static ComponentUI createUI(JComponent c) {
        if (labelUI == null) {
            labelUI = new TmmLabelUI();
        }
        return labelUI;
    }

    @Override
    protected String layoutCL(JLabel label, FontMetrics fontMetrics, String text, Icon icon, Rectangle viewR, Rectangle iconR, Rectangle textR) {
        String stringFromSwingUtilities = SwingUtilities.layoutCompoundLabel(label, fontMetrics, text, icon, label.getVerticalAlignment(), label.getHorizontalAlignment(), label.getVerticalTextPosition(), label.getHorizontalTextPosition(), viewR, iconR, textR, label.getIconTextGap());
        int clipPosition = this.getClipPosition(label);
        switch (clipPosition) {
            case 0: 
            case 2: {
                return this.reLayoutString(label, clipPosition, text, stringFromSwingUtilities);
            }
        }
        return stringFromSwingUtilities;
    }

    private int getClipPosition(JLabel label) {
        Object prop = label.getClientProperty("clipPosition");
        if (prop != null && prop instanceof Integer) {
            if ((Integer)prop == 2) {
                return 2;
            }
            if ((Integer)prop == 4) {
                return 4;
            }
            if ((Integer)prop == 0) {
                return 0;
            }
        }
        return 4;
    }

    private String reLayoutString(JLabel label, int clipPosition, String originalText, String stringFromSwingUtilities) {
        block8: {
            int targetStringWidth;
            FontMetrics fm;
            String dots;
            block7: {
                if (!stringFromSwingUtilities.endsWith("...")) {
                    return stringFromSwingUtilities;
                }
                dots = "...";
                fm = label.getFontMetrics(label.getFont());
                targetStringWidth = fm.stringWidth(stringFromSwingUtilities);
                if (clipPosition != 2) break block7;
                int i = originalText.length() - stringFromSwingUtilities.length();
                if (i < 0) {
                    return stringFromSwingUtilities;
                }
                while (i < originalText.length()) {
                    String substring = dots + originalText.substring(i);
                    if (fm.stringWidth(substring) <= targetStringWidth) {
                        return substring;
                    }
                    ++i;
                }
                break block8;
            }
            if (clipPosition != 0) break block8;
            int i = stringFromSwingUtilities.length() / 2;
            if (i < 0) {
                return stringFromSwingUtilities;
            }
            while (i > 0) {
                String substring = originalText.substring(0, i) + dots + originalText.substring(originalText.length() - i);
                if (fm.stringWidth(substring) <= targetStringWidth) {
                    return substring;
                }
                --i;
            }
        }
        return stringFromSwingUtilities;
    }
}

