/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.plaf;

import com.jtattoo.plaf.AbstractLookAndFeel;
import com.jtattoo.plaf.BaseComboBoxUI;
import com.jtattoo.plaf.NoFocusButton;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;

public class TmmComboBoxUI
extends BaseComboBoxUI {
    public static ComponentUI createUI(JComponent c) {
        return new TmmComboBoxUI();
    }

    @Override
    public JButton createArrowButton() {
        return new ArrowButton();
    }

    @Override
    public void installUI(JComponent c) {
        super.installUI(c);
        if (this.comboBox.getEditor() != null) {
            if (this.comboBox.getEditor().getEditorComponent() instanceof JTextField) {
                ((JTextField)this.comboBox.getEditor().getEditorComponent()).setBorder(BorderFactory.createEmptyBorder(0, 1, 0, 1));
            } else if (this.comboBox.getEditor().getEditorComponent() instanceof JLabel) {
                ((JLabel)this.comboBox.getEditor().getEditorComponent()).setBorder(BorderFactory.createEmptyBorder(0, 1, 0, 1));
            }
        }
    }

    @Override
    protected void installDefaults() {
        super.installDefaults();
        this.squareButton = false;
    }

    @Override
    public Dimension getPreferredSize(JComponent c) {
        Dimension size = super.getPreferredSize(c);
        return new Dimension(size.width + 6, size.height);
    }

    @Override
    public void paintCurrentValue(Graphics g, Rectangle bounds, boolean hasFocus) {
        Component c;
        ListCellRenderer<Object> renderer = this.comboBox.getRenderer();
        if (hasFocus && !this.isPopupVisible(this.comboBox)) {
            c = renderer.getListCellRendererComponent(this.listBox, this.comboBox.getSelectedItem(), -1, true, false);
        } else {
            c = renderer.getListCellRendererComponent(this.listBox, this.comboBox.getSelectedItem(), -1, false, false);
            c.setBackground(UIManager.getColor("ComboBox.background"));
        }
        c.setFont(this.comboBox.getFont());
        if (this.comboBox.isEnabled()) {
            c.setForeground(this.comboBox.getForeground());
            c.setBackground(this.comboBox.getBackground());
        } else {
            c.setForeground(UIManager.getColor("ComboBox.disabledForeground", c.getLocale()));
            c.setBackground(UIManager.getColor("ComboBox.disabledBackground", c.getLocale()));
        }
        boolean shouldValidate = false;
        if (c instanceof JPanel) {
            shouldValidate = true;
        }
        int x = bounds.x;
        int y = bounds.y;
        int w = bounds.width;
        int h = bounds.height;
        if (this.padding != null) {
            x = bounds.x + this.padding.left;
            y = bounds.y + this.padding.top;
            w = bounds.width - (this.padding.left + this.padding.right);
            h = bounds.height - (this.padding.top + this.padding.bottom);
        }
        this.currentValuePane.paintComponent(g, c, this.comboBox, x, y, w, h, shouldValidate);
    }

    @Override
    public void paintCurrentValueBackground(Graphics g, Rectangle bounds, boolean hasFocus) {
        Color t = g.getColor();
        if (this.comboBox.isEnabled()) {
            g.setColor(UIManager.getColor("ComboBox.background", this.comboBox.getLocale()));
        } else {
            g.setColor(UIManager.getColor("ComboBox.disabledBackground", this.comboBox.getLocale()));
        }
        g.fillRect(0, 0, this.comboBox.getWidth(), this.comboBox.getHeight());
        g.setColor(t);
    }

    @Override
    protected void setButtonBorder() {
    }

    private class ArrowButton
    extends NoFocusButton {
        private static final long serialVersionUID = -2765755741007665606L;

        public ArrowButton() {
            this.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        }

        @Override
        public void paint(Graphics g) {
            int w = this.getWidth();
            int h = this.getHeight();
            g.setColor(AbstractLookAndFeel.getButtonForegroundColor());
            int[] xPoints = new int[]{w / 2 + 5, w / 2 - 5, w / 2};
            int[] yPoints = new int[]{h / 2 - 1, h / 2 - 1, h / 2 + 4};
            g.fillPolygon(xPoints, yPoints, xPoints.length);
        }
    }
}

