/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.panels;

import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.jdesktop.beansbinding.AutoBinding;
import org.jdesktop.beansbinding.BeanProperty;
import org.jdesktop.beansbinding.Binding;
import org.jdesktop.beansbinding.Bindings;
import org.jdesktop.beansbinding.Property;
import org.jdesktop.observablecollections.ObservableCollections;
import org.jdesktop.swingbinding.JTableBinding;
import org.jdesktop.swingbinding.SwingBindings;
import org.tinymediamanager.core.MediaFileType;
import org.tinymediamanager.core.UTF8Control;
import org.tinymediamanager.core.entities.MediaFile;
import org.tinymediamanager.core.entities.MediaFileAudioStream;
import org.tinymediamanager.core.entities.MediaFileSubtitle;
import org.tinymediamanager.ui.DoubleInputVerifier;
import org.tinymediamanager.ui.IconManager;
import org.tinymediamanager.ui.IntegerInputVerifier;
import org.tinymediamanager.ui.TmmFontHelper;
import org.tinymediamanager.ui.components.TmmLabel;
import org.tinymediamanager.ui.components.TmmSplitPane;
import org.tinymediamanager.ui.components.table.TmmTable;

public class MediaFileEditorPanel
extends JPanel {
    private static final long serialVersionUID = -2416409052145301941L;
    private static final ResourceBundle BUNDLE = ResourceBundle.getBundle("messages", new UTF8Control());
    private static final Map<Float, String> ASPECT_RATIOS = MediaFileEditorPanel.createAspectRatios();
    private final Set<Binding> bindings = new HashSet<Binding>();
    private List<MediaFileContainer> mediaFiles = ObservableCollections.observableList(new ArrayList());
    private TmmTable tableMediaFiles;
    private JLabel lblFilename;
    private JTextField tfCodec;
    private JTextField tfContainerFormat;
    private JTextField tfWidth;
    private JTextField tfHeight;
    private TmmTable tableAudioStreams;
    private TmmTable tableSubtitles;
    private JButton btnAddAudioStream;
    private JButton btnRemoveAudioStream;
    private JButton btnAddSubtitle;
    private JButton btnRemoveSubtitle;
    private JComboBox<String> cb3dFormat;
    private JComboBox cbAspectRatio;
    private JTextField tfFrameRate;
    private JTextField tfBitDepth;
    private JTextField tfHdrFormat;

    public MediaFileEditorPanel(List<MediaFile> mediaFiles) {
        for (MediaFile mediaFile : mediaFiles) {
            MediaFileContainer container = new MediaFileContainer(mediaFile);
            this.mediaFiles.add(container);
        }
        Vector<Float> aspectRatios = new Vector<Float>(ASPECT_RATIOS.keySet());
        Vector<String> threeDFormats = new Vector<String>();
        threeDFormats.add("");
        threeDFormats.add("3D");
        threeDFormats.add("3D SBS");
        threeDFormats.add("3D HSBS");
        threeDFormats.add("3D TAB");
        threeDFormats.add("3D HTAB");
        threeDFormats.add("3D MVC");
        this.setLayout((LayoutManager)new MigLayout("", "[300lp:450lp,grow]", "[200lp:450lp,grow]"));
        TmmSplitPane splitPane = new TmmSplitPane();
        this.add((Component)splitPane, "cell 0 0,grow");
        JPanel panelMediaFiles = new JPanel();
        panelMediaFiles.setLayout((LayoutManager)new MigLayout("", "[200lp:250lp,grow]", "[200lp:300lp,grow]"));
        JScrollPane scrollPaneMediaFiles = new JScrollPane();
        panelMediaFiles.add((Component)scrollPaneMediaFiles, "cell 0 0,grow");
        splitPane.setLeftComponent(panelMediaFiles);
        this.tableMediaFiles = new TmmTable();
        this.tableMediaFiles.configureScrollPane(scrollPaneMediaFiles);
        scrollPaneMediaFiles.setViewportView(this.tableMediaFiles);
        JPanel panelDetails = new JPanel();
        splitPane.setRightComponent(panelDetails);
        panelDetails.setLayout((LayoutManager)new MigLayout("", "[][65lp:65lp,grow][20lp:n][][65lp:65lp,grow][20lp:n][][][50lp:n,grow]", "[][][][][][100lp:150lp][100lp:150lp]"));
        this.lblFilename = new JLabel("");
        TmmFontHelper.changeFont(this.lblFilename, 1.167, 1);
        panelDetails.add((Component)this.lblFilename, "cell 0 0 9 1,growx");
        TmmLabel lblCodec = new TmmLabel(BUNDLE.getString("metatag.codec"));
        panelDetails.add((Component)lblCodec, "cell 0 1,alignx right");
        this.tfCodec = new JTextField();
        panelDetails.add((Component)this.tfCodec, "cell 1 1,growx");
        this.tfCodec.setColumns(10);
        TmmLabel lblContainerFormat = new TmmLabel(BUNDLE.getString("metatag.container"));
        panelDetails.add((Component)lblContainerFormat, "cell 3 1,alignx right");
        this.tfContainerFormat = new JTextField();
        panelDetails.add((Component)this.tfContainerFormat, "cell 4 1,growx");
        this.tfContainerFormat.setColumns(10);
        TmmLabel lblWidth = new TmmLabel(BUNDLE.getString("metatag.width"));
        panelDetails.add((Component)lblWidth, "cell 0 2,alignx right");
        this.tfWidth = new JTextField();
        this.tfWidth.setInputVerifier(new IntegerInputVerifier());
        panelDetails.add((Component)this.tfWidth, "cell 1 2,growx");
        this.tfWidth.setColumns(10);
        TmmLabel lblHeight = new TmmLabel(BUNDLE.getString("metatag.height"));
        panelDetails.add((Component)lblHeight, "cell 3 2,alignx right");
        this.tfHeight = new JTextField();
        this.tfHeight.setInputVerifier(new IntegerInputVerifier());
        panelDetails.add((Component)this.tfHeight, "cell 4 2,growx");
        this.tfHeight.setColumns(10);
        TmmLabel lblAspectT = new TmmLabel(BUNDLE.getString("metatag.aspect"));
        panelDetails.add((Component)lblAspectT, "cell 6 2,alignx right");
        this.cbAspectRatio = new JComboBox<Float>(aspectRatios);
        this.cbAspectRatio.setEditable(true);
        this.cbAspectRatio.setRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                String text = (String)ASPECT_RATIOS.get(value);
                if (StringUtils.isBlank((CharSequence)text)) {
                    text = String.valueOf(text);
                }
                return super.getListCellRendererComponent((JList<?>)list, text, index, isSelected, cellHasFocus);
            }
        });
        panelDetails.add((Component)this.cbAspectRatio, "cell 7 2,growx");
        TmmLabel lblFrameRate = new TmmLabel(BUNDLE.getString("metatag.framerate"));
        panelDetails.add((Component)lblFrameRate, "cell 0 3,alignx trailing");
        this.tfFrameRate = new JTextField();
        this.tfFrameRate.setInputVerifier(new DoubleInputVerifier());
        panelDetails.add((Component)this.tfFrameRate, "cell 1 3,growx");
        this.tfFrameRate.setColumns(10);
        TmmLabel lbld = new TmmLabel("3D Format");
        panelDetails.add((Component)lbld, "cell 3 3,alignx right");
        this.cb3dFormat = new JComboBox(threeDFormats);
        panelDetails.add(this.cb3dFormat, "cell 4 3,growx,aligny top");
        TmmLabel lblBitDepthT = new TmmLabel(BUNDLE.getString("metatag.videobitdepth"));
        panelDetails.add((Component)lblBitDepthT, "cell 0 4,alignx trailing");
        this.tfBitDepth = new JTextField();
        this.tfBitDepth.setInputVerifier(new IntegerInputVerifier());
        panelDetails.add((Component)this.tfBitDepth, "cell 1 4,growx");
        this.tfBitDepth.setColumns(10);
        TmmLabel lblHdrFormatT = new TmmLabel(BUNDLE.getString("metatag.hdrformat"));
        panelDetails.add((Component)lblHdrFormatT, "cell 3 4,alignx trailing");
        this.tfHdrFormat = new JTextField();
        panelDetails.add((Component)this.tfHdrFormat, "cell 4 4,growx");
        this.tfHdrFormat.setColumns(10);
        TmmLabel lblAudiostreams = new TmmLabel("AudioStreams");
        panelDetails.add((Component)lblAudiostreams, "flowy,cell 0 5,alignx right,aligny top");
        JScrollPane scrollPane = new JScrollPane();
        panelDetails.add((Component)scrollPane, "cell 1 5 8 1,grow");
        this.tableAudioStreams = new TmmTable();
        this.tableAudioStreams.configureScrollPane(scrollPane);
        scrollPane.setViewportView(this.tableAudioStreams);
        TmmLabel lblSubtitles = new TmmLabel("Subtitles");
        panelDetails.add((Component)lblSubtitles, "flowy,cell 0 6,alignx right,aligny top");
        scrollPane = new JScrollPane();
        panelDetails.add((Component)scrollPane, "cell 1 6 8 1,grow");
        this.tableSubtitles = new TmmTable();
        this.tableSubtitles.configureScrollPane(scrollPane);
        scrollPane.setViewportView(this.tableSubtitles);
        this.btnAddAudioStream = new JButton("");
        this.btnAddAudioStream.setAction(new AddAudioStreamAction());
        this.btnAddAudioStream.setMargin(new Insets(2, 2, 2, 2));
        this.btnAddAudioStream.setIcon(IconManager.ADD_INV);
        panelDetails.add((Component)this.btnAddAudioStream, "cell 0 5,alignx right,aligny top");
        this.btnRemoveAudioStream = new JButton("");
        this.btnRemoveAudioStream.setAction(new RemoveAudioStreamAction());
        this.btnRemoveAudioStream.setMargin(new Insets(2, 2, 2, 2));
        this.btnRemoveAudioStream.setIcon(IconManager.REMOVE_INV);
        panelDetails.add((Component)this.btnRemoveAudioStream, "cell 0 5,alignx right,aligny top");
        this.btnAddSubtitle = new JButton("");
        this.btnAddSubtitle.setAction(new AddSubtitleAction());
        this.btnAddSubtitle.setMargin(new Insets(2, 2, 2, 2));
        this.btnAddSubtitle.setIcon(IconManager.ADD_INV);
        panelDetails.add((Component)this.btnAddSubtitle, "cell 0 6,alignx right,aligny top");
        this.btnRemoveSubtitle = new JButton("");
        this.btnRemoveSubtitle.setAction(new RemoveSubtitleAction());
        this.btnRemoveSubtitle.setMargin(new Insets(2, 2, 2, 2));
        this.btnRemoveSubtitle.setIcon(IconManager.REMOVE_INV);
        panelDetails.add((Component)this.btnRemoveSubtitle, "cell 0 6,alignx right,aligny top");
        this.initDataBindings();
        if (!this.mediaFiles.isEmpty()) {
            this.tableMediaFiles.getSelectionModel().setSelectionInterval(0, 0);
        }
        this.tableMediaFiles.getSelectionModel().addListSelectionListener(new ListSelectionListener(){
            private Set<MediaFileType> videoTypes = new HashSet<MediaFileType>(Arrays.asList(MediaFileType.VIDEO, MediaFileType.SAMPLE, MediaFileType.TRAILER));

            @Override
            public void valueChanged(ListSelectionEvent arg0) {
                int selectedRow;
                if (!arg0.getValueIsAdjusting() && (selectedRow = MediaFileEditorPanel.this.tableMediaFiles.convertRowIndexToModel(MediaFileEditorPanel.this.tableMediaFiles.getSelectedRow())) > -1) {
                    MediaFile mf = ((MediaFileContainer)MediaFileEditorPanel.this.mediaFiles.get(selectedRow)).mediaFile;
                    MediaFileEditorPanel.this.tfCodec.setEnabled(mf.getType() != MediaFileType.NFO);
                    MediaFileEditorPanel.this.btnAddAudioStream.setEnabled(this.videoTypes.contains((Object)mf.getType()));
                    MediaFileEditorPanel.this.btnRemoveAudioStream.setEnabled(this.videoTypes.contains((Object)mf.getType()));
                    MediaFileEditorPanel.this.btnAddSubtitle.setEnabled(this.videoTypes.contains((Object)mf.getType()));
                    MediaFileEditorPanel.this.btnRemoveSubtitle.setEnabled(this.videoTypes.contains((Object)mf.getType()));
                    MediaFileEditorPanel.this.cb3dFormat.setEnabled(this.videoTypes.contains((Object)mf.getType()));
                }
            }
        });
    }

    private static Map<Float, String> createAspectRatios() {
        LinkedHashMap<Float, String> predefinedValues = new LinkedHashMap<Float, String>();
        predefinedValues.put(Float.valueOf(0.0f), "calculated");
        predefinedValues.put(Float.valueOf(1.33f), "1.33 (4:3)");
        predefinedValues.put(Float.valueOf(1.77f), "1.755 (16:9)");
        predefinedValues.put(Float.valueOf(1.85f), "1.85 (16:9 / widescreen)");
        predefinedValues.put(Float.valueOf(2.0f), "2.00 (18:9 / Univisium)");
        predefinedValues.put(Float.valueOf(2.35f), "2.35 (21:9 / cinemascope)");
        predefinedValues.put(Float.valueOf(2.39f), "2.39 (12:5 / theatrical widescreen)");
        return predefinedValues;
    }

    private int[] convertSelectedRowsToModelRows(JTable table) {
        int[] tableRows = table.getSelectedRows();
        int[] modelRows = new int[tableRows.length];
        for (int i = 0; i < tableRows.length; ++i) {
            modelRows[i] = table.convertRowIndexToModel(tableRows[i]);
        }
        ArrayUtils.reverse((int[])modelRows);
        return modelRows;
    }

    public static void syncMediaFiles(List<MediaFile> mfsFromEditor, List<MediaFile> mfsFromMediaEntity) {
        block0: for (MediaFile mfEditor : mfsFromEditor) {
            for (MediaFile mfOriginal : mfsFromMediaEntity) {
                if (!mfEditor.equals(mfOriginal)) continue;
                if (!mfEditor.getVideoCodec().equals(mfOriginal.getVideoCodec())) {
                    mfOriginal.setVideoCodec(mfEditor.getVideoCodec());
                }
                if (!mfEditor.getContainerFormat().equals(mfOriginal.getContainerFormat())) {
                    mfOriginal.setContainerFormat(mfEditor.getContainerFormat());
                }
                if (mfEditor.getVideoWidth() != mfOriginal.getVideoWidth()) {
                    mfOriginal.setVideoWidth(mfEditor.getVideoWidth());
                }
                if (mfEditor.getVideoHeight() != mfOriginal.getVideoHeight()) {
                    mfOriginal.setVideoHeight(mfEditor.getVideoHeight());
                }
                if (mfEditor.getAspectRatio() != mfOriginal.getAspectRatio()) {
                    mfOriginal.setAspectRatio(mfEditor.getAspectRatio());
                }
                if (mfEditor.getFrameRate() != mfOriginal.getFrameRate()) {
                    mfOriginal.setFrameRate(mfEditor.getFrameRate());
                }
                if (!mfEditor.getVideo3DFormat().equals(mfOriginal.getVideo3DFormat())) {
                    mfOriginal.setVideo3DFormat(mfEditor.getVideo3DFormat());
                }
                if (!mfEditor.getHdrFormat().equals(mfOriginal.getHdrFormat())) {
                    mfOriginal.setHdrFormat(mfEditor.getHdrFormat());
                }
                if (mfEditor.getBitDepth() != mfOriginal.getBitDepth()) {
                    mfOriginal.setBitDepth(mfEditor.getBitDepth());
                }
                mfOriginal.setAudioStreams(mfEditor.getAudioStreams());
                mfOriginal.setSubtitles(mfEditor.getSubtitles());
                continue block0;
            }
        }
    }

    public void unbindBindings() {
        for (Binding binding : this.bindings) {
            if (binding == null || !binding.isBound()) continue;
            binding.unbind();
        }
    }

    protected void initDataBindings() {
        JTableBinding jTableBinding = SwingBindings.createJTableBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, this.mediaFiles, (JTable)this.tableMediaFiles);
        BeanProperty mediaFileContainerBeanProperty = BeanProperty.create((String)"mediaFile.filename");
        jTableBinding.addColumnBinding((Property)mediaFileContainerBeanProperty).setColumnName("Filename").setEditable(false);
        jTableBinding.setEditable(false);
        jTableBinding.bind();
        BeanProperty jTableBeanProperty = BeanProperty.create((String)"selectedElement.mediaFile.filename");
        BeanProperty jLabelBeanProperty = BeanProperty.create((String)"text");
        AutoBinding autoBinding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.tableMediaFiles, (Property)jTableBeanProperty, (Object)this.lblFilename, (Property)jLabelBeanProperty);
        autoBinding.bind();
        BeanProperty jTableBeanProperty_1 = BeanProperty.create((String)"selectedElement.mediaFile.videoCodec");
        BeanProperty jTextFieldBeanProperty = BeanProperty.create((String)"text");
        AutoBinding autoBinding_1 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.tableMediaFiles, (Property)jTableBeanProperty_1, (Object)this.tfCodec, (Property)jTextFieldBeanProperty);
        autoBinding_1.bind();
        BeanProperty jTableBeanProperty_3 = BeanProperty.create((String)"selectedElement.mediaFile.containerFormat");
        BeanProperty jTextFieldBeanProperty_2 = BeanProperty.create((String)"text");
        AutoBinding autoBinding_3 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.tableMediaFiles, (Property)jTableBeanProperty_3, (Object)this.tfContainerFormat, (Property)jTextFieldBeanProperty_2);
        autoBinding_3.bind();
        BeanProperty jTableBeanProperty_5 = BeanProperty.create((String)"selectedElement.mediaFile.videoWidth");
        BeanProperty jTextFieldBeanProperty_4 = BeanProperty.create((String)"text");
        AutoBinding autoBinding_5 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.tableMediaFiles, (Property)jTableBeanProperty_5, (Object)this.tfWidth, (Property)jTextFieldBeanProperty_4);
        autoBinding_5.bind();
        BeanProperty jTableBeanProperty_6 = BeanProperty.create((String)"selectedElement.mediaFile.videoHeight");
        BeanProperty jTextFieldBeanProperty_5 = BeanProperty.create((String)"text");
        AutoBinding autoBinding_6 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.tableMediaFiles, (Property)jTableBeanProperty_6, (Object)this.tfHeight, (Property)jTextFieldBeanProperty_5);
        autoBinding_6.bind();
        BeanProperty jTableBeanProperty_2 = BeanProperty.create((String)"selectedElement.audioStreams");
        JTableBinding jTableBinding_1 = SwingBindings.createJTableBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.tableMediaFiles, (Property)jTableBeanProperty_2, (JTable)this.tableAudioStreams);
        BeanProperty mediaFileAudioStreamBeanProperty = BeanProperty.create((String)"language");
        jTableBinding_1.addColumnBinding((Property)mediaFileAudioStreamBeanProperty).setColumnName("Language").setColumnClass(String.class);
        BeanProperty mediaFileAudioStreamBeanProperty_1 = BeanProperty.create((String)"codec");
        jTableBinding_1.addColumnBinding((Property)mediaFileAudioStreamBeanProperty_1).setColumnName("Codec");
        BeanProperty mediaFileAudioStreamBeanProperty_2 = BeanProperty.create((String)"audioChannels");
        jTableBinding_1.addColumnBinding((Property)mediaFileAudioStreamBeanProperty_2).setColumnName("Channels");
        BeanProperty mediaFileAudioStreamBeanProperty_3 = BeanProperty.create((String)"bitrate");
        jTableBinding_1.addColumnBinding((Property)mediaFileAudioStreamBeanProperty_3).setColumnName("Bitrate").setColumnClass(Integer.class);
        jTableBinding_1.bind();
        BeanProperty jTableBeanProperty_4 = BeanProperty.create((String)"selectedElement.subtitles");
        JTableBinding jTableBinding_2 = SwingBindings.createJTableBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.tableMediaFiles, (Property)jTableBeanProperty_4, (JTable)this.tableSubtitles);
        BeanProperty mediaFileSubtitleBeanProperty = BeanProperty.create((String)"language");
        jTableBinding_2.addColumnBinding((Property)mediaFileSubtitleBeanProperty).setColumnName("Language").setColumnClass(String.class);
        BeanProperty mediaFileSubtitleBeanProperty_1 = BeanProperty.create((String)"forced");
        jTableBinding_2.addColumnBinding((Property)mediaFileSubtitleBeanProperty_1).setColumnName("Forced").setColumnClass(Boolean.class);
        jTableBinding_2.bind();
        BeanProperty jTableBeanProperty_7 = BeanProperty.create((String)"selectedElement.mediaFile.video3DFormat");
        BeanProperty jComboBoxBeanProperty = BeanProperty.create((String)"selectedItem");
        AutoBinding autoBinding_2 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.tableMediaFiles, (Property)jTableBeanProperty_7, this.cb3dFormat, (Property)jComboBoxBeanProperty);
        autoBinding_2.bind();
        BeanProperty tmmTableBeanProperty = BeanProperty.create((String)"selectedElement.mediaFile.aspectRatio");
        AutoBinding autoBinding_4 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.tableMediaFiles, (Property)tmmTableBeanProperty, (Object)this.cbAspectRatio, (Property)jComboBoxBeanProperty);
        autoBinding_4.bind();
        BeanProperty tmmTableBeanProperty_1 = BeanProperty.create((String)"selectedElement.mediaFile.frameRate");
        BeanProperty jFormattedTextFieldBeanProperty = BeanProperty.create((String)"text");
        AutoBinding autoBinding_7 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.tableMediaFiles, (Property)tmmTableBeanProperty_1, (Object)this.tfFrameRate, (Property)jFormattedTextFieldBeanProperty);
        autoBinding_7.bind();
        BeanProperty tmmTableBeanProperty_2 = BeanProperty.create((String)"selectedElement.mediaFile.bitDepth");
        BeanProperty jTextFieldBeanProperty_1 = BeanProperty.create((String)"text");
        AutoBinding autoBinding_8 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.tableMediaFiles, (Property)tmmTableBeanProperty_2, (Object)this.tfBitDepth, (Property)jTextFieldBeanProperty_1);
        autoBinding_8.bind();
        BeanProperty tmmTableBeanProperty_3 = BeanProperty.create((String)"selectedElement.mediaFile.hdrFormat");
        BeanProperty jTextFieldBeanProperty_3 = BeanProperty.create((String)"text");
        AutoBinding autoBinding_9 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.tableMediaFiles, (Property)tmmTableBeanProperty_3, (Object)this.tfHdrFormat, (Property)jTextFieldBeanProperty_3);
        autoBinding_9.bind();
    }

    public class MediaFileContainer {
        private MediaFile mediaFile;
        private List<MediaFileAudioStream> audioStreams;
        private List<MediaFileSubtitle> subtitles;

        private MediaFileContainer(MediaFile mediaFile) {
            this.mediaFile = mediaFile;
            this.audioStreams = ObservableCollections.observableList(new ArrayList<MediaFileAudioStream>(mediaFile.getAudioStreams()));
            this.subtitles = ObservableCollections.observableList(new ArrayList<MediaFileSubtitle>(mediaFile.getSubtitles()));
        }

        public MediaFile getMediaFile() {
            return this.mediaFile;
        }

        public List<MediaFileAudioStream> getAudioStreams() {
            return this.audioStreams;
        }

        public List<MediaFileSubtitle> getSubtitles() {
            return this.subtitles;
        }

        public void addAudioStream() {
            this.audioStreams.add(new MediaFileAudioStream());
            this.mediaFile.setAudioStreams(this.audioStreams);
        }

        public void removeAudioStream(int index) {
            this.audioStreams.remove(index);
            this.mediaFile.setAudioStreams(this.audioStreams);
        }

        public void addSubtitle() {
            this.subtitles.add(new MediaFileSubtitle());
            this.mediaFile.setSubtitles(this.subtitles);
        }

        public void removeSubtitle(int index) {
            this.subtitles.remove(index);
            this.mediaFile.setSubtitles(this.subtitles);
        }
    }

    private class RemoveSubtitleAction
    extends AbstractAction {
        private static final long serialVersionUID = -7079866940827356996L;

        public RemoveSubtitleAction() {
            this.putValue("ShortDescription", BUNDLE.getString("subtitle.remove"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int mediaFileRow;
            int[] subtitleRows = MediaFileEditorPanel.this.convertSelectedRowsToModelRows(MediaFileEditorPanel.this.tableSubtitles);
            if (subtitleRows.length > 0 && (mediaFileRow = MediaFileEditorPanel.this.tableMediaFiles.getSelectedRow()) > -1) {
                mediaFileRow = MediaFileEditorPanel.this.tableMediaFiles.convertRowIndexToModel(mediaFileRow);
                MediaFileContainer mf = (MediaFileContainer)MediaFileEditorPanel.this.mediaFiles.get(mediaFileRow);
                for (int row : subtitleRows) {
                    mf.removeSubtitle(row);
                }
            }
        }
    }

    private class AddSubtitleAction
    extends AbstractAction {
        private static final long serialVersionUID = 2903255414523349767L;

        public AddSubtitleAction() {
            this.putValue("ShortDescription", BUNDLE.getString("subtitle.add"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int mediaFileRow = MediaFileEditorPanel.this.tableMediaFiles.getSelectedRow();
            if (mediaFileRow > -1) {
                mediaFileRow = MediaFileEditorPanel.this.tableMediaFiles.convertRowIndexToModel(mediaFileRow);
                MediaFileContainer mf = (MediaFileContainer)MediaFileEditorPanel.this.mediaFiles.get(mediaFileRow);
                mf.addSubtitle();
            }
        }
    }

    private class RemoveAudioStreamAction
    extends AbstractAction {
        private static final long serialVersionUID = -7079826940827356996L;

        public RemoveAudioStreamAction() {
            this.putValue("ShortDescription", BUNDLE.getString("audiostream.remove"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int mediaFileRow;
            int[] audioRows = MediaFileEditorPanel.this.convertSelectedRowsToModelRows(MediaFileEditorPanel.this.tableAudioStreams);
            if (audioRows.length > 0 && (mediaFileRow = MediaFileEditorPanel.this.tableMediaFiles.getSelectedRow()) > -1) {
                mediaFileRow = MediaFileEditorPanel.this.tableMediaFiles.convertRowIndexToModel(mediaFileRow);
                MediaFileContainer mf = (MediaFileContainer)MediaFileEditorPanel.this.mediaFiles.get(mediaFileRow);
                for (int row : audioRows) {
                    mf.removeAudioStream(row);
                }
            }
        }
    }

    private class AddAudioStreamAction
    extends AbstractAction {
        private static final long serialVersionUID = 2903255414523349267L;

        public AddAudioStreamAction() {
            this.putValue("ShortDescription", BUNDLE.getString("audiostream.add"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int mediaFileRow = MediaFileEditorPanel.this.tableMediaFiles.getSelectedRow();
            if (mediaFileRow > -1) {
                mediaFileRow = MediaFileEditorPanel.this.tableMediaFiles.convertRowIndexToModel(mediaFileRow);
                MediaFileContainer mf = (MediaFileContainer)MediaFileEditorPanel.this.mediaFiles.get(mediaFileRow);
                mf.addAudioStream();
            }
        }
    }
}

