/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.moviesets.dialogs;

import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import net.miginfocom.swing.MigLayout;
import org.jdesktop.beansbinding.AutoBinding;
import org.jdesktop.beansbinding.BeanProperty;
import org.jdesktop.beansbinding.Binding;
import org.jdesktop.beansbinding.BindingGroup;
import org.jdesktop.beansbinding.Bindings;
import org.jdesktop.beansbinding.Property;
import org.jdesktop.observablecollections.ObservableCollections;
import org.jdesktop.swingbinding.JTableBinding;
import org.jdesktop.swingbinding.SwingBindings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.core.Message;
import org.tinymediamanager.core.MessageManager;
import org.tinymediamanager.core.ScraperMetadataConfig;
import org.tinymediamanager.core.movie.MovieModuleManager;
import org.tinymediamanager.core.movie.MovieSetScraperMetadataConfig;
import org.tinymediamanager.core.movie.MovieSetSearchAndScrapeOptions;
import org.tinymediamanager.core.movie.entities.Movie;
import org.tinymediamanager.core.movie.entities.MovieSet;
import org.tinymediamanager.scraper.MediaMetadata;
import org.tinymediamanager.scraper.MediaScraper;
import org.tinymediamanager.scraper.MediaSearchResult;
import org.tinymediamanager.scraper.ScraperType;
import org.tinymediamanager.scraper.interfaces.IMovieSetMetadataProvider;
import org.tinymediamanager.ui.IconManager;
import org.tinymediamanager.ui.TmmFontHelper;
import org.tinymediamanager.ui.components.ImageLabel;
import org.tinymediamanager.ui.components.ReadOnlyTextPane;
import org.tinymediamanager.ui.components.TmmLabel;
import org.tinymediamanager.ui.components.TmmSplitPane;
import org.tinymediamanager.ui.components.combobox.ScraperMetadataConfigCheckComboBox;
import org.tinymediamanager.ui.components.table.TmmTable;
import org.tinymediamanager.ui.dialogs.TmmDialog;
import org.tinymediamanager.ui.moviesets.MovieSetChooserModel;

public class MovieSetChooserDialog
extends TmmDialog
implements ActionListener {
    private static final long serialVersionUID = -1023959850452480592L;
    private static final Logger LOGGER = LoggerFactory.getLogger(MovieSetChooserDialog.class);
    private MovieSet movieSetToScrape;
    private List<MovieSetChooserModel> movieSetsFound = ObservableCollections.observableList(new ArrayList());
    private boolean continueQueue = true;
    private JLabel lblProgressAction;
    private JProgressBar progressBar;
    private JTextField tfMovieSetName;
    private JTable tableMovieSets;
    private JLabel lblMovieSetName;
    private ImageLabel lblMovieSetPoster;
    private JTable tableMovies;
    private JCheckBox cbAssignMovies;
    private JButton btnOk;
    private JTextPane tpPlot;
    private ScraperMetadataConfigCheckComboBox<MovieSetScraperMetadataConfig> cbScraperConfig;

    public MovieSetChooserDialog(MovieSet movieSet, boolean inQueue) {
        super(BUNDLE.getString("movieset.search"), "movieSetChooser");
        this.movieSetToScrape = movieSet;
        JPanel panelHeader = new JPanel();
        panelHeader.setLayout((LayoutManager)new MigLayout("", "[grow][]", "[]"));
        SearchAction searchAction = new SearchAction();
        this.tfMovieSetName = new JTextField();
        this.tfMovieSetName.addActionListener(searchAction);
        panelHeader.add((Component)this.tfMovieSetName, "cell 0 0,growx");
        this.tfMovieSetName.setColumns(10);
        JButton btnSearch = new JButton(searchAction);
        panelHeader.add((Component)btnSearch, "cell 1 0");
        this.setTopIformationPanel(panelHeader);
        JPanel panelContent = new JPanel();
        this.getContentPane().add((Component)panelContent, "Center");
        panelContent.setLayout((LayoutManager)new MigLayout("", "[950lp,grow]", "[500,grow][][][]"));
        TmmSplitPane splitPane = new TmmSplitPane();
        splitPane.setResizeWeight(0.5);
        panelContent.add((Component)splitPane, "cell 0 0,grow");
        JPanel panelResults = new JPanel();
        panelResults.setLayout((LayoutManager)new MigLayout("", "[200lp:300lp,grow]", "[300lp,grow]"));
        JScrollPane panelSearchResults = new JScrollPane();
        panelResults.add((Component)panelSearchResults, "cell 0 0,grow");
        splitPane.setLeftComponent(panelResults);
        this.tableMovieSets = new TmmTable();
        panelSearchResults.setViewportView(this.tableMovieSets);
        this.tableMovieSets.setSelectionMode(0);
        ListSelectionModel rowSM = this.tableMovieSets.getSelectionModel();
        rowSM.addListSelectionListener(e -> {
            if (e.getValueIsAdjusting()) {
                return;
            }
            ListSelectionModel lsm = (ListSelectionModel)e.getSource();
            if (!lsm.isSelectionEmpty()) {
                int selectedRow = lsm.getMinSelectionIndex();
                selectedRow = this.tableMovieSets.convertRowIndexToModel(selectedRow);
                try {
                    MovieSetChooserModel model = this.movieSetsFound.get(selectedRow);
                    if (model != MovieSetChooserModel.emptyResult && !model.isScraped()) {
                        ScrapeTask task = new ScrapeTask(model);
                        task.execute();
                    }
                }
                catch (Exception ex) {
                    LOGGER.warn(ex.getMessage());
                }
            }
        });
        this.tableMovieSets.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() >= 2 && !e.isConsumed() && e.getButton() == 1) {
                    MovieSetChooserDialog.this.actionPerformed(new ActionEvent(MovieSetChooserDialog.this.btnOk, 1001, "Save"));
                }
            }
        });
        JPanel panelSearchDetail = new JPanel();
        splitPane.setRightComponent(panelSearchDetail);
        panelSearchDetail.setLayout((LayoutManager)new MigLayout("", "[150lp,grow 60][450lp,grow]", "[][250lp,grow][150lp][]"));
        this.lblMovieSetName = new JLabel("");
        TmmFontHelper.changeFont(this.lblMovieSetName, 1.166, 1);
        panelSearchDetail.add((Component)this.lblMovieSetName, "cell 0 0 2 1,growx");
        this.lblMovieSetPoster = new ImageLabel();
        panelSearchDetail.add((Component)this.lblMovieSetPoster, "cell 0 1,grow");
        JScrollPane scrollPane = new JScrollPane();
        panelSearchDetail.add((Component)scrollPane, "cell 1 1,grow");
        this.tpPlot = new ReadOnlyTextPane();
        scrollPane.setViewportView(this.tpPlot);
        scrollPane = new JScrollPane();
        panelSearchDetail.add((Component)scrollPane, "cell 0 2 2 1,grow");
        this.tableMovies = new TmmTable();
        scrollPane.setViewportView(this.tableMovies);
        this.cbAssignMovies = new JCheckBox(BUNDLE.getString("movieset.movie.assign"));
        this.cbAssignMovies.setSelected(true);
        panelSearchDetail.add((Component)this.cbAssignMovies, "cell 0 3 2 1,growx,aligny top");
        JSeparator separator = new JSeparator();
        panelContent.add((Component)separator, "cell 0 1,growx");
        TmmLabel lblScrapeFollowingItems = new TmmLabel(BUNDLE.getString("chooser.scrape"));
        panelContent.add((Component)lblScrapeFollowingItems, "cell 0 2");
        this.cbScraperConfig = new ScraperMetadataConfigCheckComboBox((ScraperMetadataConfig[])MovieSetScraperMetadataConfig.values());
        panelContent.add(this.cbScraperConfig, "cell 0 3,growx, wmin 0");
        JPanel infoPanel = new JPanel();
        infoPanel.setLayout((LayoutManager)new MigLayout("", "[][grow]", "[]"));
        this.progressBar = new JProgressBar();
        infoPanel.add((Component)this.progressBar, "cell 0 0");
        this.lblProgressAction = new JLabel("");
        infoPanel.add((Component)this.lblProgressAction, "cell 1 0");
        this.setBottomInformationPanel(infoPanel);
        if (inQueue) {
            JButton btnAbort = new JButton(BUNDLE.getString("Button.abortqueue"));
            btnAbort.setActionCommand("Abort");
            btnAbort.setToolTipText(BUNDLE.getString("Button.abortqueue"));
            btnAbort.setIcon(IconManager.STOP_INV);
            btnAbort.addActionListener(this);
            this.addButton(btnAbort);
        }
        JButton btnCancel = new JButton(BUNDLE.getString("Button.cancel"));
        btnCancel.setActionCommand("Cancel");
        btnCancel.setToolTipText(BUNDLE.getString("Button.cancel"));
        btnCancel.setIcon(IconManager.CANCEL_INV);
        btnCancel.addActionListener(this);
        this.addButton(btnCancel);
        this.btnOk = new JButton(BUNDLE.getString("Button.ok"));
        this.btnOk.setActionCommand("Save");
        this.btnOk.setToolTipText(BUNDLE.getString("Button.ok"));
        this.btnOk.setIcon(IconManager.APPLY_INV);
        this.btnOk.addActionListener(this);
        this.addDefaultButton(this.btnOk);
        this.bindingGroup = this.initDataBindings();
        this.tableMovies.getSelectionModel().setSelectionMode(0);
        this.tableMovies.setAutoResizeMode(4);
        this.cbScraperConfig.setSelectedItems((MovieSetScraperMetadataConfig[])MovieSetScraperMetadataConfig.values());
        this.tableMovieSets.getColumnModel().getColumn(0).setHeaderValue(BUNDLE.getString("chooser.searchresult"));
        this.tfMovieSetName.setText(movieSet.getTitle());
        this.searchMovie();
    }

    private void searchMovie() {
        SearchTask task = new SearchTask(this.tfMovieSetName.getText());
        task.execute();
    }

    @Override
    public void actionPerformed(ActionEvent arg0) {
        int row;
        if ("Cancel".equals(arg0.getActionCommand())) {
            this.setVisible(false);
        }
        if ("Save".equals(arg0.getActionCommand()) && (row = this.tableMovieSets.getSelectedRow()) >= 0) {
            MovieSetChooserModel model = this.movieSetsFound.get(row);
            if (model != MovieSetChooserModel.emptyResult) {
                if (!model.isScraped()) {
                    MessageManager.instance.pushMessage(new Message(Message.MessageLevel.ERROR, "MovieSetChooser", "message.scrape.threadcrashed"));
                    return;
                }
                MediaMetadata md = model.getMetadata();
                List<MovieSetScraperMetadataConfig> scraperConfig = this.cbScraperConfig.getSelectedItems();
                this.movieSetToScrape.setMetadata(md, scraperConfig);
                if (this.cbAssignMovies.isSelected()) {
                    this.movieSetToScrape.removeAllMovies();
                    for (int i = 0; i < model.getMovies().size(); ++i) {
                        MovieSetChooserModel.MovieInSet movieInSet = model.getMovies().get(i);
                        Movie movie = movieInSet.getMovie();
                        if (movie == null) continue;
                        if (movie.getMovieSet() != null) {
                            MovieSet mSet = movie.getMovieSet();
                            mSet.removeMovie(movie, true);
                        }
                        movie.setMovieSet(this.movieSetToScrape);
                        movie.writeNFO();
                        movie.saveToDb();
                        this.movieSetToScrape.addMovie(movie);
                    }
                    this.movieSetToScrape.saveToDb();
                }
                if (ScraperMetadataConfig.containsAnyArtwork(scraperConfig)) {
                    model.startArtworkScrapeTask(this.movieSetToScrape, scraperConfig);
                }
            }
            this.setVisible(false);
        }
        if ("Abort".equals(arg0.getActionCommand())) {
            this.continueQueue = false;
            this.setVisible(false);
        }
    }

    private void startProgressBar(String description) {
        SwingUtilities.invokeLater(() -> {
            this.lblProgressAction.setText(description);
            this.progressBar.setVisible(true);
            this.progressBar.setIndeterminate(true);
        });
    }

    private void stopProgressBar() {
        SwingUtilities.invokeLater(() -> {
            this.lblProgressAction.setText("");
            this.progressBar.setVisible(false);
            this.progressBar.setIndeterminate(false);
        });
    }

    public boolean showDialog() {
        this.setVisible(true);
        return this.continueQueue;
    }

    protected BindingGroup initDataBindings() {
        JTableBinding jTableBinding = SwingBindings.createJTableBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, this.movieSetsFound, (JTable)this.tableMovieSets);
        BeanProperty movieSetChooserModelBeanProperty = BeanProperty.create((String)"name");
        jTableBinding.addColumnBinding((Property)movieSetChooserModelBeanProperty).setEditable(false);
        jTableBinding.bind();
        BeanProperty jTableBeanProperty = BeanProperty.create((String)"selectedElement.movies");
        JTableBinding jTableBinding_1 = SwingBindings.createJTableBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this.tableMovieSets, (Property)jTableBeanProperty, (JTable)this.tableMovies);
        BeanProperty movieInSetBeanProperty = BeanProperty.create((String)"name");
        jTableBinding_1.addColumnBinding((Property)movieInSetBeanProperty).setColumnName("Movie").setEditable(false);
        BeanProperty movieInSetBeanProperty_2 = BeanProperty.create((String)"movie.title");
        jTableBinding_1.addColumnBinding((Property)movieInSetBeanProperty_2).setColumnName("matched movie").setEditable(false);
        jTableBinding_1.bind();
        BeanProperty jTableBeanProperty_1 = BeanProperty.create((String)"selectedElement.name");
        BeanProperty jLabelBeanProperty = BeanProperty.create((String)"text");
        AutoBinding autoBinding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this.tableMovieSets, (Property)jTableBeanProperty_1, (Object)this.lblMovieSetName, (Property)jLabelBeanProperty);
        autoBinding.bind();
        BeanProperty jTableBeanProperty_2 = BeanProperty.create((String)"selectedElement.posterUrl");
        BeanProperty imageLabelBeanProperty = BeanProperty.create((String)"imageUrl");
        AutoBinding autoBinding_1 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this.tableMovieSets, (Property)jTableBeanProperty_2, (Object)this.lblMovieSetPoster, (Property)imageLabelBeanProperty);
        autoBinding_1.bind();
        BeanProperty jTableBeanProperty_3 = BeanProperty.create((String)"selectedElement.overview");
        BeanProperty readOnlyTextPaneBeanProperty = BeanProperty.create((String)"text");
        AutoBinding autoBinding_2 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this.tableMovieSets, (Property)jTableBeanProperty_3, (Object)this.tpPlot, (Property)readOnlyTextPaneBeanProperty);
        autoBinding_2.bind();
        BindingGroup bindingGroup = new BindingGroup();
        bindingGroup.addBinding((Binding)jTableBinding);
        bindingGroup.addBinding((Binding)jTableBinding_1);
        bindingGroup.addBinding((Binding)autoBinding);
        bindingGroup.addBinding((Binding)autoBinding_1);
        bindingGroup.addBinding((Binding)autoBinding_2);
        return bindingGroup;
    }

    private class ScrapeTask
    extends SwingWorker<Void, Void> {
        private MovieSetChooserModel model;

        ScrapeTask(MovieSetChooserModel model) {
            this.model = model;
        }

        @Override
        public Void doInBackground() {
            MovieSetChooserDialog.this.startProgressBar(BUNDLE.getString("chooser.scrapeing") + " " + this.model.getName());
            MovieSetChooserDialog.this.btnOk.setEnabled(false);
            this.model.scrapeMetadata();
            MovieSetChooserDialog.this.btnOk.setEnabled(true);
            return null;
        }

        @Override
        public void done() {
            MovieSetChooserDialog.this.stopProgressBar();
        }
    }

    private class SearchAction
    extends AbstractAction {
        private static final long serialVersionUID = -6561883838396668177L;

        SearchAction() {
            this.putValue("Name", BUNDLE.getString("Button.search"));
            this.putValue("ShortDescription", BUNDLE.getString("movieset.search"));
            this.putValue("SmallIcon", IconManager.SEARCH_INV);
            this.putValue("SwingLargeIconKey", IconManager.SEARCH_INV);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            MovieSetChooserDialog.this.searchMovie();
        }
    }

    private class SearchTask
    extends SwingWorker<Void, Void> {
        private String searchTerm;

        public SearchTask(String searchTerm) {
            this.searchTerm = searchTerm;
        }

        @Override
        public Void doInBackground() {
            MovieSetChooserDialog.this.startProgressBar(BUNDLE.getString("chooser.searchingfor") + " " + this.searchTerm);
            try {
                List<MediaScraper> sets = MediaScraper.getMediaScrapers(ScraperType.MOVIE_SET);
                if (sets != null && !sets.isEmpty()) {
                    MediaScraper first = sets.get(0);
                    IMovieSetMetadataProvider mp = (IMovieSetMetadataProvider)first.getMediaProvider();
                    MovieSetSearchAndScrapeOptions options = new MovieSetSearchAndScrapeOptions();
                    options.setSearchQuery(this.searchTerm);
                    options.setLanguage(MovieModuleManager.SETTINGS.getScraperLanguage());
                    List<MediaSearchResult> movieSets = mp.search(options);
                    MovieSetChooserDialog.this.movieSetsFound.clear();
                    if (movieSets.isEmpty()) {
                        MovieSetChooserDialog.this.movieSetsFound.add(MovieSetChooserModel.emptyResult);
                    } else {
                        for (MediaSearchResult collection : movieSets) {
                            MovieSetChooserModel model = new MovieSetChooserModel(collection);
                            MovieSetChooserDialog.this.movieSetsFound.add(model);
                        }
                    }
                }
                if (!MovieSetChooserDialog.this.movieSetsFound.isEmpty()) {
                    MovieSetChooserDialog.this.tableMovieSets.setRowSelectionInterval(0, 0);
                }
            }
            catch (Exception e1) {
                LOGGER.warn("SearchTask", (Throwable)e1);
            }
            return null;
        }

        @Override
        public void done() {
            MovieSetChooserDialog.this.stopProgressBar();
        }
    }
}

