/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.moviesets.actions;

import java.awt.event.ActionEvent;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.JOptionPane;
import org.tinymediamanager.core.UTF8Control;
import org.tinymediamanager.core.movie.MovieList;
import org.tinymediamanager.core.movie.entities.MovieSet;
import org.tinymediamanager.ui.IconManager;
import org.tinymediamanager.ui.MainWindow;
import org.tinymediamanager.ui.actions.TmmAction;
import org.tinymediamanager.ui.moviesets.MovieSetUIModule;

public class MovieSetRemoveAction
extends TmmAction {
    private static final long serialVersionUID = -9030996266835702009L;
    private static final ResourceBundle BUNDLE = ResourceBundle.getBundle("messages", new UTF8Control());

    public MovieSetRemoveAction() {
        this.putValue("Name", BUNDLE.getString("movieset.remove.desc"));
        this.putValue("SwingLargeIconKey", IconManager.DELETE);
        this.putValue("SmallIcon", IconManager.DELETE);
        this.putValue("ShortDescription", BUNDLE.getString("movieset.remove.desc"));
    }

    @Override
    protected void processAction(ActionEvent e) {
        List<MovieSet> selectedMovieSets = MovieSetUIModule.getInstance().getSelectionModel().getSelectedMovieSets();
        if (selectedMovieSets.isEmpty()) {
            JOptionPane.showMessageDialog(MainWindow.getActiveInstance(), BUNDLE.getString("tmm.nothingselected"));
            return;
        }
        for (MovieSet movieSet : selectedMovieSets) {
            MovieList.getInstance().removeMovieSet(movieSet);
        }
    }
}

