/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.moviesets.actions;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.ResourceBundle;
import javax.swing.JOptionPane;
import org.tinymediamanager.core.UTF8Control;
import org.tinymediamanager.core.movie.MovieSetSearchAndScrapeOptions;
import org.tinymediamanager.core.movie.entities.MovieSet;
import org.tinymediamanager.core.movie.tasks.MovieSetMissingArtworkDownloadTask;
import org.tinymediamanager.core.threading.TmmTaskManager;
import org.tinymediamanager.ui.IconManager;
import org.tinymediamanager.ui.MainWindow;
import org.tinymediamanager.ui.actions.TmmAction;
import org.tinymediamanager.ui.moviesets.MovieSetUIModule;

public class MovieSetMissingArtworkAction
extends TmmAction {
    private static final ResourceBundle BUNDLE = ResourceBundle.getBundle("messages", new UTF8Control());

    public MovieSetMissingArtworkAction() {
        this.putValue("Name", BUNDLE.getString("movieset.downloadmissingartwork"));
        this.putValue("SmallIcon", IconManager.IMAGE);
        this.putValue("SwingLargeIconKey", IconManager.IMAGE);
    }

    @Override
    protected void processAction(ActionEvent e) {
        ArrayList<MovieSet> selectedMovieSets = new ArrayList<MovieSet>(MovieSetUIModule.getInstance().getSelectionModel().getSelectedMovieSets());
        if (selectedMovieSets.isEmpty()) {
            JOptionPane.showMessageDialog(MainWindow.getActiveInstance(), BUNDLE.getString("tmm.nothingselected"));
            return;
        }
        MovieSetSearchAndScrapeOptions options = new MovieSetSearchAndScrapeOptions();
        options.loadDefaults();
        MovieSetMissingArtworkDownloadTask task = new MovieSetMissingArtworkDownloadTask(selectedMovieSets, options);
        TmmTaskManager.getInstance().addDownloadTask(task);
    }
}

