/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.moviesets.actions;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.ResourceBundle;
import javax.swing.JOptionPane;
import org.tinymediamanager.core.UTF8Control;
import org.tinymediamanager.core.movie.MovieModuleManager;
import org.tinymediamanager.core.movie.entities.MovieSet;
import org.tinymediamanager.ui.MainWindow;
import org.tinymediamanager.ui.actions.TmmAction;
import org.tinymediamanager.ui.moviesets.MovieSetUIModule;

public class DebugDumpMovieSetAction
extends TmmAction {
    private static final long serialVersionUID = -8473181347332963044L;
    private static final ResourceBundle BUNDLE = ResourceBundle.getBundle("messages", new UTF8Control());

    public DebugDumpMovieSetAction() {
        this.putValue("Name", BUNDLE.getString("debug.entity.dump"));
        this.putValue("ShortDescription", BUNDLE.getString("debug.entity.dump.desc"));
    }

    @Override
    protected void processAction(ActionEvent e) {
        ArrayList<MovieSet> selectedMovieSets = new ArrayList<MovieSet>(MovieSetUIModule.getInstance().getSelectionModel().getSelectedMovieSets());
        if (selectedMovieSets.isEmpty()) {
            JOptionPane.showMessageDialog(MainWindow.getActiveInstance(), BUNDLE.getString("tmm.nothingselected"));
            return;
        }
        for (MovieSet ms : selectedMovieSets) {
            MovieModuleManager.getInstance().dump(ms);
        }
    }
}

