/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.moviesets;

import java.awt.CardLayout;
import java.awt.Component;
import javax.swing.Icon;
import javax.swing.JMenu;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import org.tinymediamanager.Globals;
import org.tinymediamanager.core.movie.MovieModuleManager;
import org.tinymediamanager.core.movie.entities.Movie;
import org.tinymediamanager.core.movie.entities.MovieSet;
import org.tinymediamanager.ui.AbstractTmmUIModule;
import org.tinymediamanager.ui.IconManager;
import org.tinymediamanager.ui.components.MainTabbedPane;
import org.tinymediamanager.ui.movies.MovieSelectionModel;
import org.tinymediamanager.ui.movies.panels.MovieArtworkPanel;
import org.tinymediamanager.ui.movies.panels.MovieCastPanel;
import org.tinymediamanager.ui.movies.panels.MovieInformationPanel;
import org.tinymediamanager.ui.movies.panels.MovieMediaInformationPanel;
import org.tinymediamanager.ui.movies.panels.TrailerPanel;
import org.tinymediamanager.ui.moviesets.MovieSetSelectionModel;
import org.tinymediamanager.ui.moviesets.actions.DebugDumpMovieSetAction;
import org.tinymediamanager.ui.moviesets.actions.MovieEditAction;
import org.tinymediamanager.ui.moviesets.actions.MovieSetAddAction;
import org.tinymediamanager.ui.moviesets.actions.MovieSetCleanupArtworkAction;
import org.tinymediamanager.ui.moviesets.actions.MovieSetEditAction;
import org.tinymediamanager.ui.moviesets.actions.MovieSetMissingArtworkAction;
import org.tinymediamanager.ui.moviesets.actions.MovieSetRemoveAction;
import org.tinymediamanager.ui.moviesets.actions.MovieSetRenameAction;
import org.tinymediamanager.ui.moviesets.actions.MovieSetSearchAction;
import org.tinymediamanager.ui.moviesets.dialogs.MovieSetFilterDialog;
import org.tinymediamanager.ui.moviesets.panels.MovieSetArtworkPanel;
import org.tinymediamanager.ui.moviesets.panels.MovieSetInformationPanel;
import org.tinymediamanager.ui.moviesets.panels.MovieSetTreePanel;
import org.tinymediamanager.ui.settings.TmmSettingsNode;

public class MovieSetUIModule
extends AbstractTmmUIModule {
    private static final String ID = "movieSets";
    private static MovieSetUIModule instance = null;
    private final MovieSetSelectionModel selectionModel = new MovieSetSelectionModel();
    private final MovieSelectionModel movieSelectionModel = new MovieSelectionModel();
    private final MovieSetTreePanel treePanel = new MovieSetTreePanel(this.selectionModel);
    private final JPanel dataPanel;
    private final MovieSetFilterDialog movieSetFilterDialog;
    private JPopupMenu popupMenu;

    private MovieSetUIModule() {
        this.listPanel = this.treePanel;
        this.detailPanel = new JPanel();
        this.detailPanel.setOpaque(false);
        this.detailPanel.setLayout(new CardLayout());
        this.dataPanel = new JPanel();
        this.dataPanel.setOpaque(false);
        this.dataPanel.setLayout(new CardLayout());
        this.detailPanel.add((Component)this.dataPanel, "cell 0 0, grow");
        MainTabbedPane movieSetDetailPanel = new MainTabbedPane(){
            private static final long serialVersionUID = 3233548865608767661L;

            @Override
            public void updateUI() {
                this.putClientProperty("leftBorder", "half");
                this.putClientProperty("bottomBorder", Boolean.FALSE);
                super.updateUI();
            }
        };
        movieSetDetailPanel.addTab(BUNDLE.getString("metatag.details"), new MovieSetInformationPanel(this.selectionModel));
        movieSetDetailPanel.addTab(BUNDLE.getString("metatag.artwork"), new MovieSetArtworkPanel(this.selectionModel));
        this.dataPanel.add((Component)movieSetDetailPanel, "movieSet");
        MainTabbedPane movieDetailPanel = new MainTabbedPane(){
            private static final long serialVersionUID = 3233548867189767661L;

            @Override
            public void updateUI() {
                this.putClientProperty("leftBorder", "half");
                this.putClientProperty("bottomBorder", Boolean.FALSE);
                super.updateUI();
            }
        };
        movieDetailPanel.addTab(BUNDLE.getString("metatag.details"), new MovieInformationPanel(this.movieSelectionModel));
        movieDetailPanel.addTab(BUNDLE.getString("metatag.cast"), new MovieCastPanel(this.movieSelectionModel));
        movieDetailPanel.addTab(BUNDLE.getString("metatag.mediafiles"), new MovieMediaInformationPanel(this.movieSelectionModel));
        movieDetailPanel.addTab(BUNDLE.getString("metatag.artwork"), new MovieArtworkPanel(this.movieSelectionModel));
        movieDetailPanel.addTab(BUNDLE.getString("metatag.trailer"), new TrailerPanel(this.movieSelectionModel));
        this.dataPanel.add((Component)movieDetailPanel, "movie");
        this.movieSetFilterDialog = new MovieSetFilterDialog(this.treePanel.getTreeTable());
        this.createActions();
        this.createPopupMenu();
        this.registerAccelerators();
        this.init();
    }

    public static MovieSetUIModule getInstance() {
        if (instance == null) {
            instance = new MovieSetUIModule();
        }
        return instance;
    }

    private void init() {
        if (MovieModuleManager.SETTINGS.isStoreUiFilters()) {
            SwingUtilities.invokeLater(() -> this.treePanel.getTreeTable().setFilterValues(MovieModuleManager.SETTINGS.getMovieSetUiFilters()));
        }
    }

    public void setFilterDialogVisible(boolean visible) {
        this.movieSetFilterDialog.setVisible(visible);
    }

    private void createActions() {
        this.updateAction = this.createAndRegisterAction(MovieSetAddAction.class);
        this.searchAction = this.createAndRegisterAction(MovieSetSearchAction.class);
        this.editAction = this.createAndRegisterAction(MovieSetEditAction.class);
    }

    private void createPopupMenu() {
        this.popupMenu = new JPopupMenu();
        this.popupMenu.add(this.createAndRegisterAction(MovieSetAddAction.class));
        this.popupMenu.add(this.createAndRegisterAction(MovieSetRemoveAction.class));
        this.popupMenu.add(this.createAndRegisterAction(MovieSetEditAction.class));
        this.popupMenu.add(this.createAndRegisterAction(MovieSetSearchAction.class));
        this.popupMenu.add(this.createAndRegisterAction(MovieSetCleanupArtworkAction.class));
        this.popupMenu.add(this.createAndRegisterAction(MovieSetMissingArtworkAction.class));
        this.popupMenu.addSeparator();
        this.popupMenu.add(this.createAndRegisterAction(MovieEditAction.class));
        this.popupMenu.addSeparator();
        this.popupMenu.add(this.createAndRegisterAction(MovieSetRenameAction.class));
        if (Globals.isDebug()) {
            JMenu debugMenu = new JMenu("Debug");
            debugMenu.add(new DebugDumpMovieSetAction());
            this.popupMenu.addSeparator();
            this.popupMenu.add(debugMenu);
        }
        this.listPanel.setPopupMenu(this.popupMenu);
        this.updatePopupMenu = new JPopupMenu(BUNDLE.getString("movieset.add"));
        this.updatePopupMenu.add(this.createAndRegisterAction(MovieSetAddAction.class));
    }

    @Override
    public String getModuleId() {
        return ID;
    }

    @Override
    public String getTabTitle() {
        return BUNDLE.getString("tmm.moviesets");
    }

    @Override
    public Icon getSearchButtonIcon() {
        return IconManager.TOOLBAR_ADD_MOVIE_SET;
    }

    @Override
    public Icon getSearchButtonHoverIcon() {
        return IconManager.TOOLBAR_ADD_MOVIE_SET_HOVER;
    }

    public MovieSetSelectionModel getSelectionModel() {
        return this.selectionModel;
    }

    @Override
    public TmmSettingsNode getSettingsNode() {
        return null;
    }

    public void setSelectedMovieSet(MovieSet movieSet) {
        this.selectionModel.setSelectedMovieSet(movieSet);
        CardLayout cl = (CardLayout)this.dataPanel.getLayout();
        cl.show(this.dataPanel, "movieSet");
    }

    public void setSelectedMovie(Movie movie) {
        this.movieSelectionModel.setSelectedMovie(movie);
        CardLayout cl = (CardLayout)this.dataPanel.getLayout();
        cl.show(this.dataPanel, "movie");
    }
}

