/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.moviesets;

import java.awt.FontMetrics;
import java.util.ResourceBundle;
import javax.swing.ImageIcon;
import org.tinymediamanager.core.MediaFileType;
import org.tinymediamanager.core.UTF8Control;
import org.tinymediamanager.core.entities.MediaEntity;
import org.tinymediamanager.core.entities.MediaFile;
import org.tinymediamanager.core.entities.MediaRating;
import org.tinymediamanager.core.movie.entities.Movie;
import org.tinymediamanager.core.movie.entities.MovieSet;
import org.tinymediamanager.ui.IconManager;
import org.tinymediamanager.ui.components.table.TmmTableFormat;
import org.tinymediamanager.ui.components.tree.TmmTreeNode;
import org.tinymediamanager.ui.renderer.RightAlignTableCellRenderer;

public class MovieSetTableFormat
extends TmmTableFormat<TmmTreeNode> {
    private static final ResourceBundle BUNDLE = ResourceBundle.getBundle("messages", new UTF8Control());

    public MovieSetTableFormat() {
        FontMetrics fontMetrics = this.getFontMetrics();
        TmmTableFormat.Column col = new TmmTableFormat.Column(this, BUNDLE.getString("movieset.moviecount"), "seasons", this::getMovieCount, String.class);
        col.setHeaderIcon(IconManager.COUNT);
        col.setColumnResizeable(false);
        col.setMinWidth((int)((float)fontMetrics.stringWidth("99") * 1.2f));
        this.addColumn(col);
        col = new TmmTableFormat.Column(this, BUNDLE.getString("metatag.rating"), "rating", this::getRating, String.class);
        col.setHeaderIcon(IconManager.RATING);
        col.setCellRenderer(new RightAlignTableCellRenderer());
        col.setColumnResizeable(false);
        col.setMinWidth((int)((float)fontMetrics.stringWidth("99.9") * 1.2f));
        this.addColumn(col);
        col = new TmmTableFormat.Column(this, BUNDLE.getString("metatag.format"), "format", this::getFormat, String.class);
        col.setHeaderIcon(IconManager.VIDEO_FORMAT);
        col.setColumnResizeable(false);
        col.setMinWidth((int)((float)fontMetrics.stringWidth("1080p") * 1.2f));
        this.addColumn(col);
        col = new TmmTableFormat.Column(this, BUNDLE.getString("metatag.size"), "fileSize", this::getFileSize, String.class);
        col.setHeaderIcon(IconManager.FILE_SIZE);
        col.setCellRenderer(new RightAlignTableCellRenderer());
        col.setColumnResizeable(false);
        col.setMinWidth((int)((float)fontMetrics.stringWidth("50000M") * 1.2f));
        this.addColumn(col);
        col = new TmmTableFormat.Column(this, BUNDLE.getString("tmm.nfo"), "nfo", this::hasNfo, ImageIcon.class);
        col.setHeaderIcon(IconManager.NFO);
        col.setColumnResizeable(false);
        this.addColumn(col);
        col = new TmmTableFormat.Column(this, BUNDLE.getString("tmm.images"), "images", this::hasImages, ImageIcon.class);
        col.setHeaderIcon(IconManager.IMAGES);
        col.setColumnResizeable(false);
        this.addColumn(col);
        col = new TmmTableFormat.Column(this, BUNDLE.getString("metatag.watched"), "watched", this::isWatched, ImageIcon.class);
        col.setHeaderIcon(IconManager.WATCHED);
        col.setColumnResizeable(false);
        this.addColumn(col);
    }

    private String getMovieCount(TmmTreeNode node) {
        int size;
        Object userObject = node.getUserObject();
        if (userObject instanceof MovieSet && (size = ((MovieSet)userObject).getMovies().size()) > 0) {
            return String.valueOf(size);
        }
        return null;
    }

    private String getRating(TmmTreeNode node) {
        MediaRating mediaRating;
        Object userObject = node.getUserObject();
        if (userObject instanceof Movie && (mediaRating = ((MediaEntity)userObject).getRating()) != null && mediaRating.getRating() > 0.0f) {
            return String.valueOf(mediaRating.getRating());
        }
        return null;
    }

    private String getFormat(TmmTreeNode node) {
        Object userObject = node.getUserObject();
        if (userObject instanceof Movie) {
            return ((Movie)userObject).getMediaInfoVideoFormat();
        }
        return null;
    }

    private String getFileSize(TmmTreeNode node) {
        Object userObject = node.getUserObject();
        if (userObject instanceof Movie) {
            long size = 0L;
            for (MediaFile mf : ((Movie)userObject).getMediaFiles(MediaFileType.VIDEO)) {
                size += mf.getFilesize();
            }
            return (int)((double)size / 1000000.0) + " M";
        }
        return null;
    }

    private ImageIcon hasNfo(TmmTreeNode node) {
        Object userObject = node.getUserObject();
        if (userObject instanceof Movie) {
            return this.getCheckIcon(((Movie)userObject).getHasNfoFile());
        }
        return null;
    }

    private ImageIcon hasImages(TmmTreeNode node) {
        Object userObject = node.getUserObject();
        if (userObject instanceof MovieSet) {
            return this.getCheckIcon(((MovieSet)userObject).getHasImages());
        }
        if (userObject instanceof Movie) {
            return this.getCheckIcon(((Movie)userObject).getHasImages());
        }
        return null;
    }

    private ImageIcon isWatched(TmmTreeNode node) {
        Object userObject = node.getUserObject();
        if (userObject instanceof MovieSet) {
            return this.getCheckIcon(((MovieSet)userObject).isWatched());
        }
        if (userObject instanceof Movie) {
            return this.getCheckIcon(((Movie)userObject).isWatched());
        }
        return null;
    }
}

