/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.movies.panels;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.beans.PropertyChangeListener;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ResourceBundle;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang3.StringUtils;
import org.jdesktop.beansbinding.AutoBinding;
import org.jdesktop.beansbinding.BeanProperty;
import org.jdesktop.beansbinding.Bindings;
import org.jdesktop.beansbinding.Converter;
import org.jdesktop.beansbinding.Property;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.core.MediaFileType;
import org.tinymediamanager.core.Message;
import org.tinymediamanager.core.MessageManager;
import org.tinymediamanager.core.UTF8Control;
import org.tinymediamanager.core.entities.MediaFile;
import org.tinymediamanager.core.movie.entities.Movie;
import org.tinymediamanager.ui.ColumnLayout;
import org.tinymediamanager.ui.IconManager;
import org.tinymediamanager.ui.TmmUIHelper;
import org.tinymediamanager.ui.components.FlatButton;
import org.tinymediamanager.ui.components.ImageLabel;
import org.tinymediamanager.ui.components.LinkLabel;
import org.tinymediamanager.ui.components.ReadOnlyTextArea;
import org.tinymediamanager.ui.components.StarRater;
import org.tinymediamanager.ui.components.TmmLabel;
import org.tinymediamanager.ui.converter.CertificationImageConverter;
import org.tinymediamanager.ui.converter.RatingConverter;
import org.tinymediamanager.ui.converter.RuntimeConverter;
import org.tinymediamanager.ui.converter.VoteCountConverter;
import org.tinymediamanager.ui.converter.ZeroIdConverter;
import org.tinymediamanager.ui.movies.MovieOtherIdsConverter;
import org.tinymediamanager.ui.movies.MovieSelectionModel;
import org.tinymediamanager.ui.panels.MediaInformationLogosPanel;

public class MovieInformationPanel
extends JPanel {
    private static final Logger LOGGER = LoggerFactory.getLogger(MovieInformationPanel.class);
    private static final long serialVersionUID = -8527284262749511617L;
    private static final ResourceBundle BUNDLE = ResourceBundle.getBundle("messages", new UTF8Control());
    private final MovieSelectionModel movieSelectionModel;
    private StarRater starRater;
    private JLabel lblMovieName;
    private JLabel lblRating;
    private JLabel lblVoteCount;
    private JLabel lblTagline;
    private JLabel lblYear;
    private LinkLabel lblImdbid;
    private JLabel lblRunningTime;
    private LinkLabel lblTmdbid;
    private JTextArea taGenres;
    private JTextArea taPlot;
    private ImageLabel lblMoviePoster;
    private JLabel lblPosterSize;
    private ImageLabel lblMovieFanart;
    private JLabel lblFanartSize;
    private JLabel lblCertification;
    private JTextArea taOtherIds;
    private MediaInformationLogosPanel panelLogos;
    private JSeparator sepLogos;
    private JLabel lblOriginalTitle;
    private JButton btnPlay;
    private JScrollPane scrollPane;
    private JTextArea taProduction;
    private JTextArea taTags;
    private JLabel lblEdition;
    private LinkLabel lblMoviePath;
    private JLabel lblMovieSet;
    private JLabel lblSpokenLanguages;
    private JLabel lblCountry;
    private JLabel lblReleaseDate;
    private JTextArea taNote;
    private JLabel lblCertificationLogo;
    private LinkLabel lblTraktTvId;

    public MovieInformationPanel(MovieSelectionModel movieSelectionModel) {
        this.movieSelectionModel = movieSelectionModel;
        this.initComponents();
        this.initDataBindings();
        this.lblTmdbid.addActionListener(arg0 -> {
            String url = "https://www.themoviedb.org/movie/" + this.lblTmdbid.getText();
            try {
                TmmUIHelper.browseUrl(url);
            }
            catch (Exception e) {
                LOGGER.error("browse to tmdbid", (Throwable)e);
                MessageManager.instance.pushMessage(new Message(Message.MessageLevel.ERROR, (Object)url, "message.erroropenurl", new String[]{":", e.getLocalizedMessage()}));
            }
        });
        this.lblImdbid.addActionListener(arg0 -> {
            String url = "https://www.imdb.com/title/" + this.lblImdbid.getText();
            try {
                TmmUIHelper.browseUrl(url);
            }
            catch (Exception e) {
                LOGGER.error("browse to imdbid", (Throwable)e);
                MessageManager.instance.pushMessage(new Message(Message.MessageLevel.ERROR, (Object)url, "message.erroropenurl", new String[]{":", e.getLocalizedMessage()}));
            }
        });
        this.lblTraktTvId.addActionListener(arg0 -> {
            String url = "https://trakt.tv/movies/" + this.lblTraktTvId.getText();
            try {
                TmmUIHelper.browseUrl(url);
            }
            catch (Exception e) {
                LOGGER.error("browse to trakt.tv", (Throwable)e);
                MessageManager.instance.pushMessage(new Message(Message.MessageLevel.ERROR, (Object)url, "message.erroropenurl", new String[]{":", e.getLocalizedMessage()}));
            }
        });
        this.lblMoviePath.addActionListener(arg0 -> {
            if (!StringUtils.isEmpty((CharSequence)this.lblMoviePath.getText())) {
                Path path = Paths.get(this.lblMoviePath.getText(), new String[0]);
                try {
                    if (Files.exists(path, new LinkOption[0])) {
                        TmmUIHelper.openFile(path);
                    }
                }
                catch (Exception ex) {
                    LOGGER.error("open filemanager", (Throwable)ex);
                    MessageManager.instance.pushMessage(new Message(Message.MessageLevel.ERROR, (Object)path, "message.erroropenfolder", new String[]{":", ex.getLocalizedMessage()}));
                }
            }
        });
        PropertyChangeListener propertyChangeListener = propertyChangeEvent -> {
            String property = propertyChangeEvent.getPropertyName();
            Object source = propertyChangeEvent.getSource();
            if (source.getClass() != MovieSelectionModel.class) {
                return;
            }
            MovieSelectionModel selectionModel = (MovieSelectionModel)source;
            Movie movie = selectionModel.getSelectedMovie();
            if ("selectedMovie".equals(property) || "poster".equals(property)) {
                this.setPoster(movie);
            }
            if ("selectedMovie".equals(property) || "fanart".equals(property)) {
                this.setFanart(movie);
            }
            if ("selectedMovie".equals(property) || "mediaFiles".equals(property) || "mediaInformation".equals(property)) {
                this.panelLogos.setMediaInformationSource(movie);
            }
            if ("selectedMovie".equals(property)) {
                SwingUtilities.invokeLater(() -> this.scrollPane.getVerticalScrollBar().setValue(0));
            }
        };
        movieSelectionModel.addPropertyChangeListener(propertyChangeListener);
        this.btnPlay.addActionListener(e -> {
            MediaFile mf = movieSelectionModel.getSelectedMovie().getMainVideoFile();
            if (StringUtils.isNotBlank((CharSequence)mf.getFilename())) {
                try {
                    TmmUIHelper.openFile(mf.getFileAsPath());
                }
                catch (Exception ex) {
                    LOGGER.error("open file", (Throwable)ex);
                    MessageManager.instance.pushMessage(new Message(Message.MessageLevel.ERROR, (Object)mf, "message.erroropenfile", new String[]{":", ex.getLocalizedMessage()}));
                }
            }
        });
    }

    private void initComponents() {
        this.putClientProperty("class", "roundedPanel");
        this.setLayout((LayoutManager)new MigLayout("", "[100lp:100lp,grow][300lp:300lp,grow 250]", "[][grow]"));
        JPanel panelLeft = new JPanel();
        panelLeft.setLayout(new ColumnLayout());
        this.add((Component)panelLeft, "cell 0 0 1 2,grow");
        this.lblMoviePoster = new ImageLabel(false, false, true);
        this.lblMoviePoster.setDesiredAspectRatio(0.6666667f);
        this.lblMoviePoster.setCursor(Cursor.getPredefinedCursor(12));
        panelLeft.add(this.lblMoviePoster);
        this.lblMoviePoster.enableLightbox();
        this.lblPosterSize = new JLabel(BUNDLE.getString("mediafiletype.poster"));
        panelLeft.add(this.lblPosterSize);
        panelLeft.add(Box.createVerticalStrut(20));
        this.lblMovieFanart = new ImageLabel(false, false, true);
        this.lblMovieFanart.setDesiredAspectRatio(1.7777778f);
        this.lblMovieFanart.setCursor(Cursor.getPredefinedCursor(12));
        panelLeft.add(this.lblMovieFanart);
        this.lblMovieFanart.enableLightbox();
        this.lblFanartSize = new JLabel(BUNDLE.getString("mediafiletype.fanart"));
        panelLeft.add(this.lblFanartSize);
        JPanel panelTitle = new JPanel();
        this.add((Component)panelTitle, "cell 1 0,grow");
        panelTitle.setLayout((LayoutManager)new MigLayout("insets 0 0 n n", "[grow][]", "[][][shrink 0]"));
        this.lblMovieName = new TmmLabel("", 1.33);
        panelTitle.add((Component)this.lblMovieName, "flowx,cell 0 0,wmin 0,growx");
        this.btnPlay = new FlatButton(IconManager.PLAY_LARGE);
        panelTitle.add((Component)this.btnPlay, "cell 1 0 1 2,aligny top");
        this.lblOriginalTitle = new JLabel("");
        panelTitle.add((Component)this.lblOriginalTitle, "cell 0 1,growx,wmin 0");
        panelTitle.add((Component)new JSeparator(), "cell 0 2 2 1,growx");
        JPanel panelRight = new JPanel();
        panelRight.setLayout((LayoutManager)new MigLayout("insets n 0 n n, hidemode 2", "[100lp,grow]", "[shrink 0][][shrink 0][][][][][shrink 0][][grow,top][][]"));
        this.scrollPane = new JScrollPane(panelRight);
        this.scrollPane.setHorizontalScrollBarPolicy(31);
        this.add((Component)this.scrollPane, "cell 1 1,grow, wmin 0");
        JPanel panelTopDetails = new JPanel();
        panelRight.add((Component)panelTopDetails, "cell 0 0,grow");
        panelTopDetails.setLayout((LayoutManager)new MigLayout("insets 0", "[][][40lp][][grow][]", "[]2lp[]2lp[grow]2lp[]2lp[]2lp[]2lp[]2lp[]"));
        TmmLabel lblYearT = new TmmLabel(BUNDLE.getString("metatag.year"));
        panelTopDetails.add((Component)lblYearT, "cell 0 0");
        this.lblYear = new JLabel("");
        panelTopDetails.add((Component)this.lblYear, "cell 1 0,growx");
        TmmLabel lblImdbIdT = new TmmLabel(BUNDLE.getString("metatag.imdb"));
        panelTopDetails.add((Component)lblImdbIdT, "cell 3 0");
        this.lblImdbid = new LinkLabel("");
        panelTopDetails.add((Component)this.lblImdbid, "cell 4 0");
        this.lblCertificationLogo = new JLabel("");
        panelTopDetails.add((Component)this.lblCertificationLogo, "cell 5 0 1 3, top");
        TmmLabel lblReleaseDateT = new TmmLabel(BUNDLE.getString("metatag.releasedate"));
        panelTopDetails.add((Component)lblReleaseDateT, "cell 0 1");
        this.lblReleaseDate = new JLabel("");
        panelTopDetails.add((Component)this.lblReleaseDate, "cell 1 1");
        TmmLabel lblTmdbIdT = new TmmLabel(BUNDLE.getString("metatag.tmdb"));
        panelTopDetails.add((Component)lblTmdbIdT, "cell 3 1");
        this.lblTmdbid = new LinkLabel("");
        panelTopDetails.add((Component)this.lblTmdbid, "cell 4 1");
        TmmLabel lblCertificationT = new TmmLabel(BUNDLE.getString("metatag.certification"));
        panelTopDetails.add((Component)lblCertificationT, "cell 0 2");
        this.lblCertification = new JLabel("");
        panelTopDetails.add((Component)this.lblCertification, "cell 1 2,growx");
        TmmLabel lblTraktTvIdT = new TmmLabel("Trakt.tv ID");
        panelTopDetails.add((Component)lblTraktTvIdT, "cell 3 2");
        this.lblTraktTvId = new LinkLabel();
        panelTopDetails.add((Component)this.lblTraktTvId, "cell 4 2");
        TmmLabel lblOtherIdsT = new TmmLabel(BUNDLE.getString("metatag.otherids"));
        panelTopDetails.add((Component)lblOtherIdsT, "cell 3 3");
        this.taOtherIds = new ReadOnlyTextArea();
        panelTopDetails.add((Component)this.taOtherIds, "cell 4 3 2 1,growx,wmin 0");
        TmmLabel lblRunningTimeT = new TmmLabel(BUNDLE.getString("metatag.runtime"));
        panelTopDetails.add((Component)lblRunningTimeT, "cell 0 3,aligny top");
        this.lblRunningTime = new JLabel("");
        panelTopDetails.add((Component)this.lblRunningTime, "cell 1 3,aligny top");
        TmmLabel lblGenresT = new TmmLabel(BUNDLE.getString("metatag.genre"));
        panelTopDetails.add((Component)lblGenresT, "cell 0 4");
        this.taGenres = new ReadOnlyTextArea();
        panelTopDetails.add((Component)this.taGenres, "cell 1 4 5 1,growx,wmin 0");
        TmmLabel lblProductionT = new TmmLabel(BUNDLE.getString("metatag.production"));
        panelTopDetails.add((Component)lblProductionT, "cell 0 5");
        this.taProduction = new ReadOnlyTextArea();
        panelTopDetails.add((Component)this.taProduction, "cell 1 5 5 1,growx,wmin 0");
        TmmLabel lblCountryT = new TmmLabel(BUNDLE.getString("metatag.country"));
        panelTopDetails.add((Component)lblCountryT, "cell 0 6");
        this.lblCountry = new JLabel("");
        panelTopDetails.add((Component)this.lblCountry, "cell 1 6 5 1,wmin 0");
        TmmLabel lblSpokenLanguagesT = new TmmLabel(BUNDLE.getString("metatag.spokenlanguages"));
        panelTopDetails.add((Component)lblSpokenLanguagesT, "cell 0 7,wmin 0");
        this.lblSpokenLanguages = new JLabel("");
        panelTopDetails.add((Component)this.lblSpokenLanguages, "cell 1 7 5 1");
        panelRight.add((Component)new JSeparator(), "cell 0 1,growx");
        this.starRater = new StarRater(10, 1);
        panelRight.add((Component)this.starRater, "flowx,cell 0 2,aligny center");
        this.starRater.setEnabled(false);
        this.lblRating = new JLabel("");
        panelRight.add((Component)this.lblRating, "cell 0 2,aligny center");
        this.lblVoteCount = new JLabel("");
        panelRight.add((Component)this.lblVoteCount, "cell 0 2,aligny center");
        this.sepLogos = new JSeparator();
        panelRight.add((Component)this.sepLogos, "cell 0 3,growx");
        this.panelLogos = new MediaInformationLogosPanel();
        panelRight.add((Component)this.panelLogos, "cell 0 4,wmin 0");
        panelRight.add((Component)new JSeparator(), "cell 0 5,growx");
        TmmLabel lblTaglineT = new TmmLabel(BUNDLE.getString("metatag.tagline"));
        panelRight.add((Component)lblTaglineT, "cell 0 6,alignx left,aligny top");
        this.lblTagline = new JLabel();
        panelRight.add((Component)this.lblTagline, "cell 0 7,growx,wmin 0,aligny top");
        TmmLabel lblPlotT = new TmmLabel(BUNDLE.getString("metatag.plot"));
        panelRight.add((Component)lblPlotT, "cell 0 8,alignx left,aligny top");
        this.taPlot = new ReadOnlyTextArea();
        panelRight.add((Component)this.taPlot, "cell 0 9,growx,wmin 0,aligny top");
        panelRight.add((Component)new JSeparator(), "cell 0 10,growx");
        JPanel panelBottomDetails = new JPanel();
        panelRight.add((Component)panelBottomDetails, "cell 0 11,grow");
        panelBottomDetails.setLayout((LayoutManager)new MigLayout("insets 0", "[][200lp,grow]", "[]2lp[]2lp[]2lp[]2lp[]"));
        TmmLabel lblMoviesetT = new TmmLabel(BUNDLE.getString("metatag.movieset"));
        panelBottomDetails.add((Component)lblMoviesetT, "cell 0 0");
        this.lblMovieSet = new JLabel("");
        panelBottomDetails.add((Component)this.lblMovieSet, "cell 1 0,growx,wmin 0");
        TmmLabel lblEditionT = new TmmLabel(BUNDLE.getString("metatag.edition"));
        panelBottomDetails.add((Component)lblEditionT, "cell 0 1");
        this.lblEdition = new JLabel("");
        panelBottomDetails.add((Component)this.lblEdition, "cell 1 1,growx,wmin 0");
        TmmLabel lblTagsT = new TmmLabel(BUNDLE.getString("metatag.tags"));
        panelBottomDetails.add((Component)lblTagsT, "cell 0 2");
        this.taTags = new ReadOnlyTextArea();
        panelBottomDetails.add((Component)this.taTags, "cell 1 2,growx,wmin 0");
        TmmLabel lblMoviePathT = new TmmLabel(BUNDLE.getString("metatag.path"));
        panelBottomDetails.add((Component)lblMoviePathT, "cell 0 3");
        this.lblMoviePath = new LinkLabel("");
        panelBottomDetails.add((Component)this.lblMoviePath, "cell 1 3,growx,wmin 0");
        TmmLabel lblNoteT = new TmmLabel(BUNDLE.getString("metatag.note"));
        panelBottomDetails.add((Component)lblNoteT, "cell 0 4");
        this.taNote = new ReadOnlyTextArea();
        panelBottomDetails.add((Component)this.taNote, "cell 1 4,growx,wmin 0");
    }

    private void setPoster(Movie movie) {
        this.lblMoviePoster.clearImage();
        this.lblMoviePoster.setImagePath(movie.getArtworkFilename(MediaFileType.POSTER));
        Dimension posterSize = movie.getArtworkDimension(MediaFileType.POSTER);
        if (posterSize.width > 0 && posterSize.height > 0) {
            this.lblPosterSize.setText(BUNDLE.getString("mediafiletype.poster") + " - " + posterSize.width + "x" + posterSize.height);
        } else {
            this.lblPosterSize.setText(BUNDLE.getString("mediafiletype.poster"));
        }
    }

    private void setFanart(Movie movie) {
        this.lblMovieFanart.clearImage();
        this.lblMovieFanart.setImagePath(movie.getArtworkFilename(MediaFileType.FANART));
        Dimension fanartSize = movie.getArtworkDimension(MediaFileType.FANART);
        if (fanartSize.width > 0 && fanartSize.height > 0) {
            this.lblFanartSize.setText(BUNDLE.getString("mediafiletype.fanart") + " - " + fanartSize.width + "x" + fanartSize.height);
        } else {
            this.lblFanartSize.setText(BUNDLE.getString("mediafiletype.fanart"));
        }
    }

    protected void initDataBindings() {
        BeanProperty movieSelectionModelBeanProperty_2 = BeanProperty.create((String)"selectedMovie.rating.votes");
        BeanProperty jLabelBeanProperty = BeanProperty.create((String)"text");
        AutoBinding autoBinding_2 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this.movieSelectionModel, (Property)movieSelectionModelBeanProperty_2, (Object)this.lblVoteCount, (Property)jLabelBeanProperty);
        autoBinding_2.setConverter((Converter)new VoteCountConverter());
        autoBinding_2.bind();
        BeanProperty movieSelectionModelBeanProperty_8 = BeanProperty.create((String)"selectedMovie.year");
        AutoBinding autoBinding_9 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this.movieSelectionModel, (Property)movieSelectionModelBeanProperty_8, (Object)this.lblYear, (Property)jLabelBeanProperty);
        autoBinding_9.bind();
        BeanProperty movieSelectionModelBeanProperty_12 = BeanProperty.create((String)"selectedMovie.imdbId");
        BeanProperty jTextAreaBeanProperty = BeanProperty.create((String)"text");
        AutoBinding autoBinding_10 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this.movieSelectionModel, (Property)movieSelectionModelBeanProperty_12, (Object)this.lblImdbid, (Property)jTextAreaBeanProperty);
        autoBinding_10.bind();
        BeanProperty movieSelectionModelBeanProperty_13 = BeanProperty.create((String)"selectedMovie.runtime");
        AutoBinding autoBinding_14 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this.movieSelectionModel, (Property)movieSelectionModelBeanProperty_13, (Object)this.lblRunningTime, (Property)jLabelBeanProperty);
        autoBinding_14.setConverter((Converter)new RuntimeConverter());
        autoBinding_14.bind();
        BeanProperty movieSelectionModelBeanProperty_15 = BeanProperty.create((String)"selectedMovie.tmdbId");
        AutoBinding autoBinding_7 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this.movieSelectionModel, (Property)movieSelectionModelBeanProperty_15, (Object)this.lblTmdbid, (Property)jTextAreaBeanProperty);
        autoBinding_7.setConverter((Converter)new ZeroIdConverter());
        autoBinding_7.bind();
        BeanProperty movieSelectionModelBeanProperty_16 = BeanProperty.create((String)"selectedMovie.genresAsString");
        AutoBinding autoBinding_17 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this.movieSelectionModel, (Property)movieSelectionModelBeanProperty_16, (Object)this.taGenres, (Property)jTextAreaBeanProperty);
        autoBinding_17.bind();
        BeanProperty movieSelectionModelBeanProperty_14 = BeanProperty.create((String)"selectedMovie.plot");
        AutoBinding autoBinding_18 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this.movieSelectionModel, (Property)movieSelectionModelBeanProperty_14, (Object)this.taPlot, (Property)jTextAreaBeanProperty);
        autoBinding_18.bind();
        BeanProperty movieSelectionModelBeanProperty_3 = BeanProperty.create((String)"selectedMovie.tagline");
        AutoBinding autoBinding_4 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this.movieSelectionModel, (Property)movieSelectionModelBeanProperty_3, (Object)this.lblTagline, (Property)jLabelBeanProperty);
        autoBinding_4.bind();
        BeanProperty movieSelectionModelBeanProperty_4 = BeanProperty.create((String)"selectedMovie.title");
        AutoBinding autoBinding_5 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this.movieSelectionModel, (Property)movieSelectionModelBeanProperty_4, (Object)this.lblMovieName, (Property)jLabelBeanProperty);
        autoBinding_5.bind();
        BeanProperty movieSelectionModelBeanProperty = BeanProperty.create((String)"selectedMovie.certification.name");
        AutoBinding autoBinding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this.movieSelectionModel, (Property)movieSelectionModelBeanProperty, (Object)this.lblCertification, (Property)jLabelBeanProperty);
        autoBinding.bind();
        BeanProperty movieSelectionModelBeanProperty_6 = BeanProperty.create((String)"selectedMovie.originalTitle");
        AutoBinding autoBinding_8 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this.movieSelectionModel, (Property)movieSelectionModelBeanProperty_6, (Object)this.lblOriginalTitle, (Property)jLabelBeanProperty);
        autoBinding_8.bind();
        BeanProperty movieSelectionModelBeanProperty_5 = BeanProperty.create((String)"selectedMovie.ids");
        AutoBinding autoBinding_6 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this.movieSelectionModel, (Property)movieSelectionModelBeanProperty_5, (Object)this.taOtherIds, (Property)jTextAreaBeanProperty);
        autoBinding_6.setConverter((Converter)new MovieOtherIdsConverter());
        autoBinding_6.bind();
        BeanProperty movieSelectionModelBeanProperty_7 = BeanProperty.create((String)"selectedMovie.rating.ratingNormalized");
        BeanProperty starRaterBeanProperty = BeanProperty.create((String)"rating");
        AutoBinding autoBinding_3 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this.movieSelectionModel, (Property)movieSelectionModelBeanProperty_7, (Object)this.starRater, (Property)starRaterBeanProperty);
        autoBinding_3.bind();
        BeanProperty movieSelectionModelBeanProperty_9 = BeanProperty.create((String)"selectedMovie");
        BeanProperty jLabelBeanProperty_1 = BeanProperty.create((String)"text");
        AutoBinding autoBinding_1 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this.movieSelectionModel, (Property)movieSelectionModelBeanProperty_9, (Object)this.lblRating, (Property)jLabelBeanProperty_1);
        autoBinding_1.setConverter(new RatingConverter());
        autoBinding_1.bind();
        BeanProperty movieSelectionModelBeanProperty_1 = BeanProperty.create((String)"selectedMovie.releaseDateAsString");
        AutoBinding autoBinding_11 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this.movieSelectionModel, (Property)movieSelectionModelBeanProperty_1, (Object)this.lblReleaseDate, (Property)jLabelBeanProperty);
        autoBinding_11.bind();
        BeanProperty movieSelectionModelBeanProperty_10 = BeanProperty.create((String)"selectedMovie.productionCompany");
        AutoBinding autoBinding_12 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this.movieSelectionModel, (Property)movieSelectionModelBeanProperty_10, (Object)this.taProduction, (Property)jTextAreaBeanProperty);
        autoBinding_12.bind();
        BeanProperty movieSelectionModelBeanProperty_11 = BeanProperty.create((String)"selectedMovie.country");
        AutoBinding autoBinding_13 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this.movieSelectionModel, (Property)movieSelectionModelBeanProperty_11, (Object)this.lblCountry, (Property)jLabelBeanProperty);
        autoBinding_13.bind();
        BeanProperty movieSelectionModelBeanProperty_17 = BeanProperty.create((String)"selectedMovie.spokenLanguages");
        AutoBinding autoBinding_15 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this.movieSelectionModel, (Property)movieSelectionModelBeanProperty_17, (Object)this.lblSpokenLanguages, (Property)jLabelBeanProperty);
        autoBinding_15.bind();
        BeanProperty movieSelectionModelBeanProperty_18 = BeanProperty.create((String)"selectedMovie.movieSetTitle");
        AutoBinding autoBinding_16 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this.movieSelectionModel, (Property)movieSelectionModelBeanProperty_18, (Object)this.lblMovieSet, (Property)jLabelBeanProperty);
        autoBinding_16.bind();
        BeanProperty movieSelectionModelBeanProperty_19 = BeanProperty.create((String)"selectedMovie.edition.title");
        AutoBinding autoBinding_19 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this.movieSelectionModel, (Property)movieSelectionModelBeanProperty_19, (Object)this.lblEdition, (Property)jLabelBeanProperty);
        autoBinding_19.bind();
        BeanProperty movieSelectionModelBeanProperty_20 = BeanProperty.create((String)"selectedMovie.tagsAsString");
        AutoBinding autoBinding_20 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this.movieSelectionModel, (Property)movieSelectionModelBeanProperty_20, (Object)this.taTags, (Property)jTextAreaBeanProperty);
        autoBinding_20.bind();
        BeanProperty movieSelectionModelBeanProperty_21 = BeanProperty.create((String)"selectedMovie.path");
        BeanProperty linkLabelBeanProperty = BeanProperty.create((String)"text");
        AutoBinding autoBinding_21 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this.movieSelectionModel, (Property)movieSelectionModelBeanProperty_21, (Object)this.lblMoviePath, (Property)linkLabelBeanProperty);
        autoBinding_21.bind();
        BeanProperty movieSelectionModelBeanProperty_22 = BeanProperty.create((String)"selectedMovie.note");
        AutoBinding autoBinding_22 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this.movieSelectionModel, (Property)movieSelectionModelBeanProperty_22, (Object)this.taNote, (Property)jTextAreaBeanProperty);
        autoBinding_22.bind();
        BeanProperty movieSelectionModelBeanProperty_23 = BeanProperty.create((String)"selectedMovie.certification");
        BeanProperty jLabelBeanProperty_2 = BeanProperty.create((String)"icon");
        AutoBinding autoBinding_23 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this.movieSelectionModel, (Property)movieSelectionModelBeanProperty_23, (Object)this.lblCertificationLogo, (Property)jLabelBeanProperty_2);
        autoBinding_23.setConverter((Converter)new CertificationImageConverter());
        autoBinding_23.bind();
        BeanProperty movieSelectionModelBeanProperty_24 = BeanProperty.create((String)"selectedMovie.traktTvId");
        AutoBinding autoBinding_24 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this.movieSelectionModel, (Property)movieSelectionModelBeanProperty_24, (Object)this.lblTraktTvId, (Property)jTextAreaBeanProperty);
        autoBinding_24.setConverter((Converter)new ZeroIdConverter());
        autoBinding_24.bind();
    }
}

