/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.movies.filters;

import java.util.List;
import javax.swing.JLabel;
import org.tinymediamanager.core.MediaFileHelper;
import org.tinymediamanager.core.entities.MediaFile;
import org.tinymediamanager.core.movie.entities.Movie;
import org.tinymediamanager.ui.components.TmmLabel;
import org.tinymediamanager.ui.movies.filters.AbstractCheckComboBoxMovieUIFilter;

public class MovieVideoFormatFilter
extends AbstractCheckComboBoxMovieUIFilter<String> {
    public MovieVideoFormatFilter() {
        this.setValues(MediaFileHelper.getVideoFormats());
    }

    @Override
    public String getId() {
        return "movieVideoFormat";
    }

    @Override
    public boolean accept(Movie movie) {
        List selectedValues = this.checkComboBox.getSelectedItems();
        MediaFile mf = movie.getMainVideoFile();
        if (mf == null) {
            return false;
        }
        for (String videoFormat : selectedValues) {
            if ("UHD".equals(videoFormat) && mf.isVideoDefinitionUHD()) {
                return true;
            }
            if ("HD".equals(videoFormat) && mf.isVideoDefinitionHD()) {
                return true;
            }
            if ("SD".equals(videoFormat) && mf.isVideoDefinitionSD()) {
                return true;
            }
            if ("LD".equals(videoFormat) && mf.isVideoDefinitionLD()) {
                return true;
            }
            if (!videoFormat.equals(movie.getMediaInfoVideoFormat())) continue;
            return true;
        }
        return false;
    }

    @Override
    protected JLabel createLabel() {
        return new TmmLabel(BUNDLE.getString("metatag.resolution"));
    }

    @Override
    protected String parseTypeToString(String type) throws Exception {
        return type;
    }

    @Override
    protected String parseStringToType(String string) throws Exception {
        return string;
    }
}

